/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.domain.fileimport.file.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BasedataEntityType;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileNameUtils;
import kd.hdtc.hrcc.business.domain.fileimport.file.IFileFieldDealService;
import kd.hdtc.hrcc.business.domain.fileimport.file.impl.FileImportBaseService;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportConfigBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportFileFieldInfoBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportSubTaskResultBean;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.FileUtils;
import kd.hdtc.hrdbs.common.util.HDTCArrayUtils;

public class PictureFieldDealServiceImpl
extends FileImportBaseService
implements IFileFieldDealService {
    private static Log LOG = LogFactory.getLog(PictureFieldDealServiceImpl.class);

    @Override
    public FileImportSubTaskResultBean uploadFileList(FileImportFileFieldInfoBo fileImportFileFieldInfoBo, DynamicObject subTask, FileImportConfigBo fileImportConfigBo) {
        FileImportSubTaskResultBean fileImportSubTaskResultBean = new FileImportSubTaskResultBean(fileImportFileFieldInfoBo.getEntityNumber());
        fileImportSubTaskResultBean.setDataPkId(fileImportFileFieldInfoBo.getDataPkId());
        if (CollectionUtils.isEmpty(fileImportFileFieldInfoBo.getFileInfoList())) {
            LOG.info("PictureFieldDealServiceImpl deal data is null");
            fileImportSubTaskResultBean.fail("PictureFieldDealServiceImpl deal data is null");
            return fileImportSubTaskResultBean;
        }
        List<FileImportFileFieldInfoBo.FileInfo> fileInfoList = fileImportFileFieldInfoBo.getFileInfoList();
        Object[] bizDynArr = this.getBizDataDynArr(fileImportFileFieldInfoBo);
        if (HDTCArrayUtils.isEmpty((Object[])bizDynArr)) {
            LOG.info("PictureFieldDealServiceImpl select data is null dataPkId=:{}", fileImportFileFieldInfoBo.getDataPkId());
            fileImportSubTaskResultBean.fail("PictureFieldDealServiceImpl select data is null");
            return fileImportSubTaskResultBean;
        }
        HashMap<FileItem, FileImportFileFieldInfoBo.FileInfo> fileItemMap = new HashMap<FileItem, FileImportFileFieldInfoBo.FileInfo>(fileInfoList.size());
        ArrayList<DynamicObject> dealBizData = new ArrayList<DynamicObject>(bizDynArr.length);
        List<String> pathList = this.uploadPicToRemote(fileImportFileFieldInfoBo, (DynamicObject[])bizDynArr, fileItemMap, dealBizData);
        this.analysisUploadResult(fileImportFileFieldInfoBo, fileImportSubTaskResultBean, fileItemMap, pathList, true);
        this.doSaveBindingBizEntityData(fileImportFileFieldInfoBo, dealBizData, pathList, fileImportSubTaskResultBean);
        return fileImportSubTaskResultBean;
    }

    private void doSaveBindingBizEntityData(FileImportFileFieldInfoBo fileImportFileFieldInfoBo, List<DynamicObject> dealBizData, List<String> pathList, FileImportSubTaskResultBean fileImportSubTaskResultBean) {
        if (CollectionUtils.isEmpty(pathList)) {
            LOG.info("PictureFieldDealServiceImpl imageFileService.upload success size is zero");
            fileImportSubTaskResultBean.fail("PictureFieldDealServiceImpl imageFileService.upload success size is zero");
            fileImportFileFieldInfoBo.getFileInfoList().forEach(fileInfo -> fileImportSubTaskResultBean.getFailFileNameList().add(fileInfo.getFileName()));
        }
        for (int index = 0; index < pathList.size(); ++index) {
            DynamicObject bizDyn = dealBizData.get(index);
            bizDyn.set(fileImportFileFieldInfoBo.getFiledNumber(), (Object)pathList.get(index));
        }
        CommonEntityServiceFactory.getEntityService((String)fileImportFileFieldInfoBo.getEntityNumber()).save(dealBizData.toArray(new DynamicObject[0]));
    }

    private List<String> uploadPicToRemote(FileImportFileFieldInfoBo fileImportFileFieldInfoBo, DynamicObject[] bizDynArr, Map<FileItem, FileImportFileFieldInfoBo.FileInfo> fileItemMap, List<DynamicObject> dealBizData) {
        Object dataPkId = fileImportFileFieldInfoBo.getDataPkId();
        ImmutableMap fileInfoListMap = ImmutableMap.of((Object)dataPkId, fileImportFileFieldInfoBo.getFileInfoList());
        FileService imageFileService = FileServiceFactory.getImageFileService();
        RequestContext requestContext = RequestContext.get();
        ArrayList fileItemList = Lists.newArrayListWithExpectedSize((int)bizDynArr.length);
        Arrays.stream(bizDynArr).forEach(arg_0 -> PictureFieldDealServiceImpl.lambda$uploadPicToRemote$2((Map)fileInfoListMap, requestContext, fileImportFileFieldInfoBo, fileItemList, dealBizData, fileItemMap, arg_0));
        return imageFileService.upload(fileItemList.toArray(new FileItem[0]));
    }

    @Override
    public FileImportSubTaskResultBean deleteFileList(FileImportFileFieldInfoBo fileImportFileFieldInfoBo) {
        DynamicObject[] bizDataDynArr = this.getBizDataDynArr(fileImportFileFieldInfoBo);
        FileService imageFileService = FileServiceFactory.getImageFileService();
        for (DynamicObject bizDyn : bizDataDynArr) {
            imageFileService.delete(bizDyn.getString(fileImportFileFieldInfoBo.getFiledNumber()));
            bizDyn.set(fileImportFileFieldInfoBo.getFiledNumber(), (Object)"");
        }
        this.saveBizDataDyn(fileImportFileFieldInfoBo.getEntityNumber(), bizDataDynArr);
        return new FileImportSubTaskResultBean();
    }

    @Override
    public Map<Long, List<String>> queryFileList(FileImportFileFieldInfoBo fileImportFileFieldInfoBo, Set<Long> dataPkIdSet) {
        DynamicObject[] bizDataDynArr;
        HashMap<Long, List<String>> idVsFileNameListMap = new HashMap<Long, List<String>>(16);
        if (fileImportFileFieldInfoBo == null) {
            return idVsFileNameListMap;
        }
        for (DynamicObject bizDyn : bizDataDynArr = this.getBizDataDynArr(fileImportFileFieldInfoBo, dataPkIdSet)) {
            long dataPkId = bizDyn.getLong("id");
            idVsFileNameListMap.putIfAbsent(dataPkId, new ArrayList(10));
            String fileRelativePath = bizDyn.getString(fileImportFileFieldInfoBo.getFiledNumber());
            ((List)idVsFileNameListMap.get(dataPkId)).add(fileRelativePath.substring(fileRelativePath.lastIndexOf("/")));
        }
        return idVsFileNameListMap;
    }

    private static /* synthetic */ void lambda$uploadPicToRemote$2(Map fileInfoListMap, RequestContext requestContext, FileImportFileFieldInfoBo fileImportFileFieldInfoBo, List fileItemList, List dealBizData, Map fileItemMap, DynamicObject data) {
        Object pkId = data.get("id");
        List fileInfoList = (List)fileInfoListMap.get(pkId);
        BasedataEntityType dataEntityType = (BasedataEntityType)data.getDataEntityType();
        if (CollectionUtils.isEmpty((Collection)fileInfoList)) {
            return;
        }
        fileInfoList.forEach(fileInfo -> {
            String relativePath = FileNameUtils.getImageFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (String)dataEntityType.getAppId(), (String)fileImportFileFieldInfoBo.getEntityNumber(), (Object)pkId, (String)fileInfo.getFileName());
            TempFileCacheDownloadable.Content content = FileUtils.getCacheContentFromTempUrl((String)fileInfo.getTemUrl());
            FileItem fileItem = new FileItem(fileInfo.getFileName(), relativePath, content.getInputStream());
            fileItemList.add(fileItem);
            dealBizData.add(data);
            fileItemMap.put(fileItem, fileInfo);
        });
    }
}

