/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.domain.fileimport.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrcc.business.common.ServiceFactory;
import kd.hdtc.hrcc.business.common.enums.FileImportTipsEnum;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.EntityBo;
import kd.hdtc.hrcc.business.domain.fileimport.IFileImportConfigDomainService;
import kd.hdtc.hrcc.business.domain.fileimport.entity.IFileImportConfigEntityService;
import kd.hdtc.hrcc.business.domain.fileimport.file.FileImportFieldDealServiceFactory;
import kd.hdtc.hrcc.business.domain.fileimport.file.IFileFieldDealService;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportConfigBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportConfigEntityRelTreeBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportFieldBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportFileFieldInfoBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportPreviewResultBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportSingleFilePreviewResultBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportSubSceneBo;
import kd.hdtc.hrcc.business.domain.fileimport.utils.EntityFieldDealUtils;
import kd.hdtc.hrcc.business.domain.fileimport.utils.FileImportFileNameUtils;
import kd.hdtc.hrcc.common.enums.FileFieldTypeEnum;
import kd.hdtc.hrcc.common.enums.FileImportPreviewStatusEnum;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.HDTCArrayUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class FileImportConfigDomainServiceImpl
implements IFileImportConfigDomainService {
    private static Log LOG = LogFactory.getLog(FileImportConfigDomainServiceImpl.class);
    private IFileImportConfigEntityService fileImportConfigEntityService = ServiceFactory.getService(IFileImportConfigEntityService.class);

    @Override
    public FileImportConfigBo getConfigBoById(Long configId) {
        DynamicObjectCollection configEntityCollection;
        DynamicObjectCollection showFieldEntityCollection;
        LOG.info("getConfigBoById start configId:{}", (Object)configId);
        DynamicObject configDyn = this.fileImportConfigEntityService.queryConfigById(configId);
        if (configDyn == null) {
            return null;
        }
        LOG.info("getConfigBoById have data configId:{},configName:{}", (Object)configId, configDyn.get("name"));
        FileImportConfigBo fileImportConfigBo = new FileImportConfigBo();
        fileImportConfigBo.setConfigId(configDyn.getLong("id"));
        fileImportConfigBo.setConfigNumber(configDyn.getString("number"));
        fileImportConfigBo.setConfigName(configDyn.getString("name"));
        fileImportConfigBo.setPrompt(configDyn.getString("prompt"));
        FileImportConfigBo.dealPromptInfo(fileImportConfigBo);
        fileImportConfigBo.setMainEntityNumber(configDyn.getString("mainentity.number"));
        String keyFieldStr = configDyn.getString("keyfields");
        if (StringUtils.isNotEmpty((String)keyFieldStr)) {
            LinkedHashSet newValueSet = Arrays.stream(keyFieldStr.split(",")).filter(data -> StringUtils.isNotEmpty((String)data)).map(FileImportFieldBo::new).collect(Collectors.toCollection(LinkedHashSet::new));
            fileImportConfigBo.setKeyFieldSet(newValueSet);
            this.renderFieldType(newValueSet);
        }
        if (CollectionUtils.isNotEmpty((Collection)(showFieldEntityCollection = configDyn.getDynamicObjectCollection("showfieldentryentity")))) {
            LinkedHashSet showFieldSet = showFieldEntityCollection.stream().map(data -> data.getString("showcolnumber")).map(FileImportFieldBo::new).collect(Collectors.toCollection(LinkedHashSet::new));
            fileImportConfigBo.setShowFieldSet(showFieldSet);
            this.renderFieldType(showFieldSet);
        }
        if (CollectionUtils.isNotEmpty((Collection)(configEntityCollection = configDyn.getDynamicObjectCollection("cfgentryentity")))) {
            ArrayList fileImportSubSceneList = Lists.newArrayListWithExpectedSize((int)configEntityCollection.size());
            Map<String, DynamicObject> conditionMap = null;
            DynamicObjectCollection conditionEntityCollection = configDyn.getDynamicObjectCollection("treeentryentity");
            if (CollectionUtils.isNotEmpty((Collection)conditionEntityCollection)) {
                conditionMap = conditionEntityCollection.stream().collect(Collectors.toMap(data -> data.getString("targetentity.number"), dy -> dy, (v1, v2) -> v2));
            }
            Map<String, DynamicObject> finalConditionMap = conditionMap;
            configEntityCollection.forEach(data -> {
                FileImportSubSceneBo fileImportSubSceneBo = new FileImportSubSceneBo();
                fileImportSubSceneBo.setSubSceneId(data.getLong("id"));
                fileImportSubSceneBo.setSubSceneNumber(data.getString("scenenumber"));
                fileImportSubSceneBo.setSubSceneName(data.getString("scenename"));
                fileImportSubSceneBo.setFieldType(data.getString("fieldtype"));
                fileImportSubSceneBo.setSpecialIde(data.getString("specialide"));
                fileImportSubSceneBo.setSingleUpdate(data.getBoolean("issingleupdate"));
                FileImportFieldBo fieldInfo = new FileImportFieldBo(data.getString("fieldnumber"));
                fileImportSubSceneBo.setFieldInfo(fieldInfo);
                String fieldType = data.getString("fieldtype");
                fileImportSubSceneBo.setFieldType(fieldType);
                this.buildFileFieldInfoByType(fieldType, fieldInfo.getEntityNumber(), fieldInfo.getFiledNumber(), fileImportSubSceneBo);
                FileImportConfigEntityRelTreeBo fileImportConfigEntityRelTreeBo = this.buildConfigEntityRelTree(finalConditionMap, fieldInfo.getEntityNumber(), fileImportConfigBo.getMainEntityNumber());
                fileImportSubSceneBo.setRelTreeBo(fileImportConfigEntityRelTreeBo);
                fileImportSubSceneList.add(fileImportSubSceneBo);
            });
            fileImportConfigBo.setFileImportSubSceneList(fileImportSubSceneList);
        }
        LOG.info("getConfigBoById end configId:{}", (Object)configId);
        return fileImportConfigBo;
    }

    private FileImportConfigEntityRelTreeBo buildConfigEntityRelTree(Map<String, DynamicObject> conditionMap, String entityNumber, String mainEntityNumber) {
        DynamicObject relInfo;
        FileImportConfigEntityRelTreeBo fileImportConfigEntityRelTreeBo = null;
        if (StringUtils.equals((String)entityNumber, (String)mainEntityNumber)) {
            fileImportConfigEntityRelTreeBo = new FileImportConfigEntityRelTreeBo();
            fileImportConfigEntityRelTreeBo.setEntityNumber(entityNumber);
            fileImportConfigEntityRelTreeBo.setRoot(true);
        } else if (conditionMap != null && (relInfo = conditionMap.get(entityNumber)) != null) {
            fileImportConfigEntityRelTreeBo = new FileImportConfigEntityRelTreeBo();
            fileImportConfigEntityRelTreeBo.setEntityNumber(entityNumber);
            fileImportConfigEntityRelTreeBo.setLogicalRel(relInfo.getString("logicalrel"));
            fileImportConfigEntityRelTreeBo.setFieldNumber(relInfo.getString("targetrelfield"));
            fileImportConfigEntityRelTreeBo.setRelFieldNumber(relInfo.getString("sourcerelfield"));
            String sourceNumber = relInfo.getString("sourceentity.number");
            FileImportConfigEntityRelTreeBo parent = this.buildConfigEntityRelTree(conditionMap, sourceNumber, mainEntityNumber);
            fileImportConfigEntityRelTreeBo.setParent(parent);
            fileImportConfigEntityRelTreeBo.setRoot(false);
        }
        return fileImportConfigEntityRelTreeBo;
    }

    private void buildFileFieldInfoByType(String fieldType, String entityNumber, String fieldNumber, FileImportSubSceneBo fileImportSubSceneBo) {
        if (StringUtils.equals((String)FileFieldTypeEnum.PICTURE.getType(), (String)fieldType)) {
            EntityFieldDealUtils.getPictureFieldInfo(entityNumber, fieldNumber, prop -> {
                if (prop != null) {
                    fileImportSubSceneBo.setNum(1);
                    fileImportSubSceneBo.setSize(prop.getMaxImgSize());
                }
            });
        } else if (StringUtils.equals((String)FileFieldTypeEnum.ATTACHMENT_FIELD.getType(), (String)fieldType)) {
            EntityFieldDealUtils.getAttachmentFieldInfo(entityNumber, fieldNumber, prop -> {
                if (prop != null) {
                    fileImportSubSceneBo.setNum(prop.getMaxAtmCount());
                    fileImportSubSceneBo.setSize(prop.getMaxAtmSize());
                    fileImportSubSceneBo.setFormat(prop.getExtendName());
                    fileImportSubSceneBo.setSupportSame(!prop.getCheckDuplicateFileName());
                }
            });
        } else if (StringUtils.equals((String)FileFieldTypeEnum.ATTACHMENT_PANEL.getType(), (String)fieldType)) {
            EntityFieldDealUtils.getAttachmentApInfo(entityNumber, fieldNumber, prop -> {
                if (prop != null) {
                    fileImportSubSceneBo.setNum(prop.getMaxAtmCount());
                    fileImportSubSceneBo.setSize(prop.getMaxAtmSize());
                    fileImportSubSceneBo.setFormat(prop.getExtendName());
                    fileImportSubSceneBo.setSupportSame(!prop.getCheckDuplicateFileName());
                }
            });
        }
    }

    private void renderFieldType(LinkedHashSet<FileImportFieldBo> boSet) {
        boSet.stream().forEach(bo -> {
            DynamicProperty prop = this.getFieldProp(bo.getEntityNumber(), bo.getFiledNumber());
            bo.setDataType(prop.getPropertyType());
        });
    }

    private DynamicProperty getFieldProp(String entityNumber, String fieldNumber) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        DynamicProperty pp = null;
        int index = fieldNumber.indexOf(".");
        if (index > 0) {
            String caEntityNumber = fieldNumber.substring(0, index);
            DynamicProperty prop = mainEntityType.getProperty(caEntityNumber);
            if (prop instanceof BasedataProp) {
                pp = this.getFieldProp(((BasedataProp)prop).getBaseEntityId(), fieldNumber.substring(index + 1));
            }
        } else {
            return mainEntityType.getProperty(fieldNumber);
        }
        return pp;
    }

    @Override
    public FileImportPreviewResultBo validateFileNameByConfig(FileImportPreviewResultBo fileImportPreviewResultBo) {
        if (fileImportPreviewResultBo == null) {
            LOG.info("validateFileNameByConfig fileImportPreviewResultBo is null");
            return null;
        }
        FileImportConfigBo fileImportConfigBo = fileImportPreviewResultBo.getFileImportConfigBo();
        List<FileImportFileFieldInfoBo.FileInfo> fileNameList = fileImportPreviewResultBo.getFileNameList();
        if (fileImportConfigBo == null) {
            LOG.info("validateFileNameByConfig fileImportPreviewResultBo is null");
            return null;
        }
        if (CollectionUtils.isEmpty(fileNameList)) {
            LOG.info("validateFileNameByConfig fileNameList is null");
            return null;
        }
        LOG.info("validateFileNameByConfig start size:", (Object)fileImportPreviewResultBo.getFileNameList().size());
        Map<String, FileImportSubSceneBo> subSceneMap = FileImportSubSceneBo.buildSubMapBySpecialIde(fileImportConfigBo.getFileImportSubSceneList());
        HashMap<FileImportSubSceneBo, Map> subSceneConditionListMap = new HashMap<FileImportSubSceneBo, Map>();
        LOG.info("validateFileNameByConfig validateAndBuildValueInfoByFileNameList start ");
        long startTime = System.currentTimeMillis();
        this.validateAndBuildValueInfoByFileNameList(fileNameList, fileImportPreviewResultBo);
        LOG.info("validateFileNameByConfig validateAndBuildValueInfoByFileNameList end cost:{}ms.", (Object)(System.currentTimeMillis() - startTime));
        Map<String, FileImportSingleFilePreviewResultBo> validateResult = fileImportPreviewResultBo.getValidateResultMap();
        Optional<FileImportSingleFilePreviewResultBo> validateResultInfo = validateResult.values().stream().filter(data -> !StringUtils.equals((String)data.getPreviewStatus(), (String)FileImportPreviewStatusEnum.FAIL.getStatus())).findAny();
        if (!validateResultInfo.isPresent()) {
            LOG.info("validateFileNameByConfig all base validate data is null");
            return fileImportPreviewResultBo;
        }
        LOG.info("validateFileNameByConfig build query condition start");
        long startTimeBuildConditionTime = System.currentTimeMillis();
        validateResult.forEach((fileName, fileImportSingleFilePreviewResultBo) -> {
            if (StringUtils.equals((String)fileImportSingleFilePreviewResultBo.getPreviewStatus(), (String)FileImportPreviewStatusEnum.FAIL.getStatus())) {
                return;
            }
            Map<String, String> valueMap = fileImportSingleFilePreviewResultBo.getKeyFiledValue();
            String spacialIde = valueMap.get("spacialIde");
            FileImportSubSceneBo fileImportSubSceneBo = (FileImportSubSceneBo)subSceneMap.get(spacialIde);
            Map conditionListMap = subSceneConditionListMap.getOrDefault(fileImportSubSceneBo, new HashMap(16));
            fileImportConfigBo.getKeyFieldSet().stream().forEach(keyField -> {
                String fullFieldNumber = keyField.getFullFiledNumber();
                List conditionList = conditionListMap.getOrDefault(fullFieldNumber, new ArrayList(10));
                String fieldValue = (String)valueMap.get(fullFieldNumber);
                Class<?> classType = keyField.getDataType();
                try {
                    if (StringUtils.equals((String)classType.getName(), (String)"java.util.Date")) {
                        conditionList.add(HRDateTimeUtils.parseDate((String)fieldValue));
                    } else if (StringUtils.equals((String)classType.getName(), (String)"long")) {
                        conditionList.add(Long.parseLong(fieldValue));
                    } else {
                        conditionList.add(fieldValue);
                    }
                }
                catch (Exception ex) {
                    fileImportSingleFilePreviewResultBo.buildFailMsg(FileImportTipsEnum.DATA_FORMAT_ERROR.getInfo());
                    return;
                }
                conditionListMap.put(fullFieldNumber, conditionList);
            });
            subSceneConditionListMap.put(fileImportSubSceneBo, conditionListMap);
        });
        Map<String, List<String>> queryFieldListMap = this.buildAllQueryFieldMap(fileImportConfigBo, subSceneConditionListMap.keySet());
        LOG.info("validateFileNameByConfig build query condition end {}ms.", (Object)(System.currentTimeMillis() - startTimeBuildConditionTime));
        LOG.info("validateFileNameByConfig query data total start");
        long startTimeQueryDataTime = System.currentTimeMillis();
        if (CollectionUtils.isNotEmpty(subSceneConditionListMap)) {
            subSceneConditionListMap.forEach((subScene, conditionMap) -> {
                long sceneQueryDataTime = System.currentTimeMillis();
                Map<String, DynamicObject[]> dataMap = this.queryDataBySubSceneInfo((FileImportSubSceneBo)subScene, (Map<String, List<String>>)conditionMap, queryFieldListMap);
                LOG.info("validateFileNameByConfig query scene data end scene:{} cost:{}ms.", (Object)subScene.getSubSceneNumber(), (Object)(System.currentTimeMillis() - sceneQueryDataTime));
                long sceneBuildAndValidQueryDataTime = System.currentTimeMillis();
                this.buildAndValidateFileInfo(fileImportConfigBo, (FileImportSubSceneBo)subScene, fileImportPreviewResultBo, dataMap);
                LOG.info("validateFileNameByConfig buildAndValidateFileInfo  scene:{} cost:{}ms.", (Object)subScene.getSubSceneNumber(), (Object)(System.currentTimeMillis() - sceneBuildAndValidQueryDataTime));
            });
        }
        LOG.info("validateFileNameByConfig query data total end total cost:{}ms.", (Object)(System.currentTimeMillis() - startTimeQueryDataTime));
        LOG.info("validateFileNameByConfig end size:", (Object)fileImportPreviewResultBo.getFileNameList().size());
        return fileImportPreviewResultBo;
    }

    private void validateAndBuildValueInfoByFileNameList(List<FileImportFileFieldInfoBo.FileInfo> fileInfoList, FileImportPreviewResultBo fileImportPreviewResultBo) {
        FileImportConfigBo fileImportConfigBo = fileImportPreviewResultBo.getFileImportConfigBo();
        LinkedHashSet<FileImportFieldBo> keyFieldSet = fileImportConfigBo.getKeyFieldSet();
        LinkedHashSet keyFieldFullSet = keyFieldSet.stream().map(FileImportFieldBo::getFullFiledNumber).collect(Collectors.toCollection(LinkedHashSet::new));
        Map<String, FileImportSubSceneBo> subSceneMap = FileImportSubSceneBo.buildSubMapBySpecialIde(fileImportConfigBo.getFileImportSubSceneList());
        Map<String, FileImportSubSceneBo> fileNameSceneMap = fileImportPreviewResultBo.getFileNameAndSceneMap();
        HashMap<FileImportSubSceneBo, List> fileNameFieldMap = new HashMap<FileImportSubSceneBo, List>(subSceneMap.size());
        fileInfoList.stream().forEach(fileInfo -> {
            Map<String, String> valueMap = FileImportFileNameUtils.buildMapByKey(fileInfo.getFileName(), keyFieldFullSet);
            FileImportSingleFilePreviewResultBo resultInfo = fileImportPreviewResultBo.getValidateResultByKey(fileInfo.getZipName(), fileInfo.getFileName());
            if (valueMap == null) {
                resultInfo.buildFailMsg(FileImportTipsEnum.FILE_NAME_ERROR.getInfo());
                return;
            }
            String spacialIde = valueMap.get("spacialIde");
            FileImportSubSceneBo fileImportSubSceneBo = (FileImportSubSceneBo)subSceneMap.get(spacialIde);
            if (fileImportSubSceneBo == null) {
                resultInfo.buildFailMsg(FileImportTipsEnum.HAS_NO_SUB_SCENE.getInfo());
                return;
            }
            Set<String> supportFormatSet = fileImportSubSceneBo.getFormatSet();
            String format = fileInfo.getFormat();
            if (StringUtils.isEmpty((String)format) || CollectionUtils.isNotEmpty(supportFormatSet) && !supportFormatSet.contains(format)) {
                resultInfo.buildFailMsg(FileImportTipsEnum.UN_SUPPORT_FORMAT.getInfo());
            }
            int supportSize = fileImportSubSceneBo.getSize();
            long size = fileInfo.getSize();
            if (size != 0L && supportSize != 0 && size > (long)(supportSize * 1024 * 1024)) {
                resultInfo.buildFailMsg(FileImportTipsEnum.TOO_LARGE.getInfo());
            }
            String buildLongKey = fileImportPreviewResultBo.buildKey(fileInfo.getZipName(), fileInfo.getFileName());
            fileNameSceneMap.put(buildLongKey, fileImportSubSceneBo);
            resultInfo.setKeyFiledValue(valueMap);
            resultInfo.getFileImportFieldBoList().addAll(fileImportConfigBo.getShowFieldSet());
            List sceneFieldList = fileNameFieldMap.getOrDefault(fileImportSubSceneBo, new ArrayList(10));
            sceneFieldList.add(fileInfo);
            fileNameFieldMap.put(fileImportSubSceneBo, sceneFieldList);
        });
        fileNameFieldMap.forEach((scene, sceneFieldList) -> {
            if (CollectionUtils.isEmpty((Collection)sceneFieldList)) {
                return;
            }
            Map<String, List<FileImportFileFieldInfoBo.FileInfo>> validateNameFieldMap = sceneFieldList.stream().collect(Collectors.groupingBy(sceneField -> {
                FileImportSingleFilePreviewResultBo resultInfo = fileImportPreviewResultBo.getValidateResultByKey(sceneField.getZipName(), sceneField.getFileName());
                Map<String, String> keyFieldValueMap = resultInfo.getKeyFiledValue();
                return keyFieldValueMap.get("validate_name");
            }));
            int supportNum = scene.getNum();
            validateNameFieldMap.forEach((validateName, fieldList) -> fieldList.forEach(field -> {
                FileImportSingleFilePreviewResultBo resultInfo = fileImportPreviewResultBo.getValidateResultByKey(field.getZipName(), field.getFileName());
                resultInfo.setSameSize(fieldList.size());
                if (supportNum < fieldList.size()) {
                    resultInfo.buildFailMsg(FileImportTipsEnum.TOO_MANY.getInfo());
                }
            }));
        });
    }

    private Map<String, DynamicObject[]> queryDataBySubSceneInfo(FileImportSubSceneBo subScene, Map<String, List<String>> conditionMap, Map<String, List<String>> queryFieldListMap) {
        if (subScene == null || conditionMap.isEmpty()) {
            return null;
        }
        List<FileImportConfigEntityRelTreeBo> relBoList = FileImportConfigEntityRelTreeBo.buildEntityRelList(subScene.getRelTreeBo());
        if (CollectionUtils.isEmpty(relBoList) || conditionMap.isEmpty()) {
            return null;
        }
        HashMap<String, DynamicObject[]> dataMap = new HashMap<String, DynamicObject[]>(16);
        LOG.info("validateFileNameByConfig queryDataBySubSceneInfo start subSceneName:{} subSceneNumber{}", (Object)subScene.getSubSceneName(), (Object)subScene.getSpecialIde());
        relBoList.forEach(relTreeBo -> {
            FileImportConfigEntityRelTreeBo parent;
            String entityNumber = relTreeBo.getEntityNumber();
            List queryFieldList = (List)queryFieldListMap.get(entityNumber);
            LOG.info("validateFileNameByConfig queryDataBySubSceneInfo queryData start entityNumber:{}", (Object)entityNumber);
            if (CollectionUtils.isEmpty((Collection)queryFieldList)) {
                return;
            }
            QFilter qfilter = new QFilter("1", "=", (Object)1);
            conditionMap.forEach((fieldKey, valueList) -> {
                FileImportFieldBo fileImportFieldBo = new FileImportFieldBo((String)fieldKey);
                if (StringUtils.equals((String)entityNumber, (String)fileImportFieldBo.getEntityNumber())) {
                    qfilter.and(fileImportFieldBo.getFiledNumber(), "in", valueList);
                }
            });
            EntityBo entityBo = new EntityBo();
            if (entityBo.isHisModEntity(entityNumber)) {
                QFilter currentQf = new QFilter("iscurrentversion", "=", (Object)"1");
                qfilter.and(currentQf);
            }
            if ((parent = relTreeBo.getParent()) != null) {
                Object[] parentDataArr = (DynamicObject[])dataMap.get(parent.getEntityNumber());
                if (HDTCArrayUtils.isNotEmpty((Object[])parentDataArr)) {
                    List parentConditionList = Arrays.stream(parentDataArr).map(data -> data.get(relTreeBo.getRelFieldNumber())).collect(Collectors.toList());
                    qfilter.and(relTreeBo.getFieldNumber(), "in", parentConditionList);
                } else {
                    qfilter.and(new QFilter("1", "!=", (Object)1));
                }
            }
            queryFieldList.add("id");
            LOG.info("validateFileNameByConfig queryDataBySubSceneInfo queryData entityNumber:{} queryFieldList{} qFilter{}", new Object[]{entityNumber, queryFieldList, qfilter});
            IBaseEntityService entityService = CommonEntityServiceFactory.getEntityService((String)entityNumber);
            Object[] dataArr = entityService.query(Joiner.on((String)",").join((Iterable)queryFieldList), new QFilter[]{qfilter});
            LOG.info("validateFileNameByConfig queryDataBySubSceneInfo queryData end  entityNumber:{} size:{}", (Object)entityNumber, (Object)dataArr.length);
            if (HDTCArrayUtils.isNotEmpty((Object[])dataArr)) {
                dataMap.put(entityNumber, (DynamicObject[])dataArr);
            }
        });
        LOG.info("validateFileNameByConfig queryDataBySubSceneInfo end subSceneName:{} subSceneNumber{}", (Object)subScene.getSubSceneName(), (Object)subScene.getSpecialIde());
        return dataMap;
    }

    private Map<String, List<String>> buildAllQueryFieldMap(FileImportConfigBo fileImportConfigBo, Set<FileImportSubSceneBo> needDealSubSceneSet) {
        HashMap<String, List<String>> queryFieldListMap = new HashMap<String, List<String>>(16);
        fileImportConfigBo.getKeyFieldSet().stream().forEach(keyField -> {
            String entityNumber = keyField.getEntityNumber();
            List entityQueryFieldList = queryFieldListMap.getOrDefault(entityNumber, new ArrayList(10));
            entityQueryFieldList.add(keyField.getFiledNumber());
            queryFieldListMap.put(entityNumber, entityQueryFieldList);
        });
        fileImportConfigBo.getShowFieldSet().stream().forEach(fileImportFieldBo -> {
            String entityNumber = fileImportFieldBo.getEntityNumber();
            List entityQueryFieldList = queryFieldListMap.getOrDefault(entityNumber, new ArrayList(10));
            entityQueryFieldList.add(fileImportFieldBo.getFiledNumber());
            queryFieldListMap.put(entityNumber, entityQueryFieldList);
        });
        needDealSubSceneSet.stream().forEach(fileImportSubSceneBo -> {
            FileImportConfigEntityRelTreeBo fileImportConfigEntityRelTreeBo = fileImportSubSceneBo.getRelTreeBo();
            String entityNumber = fileImportConfigEntityRelTreeBo.getEntityNumber();
            List entityQueryFieldList = queryFieldListMap.getOrDefault(entityNumber, new ArrayList(10));
            FileImportConfigEntityRelTreeBo parentRelTreeBo = fileImportConfigEntityRelTreeBo.getParent();
            if (parentRelTreeBo != null) {
                entityQueryFieldList.add(fileImportConfigEntityRelTreeBo.getFieldNumber());
                List parentEntityQueryFieldList = queryFieldListMap.getOrDefault(parentRelTreeBo.getEntityNumber(), new ArrayList(10));
                parentEntityQueryFieldList.add(fileImportConfigEntityRelTreeBo.getRelFieldNumber());
            }
            queryFieldListMap.put(entityNumber, entityQueryFieldList);
        });
        return queryFieldListMap;
    }

    private void buildAndValidateFileInfo(FileImportConfigBo fileImportConfigBo, FileImportSubSceneBo fileImportSubSceneBo, FileImportPreviewResultBo fileImportPreviewResultBo, Map<String, DynamicObject[]> dataMap) {
        Map<String, FileImportSubSceneBo> fileNameAndSceneMap = fileImportPreviewResultBo.getFileNameAndSceneMap();
        if (CollectionUtils.isEmpty(fileNameAndSceneMap)) {
            return;
        }
        ArrayList<String> fileFullNameList = new ArrayList<String>(fileNameAndSceneMap.size());
        fileNameAndSceneMap.forEach((fileName, subScene) -> {
            if (subScene == fileImportSubSceneBo) {
                fileFullNameList.add((String)fileName);
            }
        });
        if (CollectionUtils.isEmpty(fileFullNameList)) {
            return;
        }
        if (CollectionUtils.isEmpty(dataMap)) {
            fileFullNameList.forEach(data -> fileImportPreviewResultBo.getValidateResultByFullName((String)data).buildFailMsg(FileImportTipsEnum.HAS_NO_DATA.getInfo()));
            return;
        }
        List<Map<String, FileImportFieldBo>> allValidDataList = this.buildDataInfoBySubSceneRelTree(dataMap, fileImportSubSceneBo, fileImportConfigBo.getShowFieldSet());
        fileFullNameList.forEach(fileName -> {
            FileImportSingleFilePreviewResultBo fileImportSingleFilePreviewResultBo = fileImportPreviewResultBo.getValidateResultByFullName((String)fileName);
            Map<String, String> mapValue = fileImportSingleFilePreviewResultBo.getKeyFiledValue();
            AtomicInteger validNum = new AtomicInteger();
            AtomicReference finalValidData = new AtomicReference();
            if (CollectionUtils.isNotEmpty((Collection)allValidDataList)) {
                allValidDataList.stream().forEach(validData -> {
                    boolean validResult = this.validFieldDataByKeyList((Map<String, FileImportFieldBo>)validData, mapValue);
                    if (validResult) {
                        validNum.getAndIncrement();
                        finalValidData.set(validData);
                    }
                });
            }
            if (validNum.get() == 0) {
                fileImportSingleFilePreviewResultBo.buildFailMsg(FileImportTipsEnum.HAS_NO_DATA.getInfo());
            } else if (validNum.get() > 1) {
                fileImportSingleFilePreviewResultBo.buildFailMsg(FileImportTipsEnum.HAS_TOO_MANY_DATA.getInfo());
            } else {
                fileImportSingleFilePreviewResultBo.setFileImportFieldBoList(new ArrayList<FileImportFieldBo>(((Map)finalValidData.get()).values()));
            }
        });
        long validEntityDataTime = System.currentTimeMillis();
        this.validEntityDataIdFileNum(fileImportSubSceneBo, fileImportPreviewResultBo, fileFullNameList);
        LOG.info("validateFileNameByConfig validEntityDataIdFileNum  cost:{}ms.", (Object)(System.currentTimeMillis() - validEntityDataTime));
    }

    private void validEntityDataIdFileNum(FileImportSubSceneBo fileImportSubSceneBo, FileImportPreviewResultBo fileImportPreviewResultBo, List<String> fileFullNameList) {
        if (CollectionUtils.isEmpty(fileFullNameList) || fileImportSubSceneBo.getNum() == 0) {
            return;
        }
        FileImportFieldBo fieldInfo = fileImportSubSceneBo.getFieldInfo();
        FileImportFileFieldInfoBo fileImportFileFieldInfoBo = new FileImportFileFieldInfoBo();
        fileImportFileFieldInfoBo.setEntityNumber(fieldInfo.getEntityNumber());
        fileImportFileFieldInfoBo.setFiledNumber(fieldInfo.getFiledNumber());
        HashSet<Long> dataPkIdSet = new HashSet<Long>(16);
        for (String fullFileName : fileFullNameList) {
            Map<String, FileImportSingleFilePreviewResultBo> validateResultMap = fileImportPreviewResultBo.getValidateResultMap();
            FileImportSingleFilePreviewResultBo fileImportSingleFilePreviewResultBo = validateResultMap.get(fullFileName);
            if (StringUtils.equals((String)fileImportSingleFilePreviewResultBo.getPreviewStatus(), (String)FileImportPreviewStatusEnum.FAIL.getStatus())) continue;
            FileImportFieldBo idFileImportFieldBo = fileImportSingleFilePreviewResultBo.getFileImportFieldBoList().stream().filter(fileImportFieldBo -> StringUtils.equals((String)fileImportFieldBo.getFiledNumber(), (String)"id")).findFirst().get();
            String dataPkId = idFileImportFieldBo.getValue();
            dataPkIdSet.add(Long.parseLong(dataPkId));
        }
        String fieldType = fileImportSubSceneBo.getFieldType();
        IFileFieldDealService fileFieldDealService = FileImportFieldDealServiceFactory.getServiceByType(FileFieldTypeEnum.getBizModelTypeByLevel((String)fieldType));
        Map<Long, List<String>> dataPkIdVs = fileFieldDealService.queryFileList(fileImportFileFieldInfoBo, dataPkIdSet);
        int fileNum = fileImportSubSceneBo.getNum();
        this.compareFileCount(fileImportSubSceneBo, fileImportPreviewResultBo, fileFullNameList, dataPkIdVs, fileNum);
    }

    private void compareFileCount(FileImportSubSceneBo fileImportSubSceneBo, FileImportPreviewResultBo fileImportPreviewResultBo, List<String> fileFullNameList, Map<Long, List<String>> dataPkIdVs, int fileNum) {
        for (Map.Entry<Long, List<String>> entry : dataPkIdVs.entrySet()) {
            List<String> fileNameList = entry.getValue();
            if (CollectionUtils.isEmpty(fileNameList)) continue;
            for (String fullFileName : fileFullNameList) {
                if (fileImportSubSceneBo.isSingleUpdate()) continue;
                if (fileImportSubSceneBo.getNum() == 1 && CollectionUtils.isNotEmpty(fileNameList)) {
                    fileImportPreviewResultBo.getValidateResultByFullName(fullFileName).buildFailMsg(FileImportTipsEnum.REPEAT_FILE_SINGLE_NOT_ALLOW_UPDATE.getInfo());
                }
                FileImportSingleFilePreviewResultBo fileImportSingleFilePreviewResultBo = fileImportPreviewResultBo.getValidateResultMap().get(fullFileName);
                int sameSize = fileImportSingleFilePreviewResultBo.getSameSize();
                if (fileNameList.size() + sameSize <= fileNum) continue;
                fileImportPreviewResultBo.getValidateResultByFullName(fullFileName).buildFailMsg(FileImportTipsEnum.REPEAT_FILE_SIZE_UPPER_LIMIT.getInfo());
            }
        }
    }

    private List<Map<String, FileImportFieldBo>> buildDataInfoBySubSceneRelTree(Map<String, DynamicObject[]> dataMap, FileImportSubSceneBo fileImportSubSceneBo, LinkedHashSet<FileImportFieldBo> showFieldList) {
        ArrayList<Map<String, FileImportFieldBo>> allShowFiledDataList = new ArrayList<Map<String, FileImportFieldBo>>();
        FileImportConfigEntityRelTreeBo fileImportConfigEntityRelTreeBo = fileImportSubSceneBo.getRelTreeBo();
        String entityNumber = fileImportConfigEntityRelTreeBo.getEntityNumber();
        Object[] dataArr = dataMap.get(entityNumber);
        if (HDTCArrayUtils.isEmpty((Object[])dataArr)) {
            return null;
        }
        HashMap<String, List<DynamicObject>> dataInfo = new HashMap<String, List<DynamicObject>>(16);
        this.buildDataInfoByDataKey(dataMap, fileImportConfigEntityRelTreeBo, dataInfo, null);
        Arrays.stream(dataArr).forEach(data -> {
            HashMap<String, FileImportFieldBo> fieldBoDataMap = new HashMap<String, FileImportFieldBo>(showFieldList.size());
            showFieldList.forEach(showField -> {
                FileImportFieldBo fileImportFieldBo = new FileImportFieldBo(showField.getEntityNumber(), showField.getFiledNumber());
                fileImportFieldBo.setDataType(showField.getDataType());
                if (StringUtils.equals((String)entityNumber, (String)showField.getEntityNumber())) {
                    fileImportFieldBo.setValue(data.getString(showField.getFiledNumber()));
                    fieldBoDataMap.put(fileImportFieldBo.getFullFiledNumber(), fileImportFieldBo);
                } else {
                    FileImportConfigEntityRelTreeBo parentRel = fileImportConfigEntityRelTreeBo.getParent();
                    if (parentRel == null) {
                        return;
                    }
                    this.buildSingleTreeData((Map<String, FileImportFieldBo>)fieldBoDataMap, (FileImportFieldBo)showField, parentRel, fileImportConfigEntityRelTreeBo.getFieldNumber(), (DynamicObject)data, (Map<String, List<DynamicObject>>)dataInfo);
                }
            });
            if (CollectionUtils.isNotEmpty(fieldBoDataMap)) {
                FileImportFieldBo fileImportFieldBo = new FileImportFieldBo(data.getDataEntityType().getName(), "id");
                fileImportFieldBo.setValue(data.getString("id"));
                fieldBoDataMap.put(fileImportFieldBo.getFullFiledNumber(), fileImportFieldBo);
                allShowFiledDataList.add(fieldBoDataMap);
            }
        });
        return allShowFiledDataList;
    }

    private void buildDataInfoByDataKey(Map<String, DynamicObject[]> dataMap, FileImportConfigEntityRelTreeBo fileImportConfigEntityRelTreeBo, Map<String, List<DynamicObject>> dataInfo, String dataKey) {
        Object[] dataArr = dataMap.get(fileImportConfigEntityRelTreeBo.getEntityNumber());
        if (HDTCArrayUtils.isEmpty((Object[])dataArr)) {
            return;
        }
        Arrays.stream(dataArr).forEach(data -> {
            StringBuilder buildKey = new StringBuilder();
            buildKey.append(fileImportConfigEntityRelTreeBo.getEntityNumber()).append(".");
            if (StringUtils.isEmpty((String)dataKey)) {
                buildKey.append(data.getString("id"));
            } else {
                buildKey.append(data.getString(dataKey));
            }
            List dataList = dataInfo.getOrDefault(buildKey.toString(), new ArrayList(10));
            dataList.add(data);
            dataInfo.put(buildKey.toString(), dataList);
        });
        FileImportConfigEntityRelTreeBo parentRel = fileImportConfigEntityRelTreeBo.getParent();
        if (parentRel != null) {
            this.buildDataInfoByDataKey(dataMap, parentRel, dataInfo, fileImportConfigEntityRelTreeBo.getRelFieldNumber());
        }
    }

    private void buildSingleTreeData(Map<String, FileImportFieldBo> fieldBoDataMap, FileImportFieldBo showField, FileImportConfigEntityRelTreeBo currentRel, String relField, DynamicObject data, Map<String, List<DynamicObject>> dataInfo) {
        FileImportFieldBo fileImportFieldBo = new FileImportFieldBo(showField.getEntityNumber(), showField.getFiledNumber());
        fileImportFieldBo.setDataType(showField.getDataType());
        StringBuilder dataKey = new StringBuilder(currentRel.getEntityNumber()).append(".").append(data.getString(relField));
        List<DynamicObject> dataList = dataInfo.get(dataKey.toString());
        if (CollectionUtils.isEmpty(dataList) || dataList.size() > 1) {
            return;
        }
        if (StringUtils.equals((String)currentRel.getEntityNumber(), (String)showField.getEntityNumber())) {
            fileImportFieldBo.setValue(dataList.get(0).getString(showField.getFiledNumber()));
            fieldBoDataMap.put(fileImportFieldBo.getFullFiledNumber(), fileImportFieldBo);
        } else if (currentRel.getParent() != null) {
            this.buildSingleTreeData(fieldBoDataMap, showField, currentRel.getParent(), currentRel.getFieldNumber(), dataList.get(0), dataInfo);
        }
    }

    private boolean validFieldDataByKeyList(Map<String, FileImportFieldBo> fieldMap, Map<String, String> mapValue) {
        AtomicInteger index = new AtomicInteger();
        AtomicBoolean result = new AtomicBoolean(true);
        mapValue.forEach((fullNumber, value) -> {
            FileImportFieldBo fileImportFieldBo = (FileImportFieldBo)fieldMap.get(fullNumber);
            if (fileImportFieldBo == null) {
                return;
            }
            String fieldValue = fileImportFieldBo.getValue();
            Class<?> datatype = fileImportFieldBo.getDataType();
            if (fieldValue == null || value == null) {
                return;
            }
            if (StringUtils.equals((String)datatype.getName(), (String)"java.util.Date")) {
                try {
                    Date dateFieldValue = HRDateTimeUtils.parseDate((String)fieldValue);
                    Date dateValue = HRDateTimeUtils.parseDate((String)value);
                    if (dateFieldValue.getTime() != dateValue.getTime()) {
                        result.set(false);
                        return;
                    }
                    index.getAndIncrement();
                }
                catch (ParseException e) {
                    result.set(false);
                    return;
                }
            } else {
                if (!StringUtils.equals((String)fieldValue, (String)value)) {
                    result.set(false);
                    return;
                }
                index.getAndIncrement();
            }
        });
        if (!result.get()) {
            return result.get();
        }
        return index.get() != 0;
    }
}

