/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.domain.fileimport.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BasedataEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.url.UrlService;
import kd.hdtc.hrcc.business.common.ServiceFactory;
import kd.hdtc.hrcc.business.common.utils.fileimport.FileImportTaskHandleUtils;
import kd.hdtc.hrcc.business.domain.fileimport.IFileImportTaskDomainService;
import kd.hdtc.hrcc.business.domain.fileimport.entity.IFileImportSubTaskEntityService;
import kd.hdtc.hrcc.business.domain.fileimport.entity.IFileImportTaskEntityService;
import kd.hdtc.hrcc.business.domain.fileimport.file.FileImportFieldDealServiceFactory;
import kd.hdtc.hrcc.business.domain.fileimport.file.IFileFieldDealService;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportConfigBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportFileFieldInfoBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportSubTaskResultBean;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportTaskBean;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportTaskData;
import kd.hdtc.hrcc.business.domain.fileimport.utils.FileImportUtils;
import kd.hdtc.hrcc.common.enums.FileFieldTypeEnum;
import kd.hdtc.hrcc.common.enums.FileImportSubTaskDealStatusEnum;
import kd.hdtc.hrcc.common.enums.FileImportTaskDealStatusEnum;
import kd.hdtc.hrcc.common.enums.FileImportTaskTypeEnum;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.HDTCArrayUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.ThrowableUtils;

public class FileImportTaskDomainServiceImpl
implements IFileImportTaskDomainService {
    private static Log LOG = LogFactory.getLog(FileImportTaskDomainServiceImpl.class);
    private IFileImportSubTaskEntityService fileImportSubTaskEntityService = ServiceFactory.getService(IFileImportSubTaskEntityService.class);
    private IFileImportTaskEntityService fileImportTaskEntityService = ServiceFactory.getService(IFileImportTaskEntityService.class);
    private static final String SUB_SELECT_PROPS = "id,dealstatus,tmpurl,fieldtype,datapkid,filednumber,zipname,zipurl,filename,scene,entitynumber,task,executetime,singleplugin";
    private static final String SELECT_PROPS = "id,number,name,creator.name,modifier.name,createtime,modifytime,config,taskstatus,taskid,tasktype";
    private static final String TASK = "task";
    private static final String TASK_STATUS = "taskstatus";

    @Override
    public DynamicObject[] getSubTasksByTaskId(long bizTaskId) {
        return this.fileImportSubTaskEntityService.query(SUB_SELECT_PROPS, new QFilter[]{new QFilter(TASK, "=", (Object)bizTaskId)});
    }

    @Override
    public FileImportTaskData getAllValidTaskInfoList(QFilter initFilter, int pageIndex, int pageSize) {
        ImmutableList validateStatusFilter = ImmutableList.of((Object)FileImportTaskDealStatusEnum.EXECUTING.getStatus(), (Object)FileImportTaskDealStatusEnum.COMPLETE.getStatus(), (Object)FileImportTaskDealStatusEnum.FAIL.getStatus());
        QFilter statusFilter = new QFilter(TASK_STATUS, "in", (Object)validateStatusFilter);
        if (initFilter != null) {
            statusFilter.and(initFilter);
        }
        int count = this.fileImportTaskEntityService.count(new QFilter[]{statusFilter});
        FileImportTaskData fileImportTaskData = new FileImportTaskData();
        fileImportTaskData.setPageSize(pageSize);
        fileImportTaskData.setPageIndex(pageIndex);
        fileImportTaskData.setTotal(0);
        if (count <= 0) {
            return fileImportTaskData;
        }
        fileImportTaskData.setTotal(count);
        QFilter ingFilter = new QFilter(TASK_STATUS, "=", (Object)FileImportTaskDealStatusEnum.EXECUTING.getStatus());
        if (initFilter != null) {
            ingFilter.and(initFilter);
        }
        int ingCount = this.fileImportTaskEntityService.count(new QFilter[]{ingFilter});
        fileImportTaskData.setIngCount(ingCount);
        QFilter completeFilter = new QFilter(TASK_STATUS, "=", (Object)FileImportTaskDealStatusEnum.COMPLETE.getStatus());
        if (initFilter != null) {
            completeFilter.and(initFilter);
        }
        int completeCount = this.fileImportTaskEntityService.count(new QFilter[]{completeFilter});
        fileImportTaskData.setCompleteCount(completeCount);
        QFilter failFilter = new QFilter(TASK_STATUS, "=", (Object)FileImportTaskDealStatusEnum.FAIL.getStatus());
        if (initFilter != null) {
            failFilter.and(initFilter);
        }
        int failCount = this.fileImportTaskEntityService.count(new QFilter[]{failFilter});
        fileImportTaskData.setFailCount(failCount);
        if (initFilter != null) {
            statusFilter.and(initFilter);
        }
        DynamicObject[] taskArr = this.fileImportTaskEntityService.queryPageCollection(SELECT_PROPS, new QFilter[]{statusFilter}, "createtime desc", pageIndex, pageSize);
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)taskArr.length);
        Arrays.stream(taskArr).forEach(data -> {
            FileImportTaskBean fileImportTaskBean = new FileImportTaskBean();
            fileImportTaskBean.setId(data.getLong("id"));
            fileImportTaskBean.setIdStr(data.getString("id"));
            fileImportTaskBean.setTaskName(data.getString("name"));
            fileImportTaskBean.setTaskNumber(data.getString("number"));
            fileImportTaskBean.setConfigName(data.getString("config.name"));
            fileImportTaskBean.setTaskId(data.getString("taskid"));
            fileImportTaskBean.setTaskStatus(data.getString(TASK_STATUS));
            fileImportTaskBean.setCreateTime(data.getDate("createtime"));
            fileImportTaskBean.setCreatorName(data.getString("creator.name"));
            FileImportTaskTypeEnum taskType = FileImportTaskTypeEnum.getByType((String)data.getString("tasktype"));
            if (taskType != null) {
                fileImportTaskBean.setTaskType(taskType.getName());
            }
            resultList.add(fileImportTaskBean);
        });
        List idList = resultList.stream().map(FileImportTaskBean::getId).collect(Collectors.toList());
        Object[] subTaskArr = this.fileImportSubTaskEntityService.query(SUB_SELECT_PROPS, new QFilter[]{new QFilter(TASK, "in", idList)});
        if (HDTCArrayUtils.isNotEmpty((Object[])subTaskArr)) {
            Map<String, List<DynamicObject>> subTaskMap = Arrays.stream(subTaskArr).collect(Collectors.groupingBy(data -> data.getString("task_id")));
            resultList.stream().forEach(fileImportTaskBean -> {
                List subTaskList = (List)subTaskMap.get(String.valueOf(fileImportTaskBean.getId()));
                if (CollectionUtils.isNotEmpty((Collection)subTaskList)) {
                    long successNum = subTaskList.stream().filter(data -> StringUtils.equals((String)data.getString("dealstatus"), (String)FileImportSubTaskDealStatusEnum.SUCCESS.getStatus())).count();
                    long failNum = subTaskList.stream().filter(data -> StringUtils.equals((String)data.getString("dealstatus"), (String)FileImportSubTaskDealStatusEnum.FAIL.getStatus())).count();
                    fileImportTaskBean.setTaskProcess((int)Math.floor((successNum + failNum) / (long)subTaskList.size()) * 100);
                    fileImportTaskBean.setSuccessNum(successNum);
                    fileImportTaskBean.setFailNum(failNum);
                }
            });
        }
        List taskIdList = resultList.stream().map(FileImportTaskBean::getTaskId).collect(Collectors.toList());
        LOG.info("getAllValidTaskInfoList select bos task start taskIdList:{}", taskIdList);
        List taskInfoList = ScheduleServiceHelper.queryTask(taskIdList);
        if (CollectionUtils.isNotEmpty((Collection)taskInfoList)) {
            Map<String, TaskInfo> bozTaskMap = taskInfoList.stream().filter(data -> data != null && data.getId() != null).collect(Collectors.toMap(TaskInfo::getId, data -> data, (v1, v2) -> v2));
            resultList.stream().forEach(fileImportTaskBean -> {
                FileImportTaskDealStatusEnum taskStatusEnum;
                TaskInfo bizTask = (TaskInfo)bozTaskMap.get(fileImportTaskBean.getTaskId());
                if (bizTask != null) {
                    if (StringUtils.equals((String)FileImportTaskDealStatusEnum.FAIL.getStatus(), (String)fileImportTaskBean.getTaskStatus())) {
                        fileImportTaskBean.setFailureReason(bizTask.getFailureReason());
                    }
                    if (StringUtils.equals((String)"ABORTED", (String)bizTask.getStatus())) {
                        fileImportTaskBean.setTaskStatus(FileImportTaskDealStatusEnum.ABORTED.getStatus());
                    }
                }
                fileImportTaskBean.setTaskStatusName((taskStatusEnum = FileImportTaskDealStatusEnum.getByStatus((String)fileImportTaskBean.getTaskStatus())) == null ? fileImportTaskBean.getTaskStatus() : taskStatusEnum.getName());
            });
            LOG.info("getAllValidTaskInfoList select bos task end taskIdList.size:{}", (Object)taskIdList.size());
        }
        fileImportTaskData.setTaskList(resultList);
        return fileImportTaskData;
    }

    @Override
    public FileImportTaskBean getValidTaskInfoById(long bizTaskId) {
        DynamicObject task = this.fileImportTaskEntityService.queryOne(SELECT_PROPS, new QFilter[]{new QFilter("id", "=", (Object)bizTaskId)});
        if (task == null) {
            return null;
        }
        FileImportTaskBean fileImportTaskBean = new FileImportTaskBean();
        fileImportTaskBean.setId(task.getLong("id"));
        fileImportTaskBean.setIdStr(task.getString("id"));
        fileImportTaskBean.setConfigName(task.getString("config.name"));
        fileImportTaskBean.setTaskId(task.getString("taskid"));
        fileImportTaskBean.setTaskStatus(task.getString(TASK_STATUS));
        fileImportTaskBean.setCreateTime(task.getDate("createtime"));
        fileImportTaskBean.setCreatorName(task.getString("creator.name"));
        fileImportTaskBean.setTaskType(task.getString("taskType"));
        Object[] subTaskArr = this.fileImportSubTaskEntityService.query(SUB_SELECT_PROPS, new QFilter[]{new QFilter(TASK, "=", (Object)bizTaskId)});
        if (HDTCArrayUtils.isNotEmpty((Object[])subTaskArr)) {
            long successNum = Arrays.stream(subTaskArr).filter(data -> StringUtils.equals((String)data.getString("dealstatus"), (String)FileImportSubTaskDealStatusEnum.SUCCESS.getStatus())).count();
            long failNum = Arrays.stream(subTaskArr).filter(data -> StringUtils.equals((String)data.getString("dealstatus"), (String)FileImportSubTaskDealStatusEnum.FAIL.getStatus())).count();
            fileImportTaskBean.setTaskProcess((int)Math.floor((successNum + failNum) / (long)subTaskArr.length) * 100);
            fileImportTaskBean.setSuccessNum(successNum);
            fileImportTaskBean.setFailNum(failNum);
        }
        LOG.info("getValidTaskInfoById select bos task start taskId:{}", (Object)fileImportTaskBean.getTaskId());
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)fileImportTaskBean.getTaskId());
        if (taskInfo != null) {
            FileImportTaskDealStatusEnum taskStatusEnum;
            LOG.info("getAllValidTaskInfoList select bos task end taskId:{},taskStatus:{},failureReason", new Object[]{fileImportTaskBean.getTaskId(), taskInfo.getStatus(), taskInfo.getFailureReason()});
            if (StringUtils.equals((String)FileImportTaskDealStatusEnum.FAIL.getStatus(), (String)fileImportTaskBean.getTaskStatus())) {
                fileImportTaskBean.setFailureReason(taskInfo.getFailureReason());
            }
            if (StringUtils.equals((String)"ABORTED", (String)taskInfo.getStatus())) {
                fileImportTaskBean.setTaskStatus(FileImportTaskDealStatusEnum.ABORTED.getStatus());
            }
            fileImportTaskBean.setTaskStatusName((taskStatusEnum = FileImportTaskDealStatusEnum.getByStatus((String)fileImportTaskBean.getTaskStatus())) == null ? fileImportTaskBean.getTaskStatus() : taskStatusEnum.getName());
        } else {
            LOG.info("getAllValidTaskInfoList select bos task end task is null taskId:{}", (Object)fileImportTaskBean.getTaskId());
        }
        return fileImportTaskBean;
    }

    @Override
    public FileImportSubTaskResultBean executeSubTask(DynamicObject subTask, FileImportConfigBo fileImportConfigBo) {
        LOG.info("executeSubTask start  subtaskId:{}", subTask == null ? "null" : Long.valueOf(subTask.getLong("id")));
        if (subTask == null) {
            return null;
        }
        String fieldType = subTask.getString("fieldtype");
        FileFieldTypeEnum fileFieldTypeEnum = FileFieldTypeEnum.getBizModelTypeByLevel((String)fieldType);
        IFileFieldDealService fileFieldDealService = FileImportFieldDealServiceFactory.getServiceByType(fileFieldTypeEnum);
        FileImportFileFieldInfoBo fileImportFileFieldInfoBo = this.getFileImportFileFieldInfoBo(subTask);
        FileImportSubTaskResultBean fileImportSubTaskResultBean = null;
        try {
            fileImportSubTaskResultBean = fileFieldDealService.uploadFileList(fileImportFileFieldInfoBo, subTask, fileImportConfigBo);
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
            fileImportSubTaskResultBean = new FileImportSubTaskResultBean(fileImportFileFieldInfoBo.getEntityNumber());
            fileImportSubTaskResultBean.fail(ThrowableUtils.toString((Throwable)exception));
            List<String> failFileNameList = fileImportSubTaskResultBean.getFailFileNameList();
            fileImportFileFieldInfoBo.getFileInfoList().forEach(fileInfo -> failFileNameList.add(fileInfo.getFileName()));
        }
        return fileImportSubTaskResultBean;
    }

    private FileImportFileFieldInfoBo getFileImportFileFieldInfoBo(DynamicObject subTaskDyn) {
        FileImportFileFieldInfoBo fileImportFileFieldInfoBo = this.getFileImportFieldInfoBo(subTaskDyn);
        String zipUrl = subTaskDyn.getString("zipurl");
        String domainContextUrl = UrlService.getDomainContextUrl();
        FileImportFileFieldInfoBo.FileInfo tempFileFieldInfo = FileImportUtils.getTempFileFieldInfo(zipUrl, subTaskDyn.getString("zipname"), domainContextUrl + "/" + subTaskDyn.getString("tmpurl"), fileImportFileFieldInfoBo.getSceneNumber(), subTaskDyn.getString("filename"));
        fileImportFileFieldInfoBo.getFileInfoList().add(tempFileFieldInfo);
        return fileImportFileFieldInfoBo;
    }

    @Override
    public FileImportSubTaskResultBean executeFileImportTask(DynamicObject subTaskDyn) {
        return null;
    }

    @Override
    public FileImportSubTaskResultBean executeFileDeleteTask(DynamicObject subTaskDyn) {
        LOG.info("executeFileDeleteTask start  subtaskId:{}", subTaskDyn == null ? "null" : Long.valueOf(subTaskDyn.getLong("id")));
        if (subTaskDyn == null) {
            return null;
        }
        String fieldType = subTaskDyn.getString("fieldtype");
        FileFieldTypeEnum fileFieldTypeEnum = FileFieldTypeEnum.getBizModelTypeByLevel((String)fieldType);
        IFileFieldDealService fileFieldDealService = FileImportFieldDealServiceFactory.getServiceByType(fileFieldTypeEnum);
        FileImportFileFieldInfoBo fileImportFieldInfoBo = this.getFileImportFieldInfoBo(subTaskDyn);
        FileImportFileFieldInfoBo.FileInfo tempFileFieldInfo = new FileImportFileFieldInfoBo.FileInfo();
        tempFileFieldInfo.setFileName(subTaskDyn.getString("filename"));
        fileImportFieldInfoBo.getFileInfoList().add(tempFileFieldInfo);
        return fileFieldDealService.deleteFileList(fileImportFieldInfoBo);
    }

    @Override
    public void continueTask(long taskId) {
        LOG.info("continueTask start  taskId:{}", (Object)taskId);
        DynamicObject task = this.fileImportTaskEntityService.queryOne(SELECT_PROPS, new QFilter[]{new QFilter("id", "=", (Object)taskId)});
        if (task == null) {
            return;
        }
        String bosTaskId = FileImportTaskHandleUtils.generateFileImportJob(taskId);
        task.set("taskid", (Object)bosTaskId);
        this.fileImportTaskEntityService.save(task);
    }

    private FileImportFileFieldInfoBo getFileImportFieldInfoBo(DynamicObject subTaskDyn) {
        BasedataEntityType dataEntityType = (BasedataEntityType)subTaskDyn.getDataEntityType();
        String mainConfigNumber = subTaskDyn.getString("scene.config.number");
        FileImportFileFieldInfoBo fileImportFileFieldInfoBo = new FileImportFileFieldInfoBo();
        fileImportFileFieldInfoBo.setSceneNumber(mainConfigNumber);
        fileImportFileFieldInfoBo.setAppId(dataEntityType.getAppId());
        fileImportFileFieldInfoBo.setEntityNumber(subTaskDyn.getString("entitynumber"));
        fileImportFileFieldInfoBo.setDataPkId(subTaskDyn.getLong("datapkid"));
        fileImportFileFieldInfoBo.setFiledNumber(subTaskDyn.getString("filednumber"));
        return fileImportFileFieldInfoBo;
    }
}

