/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.domain.fileimport.model;

import java.io.Serializable;
import kd.hdtc.hrdbs.common.exception.HDTCBizException;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class FileImportFieldBo
implements Serializable {
    private static final long serialVersionUID = 4398123662585020347L;
    private String entityNumber;
    private String filedNumber;
    private String fullFiledNumber;
    private Class<?> dataType;
    private String value;

    public FileImportFieldBo() {
    }

    public FileImportFieldBo(String entityNumber, String filedNumber) {
        this.entityNumber = entityNumber;
        this.filedNumber = filedNumber;
        this.fullFiledNumber = entityNumber + "." + filedNumber;
    }

    public FileImportFieldBo(String fullFiledNumber) {
        this.fullFiledNumber = fullFiledNumber;
        if (StringUtils.isEmpty((String)fullFiledNumber)) {
            return;
        }
        String[] infoArr = fullFiledNumber.split("\\.", 2);
        if (infoArr.length < 2) {
            throw new HDTCBizException("entity is error longNumber:" + fullFiledNumber);
        }
        this.entityNumber = infoArr[0];
        this.filedNumber = infoArr[1];
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public String getFiledNumber() {
        return this.filedNumber;
    }

    public void setFiledNumber(String filedNumber) {
        this.filedNumber = filedNumber;
    }

    public String getFullFiledNumber() {
        return this.fullFiledNumber;
    }

    public void setFullFiledNumber(String fullFiledNumber) {
        this.fullFiledNumber = fullFiledNumber;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Class<?> getDataType() {
        return this.dataType;
    }

    public void setDataType(Class<?> dataType) {
        this.dataType = dataType;
    }

    public static String buildLongNumber(String entityNumber, String fieldNumber) {
        return entityNumber + "." + fieldNumber;
    }

    static interface DataType {
        public static final String TYPE_NUMBER = "NUMBER";
        public static final String TYPE_STRING = "STRING";
    }
}

