/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.domain.fileimport.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportConfigBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportFileFieldInfoBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportSingleFilePreviewResultBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportSubSceneBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportValidateFailDataBean;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportValidateSuccessDataBean;
import kd.hdtc.hrcc.common.enums.FileImportPreviewStatusEnum;

public class FileImportPreviewResultBo
implements Serializable {
    private static final long serialVersionUID = 90041002549501063L;
    private List<FileImportFileFieldInfoBo.FileInfo> fileNameList;
    private FileImportConfigBo fileImportConfigBo;
    private Map<String, FileImportSubSceneBo> fileNameAndSceneMap = new HashMap<String, FileImportSubSceneBo>(16);
    private Map<String, FileImportSingleFilePreviewResultBo> validateResultMap = new HashMap<String, FileImportSingleFilePreviewResultBo>(16);
    private String previewStatus = FileImportPreviewStatusEnum.SUCCESS.getStatus();
    private String errorMsg;
    private List<FileImportValidateSuccessDataBean> successDataList = new ArrayList<FileImportValidateSuccessDataBean>(10);
    private List<FileImportValidateFailDataBean> failDataList = new ArrayList<FileImportValidateFailDataBean>(10);

    public FileImportPreviewResultBo() {
    }

    public FileImportPreviewResultBo(List<FileImportFileFieldInfoBo.FileInfo> fileNameList, FileImportConfigBo configBo) {
        this.fileNameList = fileNameList;
        this.fileImportConfigBo = configBo;
    }

    public void buildFailResult(String errorMsg) {
        this.previewStatus = FileImportPreviewStatusEnum.FAIL.getStatus();
        this.errorMsg = errorMsg;
    }

    public List<FileImportFileFieldInfoBo.FileInfo> getFileNameList() {
        return this.fileNameList;
    }

    public void setFileNameList(List<FileImportFileFieldInfoBo.FileInfo> fileNameList) {
        this.fileNameList = fileNameList;
    }

    public FileImportConfigBo getFileImportConfigBo() {
        return this.fileImportConfigBo;
    }

    public void setFileImportConfigBo(FileImportConfigBo fileImportConfigBo) {
        this.fileImportConfigBo = fileImportConfigBo;
    }

    public String getPreviewStatus() {
        return this.previewStatus;
    }

    public void setPreviewStatus(String previewStatus) {
        this.previewStatus = previewStatus;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public List<FileImportValidateSuccessDataBean> getSuccessDataList() {
        return this.successDataList;
    }

    public void setSuccessDataList(List<FileImportValidateSuccessDataBean> successDataList) {
        this.successDataList = successDataList;
    }

    public List<FileImportValidateFailDataBean> getFailDataList() {
        return this.failDataList;
    }

    public void setFailDataList(List<FileImportValidateFailDataBean> failDataList) {
        this.failDataList = failDataList;
    }

    public Map<String, FileImportSingleFilePreviewResultBo> getValidateResultMap() {
        return this.validateResultMap;
    }

    public void setValidateResultMap(Map<String, FileImportSingleFilePreviewResultBo> validateResultMap) {
        this.validateResultMap = validateResultMap;
    }

    public Map<String, FileImportSubSceneBo> getFileNameAndSceneMap() {
        return this.fileNameAndSceneMap;
    }

    public void setFileNameAndSceneMap(Map<String, FileImportSubSceneBo> fileNameAndSceneMap) {
        this.fileNameAndSceneMap = fileNameAndSceneMap;
    }

    public FileImportSingleFilePreviewResultBo getValidateResultByKey(String zipName, String fileName) {
        String buildKey = this.buildKey(zipName, fileName);
        FileImportSingleFilePreviewResultBo fileImportSingleFilePreviewResultBo = this.validateResultMap.getOrDefault(buildKey, new FileImportSingleFilePreviewResultBo(zipName, fileName));
        this.validateResultMap.put(buildKey, fileImportSingleFilePreviewResultBo);
        return fileImportSingleFilePreviewResultBo;
    }

    public FileImportSingleFilePreviewResultBo getValidateResultByFullName(String fullName) {
        FileImportFileFieldInfoBo.FileInfo fieldInfo = this.getFieldInfoByFullName(fullName);
        FileImportSingleFilePreviewResultBo fileImportSingleFilePreviewResultBo = this.validateResultMap.getOrDefault(fullName, new FileImportSingleFilePreviewResultBo(fieldInfo.getZipName(), fieldInfo.getFileName()));
        this.validateResultMap.put(fullName, fileImportSingleFilePreviewResultBo);
        return fileImportSingleFilePreviewResultBo;
    }

    public String buildKey(String zipName, String fileName) {
        StringBuilder valueKey = new StringBuilder(zipName).append("@@@@@").append(fileName);
        return valueKey.toString();
    }

    public FileImportFileFieldInfoBo.FileInfo getFieldInfoByFullName(String fullName) {
        FileImportFileFieldInfoBo.FileInfo fieldInfo = new FileImportFileFieldInfoBo.FileInfo();
        String[] nameArr = fullName.split("@@@@@");
        fieldInfo.setZipName(nameArr[0]);
        fieldInfo.setFileName(nameArr[1]);
        return fieldInfo;
    }

    public void analysisSuccessDataBeanList(FileImportPreviewResultBo fileImportPreviewResultBo, FileImportConfigBo fileImportConfigBo) {
        fileImportPreviewResultBo.setSuccessDataList(this.getSuccessDataBean(fileImportPreviewResultBo, fileImportConfigBo));
    }

    public List<FileImportValidateSuccessDataBean> getSuccessDataBean(FileImportPreviewResultBo fileImportPreviewResultBo, FileImportConfigBo fileImportConfigBo) {
        ArrayList<FileImportValidateSuccessDataBean> successDataList = new ArrayList<FileImportValidateSuccessDataBean>(10);
        List<FileImportFileFieldInfoBo.FileInfo> fileNameList = fileImportPreviewResultBo.getFileNameList();
        for (FileImportFileFieldInfoBo.FileInfo fileInfo : fileNameList) {
            FileImportSingleFilePreviewResultBo validateResult = fileImportPreviewResultBo.getValidateResultByKey(fileInfo.getZipName(), fileInfo.getFileName());
            if (!FileImportPreviewStatusEnum.SUCCESS.getStatus().equals(validateResult.getPreviewStatus())) continue;
            FileImportValidateSuccessDataBean successDataBean = new FileImportValidateSuccessDataBean();
            successDataBean.setZipName(fileInfo.getZipName());
            successDataBean.setFileName(fileInfo.getFileName());
            successDataBean.setSceneId(fileImportConfigBo.getSceneId());
            successDataBean.setFileImportFieldBoList(validateResult.getFileImportFieldBoList());
            successDataBean.setFileImportSubSceneBo(fileImportPreviewResultBo.getFileNameAndSceneMap().get(this.buildKey(fileInfo.getZipName(), fileInfo.getFileName())));
            successDataBean.setSameSize(validateResult.getSameSize());
            successDataList.add(successDataBean);
        }
        return successDataList;
    }

    public void analysisFailDataBeanList(FileImportPreviewResultBo fileImportPreviewResultBo) {
        List<FileImportValidateFailDataBean> failDataList = this.getFileImportValidateFailDataList(fileImportPreviewResultBo);
        fileImportPreviewResultBo.setFailDataList(failDataList);
    }

    public List<FileImportValidateFailDataBean> getFileImportValidateFailDataList(FileImportPreviewResultBo fileImportPreviewResultBo) {
        ArrayList<FileImportValidateFailDataBean> failDataList = new ArrayList<FileImportValidateFailDataBean>(10);
        if (fileImportPreviewResultBo == null) {
            return failDataList;
        }
        List<FileImportFileFieldInfoBo.FileInfo> fileNameList = fileImportPreviewResultBo.getFileNameList();
        for (FileImportFileFieldInfoBo.FileInfo fileInfo : fileNameList) {
            FileImportSingleFilePreviewResultBo validateResult = fileImportPreviewResultBo.getValidateResultByKey(fileInfo.getZipName(), fileInfo.getFileName());
            if (!FileImportPreviewStatusEnum.FAIL.getStatus().equals(validateResult.getPreviewStatus())) continue;
            FileImportValidateFailDataBean failDataBean = new FileImportValidateFailDataBean();
            failDataBean.setZipName(fileInfo.getZipName());
            failDataBean.setFileName(fileInfo.getFileName());
            List<String> errorMsgList = validateResult.getErrorMsgList();
            StringBuilder errMsgSb = new StringBuilder();
            for (String errMsg : errorMsgList) {
                errMsgSb.append(errMsg).append("\r\n");
            }
            failDataBean.setFailMsg(errMsgSb.toString());
            failDataList.add(failDataBean);
        }
        return failDataList;
    }
}

