/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.domain.fileimport.service.impl;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportSubTaskResultBean;
import kd.hdtc.hrcc.business.domain.fileimport.service.IFileImportExecuteSubTaskEndSingleService;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.common.util.HDTCArrayUtils;

public class PersonHeadPictureExecuteSubTaskEndSingleService
implements IFileImportExecuteSubTaskEndSingleService {
    private static Log LOG = LogFactory.getLog(PersonHeadPictureExecuteSubTaskEndSingleService.class);
    private static final String HRPI_PERSON = "hrpi_person";
    private static final String PERSON_SELECT_FIELD = "id,headsculpture";
    private static final String HRPI_PER_NO_NTS_PROP = "hrpi_pernontsprop";
    private static final String HRPI_PER_NO_NTS_PROP_SELECT_FIELD = "id,person,headsculpture";
    private static final String PERSON_FIELD = "person";
    private static final String HEAD_SCULPTURE = "headsculpture";

    @Override
    public void executeEndTask(DynamicObject subTask, FileImportSubTaskResultBean fileImportSubTaskResultBean) {
        LOG.info("PersonHeadPictureExecuteSubTaskEndSingleService executeEndTask start");
        if (subTask == null || fileImportSubTaskResultBean == null) {
            LOG.info("executeEndTask:subTask or fileImportSubTaskResultBean is null");
            return;
        }
        long dataPkId = subTask.getLong("datapkid");
        if (dataPkId == 0L) {
            LOG.info("executeEndTask: dataPkId is null");
            return;
        }
        IBaseEntityService personEntityService = CommonEntityServiceFactory.getEntityService((String)HRPI_PERSON);
        DynamicObject person = personEntityService.queryOne(PERSON_SELECT_FIELD, (Object)dataPkId);
        if (person == null) {
            LOG.info("executeEndTask: query hrpi_person is null dataPkId:{}", (Object)dataPkId);
            return;
        }
        IBaseEntityService noNtsPropEntityService = CommonEntityServiceFactory.getEntityService((String)HRPI_PER_NO_NTS_PROP);
        QFilter qFilter = new QFilter(PERSON_FIELD, "=", (Object)dataPkId);
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        Object[] noNtsPropArr = noNtsPropEntityService.query(HRPI_PER_NO_NTS_PROP_SELECT_FIELD, new QFilter[]{qFilter});
        if (HDTCArrayUtils.isEmpty((Object[])noNtsPropArr)) {
            LOG.info("executeEndTask: query hrpi_pernontsprop is null person:{}", (Object)dataPkId);
        }
        String headSculpture = person.getString(HEAD_SCULPTURE);
        LOG.info("PersonHeadPictureExecuteSubTaskEndSingleService executeEndTask headSculpture\uff1a{}", (Object)headSculpture);
        Arrays.stream(noNtsPropArr).forEach(data -> data.set(HEAD_SCULPTURE, (Object)headSculpture));
        noNtsPropEntityService.save((DynamicObject[])noNtsPropArr);
        LOG.info("PersonHeadPictureExecuteSubTaskEndSingleService executeEndTask end");
    }
}

