/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.domain.fileimport.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportFieldBo;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public class EntityFieldDealUtils {
    private static List<? extends IDataEntityProperty> filterPropExcludeType(DataEntityPropertyCollection properties) {
        return properties.stream().filter(pro -> StringUtils.isNotEmpty((String)pro.getAlias())).filter(pro -> !(pro instanceof EntryProp)).filter(pro -> !(pro instanceof MulBasedataProp)).filter(pro -> !(pro instanceof LongProp) || !((LongProp)pro).isRefId()).collect(Collectors.toList());
    }

    public static List<ComboItem> initComboFieldVal(String entityNumber, BiConsumer<String, IDataEntityProperty> consumer) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        List<? extends IDataEntityProperty> props = EntityFieldDealUtils.filterPropExcludeType(properties);
        props.stream().forEach(pro -> {
            String valueKey = pro.getName();
            if (pro instanceof BasedataProp) {
                EntityFieldDealUtils.putBaseDataPropItemList(comboItems, (BasedataProp)pro);
            } else {
                ComboItem comboItem = new ComboItem();
                if (pro.getDisplayName() == null) {
                    comboItem.setCaption(new LocaleString(pro.getName()));
                } else {
                    comboItem.setCaption(pro.getDisplayName());
                }
                comboItem.setValue(valueKey);
                comboItems.add(comboItem);
            }
            if (consumer != null) {
                consumer.accept(valueKey, (IDataEntityProperty)pro);
            }
        });
        return comboItems;
    }

    private static void putBaseDataPropItemList(List<ComboItem> comboItems, BasedataProp prop) {
        String propShowName = prop.getDisplayName() == null ? prop.getName() : (StringUtils.isNotEmpty((String)prop.getDisplayName().getLocaleValue()) ? prop.getDisplayName().getLocaleValue() : prop.getName());
        StringBuilder propValue = new StringBuilder(prop.getName());
        StringBuilder displayId = new StringBuilder(propShowName).append(".").append("id");
        StringBuilder valueId = new StringBuilder(propValue).append(".").append("id");
        ComboItem comboItemId = new ComboItem();
        comboItemId.setCaption(new LocaleString(displayId.toString()));
        comboItemId.setValue(valueId.toString());
        comboItems.add(comboItemId);
        if (StringUtils.isNotEmpty((String)prop.getNumberProp())) {
            StringBuilder displayNumber = new StringBuilder(propShowName).append(".");
            StringBuilder valueNumber = new StringBuilder(propValue).append(".");
            ComboItem comboItemNumber = new ComboItem();
            if (prop.getNumbProp() == null || prop.getNumbProp().getDisplayName() == null || StringUtils.isEmpty((String)prop.getNumbProp().getDisplayName().getLocaleValue())) {
                comboItemNumber.setCaption(new LocaleString(displayNumber.append(prop.getNumberProp()).toString()));
            } else {
                comboItemNumber.setCaption(new LocaleString(displayNumber.append(prop.getNumbProp().getDisplayName().getLocaleValue()).toString()));
            }
            comboItemNumber.setValue(valueNumber.append(prop.getNumberProp()).toString());
            comboItems.add(comboItemNumber);
        }
        if (StringUtils.isNotEmpty((String)prop.getDisplayProp())) {
            StringBuilder displayName = new StringBuilder(propShowName).append(".");
            StringBuilder valueName = new StringBuilder(propValue).append(".");
            ComboItem comboItemName = new ComboItem();
            if (prop.getDispProp() == null || prop.getDispProp().getDisplayName() == null || StringUtils.isEmpty((String)prop.getDispProp().getDisplayName().getLocaleValue())) {
                comboItemName.setCaption(new LocaleString(displayName.append(prop.getDisplayProp()).toString()));
            } else {
                comboItemName.setCaption(new LocaleString(displayName.append(prop.getDispProp().getDisplayName().getLocaleValue()).toString()));
            }
            comboItemName.setValue(valueName.append(prop.getDisplayProp()).toString());
            comboItems.add(comboItemName);
        }
    }

    public static List<ComboItem> initComboFullFieldVal(String entityNumber, BiConsumer<String, IDataEntityProperty> consumer) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        List<? extends IDataEntityProperty> props = EntityFieldDealUtils.filterPropExcludeType(properties);
        props.stream().forEach(pro -> {
            String valueKey = FileImportFieldBo.buildLongNumber(entityNumber, pro.getName());
            if (pro instanceof BasedataProp) {
                EntityFieldDealUtils.putAllBaseDataPropItemList(comboItems, (BasedataProp)pro, mainEntityType);
            } else {
                ComboItem comboItem = new ComboItem();
                StringBuilder displayName = new StringBuilder(mainEntityType.getDisplayName().getLocaleValue()).append(".");
                if (pro.getDisplayName() == null || StringUtils.isEmpty((String)pro.getDisplayName().getLocaleValue())) {
                    displayName.append(pro.getName());
                } else {
                    displayName.append(pro.getDisplayName().getLocaleValue());
                }
                comboItem.setCaption(new LocaleString(displayName.toString()));
                comboItem.setValue(valueKey);
                comboItems.add(comboItem);
            }
            if (consumer != null) {
                consumer.accept(valueKey, (IDataEntityProperty)pro);
            }
        });
        return comboItems;
    }

    private static void putAllBaseDataPropItemList(List<ComboItem> comboItems, BasedataProp prop, MainEntityType mainEntityType) {
        StringBuilder propDisplayName = new StringBuilder(mainEntityType.getDisplayName().getLocaleValue()).append(".");
        StringBuilder propDisplayValue = new StringBuilder(mainEntityType.getName()).append(".").append(prop.getName());
        if (prop.getDisplayName() == null || StringUtils.isEmpty((String)prop.getDisplayName().getLocaleValue())) {
            propDisplayName.append(prop.getName());
        } else {
            propDisplayName.append(prop.getDisplayName().getLocaleValue());
        }
        StringBuilder displayId = new StringBuilder(propDisplayName).append(".");
        StringBuilder valueId = new StringBuilder(propDisplayValue).append(".");
        ComboItem comboItemId = new ComboItem();
        comboItemId.setCaption(new LocaleString(displayId.append("id").toString()));
        comboItemId.setValue(valueId.append("id").toString());
        comboItems.add(comboItemId);
        if (StringUtils.isNotEmpty((String)prop.getNumberProp())) {
            StringBuilder displayNumber = new StringBuilder(propDisplayName).append(".");
            StringBuilder valueNumber = new StringBuilder(propDisplayValue).append(".");
            ComboItem comboItemNumber = new ComboItem();
            if (prop.getNumbProp() == null || prop.getNumbProp().getDisplayName() == null || StringUtils.isEmpty((String)prop.getNumbProp().getDisplayName().getLocaleValue())) {
                comboItemNumber.setCaption(new LocaleString(displayNumber.append(prop.getNumberProp()).toString()));
            } else {
                comboItemNumber.setCaption(new LocaleString(displayNumber.append(prop.getNumbProp().getDisplayName().getLocaleValue()).toString()));
            }
            comboItemNumber.setValue(valueNumber.append(prop.getNumberProp()).toString());
            comboItems.add(comboItemNumber);
        }
        if (StringUtils.isNotEmpty((String)prop.getDisplayProp())) {
            StringBuilder displayName = new StringBuilder(propDisplayName).append(".");
            StringBuilder valueName = new StringBuilder(propDisplayValue).append(".");
            ComboItem comboItemName = new ComboItem();
            if (prop.getDispProp() == null || prop.getDispProp().getDisplayName() == null || StringUtils.isEmpty((String)prop.getDispProp().getDisplayName().getLocaleValue())) {
                comboItemName.setCaption(new LocaleString(displayName.append(prop.getDisplayProp()).toString()));
            } else {
                comboItemName.setCaption(new LocaleString(displayName.append(prop.getDispProp().getDisplayName().getLocaleValue()).toString()));
            }
            comboItemName.setValue(valueName.append(prop.getDisplayProp()).toString());
            comboItems.add(comboItemName);
        }
    }

    public static List<ComboItem> getComboPictureVal(String entityNumber, BiConsumer<String, PictureProp> consumer) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        properties.stream().filter(pro -> StringUtils.isNotEmpty((String)pro.getAlias())).filter(pro -> pro instanceof PictureProp).forEach(pro -> {
            String valueKey = FileImportFieldBo.buildLongNumber(entityNumber, pro.getName());
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(mainEntityType.getDisplayName().getLocaleValue() + "." + pro.getName()));
            comboItem.setValue(valueKey);
            comboItems.add(comboItem);
            if (consumer != null) {
                consumer.accept(valueKey, (PictureProp)pro);
            }
        });
        return comboItems;
    }

    public static List<ComboItem> getComboAttachmentVal(String entityNumber, BiConsumer<String, AttachmentProp> consumer) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        properties.stream().filter(pro -> StringUtils.isNotEmpty((String)pro.getAlias())).filter(pro -> pro instanceof AttachmentProp).forEach(pro -> {
            String valueKey = FileImportFieldBo.buildLongNumber(entityNumber, pro.getName());
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(mainEntityType.getDisplayName().getLocaleValue() + "." + pro.getName()));
            comboItem.setValue(valueKey);
            comboItems.add(comboItem);
            if (consumer != null) {
                consumer.accept(valueKey, (AttachmentProp)pro);
            }
        });
        return comboItems;
    }

    public static List<ComboItem> getComboAttachmentApVal(String entityNumber, BiConsumer<String, AttachmentPanelAp> consumer) {
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        List apList = formMeta.getItems();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        apList.stream().filter(pro -> pro instanceof AttachmentPanelAp).forEach(pro -> {
            String valueKey = FileImportFieldBo.buildLongNumber(entityNumber, pro.getKey());
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(formMeta.getName().getLocaleValue() + "." + pro.getName()));
            comboItem.setValue(valueKey);
            comboItems.add(comboItem);
            if (consumer != null) {
                consumer.accept(valueKey, (AttachmentPanelAp)pro);
            }
        });
        return comboItems;
    }

    public static IDataEntityProperty getPictureFieldInfo(String entityNumber, String fieldNumber, Consumer<PictureProp> consumer) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        Optional<IDataEntityProperty> prop = properties.stream().filter(pro -> pro instanceof PictureProp).filter(pro -> StringUtils.equals((String)pro.getName(), (String)fieldNumber)).findFirst();
        if (consumer != null) {
            consumer.accept((PictureProp)prop.get());
        }
        return prop.get();
    }

    public static IDataEntityProperty getAttachmentFieldInfo(String entityNumber, String fieldNumber, Consumer<AttachmentProp> consumer) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        Optional<IDataEntityProperty> prop = properties.stream().filter(pro -> pro instanceof AttachmentProp).filter(pro -> StringUtils.equals((String)pro.getName(), (String)fieldNumber)).findFirst();
        if (consumer != null) {
            consumer.accept((AttachmentProp)prop.get());
        }
        return prop.get();
    }

    public static ControlAp<?> getAttachmentApInfo(String entityNumber, String fieldNumber, Consumer<AttachmentPanelAp> consumer) {
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        List apList = formMeta.getItems();
        Optional<ControlAp> prop = apList.stream().filter(pro -> pro instanceof AttachmentPanelAp).filter(pro -> StringUtils.equals((String)pro.getKey(), (String)fieldNumber)).findFirst();
        if (consumer != null) {
            consumer.accept((AttachmentPanelAp)prop.get());
        }
        return prop.get();
    }
}

