/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.domain.fileimport.utils;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.FileUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class FileImportFileNameUtils {
    private static final String COMMA = "___";
    public static final String SPACIAL_IDE = "spacialIde";
    public static final String VALIDATE_NAME = "validate_name";

    public static String getFilePrefixName(String fullFileName) {
        if (StringUtils.isEmpty((String)fullFileName)) {
            return "";
        }
        return fullFileName.substring(0, fullFileName.lastIndexOf("."));
    }

    public static String[] splitFileNameByComma(String fileName) {
        if (StringUtils.isEmpty((String)fileName)) {
            return null;
        }
        return fileName.split(COMMA);
    }

    public static boolean validateFileNameByLength(String fileName, int length) {
        if (StringUtils.isEmpty((String)fileName)) {
            return false;
        }
        return fileName.split(COMMA).length == length || fileName.split(COMMA).length == length + 1;
    }

    public static Map<String, String> buildMapByKey(String fileName, LinkedHashSet<String> keyHashSet) {
        String[] nameArr;
        if (StringUtils.isEmpty((String)fileName) || CollectionUtils.isEmpty(keyHashSet) || !FileImportFileNameUtils.validateFileNameByLength(fileName, keyHashSet.size() + 1)) {
            return null;
        }
        String suffix = FileUtils.getFileSuffix((String)fileName);
        int dotIndex = StringUtils.indexOfIgnoreCase((String)fileName, (String)".");
        if (dotIndex > 0) {
            fileName = fileName.substring(0, dotIndex);
        }
        if ((nameArr = FileImportFileNameUtils.splitFileNameByComma(fileName)) == null) {
            return new HashMap<String, String>();
        }
        AtomicInteger delC = new AtomicInteger();
        HashMap<String, String> map = new HashMap<String, String>(keyHashSet.size() + 1);
        map.put(SPACIAL_IDE, nameArr[delC.getAndIncrement()]);
        keyHashSet.forEach(data -> map.put((String)data, nameArr[delC.getAndIncrement()]));
        if (delC.get() == nameArr.length - 1) {
            StringBuilder trueValidateName = new StringBuilder();
            for (int index = 0; index < nameArr.length - 1; ++index) {
                trueValidateName.append(nameArr[index]);
            }
            trueValidateName.append(".").append(suffix);
            map.put(VALIDATE_NAME, trueValidateName.toString());
        } else {
            map.put(VALIDATE_NAME, fileName);
        }
        return map;
    }
}

