/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.domain.fileimport.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportFileFieldInfoBo;
import kd.hdtc.hrdbs.common.exception.HDTCBizException;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.FileUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class FileImportUtils {
    private static final Log LOG = LogFactory.getLog(FileImportUtils.class);
    private static final String FILE_PATH = "fileimport";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, List<File>> unzipFileToLocal(String zipFileUrl, String scene, String fileName) {
        String zipFilePath;
        HashMap<String, List<File>> dirChildFileListMap;
        block11: {
            String localTempFilePath = FileUtils.downloadTempFile((String)zipFileUrl);
            if (StringUtils.isEmpty((String)localTempFilePath)) {
                localTempFilePath = FileUtils.downloadFile((String)zipFileUrl, (String)fileName.substring(fileName.lastIndexOf("\\.")));
            }
            FileOutputStream out = null;
            dirChildFileListMap = new HashMap<String, List<File>>(10);
            String unzipFilePath = FileImportUtils.getUnzipFilePath(fileName, scene);
            zipFilePath = unzipFilePath + File.separator + fileName;
            try {
                File[] files;
                FileUtils.checkAndCreateDir((String)unzipFilePath);
                out = new FileOutputStream(unzipFilePath + File.separator + fileName);
                FileUtils.unzip((String)localTempFilePath, (String)unzipFilePath);
                File dirFile = new File(unzipFilePath);
                if (dirFile.exists() && (files = dirFile.listFiles()) != null) {
                    dirChildFileListMap.putIfAbsent(fileName, new ArrayList(10));
                    List unzipChildList = (List)dirChildFileListMap.get(fileName);
                    unzipChildList.addAll(Arrays.stream(files).filter(file -> !StringUtils.equals((String)fileName, (String)file.getName())).collect(Collectors.toList()));
                }
                if (out == null) break block11;
            }
            catch (IOException ioException) {
                try {
                    LOG.error("unzipFile is exception.dataPkId={},zipFileUrl={},ioException={}", new Object[]{scene, zipFileUrl, ioException});
                    throw new HDTCBizException("unzipFileToLocal is exception.errMsg=" + ioException.getMessage());
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ioException2) {
                            LOG.error("unzipFile close outInput is exception.dataPkId={},zipFileUrl={},ioException={}", new Object[]{scene, zipFileUrl, ioException2});
                        }
                    }
                    FileUtils.deleteLocalFile((File)new File(zipFilePath));
                    throw throwable;
                }
            }
            try {
                out.close();
            }
            catch (IOException ioException) {
                LOG.error("unzipFile close outInput is exception.dataPkId={},zipFileUrl={},ioException={}", new Object[]{scene, zipFileUrl, ioException});
            }
        }
        FileUtils.deleteLocalFile((File)new File(zipFilePath));
        return dirChildFileListMap;
    }

    public static void deleteLocalTempFile(String scene, String zipFileName, Set<String> childFileNameSet) {
        String sceneChildDir = FileImportUtils.getUnzipFilePath(zipFileName, scene);
        File dirFile = new File(sceneChildDir);
        if (dirFile.exists()) {
            File[] childFileArr = dirFile.listFiles();
            if (childFileArr == null) {
                return;
            }
            for (File childFile : childFileArr) {
                if (!childFileNameSet.contains(childFile.getName())) continue;
                FileUtils.deleteLocalFile((File)childFile);
            }
        }
    }

    public static void deleteLocalDirFile(String scene, String zipFileName) {
        String sceneChildDir = FileImportUtils.getUnzipFilePath(zipFileName, scene);
        File dirFile = new File(sceneChildDir);
        if (dirFile.exists()) {
            FileUtils.deleteLocalFile((File)dirFile);
        }
    }

    public static List<String> getChildFileNameList(String scene, String zipFileName) {
        String sceneChildDir = FileImportUtils.getUnzipFilePath(zipFileName, scene);
        File dirFile = new File(sceneChildDir);
        ArrayList<String> childFileNameList = new ArrayList<String>(10);
        if (dirFile.exists()) {
            File[] childFileArr = dirFile.listFiles();
            if (childFileArr == null) {
                return childFileNameList;
            }
            childFileNameList.addAll(Arrays.stream(childFileArr).map(File::getName).collect(Collectors.toList()));
        }
        return childFileNameList;
    }

    public static List<FileImportFileFieldInfoBo.FileInfo> getChildFileInfoList(String scene, String zipFileName) {
        String sceneChildDir = FileImportUtils.getUnzipFilePath(zipFileName, scene);
        File dirFile = new File(sceneChildDir);
        ArrayList<FileImportFileFieldInfoBo.FileInfo> fileInfoList = new ArrayList<FileImportFileFieldInfoBo.FileInfo>(10);
        if (dirFile.exists()) {
            File[] childFileArr = dirFile.listFiles();
            if (childFileArr == null) {
                return fileInfoList;
            }
            for (File file : childFileArr) {
                FileImportFileFieldInfoBo.FileInfo fileInfo = new FileImportFileFieldInfoBo.FileInfo(zipFileName, file.getName());
                fileInfo.setSize(file.length());
                fileInfoList.add(fileInfo);
            }
        }
        return fileInfoList;
    }

    public static FileImportFileFieldInfoBo.FileInfo getTempFileFieldInfo(String zipUrl, String zipFileName, String tmpFileUrl, String scene, String fileName) {
        TempFileCacheDownloadable.Content cacheContentFromTempUrl = FileUtils.getCacheContentFromTempUrl((String)tmpFileUrl);
        if (cacheContentFromTempUrl == null || cacheContentFromTempUrl.getInputStream() == null) {
            Map<String, List<File>> zipFileListMap = FileImportUtils.unzipFileToLocal(zipUrl, scene, zipFileName);
            ArrayList<File> fileList = new ArrayList<File>(10);
            for (Map.Entry<String, List<File>> zipFileEntry : zipFileListMap.entrySet()) {
                fileList.addAll((Collection<File>)zipFileEntry.getValue());
            }
            List<FileImportFileFieldInfoBo.FileInfo> fileInfoList = FileImportUtils.uploadTempFile(fileList);
            return fileInfoList.get(0);
        }
        return FileImportUtils.getUploadRemoteFileFieldInfo(zipUrl, zipFileName, scene, fileName);
    }

    private static FileImportFileFieldInfoBo.FileInfo getUploadRemoteFileFieldInfo(String zipUrl, String zipFileName, String scene, String fileName) {
        String childFileDir = FileImportUtils.getUnzipFilePath(zipFileName, scene);
        File dirFile = new File(childFileDir);
        if (dirFile.exists()) {
            File[] fileArr = dirFile.listFiles();
            if (fileArr == null) {
                Map<String, List<File>> fileListMap = FileImportUtils.unzipFileToLocal(zipUrl, scene, zipFileName);
                List<FileImportFileFieldInfoBo.FileInfo> fileInfoList = FileImportUtils.uploadTempFile(fileListMap.get(zipFileName));
                for (FileImportFileFieldInfoBo.FileInfo fileInfo : fileInfoList) {
                    if (!StringUtils.equals((String)fileInfo.getFileName(), (String)fileName)) continue;
                    return fileInfo;
                }
            } else {
                for (File file : fileArr) {
                    if (!StringUtils.equals((String)fileName, (String)file.getName())) continue;
                    List<FileImportFileFieldInfoBo.FileInfo> fileInfoList = FileImportUtils.uploadTempFile(Collections.singletonList(file));
                    return CollectionUtils.isEmpty(fileInfoList) ? null : fileInfoList.get(0);
                }
            }
        }
        String errMsg = "not find fileName:" + fileName + " in dir:" + childFileDir;
        throw new HDTCBizException(errMsg);
    }

    public static String getUnzipFilePath(String zipFileName, String scene) {
        if (StringUtils.isEmpty((String)zipFileName) || StringUtils.isEmpty((String)scene)) {
            throw new HDTCBizException("getUnzipFilePath zipFileName or scene not can empty.");
        }
        String[] fileNameArr = zipFileName.split("\\.");
        if (fileNameArr.length > 1) {
            return FileUtils.generateLocalPath() + File.separator + FILE_PATH + File.separator + scene + File.separator + fileNameArr[0];
        }
        return FileUtils.generateLocalPath() + File.separator + FILE_PATH + File.separator + scene + File.separator + zipFileName;
    }

    public static File getFileInfo(String zipFileName, String scene, String fileName) {
        String unzipFilePath = FileImportUtils.getUnzipFilePath(zipFileName, scene);
        File file = new File(unzipFilePath + File.separator + fileName);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static List<FileImportFileFieldInfoBo.FileInfo> uploadTempFile(List<File> fileList) {
        ArrayList<FileImportFileFieldInfoBo.FileInfo> tmpFileImportFieldInfoList = new ArrayList<FileImportFileFieldInfoBo.FileInfo>(10);
        String domainContextUrl = UrlService.getDomainContextUrl();
        for (File file : fileList) {
            String tempFileUrl;
            InputStream subFileInput = null;
            try {
                subFileInput = Files.newInputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]);
                tempFileUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(file.getName(), subFileInput, 28800);
            }
            catch (IOException ioException) {
                try {
                    LOG.error((Throwable)ioException);
                    throw new HDTCBizException(file.getName() + " uploadTempFile io exception.");
                }
                catch (Throwable throwable) {
                    FileImportUtils.safeClose(subFileInput);
                    throw throwable;
                }
            }
            FileImportUtils.safeClose(subFileInput);
            if (StringUtils.isEmpty((String)tempFileUrl)) {
                throw new HDTCBizException(file.getName() + " of temp url is empty.");
            }
            FileImportFileFieldInfoBo.FileInfo fileInfo = new FileImportFileFieldInfoBo.FileInfo();
            fileInfo.setFileName(file.getName());
            fileInfo.setSize(file.length());
            fileInfo.setTemUrl(domainContextUrl + "/" + tempFileUrl);
            tmpFileImportFieldInfoList.add(fileInfo);
        }
        return tmpFileImportFieldInfoList;
    }

    public static void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                throw new HDTCBizException("safeClose is ioexception.");
            }
        }
    }
}

