/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.domain.transfer.configitem.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.LogicOperate;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.bos.utils.DbTypeConverter;
import kd.hdtc.hrcc.business.common.ServiceFactory;
import kd.hdtc.hrcc.business.common.enums.HisEventEntityTypeEnum;
import kd.hdtc.hrcc.business.common.enums.TransferValidCueEnum;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.CtrlRelTableBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.EntityBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.FieldBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.HisEventBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.HrConfItemDataBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.MainEntityBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.RelEntityBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.RowDataBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.SysConfItemBo;
import kd.hdtc.hrcc.business.common.model.confitem.params.PackSchemeEntryParamBo;
import kd.hdtc.hrcc.business.common.model.confitem.params.PackSchemePresetParamBo;
import kd.hdtc.hrcc.business.common.model.confitem.params.PresetConfItemParamBo;
import kd.hdtc.hrcc.business.common.model.confitem.params.PresetConfTreeParamBo;
import kd.hdtc.hrcc.business.common.model.confitem.params.RowDataUpParamBo;
import kd.hdtc.hrcc.business.common.model.confitem.valid.ConfItemValidBo;
import kd.hdtc.hrcc.business.common.model.confitem.valid.RowDataValidCueBo;
import kd.hdtc.hrcc.business.common.utils.DfsCycleCheckServiceHelper;
import kd.hdtc.hrcc.business.common.utils.confItem.ConfItemUtils;
import kd.hdtc.hrcc.business.domain.common.entity.IBosEntityObjectEntityService;
import kd.hdtc.hrcc.business.domain.common.entity.impl.CommonServiceImpl;
import kd.hdtc.hrcc.business.domain.config.entity.IHRCCBaseConfigEntityService;
import kd.hdtc.hrcc.business.domain.transfer.configitem.IConfigItemDomainService;
import kd.hdtc.hrcc.business.domain.transfer.configitem.model.TransferDataParamBo;
import kd.hdtc.hrcc.business.domain.transfer.entity.IConfBakLogEntityService;
import kd.hdtc.hrcc.business.domain.transfer.entity.IConfigGroupEntityService;
import kd.hdtc.hrcc.business.domain.transfer.entity.IConfigItemEntityService;
import kd.hdtc.hrcc.business.domain.transfer.entity.IConfigItemRelEntityService;
import kd.hdtc.hrcc.common.MsgEnum.BizModeMsgEnum;
import kd.hdtc.hrcc.common.constants.ConfigItemConstants;
import kd.hdtc.hrcc.common.enums.EntityPropertyTypeEnum;
import kd.hdtc.hrcc.common.model.ConfItemMicroserviceInfo;
import kd.hdtc.hrdbs.business.domain.metadata.IMetaDataPresetDataDomainService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.MetaDatePresetDataDomainServiceImpl;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.business.servicehelper.MSServiceHelper;
import kd.hdtc.hrdbs.common.exception.HDTCBizException;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.DateTimeUtils;
import kd.hdtc.hrdbs.common.util.FileUtils;
import kd.hdtc.hrdbs.common.util.ObjectUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.domain.repository.HisEventEntityRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisDeleteService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.revocation.HisModelEventDataService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class ConfigItemDomainServiceImpl
implements IConfigItemDomainService {
    private static final Log LOG = LogFactory.getLog(ConfigItemDomainServiceImpl.class);
    private static final String SELECT_CONFIG_TREE_FIELD = "id,name,number,parent,issyspreset,enable,orderfield";
    private static final String SELECT_REL_ENTITY_FIELD = "id,parent,sourceentity,sourcefieldnumber,relentity,relfieldnumber,relcomparator";
    private static final String SELECT_CONFIG_ITEM_FIELD = "id,name,number,confignumber,group,supportaddtopacket,issyspreset,importtype,plugin,custparampage,bizentity,enable,orderfield";
    private static final String PREFIX_C = "c_";
    private static final String ISPRESET = "ispreset";
    private static final String ORDER = "order";
    private final IConfigItemEntityService configItemEntityService = ServiceFactory.getService(IConfigItemEntityService.class);
    private final IConfigGroupEntityService configTreeEntityService = ServiceFactory.getService(IConfigGroupEntityService.class);
    private final IConfigItemRelEntityService relEntityConfService = ServiceFactory.getService(IConfigItemRelEntityService.class);
    private final IBosEntityObjectEntityService bosEntityObjectEntityService = ServiceFactory.createInstance(IBosEntityObjectEntityService.class);
    private final IHRCCBaseConfigEntityService ihrccBaseConfigEntityService = ServiceFactory.createInstance(IHRCCBaseConfigEntityService.class);
    private final IConfBakLogEntityService configBakLogEntityService = ServiceFactory.getService(IConfBakLogEntityService.class);
    private final Set<String> confItemEntityNumSet = new HashSet<String>(16);
    private final IMetaDataPresetDataDomainService metaDatePresetDataDomainService = new MetaDatePresetDataDomainServiceImpl();
    private static final String Q_FILTER_STRING = "fid in (";
    private final Date nowDate = new Date();
    private final Long curUserId = RequestContext.get().getCurrUserId();
    private Map<String, String> confItemKeyFieldMap;
    private final DfsCycleCheckServiceHelper<String> circleChecker = new DfsCycleCheckServiceHelper();
    private Set<String> entityBlackList;
    private final int batchSize = 200;
    private final String yyyyMmDdHhMmSsPure = "yyyyMMddHHmmSSS";
    private String synConfItemEntityNum;
    private final String SPLIT_EQUAL_EMPTY = "= ";
    private final Set<Object> ctrEntityPkIdSet = new HashSet<Object>(16);
    private static final String SUCCESS_COUNT = "successCount";
    private static final String FAILED_COUNT = "failedCount";
    private static final String IS_SYSTEM = "issystem";

    @Override
    public void batchDelConfigItem(Set<Long> idSet) {
        try (TXHandle txHandle = TX.requiresNew();){
            this.relEntityConfService.deleteByFilter(new QFilter("configitem", "in", idSet).toArray());
            this.configItemEntityService.deleteByFilter(new QFilter("id", "in", idSet).toArray());
        }
    }

    @Override
    public JSONObject batchDelRiccConfigItem(Set<Long> idSet) {
        JSONObject result;
        try {
            result = (JSONObject)HRMServiceHelper.invokeBizService((String)"imsc", (String)"ricc", (String)"configItemService", (String)"delConfigItems", (Object[])new Object[]{new ArrayList<Long>(idSet)});
        }
        catch (Exception e) {
            LOG.error("sync ricc error(delConfigItems):", (Throwable)e);
            throw new KDBizException(BizModeMsgEnum.DEL_RICC_CONFIG_ITEM_FAIL_TIP.get());
        }
        return result;
    }

    @Override
    public DynamicObject[] getSysPresetConfigItemInfo(Set<Long> idSet) {
        Object[] idArr = this.configItemEntityService.query("id", new QFilter("id", "in", idSet).and("issyspreset", "=", (Object)"1").toArray());
        if (ObjectUtils.isEmpty((Object[])idArr)) {
            return new DynamicObject[0];
        }
        return idArr;
    }

    @Override
    public JSONObject syncConfigTree(Long pkId, boolean isSyncSysPreset) {
        QFilter filter = new QFilter("issyspreset", "=", (Object)isSyncSysPreset);
        if (pkId != null && pkId != 0L) {
            filter.and(new QFilter("id", "=", (Object)pkId));
        }
        DynamicObject[] configTreeArr = this.configTreeEntityService.query(SELECT_CONFIG_TREE_FIELD, new QFilter[]{filter}, "level");
        ArrayList configTreeList = Lists.newArrayListWithCapacity((int)configTreeArr.length);
        Arrays.stream(configTreeArr).forEach(config -> {
            HashMap paramMap = Maps.newHashMap();
            DynamicObject parent = config.getDynamicObject("parent");
            String enable = config.getString("enable");
            boolean isSysPreset = config.getBoolean("issyspreset");
            paramMap.put("id", config.getLong("id"));
            paramMap.put("number", isSysPreset ? config.getString("number") : this.handlePrefixC(config.getString("number")));
            paramMap.put("name", JSONObject.toJSONString((Object)config.getLocaleString("name")));
            paramMap.put("parent.id", parent == null ? 0L : parent.getLong("id"));
            paramMap.put(ISPRESET, isSysPreset);
            paramMap.put("enable", HRStringUtils.equals((String)enable, (String)"1") ? enable : "0");
            paramMap.put("orderfield", config.getString("orderfield"));
            configTreeList.add(paramMap);
        });
        JSONObject result = new JSONObject();
        if (CollectionUtils.isEmpty((Collection)configTreeList)) {
            return result;
        }
        result = this.syncRiccConfTree(configTreeList, result);
        return result;
    }

    @Override
    public JSONObject syncPresetConfigTree(List<PresetConfTreeParamBo> presetConfTreeParamBoList) {
        JSONObject result = new JSONObject();
        if (CollectionUtils.isEmpty(presetConfTreeParamBoList)) {
            return result;
        }
        ArrayList<Map<String, Object>> configTreeList = new ArrayList<Map<String, Object>>(10);
        for (PresetConfTreeParamBo presetConfTreeParamBo : presetConfTreeParamBoList) {
            HashMap treeMap = Maps.newHashMap();
            treeMap.put("id", presetConfTreeParamBo.getPkId());
            treeMap.put("number", presetConfTreeParamBo.getNumber());
            treeMap.put("name", presetConfTreeParamBo.getName());
            treeMap.put("parent.id", presetConfTreeParamBo.getParentId());
            treeMap.put(ISPRESET, Boolean.TRUE);
            treeMap.put("enable", "1");
            treeMap.put("orderfield", presetConfTreeParamBo.getOrderFieldVal());
            configTreeList.add(treeMap);
        }
        if (CollectionUtils.isEmpty(configTreeList)) {
            return result;
        }
        return this.syncRiccConfTree(configTreeList, result);
    }

    private JSONObject syncRiccConfTree(List<Map<String, Object>> configTreeList, JSONObject result) {
        try {
            result = (JSONObject)HRMServiceHelper.invokeBizService((String)"imsc", (String)"ricc", (String)"configItemService", (String)"saveConfigTree", (Object[])new Object[]{configTreeList});
        }
        catch (Exception e) {
            LOG.error("sync ricc error(syncConfigTree):", (Throwable)e);
            if (e instanceof NullPointerException) {
                result.put("msg", (Object)BizModeMsgEnum.UNKNOWN_ERROR.get());
            }
            result.put("msg", (Object)e.getMessage());
        }
        return result;
    }

    @Override
    public JSONObject syncConfigItem(List<Long> pkIdList, boolean isSyncSysPreset) {
        QFilter filter = new QFilter("issyspreset", "=", (Object)isSyncSysPreset);
        if (CollectionUtils.isNotEmpty(pkIdList)) {
            filter.and(new QFilter("id", "in", pkIdList));
        }
        DynamicObject[] configItemArr = this.configItemEntityService.query(SELECT_CONFIG_ITEM_FIELD, new QFilter[]{filter});
        Set<String> numberSet = Arrays.stream(configItemArr).map(config -> config.getString("number")).collect(Collectors.toSet());
        Map<String, Set<Long>> allConfItemIdList = this.getAllConfItemIdList(numberSet);
        ArrayList configItemList = Lists.newArrayListWithCapacity((int)configItemArr.length);
        for (DynamicObject config2 : configItemArr) {
            DynamicObject group;
            HashMap paramMap = Maps.newHashMap();
            DynamicObject bizEntity = config2.getDynamicObject("bizentity");
            if (bizEntity == null || (group = config2.getDynamicObject("group")) == null) continue;
            String enable = config2.getString("enable");
            boolean isSysPreset = config2.getBoolean("issyspreset");
            paramMap.put("id", config2.getLong("id"));
            paramMap.put("name", JSONObject.toJSONString((Object)config2.getLocaleString("name")));
            String confNumber = isSysPreset ? config2.getString("number") : config2.getString("confignumber");
            paramMap.put("number", HRStringUtils.isBlank((CharSequence)confNumber) ? this.handlePrefixC(config2.getString("number")) : confNumber);
            paramMap.put("page.number", bizEntity.getString("number"));
            paramMap.put("group.id", group.getLong("id"));
            paramMap.put("group.number", group.getString("number"));
            paramMap.put("configtype", "A");
            paramMap.put(ISPRESET, isSysPreset);
            paramMap.put("enable", HRStringUtils.equals((String)enable, (String)"1") ? enable : "0");
            paramMap.put("supportaddtopacket", true);
            paramMap.put("importtype", "microService");
            paramMap.put("microParam", this.structMicroParam());
            paramMap.put("canexportall", true);
            Set<Long> relConfigItemSet = allConfItemIdList.get(config2.getString("number"));
            ArrayList relyItemEntry = new ArrayList(10);
            for (Long rel : relConfigItemSet) {
                HashMap<String, String> relMap = new HashMap<String, String>(16);
                relMap.put("relyitem.id", String.valueOf(rel));
                relyItemEntry.add(relMap);
            }
            paramMap.put("relyitementry", relyItemEntry);
            paramMap.put("orderfield", config2.getString("orderfield"));
            configItemList.add(paramMap);
        }
        JSONObject result = new JSONObject();
        if (CollectionUtils.isEmpty((Collection)configItemList)) {
            return result;
        }
        result = this.syncRiccConfItem(configItemList, result);
        return result;
    }

    @Override
    public JSONObject syncPresetConfigItem(List<PresetConfItemParamBo> presetConfItemParamBoList) {
        JSONObject result = new JSONObject();
        if (CollectionUtils.isEmpty(presetConfItemParamBoList)) {
            return result;
        }
        List<Map<String, Object>> configItemList = this.getPresetConfItemMap(presetConfItemParamBoList);
        if (CollectionUtils.isEmpty(configItemList)) {
            return result;
        }
        result = this.syncRiccConfItem(configItemList, result);
        return result;
    }

    private List<Map<String, Object>> getPresetConfItemMap(List<PresetConfItemParamBo> presetConfItemParamBoList) {
        ArrayList<Map<String, Object>> configItemList = new ArrayList<Map<String, Object>>(10);
        for (PresetConfItemParamBo presetConfItemParamBo : presetConfItemParamBoList) {
            HashMap<String, Object> presetDataMap = new HashMap<String, Object>(16);
            presetDataMap.put("id", presetConfItemParamBo.getPkId());
            presetDataMap.put("name", presetConfItemParamBo.getName());
            presetDataMap.put("number", presetConfItemParamBo.getNumber());
            presetDataMap.put("page.number", presetConfItemParamBo.getNumber());
            presetDataMap.put("group.id", presetConfItemParamBo.getGroupId());
            presetDataMap.put("group.number", presetConfItemParamBo.getGroupNumber());
            presetDataMap.put("configtype", "A");
            presetDataMap.put(ISPRESET, Boolean.TRUE);
            presetDataMap.put("enable", "1");
            presetDataMap.put("supportaddtopacket", true);
            presetDataMap.put("importtype", "json");
            presetDataMap.put("canexportall", true);
            presetDataMap.put("keyfields", presetConfItemParamBo.getKeyFields());
            presetDataMap.put("orderfield", presetConfItemParamBo.getOrderField());
            configItemList.add(presetDataMap);
        }
        return configItemList;
    }

    private JSONObject syncRiccConfItem(List<Map<String, Object>> configItemList, JSONObject result) {
        try {
            result = (JSONObject)HRMServiceHelper.invokeBizService((String)"imsc", (String)"ricc", (String)"configItemService", (String)"saveConfigItem", (Object[])new Object[]{configItemList});
        }
        catch (Exception e) {
            LOG.error("sync ricc error(syncConfigItem):", (Throwable)e);
            if (e instanceof NullPointerException) {
                result.put("msg", (Object)BizModeMsgEnum.UNKNOWN_ERROR.get());
            }
            result.put("msg", (Object)e.getMessage());
        }
        return result;
    }

    private String handlePrefixC(String number) {
        if (number.startsWith(PREFIX_C)) {
            return number;
        }
        return PREFIX_C + number;
    }

    private Map<String, Object> structMicroParam() {
        HashMap<String, Object> microParam = new HashMap<String, Object>(6);
        microParam.put("cloud", "hdtc");
        microParam.put("appid", "hrcc");
        microParam.put("servicename", "IConfigItemService");
        microParam.put("filetransfertype", "tempFile");
        microParam.put("batchcount", 1000);
        microParam.put("param", new ArrayList());
        return microParam;
    }

    @Override
    public void loadRelEntityEntry(DynamicObjectCollection treeEntry, long id) {
        DynamicObject[] relEntityArr = this.relEntityConfService.query(SELECT_REL_ENTITY_FIELD, new QFilter("configitem", "=", (Object)id).toArray(), ORDER);
        treeEntry.clear();
        Arrays.stream(relEntityArr).forEach(rel -> {
            DynamicObject dyc = new DynamicObject(treeEntry.getDynamicObjectType());
            dyc.set("id", (Object)rel.getLong("id"));
            DynamicObject parent = rel.getDynamicObject("parent");
            if (parent == null) {
                dyc.set("pid", (Object)0L);
            } else {
                dyc.set("pid", (Object)rel.getDynamicObject("parent").getLong("id"));
            }
            dyc.set("sourceentity", (Object)rel.getDynamicObject("sourceentity"));
            dyc.set("sourcerelfield", (Object)rel.getString("sourcefieldnumber"));
            dyc.set("targetentity", (Object)rel.getDynamicObject("relentity"));
            dyc.set("targetrelfield", (Object)rel.getString("relfieldnumber"));
            dyc.set("logicalrel", (Object)rel.getString("relcomparator"));
            treeEntry.add((Object)dyc);
        });
    }

    @Override
    public DynamicObject[] getEnableConfigItemByNumbers(Set<String> numberSet) {
        QFilter numberFilter = new QFilter("number", "in", numberSet);
        Object[] resultArr = this.configItemEntityService.query("number", numberFilter.and(new QFilter("enable", "=", (Object)"1")).toArray());
        if (ObjectUtils.isEmpty((Object[])resultArr)) {
            return new DynamicObject[0];
        }
        return resultArr;
    }

    @Override
    public Set<String> getConfigItemNumber() {
        DynamicObject[] result = this.configItemEntityService.query("number", new QFilter("enable", "=", (Object)"1").toArray());
        return Arrays.stream(result).map(dyc -> dyc.getString("number")).collect(Collectors.toSet());
    }

    @Override
    public DynamicObject[] getConfigItemInfoByConfigItemNumbers(Set<String> configItemNumberSet) {
        Object[] result = this.configItemEntityService.query("id,confignumber", new QFilter("confignumber", "in", configItemNumberSet).toArray());
        if (ObjectUtils.isEmpty((Object[])result)) {
            return new DynamicObject[0];
        }
        return result;
    }

    @Override
    public List<Long> batchSaveConfigItem(DynamicObject dataEntity) {
        ArrayList<Long> retPkIdList = new ArrayList<Long>(10);
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        DynamicObject groupDyn = dataEntity.getDynamicObject("group");
        String relEntityInfo = dataEntity.getString("relentityinfo");
        ArrayList<DynamicObject> confItemList = new ArrayList<DynamicObject>(entryEntity.size());
        HashMap relEntityConfMap = Maps.newHashMap();
        LinkedList idQueue = new LinkedList();
        long[] ids = ID.genLongIds((int)(entryEntity.size() * 2));
        Arrays.stream(ids).forEach(id -> idQueue.offer(id));
        long currUserId = RequestContext.get().getCurrUserId();
        int maxOrderNum = this.queryMaxConfigItemOrderField(dataEntity);
        for (DynamicObject dyn : entryEntity) {
            Map resultTreeMap;
            List relEntityList;
            DynamicObject newDyn = this.configItemEntityService.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)newDyn);
            newDyn.set("id", idQueue.poll());
            newDyn.set("group", (Object)groupDyn);
            newDyn.set("enable", (Object)"1");
            DynamicObject bizEntity = dyn.getDynamicObject("bizentity");
            String entityNumber = bizEntity.getString("number");
            newDyn.set("number", (Object)entityNumber);
            newDyn.set("confignumber", (Object)dyn.getString("confignumber"));
            newDyn.set("name", (Object)bizEntity.getLocaleString("name"));
            newDyn.set("status", (Object)"C");
            newDyn.set("orderfield", (Object)(groupDyn.getString("orderfield") + "." + this.getNewOrderNum(maxOrderNum)));
            ++maxOrderNum;
            newDyn.set("creator", (Object)currUserId);
            retPkIdList.add(newDyn.getLong("id"));
            confItemList.add(newDyn);
            if (HRStringUtils.isEmpty((String)relEntityInfo) || CollectionUtils.isEmpty((Collection)(relEntityList = (List)(resultTreeMap = (Map)SerializationUtils.deSerializeFromBase64((String)relEntityInfo)).get(entityNumber)))) continue;
            this.structRelEntitySaveEntityMap(relEntityConfMap, dyn, newDyn, relEntityList);
        }
        this.configItemEntityService.save(confItemList.toArray(new DynamicObject[0]));
        this.relEntityConfService.save(relEntityConfMap.values().toArray(new DynamicObject[0]));
        return retPkIdList;
    }

    @Override
    public int queryMaxConfigItemOrderField(DynamicObject dynamicObject) {
        Object confItemDyn;
        String curOrderField;
        DynamicObject groupDyn = dynamicObject.getDynamicObject("group");
        QFilter groupIdFilter = new QFilter("group", "=", (Object)Long.parseLong(groupDyn.getString("masterid")));
        Object[] configItemArray = this.configItemEntityService.query(SELECT_CONFIG_ITEM_FIELD, new QFilter[]{groupIdFilter}, "orderfield desc");
        if (!ObjectUtils.isEmpty((Object[])configItemArray) && HRStringUtils.isNotEmpty((String)(curOrderField = (confItemDyn = configItemArray[0]).getString("orderfield")))) {
            String[] orderFieldArr = curOrderField.split("\\.");
            int maxOrderNum = 1;
            if (orderFieldArr.length > 1) {
                String lastOrderNumStr = orderFieldArr[orderFieldArr.length - 1];
                maxOrderNum = Integer.parseInt(lastOrderNumStr) + maxOrderNum;
                return maxOrderNum;
            }
        }
        return 1;
    }

    private String getNewOrderNum(int maxOrderNum) {
        return maxOrderNum >= 10 ? "0" + maxOrderNum : "00" + maxOrderNum;
    }

    @Override
    public String queryNewConfigItemOrderField(DynamicObject dynamicObject) {
        Object confItemDyn;
        String curOrderField;
        DynamicObject group;
        DynamicObject groupDyn = dynamicObject.getDynamicObject("group");
        if (groupDyn == null) {
            return null;
        }
        QFilter groupIdFilter = new QFilter("group", "=", (Object)Long.parseLong(groupDyn.getString("masterid")));
        Object[] configItemArray = this.configItemEntityService.query(SELECT_CONFIG_ITEM_FIELD, new QFilter[]{groupIdFilter}, "orderfield desc");
        QFilter numberFilter = new QFilter("number", "=", (Object)dynamicObject.getString("number"));
        DynamicObject configItem = this.configItemEntityService.queryOne(SELECT_CONFIG_ITEM_FIELD, new QFilter[]{numberFilter});
        if (configItem != null && (group = (DynamicObject)configItem.get("group")).getLong("id") == groupDyn.getLong("id")) {
            return configItem.getString("orderfield");
        }
        if (!ObjectUtils.isEmpty((Object[])configItemArray) && HRStringUtils.isNotEmpty((String)(curOrderField = (confItemDyn = configItemArray[0]).getString("orderfield")))) {
            String[] orderFieldArr = curOrderField.split("\\.");
            int maxOrderNum = 1;
            if (orderFieldArr.length > 1) {
                String lastOrderNumStr = orderFieldArr[orderFieldArr.length - 1];
                maxOrderNum = Integer.parseInt(lastOrderNumStr) + maxOrderNum;
                return groupDyn.getString("orderfield") + "." + this.getNewOrderNum(maxOrderNum);
            }
        }
        return groupDyn.getString("orderfield") + "." + this.getNewOrderNum(1);
    }

    @Override
    public void saveConfigItem(DynamicObject dataEntity) {
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObjectCollection relEntityDys = dataEntity.getDynamicObjectCollection("treeentryentity");
        Map<Long, DynamicObject> relEntityConfMap = relEntityDys.stream().collect(Collectors.toMap(rel -> rel.getLong("id"), rel -> rel));
        ArrayList relEntitySaveList = Lists.newArrayListWithCapacity((int)relEntityDys.size());
        relEntityDys.stream().forEach(rel -> {
            DynamicObject relEntity = this.relEntityConfService.generateEmptyDynamicObject();
            Long id = rel.getLong("id");
            relEntity.set("id", (Object)id);
            Long pid = rel.getLong("pid");
            if (pid == 0L) {
                relEntity.set("parent", null);
                relEntity.set("longnumber", (Object)ID.toStringId((long)id));
            } else {
                DynamicObject parent = (DynamicObject)relEntityConfMap.get(pid);
                relEntity.set("parent", (Object)parent.getLong("id"));
                relEntity.set("longnumber", (Object)(this.structLongNumber(relEntityConfMap, parent) + "!" + ID.toStringId((long)id)));
            }
            DynamicObject relEntityDyn = rel.getDynamicObject("targetentity");
            String keyFields = this.getRelEntityKeyFields(relEntityDyn == null ? null : relEntityDyn.getString("number"), dataEntity.getString("keyfields"));
            relEntity.set("keyfields", (Object)keyFields);
            relEntity.set("sourceentity", (Object)rel.getDynamicObject("sourceentity"));
            relEntity.set("sourcefieldnumber", (Object)rel.getString("sourcerelfield"));
            relEntity.set("relcomparator", (Object)rel.getString("logicalrel"));
            relEntity.set("relentity", (Object)relEntityDyn);
            relEntity.set("relfieldnumber", (Object)rel.getString("targetrelfield"));
            relEntity.set("configitem", (Object)dataEntity);
            relEntity.set("configitemnumber", (Object)dataEntity.getString("number"));
            relEntity.set("creator", (Object)currUserId);
            relEntity.set(ORDER, (Object)relEntityDys.indexOf(rel));
            relEntitySaveList.add(relEntity);
        });
        dataEntity.getDynamicObjectCollection("treeentryentity").clear();
        this.relEntityConfService.deleteByFilter(new QFilter("configitem", "=", (Object)dataEntity.getLong("id")).toArray());
        this.relEntityConfService.save(relEntitySaveList.toArray(new DynamicObject[0]));
    }

    @Override
    public void saveConfigItemNotOp(DynamicObject[] dataEntityArr) {
        this.delDbExistData(dataEntityArr);
        CommonServiceImpl commonService = new CommonServiceImpl("hrcc_configitems");
        ArrayList<DynamicObject> dynList = new ArrayList<DynamicObject>(10);
        for (DynamicObject dyn : dataEntityArr) {
            DynamicObject toConfItemDyn = commonService.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)toConfItemDyn);
            toConfItemDyn.set("id", (Object)dyn.getLong("id"));
            dynList.add(toConfItemDyn);
        }
        this.configItemEntityService.save(dynList.toArray(new DynamicObject[0]));
    }

    @Override
    public void delConfItemAndRelCof(List<Long> confItemPkIdList) {
        if (CollectionUtils.isEmpty(confItemPkIdList)) {
            return;
        }
        List confItemDynList = this.configItemEntityService.queryOriginalList("id", new QFilter[]{new QFilter("id", "in", confItemPkIdList)});
        if (CollectionUtils.isEmpty((Collection)confItemDynList)) {
            return;
        }
        List confItemExistPkIdList = confItemDynList.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        this.relEntityConfService.deleteByFilter(new QFilter("configitem", "in", confItemExistPkIdList).toArray());
        this.configItemEntityService.deleteByFilter(new QFilter("id", "in", confItemExistPkIdList).toArray());
    }

    private void delDbExistData(DynamicObject[] dataEntityArr) {
        if (dataEntityArr == null) {
            return;
        }
        List numberList = Arrays.stream(dataEntityArr).map(dyn -> dyn.getString("confignumber")).collect(Collectors.toList());
        Object[] dbDataDycArr = this.configItemEntityService.query("id,confignumber", new QFilter("confignumber", "in", numberList).toArray());
        if (ObjectUtils.isEmpty((Object[])dbDataDycArr)) {
            return;
        }
        Map<Long, String> dbDataDycMap = Arrays.stream(dbDataDycArr).collect(Collectors.toMap(dyc -> dyc.getLong("id"), dyc -> dyc.getString("confignumber"), (k1, k2) -> k1));
        this.relEntityConfService.deleteByFilter(new QFilter("configitem", "in", dbDataDycMap.keySet()).toArray());
        this.configItemEntityService.deleteByFilter(new QFilter("confignumber", "in", dbDataDycMap.values()).toArray());
    }

    private String structLongNumber(Map<Long, DynamicObject> relEntityConfMap, DynamicObject parent) {
        long parentId = parent.getLong("id");
        long pid = parent.getLong("pid");
        if (pid == 0L) {
            return ID.toStringId((long)parentId);
        }
        return this.structLongNumber(relEntityConfMap, relEntityConfMap.get(pid)) + "!" + ID.toStringId((long)parentId);
    }

    private void structRelEntitySaveEntityMap(Map<Long, DynamicObject> relEntityConfMap, DynamicObject dyn, DynamicObject newDyn, List<Map<String, Object>> relEntityList) {
        long currUserId = RequestContext.get().getCurrUserId();
        relEntityList.forEach(rel -> {
            DynamicObject relEntity = this.relEntityConfService.generateEmptyDynamicObject();
            Long id = (Long)rel.get("id");
            relEntity.set("id", (Object)id);
            Long pid = (Long)rel.get("pid");
            if (pid.equals(0L)) {
                relEntity.set("parent", null);
                relEntity.set("longnumber", (Object)ID.toStringId((long)id));
            } else {
                relEntity.set("parent", relEntityConfMap.get(pid));
                relEntity.set("longnumber", (Object)(((DynamicObject)relEntityConfMap.get(pid)).getString("longnumber") + "!" + ID.toStringId((long)id)));
            }
            DynamicObject relEntityDyn = (DynamicObject)rel.get("targetentity");
            String keyFields = this.getRelEntityKeyFields(relEntityDyn != null ? relEntityDyn.getString("number") : null, dyn.getString("keyfields"));
            relEntity.set("keyfields", (Object)keyFields);
            relEntity.set("sourceentity", rel.get("sourceentity"));
            relEntity.set("sourcefieldnumber", rel.get("sourcerelfield"));
            relEntity.set("relcomparator", rel.get("logicalrel"));
            relEntity.set("relentity", rel.get("targetentity"));
            relEntity.set("relfieldnumber", rel.get("targetrelfield"));
            relEntity.set("configitem", (Object)newDyn);
            relEntity.set("configitemnumber", (Object)newDyn.getString("number"));
            relEntity.set("creator", (Object)currUserId);
            relEntity.set(ORDER, (Object)relEntityList.indexOf(rel));
            relEntityConfMap.put(relEntity.getLong("id"), relEntity);
        });
    }

    private String getRelEntityKeyFields(String entityNumber, String keyFields) {
        List<String> keyFieldList;
        if (StringUtils.isEmpty((String)entityNumber)) {
            return keyFields;
        }
        MainEntityType relEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        if (!ConfItemUtils.entityContainsAllProName(relEntityType, keyFieldList = Arrays.stream(keyFields.split(",")).filter(HRStringUtils::isNotEmpty).collect(Collectors.toList()))) {
            if (keyFieldList.size() > 1 && ConfItemUtils.entityContainsNumber(relEntityType)) {
                keyFields = ",number,";
                return keyFields;
            }
            keyFields = ",id,";
        }
        return keyFields;
    }

    @Override
    public DynamicObjectCollection handleRelConfigItem(String entityNumber, DynamicObject dyc, int fieldType) {
        DynamicObjectCollection relConfigItemList = fieldType == 0 ? ((DynamicObject)dyc.getDynamicObjectCollection("entryentity").get(0)).getDynamicObjectCollection("relconfigitem") : dyc.getDynamicObjectCollection("relconfigitem");
        Map entityAllRefF7ProMap = MetadataUtils.getEntityRefF7ProMap((String)entityNumber);
        MulBasedataDynamicObjectCollection dys = new MulBasedataDynamicObjectCollection();
        Map<String, DynamicObject> entryMap = this.bosEntityObjectEntityService.queryOneByNumberList(new ArrayList<String>(entityAllRefF7ProMap.values()));
        if (CollectionUtils.isEmpty(entryMap)) {
            return null;
        }
        entryMap.values().forEach(val -> {
            DynamicObject item = relConfigItemList.addNew();
            item.set("fbasedataid", val);
            dys.add(item);
        });
        return dys;
    }

    @Override
    public List<MainEntityBo> getConfItemData(TransferDataParamBo transferDataParamBo, List<MainEntityBo> mainEntityBoList) {
        String confItemNumber = transferDataParamBo.getConfItemEntityNum();
        DynamicObject curConfItemDyn = this.getCurConfItemDyn(confItemNumber);
        if (curConfItemDyn == null) {
            return new ArrayList<MainEntityBo>(10);
        }
        this.initConfItemTransferDataParamBo(transferDataParamBo, confItemNumber, curConfItemDyn);
        MainEntityBo mainEntityBo = this.getMainAndSubEntityData(transferDataParamBo, confItemNumber, curConfItemDyn);
        if (mainEntityBo == null) {
            return mainEntityBoList;
        }
        mainEntityBoList.add(mainEntityBo);
        Map<String, List<Object>> hrRelF7ProFilterMap = this.getRelF7ProFilterMap(mainEntityBo, mainEntityBo.getHrConfItemEntityNumList());
        Set<String> relBaseEntityBlackSet = this.getEntityBlackList();
        Map<String, String> relF7ProVsF7EntityNumMap = mainEntityBo.getRelF7ProVsF7EntityNumMap();
        LOG.info("getConfItemData,relF7ProVsF7EntityNumMap={},HrConfItemEntityNumList={},SysConfItemEntityNumList={}", new Object[]{relF7ProVsF7EntityNumMap, mainEntityBo.getHrConfItemEntityNumList(), mainEntityBo.getSysConfItemEntityNumList()});
        List<String> hrConfItemEntityNumList = mainEntityBo.getHrConfItemEntityNumList();
        for (Map.Entry<String, String> f7ProEntry : relF7ProVsF7EntityNumMap.entrySet()) {
            String fieldKey = f7ProEntry.getKey();
            String baseDataEntityNum = f7ProEntry.getValue();
            List<Object> fieldValueList = hrRelF7ProFilterMap.get(fieldKey);
            if (relBaseEntityBlackSet.contains(baseDataEntityNum) || CollectionUtils.isEmpty(fieldValueList) || !hrConfItemEntityNumList.contains(baseDataEntityNum) || baseDataEntityNum.equals(confItemNumber) || MetadataUtils.isF7ItemClass((String)confItemNumber, (String)fieldKey)) continue;
            this.circleChecker.addLine(confItemNumber, baseDataEntityNum);
            List<List<String>> circularList = this.circleChecker.find();
            if (CollectionUtils.isNotEmpty(circularList)) {
                List circularEntityNumList = circularList.stream().flatMap(Collection::stream).collect(Collectors.toList());
                throw new KDBizException(new ErrorCode("circularEntityNumExists", String.join((CharSequence)"->", circularEntityNumList)), new Object[0]);
            }
            if (this.confItemEntityNumSet.contains(baseDataEntityNum)) {
                LOG.info("getConfItemData infinite loop,baseDataEntityNum={},confItemEntityNumSet={},circleChecker={}", new Object[]{baseDataEntityNum, this.confItemEntityNumSet, this.circleChecker.getCycleDetector().getVerticesInCycles()});
                continue;
            }
            LOG.info("handleConfItemRelBaseData,baseDataEntityNum={},fieldValues={}", (Object)baseDataEntityNum, fieldValueList);
            TransferDataParamBo relTransferDataParamBo = new TransferDataParamBo(baseDataEntityNum, baseDataEntityNum, "id", confItemNumber);
            this.initParamTransferDataBo(relTransferDataParamBo, "in", fieldValueList);
            this.getConfItemData(relTransferDataParamBo, mainEntityBoList);
        }
        this.handleSysConfItemData(transferDataParamBo, mainEntityBo, relBaseEntityBlackSet);
        return mainEntityBoList;
    }

    private void setConfItemPostMicroservice(MainEntityBo mainEntityBo, DynamicObject curConfItemDyn) {
        if (mainEntityBo == null || curConfItemDyn == null) {
            return;
        }
        DynamicObjectCollection microserviceCol = curConfItemDyn.getDynamicObjectCollection("postservice");
        if (microserviceCol == null) {
            return;
        }
        ArrayList<ConfItemMicroserviceInfo> confItemMicroserviceInfoList = new ArrayList<ConfItemMicroserviceInfo>(16);
        for (DynamicObject microserviceDyn : microserviceCol) {
            DynamicObject mulMicroserviceDyn = microserviceDyn.getDynamicObject("fbasedataid");
            if (!mulMicroserviceDyn.getBoolean("enable")) continue;
            ConfItemMicroserviceInfo confItemMicroserviceInfo = new ConfItemMicroserviceInfo(mulMicroserviceDyn);
            confItemMicroserviceInfoList.add(confItemMicroserviceInfo);
        }
        if (CollectionUtils.isNotEmpty(confItemMicroserviceInfoList)) {
            mainEntityBo.setConfItemMicroserviceParams(JSONArray.toJSONString(confItemMicroserviceInfoList));
        }
    }

    private void initConfItemTransferDataParamBo(TransferDataParamBo transferDataParamBo, String confItemNumber, DynamicObject curConfItemDyn) {
        transferDataParamBo.setBaseEntityBlackList(this.getEntityBlackList());
        MainEntityType dataEntityType = MetadataUtils.getMainEntityType((String)confItemNumber);
        transferDataParamBo.setDataEntityType(dataEntityType);
        transferDataParamBo.setNeedAllHis(curConfItemDyn.getBoolean("needallhis"));
        transferDataParamBo.setConfItemEntityNum(confItemNumber);
    }

    private MainEntityBo getMainAndSubEntityData(TransferDataParamBo transferDataParamBo, String confItemNumber, DynamicObject curConfItemDyn) {
        ArrayList<TransferDataParamBo> transferDataParamBoList = new ArrayList<TransferDataParamBo>(10);
        transferDataParamBoList.add(transferDataParamBo);
        MainEntityBo mainEntityBo = new MainEntityBo(transferDataParamBo.getEntityNumber(), transferDataParamBo.getParentEntity(), transferDataParamBo.getNeedAllHis());
        mainEntityBo.generateEntityData(transferDataParamBoList);
        if (CollectionUtils.isEmpty(mainEntityBo.getRowDataBoList())) {
            return null;
        }
        this.confItemEntityNumSet.add(confItemNumber);
        HashMap<String, List<RowDataBo>> allRelEntityBoMap = new HashMap<String, List<RowDataBo>>(16);
        allRelEntityBoMap.put(confItemNumber, mainEntityBo.getRowDataBoList());
        DynamicObject[] subEntityRelationArr = this.getConfItemSubEntityRelation(transferDataParamBo.getConfItemEntityNum());
        List<RelEntityBo> relSubEntityData = this.getRelSubEntityData(transferDataParamBo, subEntityRelationArr, allRelEntityBoMap);
        mainEntityBo.setRelEntityBoList(relSubEntityData);
        this.setRelEntityRelationField(mainEntityBo, subEntityRelationArr);
        this.setConfItemPostMicroservice(mainEntityBo, curConfItemDyn);
        return mainEntityBo;
    }

    private void setRelEntityRelationField(MainEntityBo mainEntityBo, DynamicObject[] subEntityRelationArr) {
        Map<String, Set<String>> sourceFieldNumVsRelEntityNumMap = mainEntityBo.getSourceFieldNumVsRelEntityNumMap();
        if (!ObjectUtils.isEmpty((Object[])subEntityRelationArr)) {
            for (DynamicObject subEntityRelDyn : subEntityRelationArr) {
                String sourceFieldNum = subEntityRelDyn.getString("sourcefieldnumber");
                sourceFieldNumVsRelEntityNumMap.putIfAbsent(sourceFieldNum, new HashSet(16));
                sourceFieldNumVsRelEntityNumMap.get(sourceFieldNum).add(subEntityRelDyn.getDynamicObject("relentity").getString("number"));
            }
        }
    }

    private DynamicObject getCurConfItemDyn(String confItemNumber) {
        List<DynamicObject> currentItemDynList = this.getEnableConfItemInfoByEntityNumbers("id,number,issyspreset,needallhis,postservice", (Set<String>)ImmutableSet.of((Object)confItemNumber), "hrcc_configitems", "number");
        if (CollectionUtils.isEmpty(currentItemDynList)) {
            return null;
        }
        List presetConfItemDynList = currentItemDynList.stream().filter(dyn -> dyn.getBoolean("issyspreset")).collect(Collectors.toList());
        DynamicObject curConfItemDyn = CollectionUtils.isNotEmpty(presetConfItemDynList) ? (DynamicObject)presetConfItemDynList.get(0) : currentItemDynList.get(0);
        return curConfItemDyn;
    }

    private void handleSysConfItemData(TransferDataParamBo transferDataParamBo, MainEntityBo mainEntityBo, Set<String> relBaseEntityBlackSet) {
        if (ObjectUtils.isEmpty((Object)mainEntityBo)) {
            return;
        }
        List<SysConfItemBo> sysConfItemBoList = mainEntityBo.getSysConfItemBoList();
        Map<String, List<Object>> sysRelF7ProFilterMap = this.getRelF7ProFilterMap(mainEntityBo, mainEntityBo.getSysConfItemEntityNumList());
        HashMap sysRelF7EntityNumMap = new HashMap(16);
        Map<String, String> relF7ProVsF7EntityNumMap = mainEntityBo.getRelF7ProVsF7EntityNumMap();
        for (Map.Entry<String, List<Object>> entry : sysRelF7ProFilterMap.entrySet()) {
            String fieldKey = entry.getKey();
            String sysBaseDataEntityNum = relF7ProVsF7EntityNumMap.get(fieldKey);
            if (!HRStringUtils.isNotEmpty((String)sysBaseDataEntityNum) || relBaseEntityBlackSet.contains(sysBaseDataEntityNum) || MetadataUtils.isF7ItemClass((String)mainEntityBo.getEntityNumber(), (String)fieldKey)) continue;
            ArrayList idList = (ArrayList)sysRelF7EntityNumMap.get(sysBaseDataEntityNum);
            if (idList == null) {
                idList = new ArrayList(10);
            }
            idList.addAll(entry.getValue());
            sysRelF7EntityNumMap.put(sysBaseDataEntityNum, idList);
        }
        for (Map.Entry<String, List<Object>> entry : sysRelF7EntityNumMap.entrySet()) {
            Set<Object> notPresetIdSet;
            SysConfItemBo sysConfItemBo = new SysConfItemBo();
            sysConfItemBo.setParentEntityNum(transferDataParamBo.getConfItemEntityNum());
            HashSet<Object> idSet = new HashSet<Object>((Collection)entry.getValue());
            String entityNumber = entry.getKey();
            if (relBaseEntityBlackSet.contains(entityNumber) || CollectionUtils.isEmpty(notPresetIdSet = this.getNotPresetIdSet(idSet, entityNumber))) continue;
            sysConfItemBo.setIdValSet(notPresetIdSet);
            sysConfItemBo.setConfItemEntityNumber(entityNumber);
            sysConfItemBoList.add(sysConfItemBo);
        }
    }

    private Set<Object> getNotPresetIdSet(Set<Object> idSet, String entityNumber) {
        String sysPresetField;
        if (CollectionUtils.isEmpty(idSet)) {
            return new HashSet<Object>(16);
        }
        CommonServiceImpl commonService = new CommonServiceImpl(entityNumber);
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        boolean isContainerSysPresetField = mainEntityType.getProperties().containsKey((Object)"issyspreset");
        boolean isContainerSystemField = mainEntityType.getProperties().containsKey((Object)IS_SYSTEM);
        String string = isContainerSysPresetField ? "issyspreset" : (sysPresetField = isContainerSystemField ? IS_SYSTEM : "");
        if (StringUtils.isNotBlank((CharSequence[])new CharSequence[]{sysPresetField})) {
            QFilter idFilter = new QFilter("id", "in", idSet);
            DynamicObject[] notPresetDynArr = commonService.loadDynamicObjectArray(new QFilter[]{new QFilter(sysPresetField, "=", (Object)"0"), idFilter});
            if (notPresetDynArr == null) {
                return new HashSet<Object>(16);
            }
            return Arrays.stream(notPresetDynArr).map(dyn -> dyn.get("id")).collect(Collectors.toSet());
        }
        return idSet;
    }

    private Map<String, List<Object>> getRelF7ProFilterMap(MainEntityBo mainEntityBo, List<String> confItemEntityNumList) {
        String fieldProKey;
        String entityNum;
        if (mainEntityBo == null) {
            return new HashMap<String, List<Object>>();
        }
        List<RowDataBo> rowDataBoList = mainEntityBo.getRowDataBoList();
        HashSet<String> hrF7ProConfItemNumSet = new HashSet<String>(confItemEntityNumList);
        Map<String, String> relF7ProVsF7EntityNumMap = mainEntityBo.getRelF7ProVsF7EntityNumMap();
        HashMap<String, List<Object>> fieldValueMap = new HashMap<String, List<Object>>(16);
        HashMap entityFilterValMap = new HashMap(16);
        for (Map.Entry<String, String> relF7ProVsEntityNumEntry : relF7ProVsF7EntityNumMap.entrySet()) {
            entityNum = relF7ProVsEntityNumEntry.getValue();
            fieldProKey = relF7ProVsEntityNumEntry.getKey();
            if (!hrF7ProConfItemNumSet.contains(entityNum)) continue;
            entityFilterValMap.putIfAbsent(entityNum, new ArrayList(10));
            List relF7IdFilterList = (List)entityFilterValMap.get(entityNum);
            ArrayList fieldValues = new ArrayList(10);
            List<FieldBo> relF7FieldBoList = ConfItemUtils.getRelF7FieldBoByPropName(rowDataBoList, fieldProKey);
            relF7FieldBoList.forEach(fieldBo -> fieldValues.add(fieldBo.getRelF7IdVal()));
            relF7IdFilterList.addAll(fieldValues);
        }
        for (Map.Entry<String, String> relF7ProVsEntityNumEntry : relF7ProVsF7EntityNumMap.entrySet()) {
            entityNum = relF7ProVsEntityNumEntry.getValue();
            fieldProKey = relF7ProVsEntityNumEntry.getKey();
            if (!hrF7ProConfItemNumSet.contains(entityNum)) continue;
            List relF7FilterValList = (List)entityFilterValMap.get(entityNum);
            fieldValueMap.put(fieldProKey, relF7FilterValList);
        }
        return fieldValueMap;
    }

    private void handleMulBaseDataRowDataBo(List<Object> fieldValues, List<RowDataBo> mulBaseRowList) {
        for (RowDataBo dataRowBo : mulBaseRowList) {
            List<FieldBo> baseFieldBoList = dataRowBo.getFieldBoList();
            ArrayList subBaseFieldBoList = new ArrayList(10);
            baseFieldBoList.forEach(bo -> {
                if ("fbasedataid".equals(bo.getFieldName())) {
                    subBaseFieldBoList.addAll(ConfItemUtils.getFieldBoList(bo.getFieldValue()));
                }
            });
            subBaseFieldBoList.forEach(bo -> {
                if ("id".equals(bo.getFieldName())) {
                    fieldValues.add(bo.getFieldValue());
                }
            });
        }
    }

    private List<RelEntityBo> getRelSubEntityData(TransferDataParamBo transferDataParamBo, DynamicObject[] subEntityRelationArr, Map<String, List<RowDataBo>> allRelEntityBoMap) {
        ArrayList<RelEntityBo> relEntityBoList = new ArrayList<RelEntityBo>(10);
        if (!ObjectUtils.isEmpty((Object[])subEntityRelationArr)) {
            HashMap<String, Map> relEntityFilterMap = new HashMap<String, Map>(16);
            HashSet<String> allSourceEntityNumSet = new HashSet<String>(16);
            allSourceEntityNumSet.addAll(allRelEntityBoMap.keySet());
            for (DynamicObject subEntityRelDyn : subEntityRelationArr) {
                HashMap<String, Object> reEntityDataMap = new HashMap<String, Object>(16);
                String curRelEntityNumber = subEntityRelDyn.getDynamicObject("relentity").getString("number");
                if (subEntityRelDyn.getDynamicObject("relentity") == null || subEntityRelDyn.getDynamicObject("sourceentity") == null) continue;
                allSourceEntityNumSet.add(curRelEntityNumber);
                String curRelSourceEntityNumber = subEntityRelDyn.getDynamicObject("sourceentity").getString("number");
                if (!allSourceEntityNumSet.contains(curRelSourceEntityNumber)) continue;
                relEntityFilterMap.computeIfAbsent(curRelSourceEntityNumber, key -> new HashMap(8));
                Map fieldFilterMap = (Map)relEntityFilterMap.get(curRelSourceEntityNumber);
                String sourceFieldNumber = subEntityRelDyn.getString("sourcefieldnumber");
                List<RowDataBo> sourceEntityDataBoList = allRelEntityBoMap.get(curRelSourceEntityNumber);
                if (ObjectUtils.isEmpty(sourceEntityDataBoList)) break;
                DynamicObject confItemDyn = subEntityRelDyn.getDynamicObject("configitem");
                HashMap<Object, Object> filterValVsSourceIdMap = new HashMap<Object, Object>(16);
                ArrayList<Object> filterRelProValList = new ArrayList<Object>(10);
                sourceEntityDataBoList.forEach(sourceRelBo -> {
                    List<Object> entityRefCol = this.getEntityRefCol(curRelSourceEntityNumber, sourceFieldNumber, (RowDataBo)sourceRelBo, (List<Object>)filterRelProValList);
                    HashSet<Object> entityRelColSet = new HashSet<Object>(entityRefCol);
                    entityRelColSet.forEach(filterVal -> filterValVsSourceIdMap.put(filterVal, sourceRelBo.getPkId()));
                });
                String relFieldKey = subEntityRelDyn.getString("relfieldnumber");
                List<Object> deduplicateFilterIdList = this.deduplicate(filterRelProValList);
                fieldFilterMap.putIfAbsent(sourceFieldNumber, deduplicateFilterIdList);
                TransferDataParamBo relTransferDataParamBo = new TransferDataParamBo(transferDataParamBo.getConfItemEntityNum(), curRelEntityNumber, relFieldKey, curRelSourceEntityNumber, confItemDyn.getBoolean("needallhis"));
                relTransferDataParamBo.setFieldKeyType(ConfItemUtils.getRelFieldKeyType(curRelEntityNumber, relFieldKey));
                relTransferDataParamBo.setFilterValVsSourceIdMap(filterValVsSourceIdMap);
                relTransferDataParamBo.setMainBoIdVsIdxMap(transferDataParamBo.getMainBoIdVsIdxMap());
                this.initParamTransferDataBo(relTransferDataParamBo, "in", deduplicateFilterIdList);
                this.initEntityRetDataMap(relTransferDataParamBo, reEntityDataMap);
                RelEntityBo relEntityBo = new RelEntityBo(relTransferDataParamBo.getEntityNumber(), relTransferDataParamBo.getParentEntity(), relTransferDataParamBo.getNeedAllHis());
                this.resetItemClassF7RelIdValList(sourceFieldNumber, sourceEntityDataBoList, relTransferDataParamBo, relEntityBo);
                relEntityBo.setConfItemEntityNumber(transferDataParamBo.getConfItemEntityNum());
                ArrayList<TransferDataParamBo> relTransferDataParamBoList = new ArrayList<TransferDataParamBo>(10);
                relTransferDataParamBoList.add(relTransferDataParamBo);
                relEntityBo.generateEntityData(relTransferDataParamBoList);
                if (CollectionUtils.isEmpty(relEntityBo.getRowDataBoList())) continue;
                allRelEntityBoMap.put(relEntityBo.getEntityNumber(), relEntityBo.getRowDataBoList());
                relEntityBoList.add(relEntityBo);
            }
        }
        return relEntityBoList;
    }

    private void resetItemClassF7RelIdValList(String sourceFieldNumber, List<RowDataBo> sourceEntityDataBoList, TransferDataParamBo relTransferDataParamBo, RelEntityBo relEntityBo) {
        String entityNumber = relTransferDataParamBo.getEntityNumber();
        String parentEntity = relTransferDataParamBo.getParentEntity();
        String itemClassF7ProName = sourceFieldNumber;
        if (sourceFieldNumber.contains(".")) {
            String[] proArr = itemClassF7ProName.split("\\.");
            itemClassF7ProName = proArr[proArr.length - 1];
        }
        if (!MetadataUtils.isF7ItemClass((String)parentEntity, (String)itemClassF7ProName)) {
            return;
        }
        Map<String, List<Map<String, Object>>> itemClassF7EntityIdNumMap = relEntityBo.getRelItemClassF7Entity(MetadataUtils.getMainEntityType((String)parentEntity), sourceEntityDataBoList, itemClassF7ProName);
        HashMap entityIdMap = new HashMap(16);
        for (Map.Entry<String, List<Map<String, Object>>> itemClassEntry : itemClassF7EntityIdNumMap.entrySet()) {
            entityIdMap.putIfAbsent(itemClassEntry.getKey(), new HashSet(16));
            List<Map<String, Object>> idVsNumList = itemClassEntry.getValue();
            if (CollectionUtils.isEmpty(idVsNumList)) continue;
            idVsNumList.forEach(idNumMap -> ((Set)entityIdMap.get(itemClassEntry.getKey())).add(idNumMap.get("id")));
        }
        Set itemClassEntityIdSet = (Set)entityIdMap.get(entityNumber);
        if (CollectionUtils.isEmpty((Collection)itemClassEntityIdSet)) {
            relTransferDataParamBo.getFieldValueList().clear();
        } else {
            relTransferDataParamBo.setFieldValueList(new ArrayList<Object>(itemClassEntityIdSet));
        }
    }

    private List<Object> deduplicate(List<Object> list) {
        return new ArrayList<Object>(new HashSet<Object>(list));
    }

    private List<Object> getEntityRefCol(String curRelSourceEntityNumber, String sourceFieldNumber, RowDataBo sourceRowDataBo, List<Object> filterRelProValList) {
        if (StringUtils.isEmpty((String)sourceFieldNumber)) {
            return filterRelProValList;
        }
        MainEntityType sourceDataEntityType = MetadataUtils.getMainEntityType((String)curRelSourceEntityNumber);
        boolean isRelSourceF7Field = this.isF7Field((IDataEntityType)sourceDataEntityType, sourceFieldNumber);
        FieldBo fieldBo = null;
        if (!sourceFieldNumber.contains(".")) {
            Optional<FieldBo> fieldBoOptional = sourceRowDataBo.getFieldBoList().stream().filter(bo -> sourceFieldNumber.equals(bo.getFieldName())).findAny();
            if (!fieldBoOptional.isPresent()) {
                return filterRelProValList;
            }
            fieldBo = fieldBoOptional.get();
        }
        if (isRelSourceF7Field && fieldBo != null) {
            filterRelProValList.add(fieldBo.getRelF7IdVal());
        } else if (sourceFieldNumber.indexOf(".") <= 0 && fieldBo != null) {
            IDataEntityProperty type = MetadataUtils.getItemFromProps((IDataEntityType)sourceDataEntityType, (String)sourceFieldNumber);
            if (type instanceof MuliLangTextProp) {
                ILocaleString mulInfo = (ILocaleString)fieldBo.getFieldValue();
                filterRelProValList.add(mulInfo.getLocaleValue());
            } else if (type instanceof MulBasedataProp) {
                List<RowDataBo> mulBaseRowBoList = ConfItemUtils.getRowDataBoList(fieldBo.getFieldValue());
                this.handleMulBaseDataRowDataBo(filterRelProValList, mulBaseRowBoList);
            } else {
                filterRelProValList.add(fieldBo.getFieldValue());
            }
        } else {
            int index = sourceFieldNumber.indexOf(".");
            String parentField = sourceFieldNumber.substring(0, index);
            IDataEntityProperty parentPropertyType = MetadataUtils.getItemFromProps((IDataEntityType)sourceDataEntityType, (String)parentField);
            if (parentPropertyType instanceof EntryProp) {
                Optional<FieldBo> parentOptional = sourceRowDataBo.getFieldBoList().stream().filter(bo -> parentField.equals(bo.getFieldName())).findAny();
                if (!parentOptional.isPresent()) {
                    return filterRelProValList;
                }
                FieldBo entryFieldBo = parentOptional.get();
                List<RowDataBo> entryRowDataBoList = ConfItemUtils.getRowDataBoList(entryFieldBo.getFieldValue());
                String field = sourceFieldNumber.substring(index + 1);
                for (RowDataBo subRowBo : entryRowDataBoList) {
                    this.getEntityRefCol(curRelSourceEntityNumber, field, subRowBo, filterRelProValList);
                }
            }
        }
        return filterRelProValList;
    }

    public DynamicObject[] getConfItemSubEntityRelation(String entityConfItemNumber) {
        CommonServiceImpl relEntityConfHelper = new CommonServiceImpl("hrcc_relentityconf");
        return relEntityConfHelper.query("relentity,relcomparator,relfieldnumber,sourceentity,sourcefieldnumber,configitem", new QFilter[]{new QFilter("configitemnumber", "=", (Object)entityConfItemNumber)}, " longnumber asc");
    }

    @Override
    public List<DynamicObject> getEnableConfItemInfoByEntityNumbers(String selectFields, Set<String> filterValSet, String entityNumber, String filterProperty) {
        DynamicObject[] dynArr = CommonEntityServiceFactory.getEntityService((String)entityNumber).query(selectFields, new QFilter[]{new QFilter(filterProperty, "in", filterValSet), ENABLE_FILTER});
        return Arrays.stream(dynArr).collect(Collectors.toList());
    }

    @Override
    public List<DynamicObject> getAllConfItemInfoByEntityNumbers(String selectFields, Set<String> filterValSet, String entityNumber, String filterProperty) {
        return new CommonServiceImpl(entityNumber).queryOriginalList(selectFields, new QFilter(filterProperty, "in", filterValSet).toArray());
    }

    @Override
    public Map<String, Set<Long>> getAllConfItemIdList(Set<String> confItemEntityNumberSet) {
        List<DynamicObject> sysConfItemDynList;
        HashMap<String, Set<Long>> retMap = new HashMap<String, Set<Long>>(16);
        if (ObjectUtils.isEmpty(confItemEntityNumberSet)) {
            return retMap;
        }
        HashMap relBaseToConfItemEntitySetMap = new HashMap(16);
        HashSet<String> allBaseEntityNumberSet = new HashSet<String>(16);
        for (String confItemEntity : confItemEntityNumberSet) {
            Map entityAllRefF7ProMap = MetadataUtils.getEntityRefF7ProMap((String)confItemEntity);
            for (String relBaseEntity : entityAllRefF7ProMap.values()) {
                relBaseToConfItemEntitySetMap.putIfAbsent(relBaseEntity, new HashSet(16));
                Set confItemEntitySet = (Set)relBaseToConfItemEntitySetMap.get(relBaseEntity);
                confItemEntitySet.add(confItemEntity);
            }
            allBaseEntityNumberSet.addAll(entityAllRefF7ProMap.values());
            retMap.putIfAbsent(confItemEntity, new HashSet(16));
        }
        List<DynamicObject> hrConfItemDynList = this.getEnableConfItemInfoByEntityNumbers("id,number", allBaseEntityNumberSet, "hrcc_configitems", "number");
        HashSet<String> sysEntityNumSet = new HashSet<String>(allBaseEntityNumberSet);
        if (!ObjectUtils.isEmpty(hrConfItemDynList)) {
            for (DynamicObject hrConfItemDyn : hrConfItemDynList) {
                String hrConfItemEntityNum = hrConfItemDyn.getString("number");
                sysEntityNumSet.remove(hrConfItemEntityNum);
                Set confItemRelBaseNumberSet = (Set)relBaseToConfItemEntitySetMap.get(hrConfItemEntityNum);
                if (ObjectUtils.isEmpty((Object)confItemRelBaseNumberSet)) continue;
                for (String confItemEntity : confItemRelBaseNumberSet) {
                    Set confItemIdSet = (Set)retMap.get(confItemEntity);
                    confItemIdSet.add(hrConfItemDyn.getLong("id"));
                }
            }
        } else if (!ObjectUtils.isEmpty(hrConfItemDynList) && hrConfItemDynList.size() == confItemEntityNumberSet.size()) {
            return retMap;
        }
        if (ObjectUtils.isEmpty(sysConfItemDynList = this.getEnableConfItemInfoByEntityNumbers("id,page.number", sysEntityNumSet, "ricc_configitems", "page.number"))) {
            return retMap;
        }
        for (DynamicObject sysConfItemDyn : sysConfItemDynList) {
            String sysConfItemEntityNum = sysConfItemDyn.getString("page.number");
            Set sysConfItemEntityNumberSet = (Set)relBaseToConfItemEntitySetMap.get(sysConfItemEntityNum);
            if (ObjectUtils.isEmpty((Object)sysConfItemEntityNumberSet)) continue;
            for (String confItemEntity : sysConfItemEntityNumberSet) {
                Set confItemIdSet = (Set)retMap.get(confItemEntity);
                confItemIdSet.add(sysConfItemDyn.getLong("id"));
            }
        }
        return retMap;
    }

    private void initParamTransferDataBo(TransferDataParamBo transferDataParamBo, String cp, List<Object> fieldValueList) {
        ArrayList<Object> newFieldValueList = new ArrayList<Object>(10);
        transferDataParamBo.setHisMod(MetadataUtils.hisEntity((String)transferDataParamBo.getEntityNumber()));
        transferDataParamBo.setControlMod(MetadataUtils.checkBaseDataCtrl((String)transferDataParamBo.getEntityNumber()));
        transferDataParamBo.setFieldValueList(ObjectUtils.isEmpty(newFieldValueList) ? fieldValueList : newFieldValueList);
        transferDataParamBo.setCp(cp);
        transferDataParamBo.setDataEntityType(MetadataUtils.getMainEntityType((String)transferDataParamBo.getEntityNumber()));
    }

    private void initEntityRetDataMap(TransferDataParamBo transferDataParamBo, Map<String, Object> entityRetDataMap) {
        MainEntityType dataEntityType = transferDataParamBo.getDataEntityType();
        entityRetDataMap.computeIfAbsent("entitynumber", key -> transferDataParamBo.getEntityNumber());
        entityRetDataMap.computeIfAbsent("appId", key -> dataEntityType.getAppId());
        entityRetDataMap.computeIfAbsent("dbRouteKey", key -> dataEntityType.getDBRouteKey());
        entityRetDataMap.computeIfAbsent("isHisMod", key -> transferDataParamBo.isHisMod());
        entityRetDataMap.computeIfAbsent("isControlMod", key -> transferDataParamBo.isControlMod());
        entityRetDataMap.computeIfAbsent("parentEntity", key -> transferDataParamBo.getParentEntity());
        entityRetDataMap.computeIfAbsent("data", key -> new ArrayList(10));
        entityRetDataMap.computeIfAbsent("hisModRelData", key -> new ArrayList(10));
        entityRetDataMap.computeIfAbsent("controlModData", key -> new HashMap(16));
        entityRetDataMap.putIfAbsent("parentEntity", "");
    }

    @Override
    public DynamicObject getBosEntityObjectByNumber(String entityNubmer) {
        if (HRStringUtils.isEmpty((String)entityNubmer)) {
            return null;
        }
        return this.bosEntityObjectEntityService.queryOneByNumber(entityNubmer);
    }

    @Override
    public ILocaleString getWriteBackRelEntity(List<Map<String, Object>> resultTreeList) {
        StringBuilder sb = new StringBuilder();
        resultTreeList.forEach(entry -> {
            DynamicObject sourceEntity = (DynamicObject)entry.get("sourceentity");
            DynamicObject targetEntity = (DynamicObject)entry.get("targetentity");
            if (targetEntity == null) {
                return;
            }
            sb.append(sourceEntity.getLocaleString("name").getLocaleValue()).append(".").append(this.handleShowName(sourceEntity, entry.get("sourcerelfield").toString())).append(entry.get("logicalrel")).append(targetEntity.getLocaleString("name").getLocaleValue()).append(".").append(this.handleShowName(targetEntity, entry.get("targetrelfield").toString())).append("\n");
        });
        return new LocaleString(sb.toString());
    }

    private String handleShowName(DynamicObject entity, String relFieldName) {
        DataEntityPropertyCollection properties = MetadataUtils.getMainEntityType((String)entity.getString("number")).getProperties();
        if (!relFieldName.contains(".")) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)relFieldName);
            if (property == null) {
                return "";
            }
            return property.getName();
        }
        List fieldNameList = Splitter.on((String)".").splitToList((CharSequence)relFieldName);
        IDataEntityProperty pro = (IDataEntityProperty)properties.get(fieldNameList.get(0));
        StringBuilder sb = new StringBuilder(pro.getName());
        DataEntityPropertyCollection entryProperties = ((EntryProp)pro).getDynamicCollectionItemPropertyType().getProperties();
        IDataEntityProperty firstPro = (IDataEntityProperty)entryProperties.get(fieldNameList.get(1));
        if (firstPro instanceof EntryProp) {
            entryProperties = ((EntryProp)firstPro).getDynamicCollectionItemPropertyType().getProperties();
            IDataEntityProperty sencondPro = (IDataEntityProperty)entryProperties.get(fieldNameList.get(2));
            return sb.append(".").append(firstPro.getName()).append(".").append(sencondPro.getName()).toString();
        }
        return sb.append(".").append(firstPro.getName()).toString();
    }

    @Override
    public List<Map<String, Object>> assembleReturnInfo(DynamicObjectCollection treeList) {
        ArrayList resultTreeList = Lists.newArrayListWithExpectedSize((int)treeList.size());
        treeList.forEach(node -> {
            TreeMap resultTreeMap = Maps.newTreeMap();
            resultTreeMap.put("id", node.getLong("id"));
            resultTreeMap.put("seq", node.getInt("seq"));
            resultTreeMap.put("pid", node.getLong("pid"));
            resultTreeMap.put("isGroupNode", node.getBoolean("isGroupNode"));
            resultTreeMap.put("sourceentity", node.getDynamicObject("sourceentity"));
            resultTreeMap.put("sourcerelfield", node.getString("sourcerelfield"));
            resultTreeMap.put("targetentity", node.getDynamicObject("targetentity"));
            resultTreeMap.put("targetrelfield", node.getString("targetrelfield"));
            resultTreeMap.put("logicalrel", node.getString("logicalrel"));
            resultTreeList.add(resultTreeMap);
        });
        return resultTreeList;
    }

    @Override
    public int getCurrentLayer(Long pid, DynamicObjectCollection treeEntry, int layer) {
        if (pid != 0L) {
            DynamicObject parentNode = treeEntry.stream().filter(node -> (long)pid.compareTo(node.getLong("id")) == 0L).findFirst().get();
            return this.getCurrentLayer(parentNode.getLong("pid"), treeEntry, ++layer);
        }
        return layer;
    }

    @Override
    public String getRelEntityRequireMsgTip(DynamicObjectCollection treeEntry) {
        ArrayList msgList = Lists.newArrayList();
        treeEntry.forEach(node -> {
            StringBuilder sb = new StringBuilder();
            DynamicObject sourceEntity = node.getDynamicObject("sourceentity");
            String sourceRelField = node.getString("sourcerelfield");
            DynamicObject targetEntity = node.getDynamicObject("targetentity");
            String targetRelField = node.getString("targetrelfield");
            sb.append(BizModeMsgEnum.ENTITY_NAME_TIP.get());
            sb.append(sourceEntity.getLocaleString("name").getLocaleValue());
            sb.append(BizModeMsgEnum.CORRESPOND_TIP.get());
            ArrayList fieldNameList = Lists.newArrayList();
            if (HRStringUtils.isEmpty((String)sourceRelField)) {
                fieldNameList.add(BizModeMsgEnum.ENTITY_FIELD_TIP.get());
            }
            if (targetEntity == null) {
                fieldNameList.add(BizModeMsgEnum.REL_ENTITY_NAME_TIP.get());
            }
            if (HRStringUtils.isEmpty((String)targetRelField)) {
                fieldNameList.add(BizModeMsgEnum.REL_ENTITY_FIELD_TIP.get());
            }
            if (CollectionUtils.isEmpty((Collection)fieldNameList)) {
                return;
            }
            String msg = fieldNameList.stream().collect(Collectors.joining("\u3001", ConfigItemConstants.DOUBLE_QUOTATION_MARKS, ConfigItemConstants.DOUBLE_QUOTATION_MARKS));
            sb.append(msg).append(BizModeMsgEnum.IS_EMPTY_TIP.get());
            msgList.add(sb.toString());
        });
        return String.join((CharSequence)"", msgList);
    }

    private boolean isF7Field(IDataEntityType dataEntityType, String relField) {
        for (IDataEntityProperty property : dataEntityType.getProperties()) {
            if (property instanceof BasedataProp && relField.equals(property.getName())) {
                return true;
            }
            if (!(property instanceof EntryProp)) continue;
            DataEntityPropertyCollection entryItemTypeCol = ((EntryProp)property).getItemType().getProperties();
            for (IDataEntityProperty iDataEntityProperty : entryItemTypeCol) {
                if (!(iDataEntityProperty instanceof BasedataProp) || !relField.equals(iDataEntityProperty.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<HrConfItemDataBo> getHrConfItemItselfData(List<String> allConfItemEntityNumList) {
        ArrayList<HrConfItemDataBo> hrConfItemDataBoList = new ArrayList<HrConfItemDataBo>(10);
        if (ObjectUtils.isEmpty(allConfItemEntityNumList)) {
            return null;
        }
        CommonServiceImpl confItemTreeService = new CommonServiceImpl("hrcc_configitems");
        QFilter confItemEnableFilter = new QFilter("enable", "=", (Object)"1");
        Object[] confItemDynArr = confItemTreeService.query("id, group,number,issyspreset", new QFilter[]{new QFilter("number", "in", allConfItemEntityNumList), confItemEnableFilter});
        if (ObjectUtils.isEmpty((Object[])confItemDynArr)) {
            return hrConfItemDataBoList;
        }
        ArrayList<Long> relIdList = new ArrayList(10);
        HashSet<Long> confItemIdSet = new HashSet<Long>(16);
        HashSet longNumberSet = new HashSet(16);
        Set sysPreSet = Arrays.stream(confItemDynArr).filter(dyn -> dyn.getBoolean("issyspreset")).map(dyn -> dyn.getString("number")).collect(Collectors.toSet());
        for (Object confItemDyn : confItemDynArr) {
            String entityNumber = confItemDyn.getString("number");
            if (sysPreSet.contains(entityNumber) && !confItemDyn.getBoolean("issyspreset")) continue;
            confItemIdSet.add(confItemDyn.getLong("id"));
            String[] longNumberArr = confItemDyn.getString("group.longnumber").split("\\.");
            longNumberSet.addAll(Arrays.stream(longNumberArr).collect(Collectors.toSet()));
        }
        CommonServiceImpl confItemRelService = new CommonServiceImpl("hrcc_relentityconf");
        List relConfItemList = confItemRelService.queryOriginalList("id,configitem.id", new QFilter[]{new QFilter("configitem", "in", confItemIdSet)});
        if (!ObjectUtils.isEmpty((Object)relConfItemList)) {
            relIdList = relConfItemList.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        }
        CommonServiceImpl confTreeService = new CommonServiceImpl("hrcc_configtree");
        Object[] confTreeDynArr = confTreeService.query("id, number", new QFilter[]{new QFilter("number", "in", longNumberSet), ENABLE_FILTER});
        ArrayList<Long> confTreeIdList = new ArrayList(10);
        if (!ObjectUtils.isEmpty((Object[])confTreeDynArr)) {
            confTreeIdList = Arrays.stream(confTreeDynArr).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        }
        HrConfItemDataBo confTreeBo = new HrConfItemDataBo();
        HrConfItemDataBo confItemBo = new HrConfItemDataBo();
        HrConfItemDataBo relEntityBo = new HrConfItemDataBo();
        confTreeBo.setEntityNumber("hrcc_configtree").setIdList(confTreeIdList);
        confItemBo.setEntityNumber("hrcc_configitems").setIdList(new ArrayList<Long>(confItemIdSet));
        hrConfItemDataBoList.add(confTreeBo);
        hrConfItemDataBoList.add(confItemBo);
        if (!ObjectUtils.isEmpty(relIdList)) {
            relEntityBo.setEntityNumber("hrcc_relentityconf").setIdList(relIdList);
            hrConfItemDataBoList.add(relEntityBo);
        }
        return hrConfItemDataBoList;
    }

    @Override
    public Map<String, Object> handleConfItemImportData(String exportUrl) {
        LOG.info("handleConfItemImportData start,exportUrl={}", (Object)exportUrl);
        long startTime = System.currentTimeMillis();
        Map<String, Object> retMap = new HashMap<String, Object>(16);
        this.initBeforeHandleConfItemData(retMap);
        MainEntityBo confItemEntityBo = this.getConfItemImportDataByUrl(exportUrl);
        if (confItemEntityBo == null) {
            return retMap;
        }
        retMap = this.handleImportData(retMap, confItemEntityBo);
        LOG.info("handleConfItemImportData end,cost={}ms", (Object)(System.currentTimeMillis() - startTime));
        return retMap;
    }

    public Map<String, Object> handleImportData(Map<String, Object> retMap, MainEntityBo confItemEntityBo) {
        String confItemEntityNum = confItemEntityBo.getEntityNumber();
        this.initConfItemKeyField(confItemEntityNum);
        ConfItemValidBo confItemValidBo = new ConfItemValidBo(confItemEntityNum);
        confItemValidBo.validConfItemData(confItemEntityBo);
        HashSet<Object> allValidFailRowDataPkIdSet = new HashSet<Object>(16);
        HashSet<Object> allValidFailConfItemRowDataPkIdSet = new HashSet<Object>(16);
        StringBuilder cheErrCueMsgSb = new StringBuilder();
        StringBuilder buInCtrRangeNotExistBuilder = new StringBuilder();
        for (RowDataValidCueBo rowDataValidCueBo : confItemValidBo.getF7RowDataValidCueBoList()) {
            if (rowDataValidCueBo.getValidSuccess().booleanValue()) continue;
            allValidFailRowDataPkIdSet.add(rowDataValidCueBo.getEntityDataPkId());
            allValidFailConfItemRowDataPkIdSet.add(rowDataValidCueBo.getConfItemDataPkId());
            cheErrCueMsgSb.append(rowDataValidCueBo.getF7ProNotExistsSb().toString());
            cheErrCueMsgSb.append(rowDataValidCueBo.getMulF7ProNotExistsSb().toString());
            buInCtrRangeNotExistBuilder.append(rowDataValidCueBo.getBuInCtrRangeNotExistSb().toString());
        }
        String cheHisErrMsg = this.syncConfItemData(confItemEntityBo, confItemValidBo, allValidFailRowDataPkIdSet);
        List<RowDataBo> syncSuccessConfItemEntityRowList = confItemEntityBo.getRowDataBoList().stream().filter(rowDataBo -> !allValidFailRowDataPkIdSet.contains(rowDataBo.getPkId())).collect(Collectors.toList());
        retMap.put(SUCCESS_COUNT, syncSuccessConfItemEntityRowList.size());
        retMap.put(FAILED_COUNT, allValidFailConfItemRowDataPkIdSet.size());
        cheErrCueMsgSb.append((CharSequence)buInCtrRangeNotExistBuilder);
        if (StringUtils.isNotEmpty((String)cheHisErrMsg)) {
            cheErrCueMsgSb.append("\r\n").append(cheHisErrMsg);
        }
        String failMsg = cheErrCueMsgSb.toString();
        retMap.put("msg", failMsg);
        Map<Object, String> possMicroServiceResult = null;
        try {
            possMicroServiceResult = this.syncPostMicroservice(confItemEntityBo, syncSuccessConfItemEntityRowList);
        }
        catch (HDTCBizException exception) {
            retMap.put("msg", failMsg + "\r\n" + exception.getMessage());
        }
        this.handleRetMap(confItemEntityNum, possMicroServiceResult, syncSuccessConfItemEntityRowList, retMap);
        retMap.put("code", StringUtils.isNotBlank((CharSequence[])new CharSequence[]{retMap.get("msg").toString()}) ? 1 : 0);
        return retMap;
    }

    private void handleRetMap(String confItemEntityNum, Map<Object, String> possMicroServiceResult, List<RowDataBo> syncSuccessConfItemEntityRowList, Map<String, Object> retMap) {
        if (!ObjectUtils.isEmpty(possMicroServiceResult)) {
            String errMsg = (String)retMap.get("msg");
            MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)confItemEntityNum);
            boolean isContainsNumber = ConfItemUtils.entityContainsNumber(mainEntityType);
            boolean isContainsName = ConfItemUtils.entityContainsProName(mainEntityType, "name");
            StringBuilder errMsgSb = new StringBuilder(errMsg);
            if (StringUtils.isNotEmpty((String)errMsg)) {
                errMsgSb.append("\r\n");
            }
            syncSuccessConfItemEntityRowList.stream().filter(rowDataBo -> possMicroServiceResult.containsKey(rowDataBo.getPkId())).forEach(rowBo -> {
                String confItemEntityDataIde = ConfItemUtils.getEntityDataIde(isContainsNumber, isContainsName, rowBo.getFieldBoList());
                errMsgSb.append(MessageFormat.format(TransferValidCueEnum.POST_MICROSERVICE.getValidCue(), confItemEntityNum, rowBo.getPkId().toString(), confItemEntityDataIde, possMicroServiceResult.get(rowBo.getPkId()))).append("\r\n");
            });
            retMap.put(SUCCESS_COUNT, (Integer)retMap.get(SUCCESS_COUNT) - possMicroServiceResult.size());
            retMap.put(FAILED_COUNT, (Integer)retMap.get(FAILED_COUNT) + possMicroServiceResult.size());
            retMap.put("msg", errMsgSb.toString());
        }
    }

    public Map<Object, String> syncPostMicroservice(MainEntityBo confItemEntityBo, List<RowDataBo> syncSuccessConfItemEntityRowList) {
        String confItemMicroserviceListStr = confItemEntityBo.getConfItemMicroserviceParams();
        if (StringUtils.isNotEmpty((String)confItemMicroserviceListStr)) {
            List confItemMicroserviceInfoList = JSONArray.parseArray((String)confItemMicroserviceListStr, ConfItemMicroserviceInfo.class);
            HashMap<Object, String> retMap = new HashMap<Object, String>(16);
            for (ConfItemMicroserviceInfo confItemMicroserviceInfo : confItemMicroserviceInfoList) {
                this.batchSyncPostProcess(confItemEntityBo, syncSuccessConfItemEntityRowList, retMap, confItemMicroserviceInfo);
            }
            return retMap;
        }
        return new HashMap<Object, String>();
    }

    private void batchSyncPostProcess(MainEntityBo confItemEntityBo, List<RowDataBo> syncSuccessConfItemEntityRowList, Map<Object, String> retMap, ConfItemMicroserviceInfo confItemMicroserviceInfo) {
        Integer batchCount = confItemMicroserviceInfo.getBatchCount();
        int totalPages = (syncSuccessConfItemEntityRowList.size() + batchCount - 1) / batchCount;
        LOG.info("syncSuccessConfItemEntityRowList.size={},totalPages={},batchCount={}", new Object[]{syncSuccessConfItemEntityRowList.size(), totalPages, batchCount});
        for (int i = 0; i < totalPages; ++i) {
            int fromIndex = i * 200;
            int toIndex = Math.min(fromIndex + 200, syncSuccessConfItemEntityRowList.size());
            List<RowDataBo> rowDataBoList = syncSuccessConfItemEntityRowList.subList(fromIndex, toIndex);
            HashMap idVsNumMap = new HashMap(16);
            rowDataBoList.forEach(rowDataBo -> idVsNumMap.put(rowDataBo.getPkId(), (String)ConfItemUtils.getFieldValueByPropName(rowDataBo.getFieldBoList(), "number")));
            LOG.info("batchSyncPostProcess invokeBizService start,serviceNumber={},entityNumber={},idVsNumMap={}", new Object[]{confItemMicroserviceInfo.getServiceNumber(), confItemEntityBo.getEntityNumber(), idVsNumMap});
            long startTime = System.currentTimeMillis();
            HRMServiceResult hrmServiceResult = (HRMServiceResult)MSServiceHelper.invokeCommonService((String)confItemMicroserviceInfo.getCloudNumber().toLowerCase(Locale.ROOT), (String)confItemMicroserviceInfo.getAppNumber(), (String)confItemMicroserviceInfo.getServiceNumber(), (String)confItemMicroserviceInfo.getMethodName(), (Object[])new Object[]{confItemEntityBo.getEntityNumber(), idVsNumMap});
            LOG.info("batchSyncPostProcess invokeBizService end,cost={}ms", (Object)(System.currentTimeMillis() - startTime));
            this.assemblyPostMicroserviceSyncRetMap(confItemEntityBo.getEntityNumber(), retMap, hrmServiceResult, confItemMicroserviceInfo);
        }
    }

    private void assemblyPostMicroserviceSyncRetMap(String entityNumber, Map<Object, String> retMap, HRMServiceResult hrmServiceResult, ConfItemMicroserviceInfo confItemMicroserviceInfo) {
        if (!hrmServiceResult.isSuccess()) {
            Map returnErrDataMap = (Map)hrmServiceResult.getReturnData();
            if (ObjectUtils.isEmpty((Object)returnErrDataMap)) {
                throw new HDTCBizException(MessageFormat.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u201c{0}\u201d\u540e\u7f6e\u670d\u52a1\u201c{1}\u201d\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{2}", (String)"ConfigItemDomainServiceImpl_6", (String)"hdtc-hrcc-business", (Object[])new Object[0]), entityNumber, confItemMicroserviceInfo.getDescription(), hrmServiceResult.getMessage()));
            }
            String errMsgPattern = ResManager.loadKDString((String)"\u201c{0}\u201d\u5904\u7406\u9519\u8bef\u4fe1\u606f\uff1a{1}", (String)"ConfigItemDomainServiceImpl_7", (String)"hdtc-hrcc-business", (Object[])new Object[0]);
            for (Map.Entry errMap : returnErrDataMap.entrySet()) {
                Object idObj = errMap.getKey();
                String errMsg = retMap.get(idObj);
                errMsg = StringUtils.isNotEmpty((String)errMsg) ? errMsg + "\r\n" + (String)errMap.getValue() : (String)errMap.getValue();
                retMap.put(idObj, MessageFormat.format(errMsgPattern, confItemMicroserviceInfo.getDescription(), errMsg));
            }
        }
    }

    private String syncConfItemData(MainEntityBo confItemEntityBo, ConfItemValidBo confItemValidBo, Set<Object> allValidFailRowDataPkIdSet) {
        List<RelEntityBo> relEntityBoList = confItemEntityBo.getRelEntityBoList();
        this.confItemEntityNumSet.add(confItemEntityBo.getEntityNumber());
        this.synConfItemEntityNum = confItemEntityBo.getEntityNumber();
        Map<String, String> entityKeyFieldsMap = this.getConfItemAndRelEntityKeyFieldsMap(relEntityBoList);
        StringBuilder hisNeedAllVerDataErrCueMsgSb = new StringBuilder();
        this.upRelEntityDataIdInPacket(confItemEntityBo, confItemValidBo, allValidFailRowDataPkIdSet, entityKeyFieldsMap, hisNeedAllVerDataErrCueMsgSb);
        this.syncRelEntityData(allValidFailRowDataPkIdSet, relEntityBoList);
        List<HisEventBo> confItemHisEventBoList = confItemEntityBo.getHisEventBoList();
        List<CtrlRelTableBo> confItemCtrlRelTableBoList = confItemEntityBo.getCtrlRelTableBoList();
        List<RowDataBo> confItemRowDataBoList = confItemEntityBo.getRowDataBoList();
        String confItemEntityNumber = confItemEntityBo.getEntityNumber();
        this.upConfItemEntityDataIdInPacket(confItemEntityBo, confItemValidBo, allValidFailRowDataPkIdSet, entityKeyFieldsMap, hisNeedAllVerDataErrCueMsgSb);
        this.syncEntityAllData(confItemEntityNumber, confItemRowDataBoList, confItemHisEventBoList, confItemCtrlRelTableBoList, allValidFailRowDataPkIdSet);
        return hisNeedAllVerDataErrCueMsgSb.toString();
    }

    private void upConfItemEntityDataIdInPacket(MainEntityBo confItemEntityBo, ConfItemValidBo confItemValidBo, Set<Object> allValidFailRowDataPkIdSet, Map<String, String> entityKeyFieldsMap, StringBuilder hisNeedAllVerDataErrCueMsgSb) {
        List<HisEventBo> confItemHisEventBoList = confItemEntityBo.getHisEventBoList();
        List<CtrlRelTableBo> confItemCtrlRelTableBoList = confItemEntityBo.getCtrlRelTableBoList();
        List<RowDataBo> confItemRowDataBoList = confItemEntityBo.getRowDataBoList();
        String confItemEntityNumber = confItemEntityBo.getEntityNumber();
        RowDataUpParamBo rowDataUpParamBo = new RowDataUpParamBo(confItemEntityBo.getEntityNumber(), confItemEntityBo.getEntityNumber(), confItemRowDataBoList, false);
        rowDataUpParamBo.setEntityHisEventBoList(confItemHisEventBoList).setEntityCtrlRelTableBoList(confItemCtrlRelTableBoList).setHisMod(confItemEntityBo.getHisMod()).setNeedAllHis(confItemEntityBo.getNeedAllHis()).setControlMod(confItemEntityBo.getControlMod()).setKeyFields(entityKeyFieldsMap.get(confItemEntityNumber));
        rowDataUpParamBo.setRelEntityBoList(confItemEntityBo.getRelEntityBoList());
        rowDataUpParamBo.setRelF7ProVsF7EntityNumMap(confItemEntityBo.getRelF7ProVsF7EntityNumMap());
        this.updateEntityIdInDataPacket(rowDataUpParamBo, confItemValidBo);
        this.buildMainEntityHisErrMsg(confItemEntityBo, allValidFailRowDataPkIdSet, hisNeedAllVerDataErrCueMsgSb, rowDataUpParamBo);
    }

    private void buildMainEntityHisErrMsg(MainEntityBo confItemEntityBo, Set<Object> allValidFailRowDataPkIdSet, StringBuilder hisNeedAllVerDataErrCueMsgSb, RowDataUpParamBo rowDataUpParamBo) {
        allValidFailRowDataPkIdSet.addAll(rowDataUpParamBo.getCheErrPkIdSet());
        confItemEntityBo.setHisEventBoList(rowDataUpParamBo.getEntityHisEventBoList());
        confItemEntityBo.setRowDataBoList(rowDataUpParamBo.getEntityRowDataBoList());
        String cheHisErrCueMsg = rowDataUpParamBo.getCheckErrCueMsg();
        if (StringUtils.isNotEmpty((String)cheHisErrCueMsg)) {
            hisNeedAllVerDataErrCueMsgSb.append(cheHisErrCueMsg).append("\r\n");
        }
    }

    private void upRelEntityDataIdInPacket(MainEntityBo confItemEntityBo, ConfItemValidBo confItemValidBo, Set<Object> allValidFailRowDataPkIdSet, Map<String, String> entityKeyFieldsMap, StringBuilder hisNeedAllVerDataErrCueMsgSb) {
        List<RelEntityBo> relEntityBoList = confItemEntityBo.getRelEntityBoList();
        for (RelEntityBo relEntityBo : relEntityBoList) {
            List<RowDataBo> relEntityRowDataBoList = relEntityBo.getRowDataBoList();
            List<HisEventBo> relEntityHisEventBoList = relEntityBo.getHisEventBoList();
            String relEntityNumber = relEntityBo.getEntityNumber();
            RowDataUpParamBo rowDataUpParamBo = new RowDataUpParamBo(relEntityBo.getEntityNumber(), confItemEntityBo.getEntityNumber(), relEntityRowDataBoList, true);
            rowDataUpParamBo.setEntityHisEventBoList(relEntityHisEventBoList).setParentEntityNumber(relEntityBo.getParentEntity()).setHisMod(relEntityBo.getHisMod()).setNeedAllHis(relEntityBo.getNeedAllHis()).setControlMod(relEntityBo.getControlMod()).setKeyFields(entityKeyFieldsMap.get(relEntityNumber));
            rowDataUpParamBo.setRelEntityBoList(confItemEntityBo.getRelEntityBoList());
            rowDataUpParamBo.setRelF7ProVsF7EntityNumMap(relEntityBo.getRelF7ProVsF7EntityNumMap());
            this.updateEntityIdInDataPacket(rowDataUpParamBo, confItemValidBo);
            this.buildRelEntityHisErrMsg(allValidFailRowDataPkIdSet, hisNeedAllVerDataErrCueMsgSb, relEntityBo, rowDataUpParamBo);
        }
    }

    private void buildRelEntityHisErrMsg(Set<Object> allValidFailRowDataPkIdSet, StringBuilder hisNeedAllVerDataErrCueMsgSb, RelEntityBo relEntityBo, RowDataUpParamBo rowDataUpParamBo) {
        allValidFailRowDataPkIdSet.addAll(rowDataUpParamBo.getCheErrPkIdSet());
        relEntityBo.setHisEventBoList(rowDataUpParamBo.getEntityHisEventBoList());
        relEntityBo.setRowDataBoList(rowDataUpParamBo.getEntityRowDataBoList());
        String cheHisErrCueMsg = rowDataUpParamBo.getCheckErrCueMsg();
        if (StringUtils.isNotEmpty((String)cheHisErrCueMsg)) {
            hisNeedAllVerDataErrCueMsgSb.append(cheHisErrCueMsg).append("\r\n");
        }
    }

    private void syncRelEntityData(Set<Object> allValidFailRowDataPkIdSet, List<RelEntityBo> relEntityBoList) {
        for (RelEntityBo relEntityBo : relEntityBoList) {
            List<RowDataBo> relEntityRowDataBoList = relEntityBo.getRowDataBoList();
            List<HisEventBo> relEntityHisEventBoList = relEntityBo.getHisEventBoList();
            String relEntityNumber = relEntityBo.getEntityNumber();
            this.syncEntityAllData(relEntityNumber, relEntityRowDataBoList, relEntityHisEventBoList, relEntityBo.getCtrlRelTableBoList(), allValidFailRowDataPkIdSet);
        }
    }

    private void handleBakDataFile(String confItemNum, String entityNum, String dataSqlFileName) {
        try {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNum);
            String zipFileName = dataSqlFileName.replace(".sql", ".zip");
            File zipSqlFile = FileUtils.createFile(null, (String)zipFileName);
            File sqlBakDataFile = FileUtils.createFile(null, (String)dataSqlFileName);
            FileUtils.toZip((String)dataSqlFileName, (String)zipFileName);
            Map uploadRetMap = FileUtils.uploadFile((String)zipFileName, (String)zipSqlFile.getPath());
            if (ObjectUtils.isEmpty((Object)uploadRetMap)) {
                throw new HDTCBizException("uploadRetMap is empty.");
            }
            this.saveConfBakDataLog(confItemNum, entityNum, dataEntityType.getAppId(), uploadRetMap, zipFileName);
            FileUtils.deleteLocalFile((File)sqlBakDataFile);
            FileUtils.deleteLocalFile((File)zipSqlFile);
        }
        catch (Exception exception) {
            LOG.error("synBakDataSqlFileName=" + dataSqlFileName, (Throwable)exception);
            throw new HDTCBizException("handleBakDataFile is exception,message=" + exception.getMessage());
        }
    }

    private void saveConfBakDataLog(String confItemNum, String entityNum, String appId, Map<String, String> uploadRetMap, String dataSqlFileName) {
        DynamicObject configBakLogDyn = this.configBakLogEntityService.generateEmptyDynamicObject();
        configBakLogDyn.set("confentitynumber", (Object)confItemNum);
        configBakLogDyn.set("appid", (Object)appId);
        configBakLogDyn.set("bakfilename", (Object)dataSqlFileName);
        configBakLogDyn.set("entitynumber", (Object)entityNum);
        configBakLogDyn.set("uploadid", (Object)uploadRetMap.get("uploadId"));
        configBakLogDyn.set("serverurl", (Object)uploadRetMap.get("serverUrl"));
        configBakLogDyn.set("clienturl", (Object)uploadRetMap.get("clientUrl"));
        configBakLogDyn.set("creator", (Object)this.curUserId);
        this.configBakLogEntityService.save(configBakLogDyn);
    }

    private Map<String, String> getConfItemAndRelEntityKeyFieldsMap(List<RelEntityBo> relEntityBoList) {
        List confItemDynList;
        HashMap<String, String> entityKeyFieldsMap = new HashMap<String, String>(16);
        if (CollectionUtils.isEmpty(this.confItemEntityNumSet)) {
            return entityKeyFieldsMap;
        }
        HashSet<String> relEntityNumberSet = new HashSet<String>(16);
        HashSet<String> relParentEntityNumberSet = new HashSet<String>(16);
        if (CollectionUtils.isNotEmpty(relEntityBoList)) {
            for (RelEntityBo relEntityBo : relEntityBoList) {
                relEntityNumberSet.add(relEntityBo.getEntityNumber());
                relParentEntityNumberSet.add(relEntityBo.getParentEntity());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(confItemDynList = this.configItemEntityService.queryOriginalList("id,number,keyfields", new QFilter[]{new QFilter("number", "in", this.confItemEntityNumSet), ENABLE_FILTER})))) {
            entityKeyFieldsMap.putAll(confItemDynList.stream().collect(Collectors.toMap(dyn -> dyn.getString("number"), dyn -> dyn.getString("keyfields"), (key1, key2) -> key1)));
        }
        if (CollectionUtils.isNotEmpty(relParentEntityNumberSet)) {
            QFilter relEntityFilter = new QFilter("relentity.number", "in", relEntityNumberSet);
            relEntityFilter.and(new QFilter("configitem.enable", "=", (Object)"1")).and(new QFilter("sourceentity.number", "in", relParentEntityNumberSet));
            List relEntityDynList = this.relEntityConfService.queryOriginalList("id,relentity.number,keyfields", new QFilter[]{relEntityFilter});
            if (CollectionUtils.isNotEmpty((Collection)relEntityDynList)) {
                entityKeyFieldsMap.putAll(relEntityDynList.stream().collect(Collectors.toMap(dyn -> dyn.getString("relentity.number"), dyn -> dyn.getString("keyfields"), (key1, key2) -> key1)));
            }
        }
        return entityKeyFieldsMap;
    }

    private void syncEntityAllData(String entityNumber, List<RowDataBo> entityRowDataBoList, List<HisEventBo> entityHisEventBoList, List<CtrlRelTableBo> entityCtrlRelTableBoList, Set<Object> allValidFailRowDataPkIdSet) {
        if (MetadataUtils.hisEntity((String)entityNumber)) {
            HashSet<Long> confItemBoIdSet = new HashSet<Long>(16);
            entityRowDataBoList.stream().filter(rowDataBo -> !allValidFailRowDataPkIdSet.contains(rowDataBo.getPkId())).forEach(rowDataBo -> confItemBoIdSet.add(this.idToLong(rowDataBo.getPkId())));
            this.syncHisEventData(entityHisEventBoList, entityNumber, confItemBoIdSet);
        }
        if (MetadataUtils.checkBaseDataCtrl((String)entityNumber)) {
            this.syncCtrData(entityCtrlRelTableBoList);
        }
        this.syncEntityItselfData(entityNumber, entityRowDataBoList, allValidFailRowDataPkIdSet);
    }

    private void updateEntityIdInDataPacket(RowDataUpParamBo rowDataUpParamBo, ConfItemValidBo confItemValidBo) {
        Set<String> keyFieldSet = rowDataUpParamBo.getKeyFieldSet();
        String entityNumber = rowDataUpParamBo.getEntityNumber();
        List<RowDataBo> entityRowDataBoList = rowDataUpParamBo.getEntityRowDataBoList();
        if (CollectionUtils.isEmpty(entityRowDataBoList)) {
            return;
        }
        HashSet<Object> pkIdSet = new HashSet<Object>(16);
        HashMap<String, Set<Object>> keyFieldMap = new HashMap<String, Set<Object>>(16);
        this.getKeyFieldValue(entityRowDataBoList, keyFieldSet, pkIdSet, keyFieldMap);
        QFilter[] filterArr = this.getUpEntityFilter(rowDataUpParamBo, pkIdSet, keyFieldMap);
        String selectFields = "id," + String.join((CharSequence)",", keyFieldSet);
        if (keyFieldSet.contains("id")) {
            selectFields = String.join((CharSequence)",", keyFieldSet);
        }
        if (rowDataUpParamBo.getHisMod().booleanValue()) {
            selectFields = selectFields + "," + "boid" + "," + "iscurrentversion";
        }
        LOG.info("updateEntityData,entityNumber={},selectFields={}", (Object)entityNumber, (Object)selectFields);
        List<DynamicObject> dbEntityDynList = this.getEntityDynListFromDb(entityNumber, selectFields, filterArr);
        if (CollectionUtils.isEmpty(dbEntityDynList)) {
            this.upCtrRelF7OrgIdData(rowDataUpParamBo, confItemValidBo);
            this.updateEntityRelItemClassF7Id(rowDataUpParamBo);
            return;
        }
        this.getEntityDbDataPkIdSet(dbEntityDynList);
        this.compareMainEntityAndUpId(rowDataUpParamBo, dbEntityDynList, confItemValidBo);
        if (rowDataUpParamBo.getHisMod().booleanValue() && !rowDataUpParamBo.getNeedAllHis().booleanValue()) {
            this.upHisEventData(rowDataUpParamBo);
        } else if (rowDataUpParamBo.getControlMod().booleanValue()) {
            this.upCtrRelTableData(rowDataUpParamBo);
            this.upCtrRelF7OrgIdData(rowDataUpParamBo, confItemValidBo);
        }
    }

    private void updateEntityRelItemClassF7Id(RowDataUpParamBo rowDataUpParamBo) {
        if (rowDataUpParamBo.getRelEntity().booleanValue()) {
            return;
        }
        Map<String, String> confItemF7ProVsF7EntityNumMap = rowDataUpParamBo.getRelF7ProVsF7EntityNumMap();
        HashMap<String, List<RowDataBo>> relEntityNumVsRowDataListMap = new HashMap<String, List<RowDataBo>>(16);
        List<RelEntityBo> relEntityBoList = rowDataUpParamBo.getRelEntityBoList();
        relEntityBoList.forEach(relEntityBo -> relEntityNumVsRowDataListMap.put(relEntityBo.getEntityNumber(), relEntityBo.getRowDataBoList()));
        List<RowDataBo> rowDataBoList = rowDataUpParamBo.getEntityRowDataBoList();
        for (Map.Entry<String, String> f7Entry : confItemF7ProVsF7EntityNumMap.entrySet()) {
            String f7ProName = f7Entry.getKey();
            String baseEntityId = f7Entry.getValue();
            List relEntityRowDataBoList = (List)relEntityNumVsRowDataListMap.get(baseEntityId);
            boolean f7ItemClass = MetadataUtils.isF7ItemClass((String)rowDataUpParamBo.getEntityNumber(), (String)f7ProName);
            if (!f7ItemClass && (CollectionUtils.isEmpty((Collection)relEntityRowDataBoList) || rowDataUpParamBo.getRelEntity().booleanValue())) continue;
            MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)rowDataUpParamBo.getEntityNumber());
            this.compareItemClassF7Up(relEntityNumVsRowDataListMap, rowDataBoList, f7ProName, relEntityRowDataBoList, mainEntityType);
        }
    }

    private void compareItemClassF7Up(Map<String, List<RowDataBo>> relEntityNumVsRowDataListMap, List<RowDataBo> rowDataBoList, String f7ProName, List<RowDataBo> relEntityRowDataBoList, MainEntityType mainEntityType) {
        boolean f7ItemClass = MetadataUtils.isF7ItemClass((String)mainEntityType.getName(), (String)f7ProName);
        for (RowDataBo rowDataBo : rowDataBoList) {
            for (FieldBo fieldBo : rowDataBo.getFieldBoList()) {
                String mainFieldName = fieldBo.getFieldName();
                if (StringUtils.equals((String)f7ProName, (String)mainFieldName) && StringUtils.equals((String)EntityPropertyTypeEnum.BASE_DATA_PROP.getByType(), (String)fieldBo.getFieldType())) {
                    if (f7ItemClass && (relEntityRowDataBoList = this.getItemClassRowDataList(relEntityNumVsRowDataListMap, f7ProName, mainEntityType, rowDataBo)) == null) continue;
                    Map<String, Object> mainRelF7Map = ConfItemUtils.getSingleF7Map(fieldBo.getFieldValue());
                    Object mainPkId = mainRelF7Map.get("id");
                    Object mainNumber = mainRelF7Map.get("number");
                    if (mainNumber == null) continue;
                    this.compareFromRelEntityAndUpRelF7Val(relEntityRowDataBoList, fieldBo, mainPkId, mainNumber);
                    continue;
                }
                if (!StringUtils.equals((String)EntityPropertyTypeEnum.ENTRY_PROP.getByType(), (String)fieldBo.getFieldType()) && !StringUtils.equals((String)EntityPropertyTypeEnum.SUB_ENTRY_PROP.getByType(), (String)fieldBo.getFieldType())) continue;
                this.compareItemClassF7Up(relEntityNumVsRowDataListMap, ConfItemUtils.getRowDataBoList(fieldBo.getFieldValue()), f7ProName, relEntityRowDataBoList, mainEntityType);
            }
        }
    }

    private List<RowDataBo> getItemClassRowDataList(Map<String, List<RowDataBo>> relEntityNumVsRowDataListMap, String f7ProName, MainEntityType mainEntityType, RowDataBo rowDataBo) {
        String typePropName = ((ItemClassProp)MetadataUtils.getFieldEntityPropertyByFieldNum((MainEntityType)mainEntityType, (String)f7ProName)).getTypePropName();
        List<Object> itemClassEntityNumList = ConfItemUtils.getFieldIdValueByPropName(rowDataBo.getFieldBoList(), typePropName);
        if (CollectionUtils.isEmpty(itemClassEntityNumList)) {
            return null;
        }
        String itemClassEntityNumber = (String)itemClassEntityNumList.get(0);
        return relEntityNumVsRowDataListMap.get(itemClassEntityNumber);
    }

    private void compareFromRelEntityAndUpRelF7Val(List<RowDataBo> relEntityRowDataBoList, FieldBo fieldBo, Object mainPkId, Object mainNumber) {
        RowDataBo relRowDataBo;
        Object pkId;
        Iterator<RowDataBo> iterator = relEntityRowDataBoList.iterator();
        while (iterator.hasNext() && !mainPkId.equals(pkId = (relRowDataBo = iterator.next()).getPkId())) {
            Object relEntityNumVal = ConfItemUtils.getFieldValueByPropName(relRowDataBo.getFieldBoList(), "number");
            if (relEntityNumVal == null || !mainNumber.equals(relEntityNumVal)) continue;
            List<FieldBo> fieldBoList = ConfItemUtils.getFieldBoList(fieldBo.getFieldValue());
            for (FieldBo mainF7FieldBo : fieldBoList) {
                if (!StringUtils.equals((String)mainF7FieldBo.getFieldName(), (String)"id")) continue;
                mainF7FieldBo.setFieldValue(pkId);
            }
            fieldBo.setFieldValue(fieldBoList);
            fieldBo.setRelF7IdVal(pkId);
        }
    }

    private void getEntityDbDataPkIdSet(List<DynamicObject> dbEntityDynList) {
        this.ctrEntityPkIdSet.clear();
        dbEntityDynList.forEach(dyn -> this.ctrEntityPkIdSet.add(dyn.get("id")));
    }

    private void upCtrRelF7OrgIdData(RowDataUpParamBo rowDataUpParamBo, ConfItemValidBo confItemValidBo) {
        List<CtrlRelTableBo> entityCtrlRelTableBoList = rowDataUpParamBo.getEntityCtrlRelTableBoList();
        Map<Object, Object> relOrgF7OldIdVsNewIdMap = confItemValidBo.getRelOrgF7OldIdVsNewIdMap();
        if (CollectionUtils.isEmpty(entityCtrlRelTableBoList) || ObjectUtils.isEmpty(relOrgF7OldIdVsNewIdMap) || !rowDataUpParamBo.getControlMod().booleanValue()) {
            return;
        }
        this.replaceAllCtrlId(rowDataUpParamBo, entityCtrlRelTableBoList, relOrgF7OldIdVsNewIdMap);
    }

    public void replaceAllCtrlId(RowDataUpParamBo rowDataUpParamBo, List<CtrlRelTableBo> entityCtrlRelTableBoList, Map<Object, Object> dataIdVsDbIdMap) {
        for (Map.Entry<Object, Object> relF7OrgEntry : dataIdVsDbIdMap.entrySet()) {
            Object dataId = relF7OrgEntry.getKey();
            Object dbId = relF7OrgEntry.getValue();
            if (dataId == null || dbId == null || rowDataUpParamBo.getCheErrPkIdSet().contains(dataId)) continue;
            for (CtrlRelTableBo ctrlRelTableBo : entityCtrlRelTableBoList) {
                if (StringUtils.isEmpty((String)ctrlRelTableBo.getKsql())) continue;
                String ksql = ctrlRelTableBo.getKsql();
                ksql = ksql.replaceAll("= " + dataId.toString() + ";", "= " + dbId.toString() + ";");
                ksql = ksql.replaceAll("= " + dataId.toString() + " ", "= " + dbId.toString() + " ");
                ksql = ksql.replaceAll("\\(" + dataId.toString() + ",", "(" + dbId.toString() + ",");
                ksql = ksql.replaceAll("," + dataId.toString() + ",", "," + dbId.toString() + ",");
                ctrlRelTableBo.setKsql(ksql);
            }
        }
    }

    private void upCtrRelTableData(RowDataUpParamBo rowDataUpParamBo) {
        Map<Object, Object> dataIdVsDbIdMap = rowDataUpParamBo.getDataIdVsDbIdMap();
        List<CtrlRelTableBo> entityCtrlRelTableBoList = rowDataUpParamBo.getEntityCtrlRelTableBoList();
        if (CollectionUtils.isEmpty(entityCtrlRelTableBoList)) {
            return;
        }
        this.replaceAllCtrlId(rowDataUpParamBo, entityCtrlRelTableBoList, dataIdVsDbIdMap);
    }

    public void upHisEventData(RowDataUpParamBo rowDataUpParamBo) {
        if (rowDataUpParamBo.getDataIdVsDbIdMap().size() == 0) {
            return;
        }
        List<HisEventBo> entityHisEventBoList = rowDataUpParamBo.getEntityHisEventBoList();
        HashSet<Long> failBizEventIdSet = new HashSet<Long>(16);
        Map<Object, Object> dataIdVsDbIdMap = rowDataUpParamBo.getDataIdVsDbIdMap();
        this.updateVerEventRowData(entityHisEventBoList, failBizEventIdSet, dataIdVsDbIdMap);
        this.updateBizEventRowData(entityHisEventBoList, failBizEventIdSet, dataIdVsDbIdMap);
    }

    private void updateVerEventRowData(List<HisEventBo> entityHisEventBoList, Set<Long> needUpBizEventIdSet, Map<Object, Object> dataIdVsDbIdMap) {
        for (HisEventBo hisEventBo : entityHisEventBoList) {
            String hisEventType = hisEventBo.getHisEventType();
            if (!HisEventEntityTypeEnum.VER_EVENT_TYPE.getType().equals(hisEventType)) continue;
            List<RowDataBo> versionHisEventRowDataBoList = hisEventBo.getRowDataBoList();
            ArrayList<RowDataBo> newVersionHisEventRowDataBoList = new ArrayList<RowDataBo>(10);
            for (RowDataBo rowDataBo : versionHisEventRowDataBoList) {
                List<FieldBo> fieldBoList = rowDataBo.getFieldBoList();
                boolean isNeedUpVId = true;
                for (FieldBo fieldBo : fieldBoList) {
                    if ("vid".equals(fieldBo.getFieldName()) && !dataIdVsDbIdMap.containsKey(fieldBo.getFieldValue())) {
                        isNeedUpVId = false;
                        break;
                    }
                    if (!"vid".equals(fieldBo.getFieldName()) || !dataIdVsDbIdMap.containsKey(fieldBo.getFieldValue())) continue;
                    fieldBo.setFieldValue(dataIdVsDbIdMap.get(fieldBo.getFieldValue()));
                    break;
                }
                if (!isNeedUpVId) continue;
                newVersionHisEventRowDataBoList.add(rowDataBo);
            }
            for (RowDataBo verRowDataBo : newVersionHisEventRowDataBoList) {
                List<FieldBo> verFieldBoList = verRowDataBo.getFieldBoList();
                for (FieldBo verFieldBo : verFieldBoList) {
                    if (!"busievent".equals(verFieldBo.getFieldName())) continue;
                    needUpBizEventIdSet.add(this.idToLong(verFieldBo.getFieldValue()));
                }
            }
        }
    }

    private void updateBizEventRowData(List<HisEventBo> entityHisEventBoList, Set<Long> failBizEventIdSet, Map<Object, Object> packetPkIdVsDbPkIdMap) {
        if (CollectionUtils.isEmpty(failBizEventIdSet)) {
            return;
        }
        for (HisEventBo hisEventBo : entityHisEventBoList) {
            String hisEventType = hisEventBo.getHisEventType();
            if (!HisEventEntityTypeEnum.BIZ_EVENT_TYPE.getType().equals(hisEventType)) continue;
            List<RowDataBo> bizHisEventRowDataBoList = hisEventBo.getRowDataBoList();
            for (RowDataBo rowDataBo : bizHisEventRowDataBoList) {
                List<FieldBo> fieldBoList = rowDataBo.getFieldBoList();
                if (!failBizEventIdSet.contains(this.idToLong(rowDataBo.getPkId()))) continue;
                for (FieldBo fieldBo : fieldBoList) {
                    if (!"boid".equals(fieldBo.getFieldName()) || !packetPkIdVsDbPkIdMap.containsKey(fieldBo.getFieldValue())) continue;
                    fieldBo.setFieldValue(packetPkIdVsDbPkIdMap.get(fieldBo.getFieldValue()));
                }
            }
        }
    }

    private void getKeyFieldValue(List<RowDataBo> entityRowDataBoList, Set<String> keyFieldSet, Set<Object> pkIdSet, Map<String, Set<Object>> keyFieldMap) {
        entityRowDataBoList.forEach(bo -> {
            pkIdSet.add(bo.getPkId());
            bo.getFieldBoList().stream().filter(fieldBo -> keyFieldSet.contains(fieldBo.getFieldName())).forEach(fieldBo -> {
                if (EntityPropertyTypeEnum.BASE_DATA_PROP.getByType().equals(fieldBo.getFieldType())) {
                    Map<String, Object> f7FieldMap = ConfItemUtils.getSingleF7Map(fieldBo.getFieldValue());
                    String numberVal = (String)f7FieldMap.get("number");
                    if (StringUtils.isNotEmpty((String)numberVal)) {
                        String f7RelProKey = fieldBo.getFieldName() + "." + "number";
                        keyFieldMap.putIfAbsent(f7RelProKey, new HashSet(10));
                        ((Set)keyFieldMap.get(f7RelProKey)).add(numberVal);
                    }
                } else {
                    keyFieldMap.putIfAbsent(fieldBo.getFieldName(), new HashSet(10));
                    ((Set)keyFieldMap.get(fieldBo.getFieldName())).add(fieldBo.getFieldValue());
                }
            });
        });
    }

    private QFilter[] getUpEntityFilter(RowDataUpParamBo rowDataUpParamBo, Set<Object> pkIdSet, Map<String, Set<Object>> keyFieldMap) {
        QFilter filter = new QFilter("id", "in", pkIdSet);
        if (rowDataUpParamBo.getHisMod().booleanValue()) {
            filter = new QFilter("boid", "in", pkIdSet);
        }
        QFilter keyFieldFilter = null;
        if (!ObjectUtils.isEmpty(keyFieldMap)) {
            for (Map.Entry<String, Set<Object>> keyFieldEntry : keyFieldMap.entrySet()) {
                if (keyFieldFilter == null) {
                    keyFieldFilter = new QFilter(keyFieldEntry.getKey(), "in", keyFieldEntry.getValue());
                    continue;
                }
                keyFieldFilter.and(new QFilter(keyFieldEntry.getKey(), "in", keyFieldEntry.getValue()));
            }
        }
        QFilter verDataStatusFilter = null;
        if (rowDataUpParamBo.getHisMod().booleanValue() && !rowDataUpParamBo.getNeedAllHis().booleanValue()) {
            verDataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        }
        if (keyFieldFilter != null) {
            filter.or(keyFieldFilter);
        }
        return new QFilter[]{verDataStatusFilter, filter};
    }

    public void compareMainEntityAndUpId(RowDataUpParamBo rowDataUpParamBo, List<DynamicObject> dbEntityDynList, ConfItemValidBo confItemValidBo) {
        List<RowDataBo> entityRowDataBoList = rowDataUpParamBo.getEntityRowDataBoList();
        HashSet<Object> dbPkIdSet = new HashSet<Object>(16);
        HashMap<Object, Object> dbKeyFieldsProValVsIdMap = new HashMap<Object, Object>(16);
        Boolean hisMod = rowDataUpParamBo.getHisMod();
        Boolean needAllHis = rowDataUpParamBo.getNeedAllHis();
        if (hisMod.booleanValue() && !needAllHis.booleanValue()) {
            this.getDbKeyFieldsValVsIdMap(rowDataUpParamBo, dbEntityDynList, dbPkIdSet, dbKeyFieldsProValVsIdMap);
            this.updateEntityDataId(rowDataUpParamBo, dbPkIdSet, dbKeyFieldsProValVsIdMap);
        } else if (hisMod.booleanValue()) {
            confItemValidBo.validNeedAllHisData(rowDataUpParamBo, dbEntityDynList, entityRowDataBoList);
        } else {
            this.getDbKeyFieldsValVsIdMap(rowDataUpParamBo, dbEntityDynList, dbPkIdSet, dbKeyFieldsProValVsIdMap);
            this.updateEntityDataId(rowDataUpParamBo, dbPkIdSet, dbKeyFieldsProValVsIdMap);
        }
        this.updateEntityRelItemClassF7Id(rowDataUpParamBo);
        confItemValidBo.validPacketPkIdRepeat(rowDataUpParamBo);
    }

    public void updateEntityDataId(RowDataUpParamBo rowDataUpParamBo, Set<Object> dbPkIdSet, Map<Object, Object> dbKeyFieldsProValVsIdMap) {
        List<RowDataBo> entityRowDataBoList = rowDataUpParamBo.getEntityRowDataBoList();
        Set<String> keyFieldSet = rowDataUpParamBo.getKeyFieldSet();
        Boolean hisMod = rowDataUpParamBo.getHisMod();
        Map<Object, Object> dataIdVsDbIdMap = rowDataUpParamBo.getDataIdVsDbIdMap();
        HashMap<Long, Long> oldBoVsDbBoIdMap = new HashMap<Long, Long>(16);
        for (RowDataBo rowDataBo : entityRowDataBoList) {
            Object dataPkId = rowDataBo.getPkId();
            if (dbPkIdSet.contains(dataPkId)) continue;
            List<FieldBo> fieldBoList = rowDataBo.getFieldBoList();
            StringBuilder dataKeyFieldsValue = new StringBuilder();
            for (String keyFieldProName : keyFieldSet) {
                Object keyFieldProValue = ConfItemUtils.getFieldValueByPropName(fieldBoList, keyFieldProName);
                if (hisMod.booleanValue()) {
                    dataKeyFieldsValue.append(keyFieldProValue).append(ConfItemUtils.getFieldValueByPropName(fieldBoList, "iscurrentversion"));
                    continue;
                }
                dataKeyFieldsValue.append(keyFieldProValue);
            }
            Object dbPkId = dbKeyFieldsProValVsIdMap.get(dataKeyFieldsValue.toString());
            if (dbPkId == null) continue;
            dataIdVsDbIdMap.put(dataPkId, dbPkId);
            rowDataBo.setPkId(dbPkId);
            for (FieldBo fieldBo : fieldBoList) {
                Object fieldValue = fieldBo.getFieldValue();
                if ("id".equals(fieldBo.getFieldName())) {
                    fieldBo.setFieldValue(dbPkId);
                    rowDataBo.setPkId(dbPkId);
                }
                if (!hisMod.booleanValue() || !"iscurrentversion".equals(fieldBo.getFieldName()) || Boolean.TRUE != fieldValue) continue;
                oldBoVsDbBoIdMap.put(this.idToLong(dataPkId), this.idToLong(dbPkId));
            }
            this.upEntityStructLongId(rowDataUpParamBo, rowDataBo, dataPkId, dbPkId);
        }
        this.upEntityBoId(entityRowDataBoList, hisMod, oldBoVsDbBoIdMap);
    }

    private void upEntityStructLongId(RowDataUpParamBo rowDataUpParamBo, RowDataBo rowDataBo, Object dataPkId, Object dbPkId) {
        if (!rowDataUpParamBo.getRelEntity().booleanValue()) {
            rowDataBo.setStructLongId(dbPkId.toString());
        } else {
            String oldStructLongId = rowDataBo.getStructLongId();
            rowDataBo.setStructLongId(oldStructLongId.replaceAll("!" + dataPkId, "!" + dbPkId));
        }
    }

    private void upEntityBoId(List<RowDataBo> entityRowDataBoList, boolean isHis, Map<Long, Long> oldBoVsDbBoIdMap) {
        if (!isHis || CollectionUtils.isEmpty(oldBoVsDbBoIdMap)) {
            return;
        }
        for (RowDataBo rowDataBo : entityRowDataBoList) {
            for (FieldBo fieldBo : rowDataBo.getFieldBoList()) {
                Long dbBoId;
                if (!"boid".equalsIgnoreCase(fieldBo.getFieldName()) || (dbBoId = oldBoVsDbBoIdMap.get(this.idToLong(fieldBo.getFieldValue()))) == null) continue;
                fieldBo.setFieldValue(dbBoId);
                rowDataBo.setBoId(dbBoId);
            }
        }
    }

    private void getDbKeyFieldsValVsIdMap(RowDataUpParamBo rowDataUpParamBo, List<DynamicObject> dbEntityDynList, Set<Object> dbPkIdSet, Map<Object, Object> dbKeyFieldsProValVsIdMap) {
        DataEntityPropertyCollection entityProperties = MetadataUtils.getMainEntityType((String)rowDataUpParamBo.getEntityNumber()).getProperties();
        Set<String> keyFieldSet = rowDataUpParamBo.getKeyFieldSet();
        Boolean hisMod = rowDataUpParamBo.getHisMod();
        for (DynamicObject dbEntityDyn : dbEntityDynList) {
            Object dbPkId = dbEntityDyn.get("id");
            dbPkIdSet.add(dbPkId);
            StringBuilder dbKeyFieldsValue = new StringBuilder();
            for (IDataEntityProperty property : entityProperties) {
                String proName = property.getName();
                if (!keyFieldSet.contains(proName)) continue;
                dbKeyFieldsValue.append(dbEntityDyn.get(proName));
            }
            if (hisMod.booleanValue()) {
                dbKeyFieldsValue.append(dbEntityDyn.getString("iscurrentversion"));
            }
            dbKeyFieldsProValVsIdMap.put(dbKeyFieldsValue.toString(), dbPkId);
        }
    }

    private List<DynamicObject> getEntityDynListFromDb(String entityNumber, String selectFields, QFilter[] filterArr) {
        return CommonEntityServiceFactory.getEntityService((String)entityNumber).queryOriginalList(selectFields, filterArr);
    }

    private void syncEntityItselfData(String entityNumber, List<RowDataBo> confItemRowDataBoList, Set<Object> allValidFailRowDataPkIdSet) {
        Object[] keyFieldArr;
        if (CollectionUtils.isEmpty(confItemRowDataBoList)) {
            return;
        }
        List<RowDataBo> entityRowBoList = confItemRowDataBoList.stream().filter(rowDataBo -> !allValidFailRowDataPkIdSet.contains(rowDataBo.getPkId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entityRowBoList)) {
            return;
        }
        ArrayList<DynamicObject> entityDynList = new ArrayList<DynamicObject>(10);
        ArrayList<Object> pkIdList = new ArrayList<Object>(10);
        IBaseEntityService entityService = CommonEntityServiceFactory.getEntityService((String)entityNumber);
        this.getEntityData(entityRowBoList, entityDynList, pkIdList, entityService);
        String keyFields = this.confItemKeyFieldMap.get(entityNumber);
        boolean isHisModEntity = MetadataUtils.hisEntity((String)entityNumber);
        HashSet<String> keyFieldSet = new HashSet<String>(16);
        if (HRStringUtils.isNotEmpty((String)keyFields) && !ObjectUtils.isEmpty((Object[])(keyFieldArr = keyFields.split(",")))) {
            Arrays.stream(keyFieldArr).filter(HRStringUtils::isNotEmpty).forEach(keyFieldSet::add);
        }
        QFilter delFilter = new EntityBo().getEntityKeyFieldFilter(entityRowBoList, keyFieldSet, isHisModEntity, true);
        this.bakEntityItselfData(entityNumber, entityService, delFilter);
        LOG.info("ConfigItemDomainServiceImpl.handleData,entityNumber={},delFilter={}", (Object)entityNumber, (Object)delFilter);
        this.entityDelAndSave(entityNumber, entityService, delFilter, entityDynList);
    }

    private void bakEntityItselfData(String entityNumber, IBaseEntityService entityService, QFilter delFilter) {
        List dbEntityDataDynList = entityService.queryOriginalList("id", delFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)dbEntityDataDynList)) {
            List<Object> bakPkIdList = dbEntityDataDynList.stream().map(dyn -> dyn.get("id")).collect(Collectors.toList());
            LOG.info("bakEntityItselfData,bakPkIdList={}", bakPkIdList);
            this.writeBakEntityDataIntoFile(entityNumber, bakPkIdList);
        }
    }

    private void getEntityData(List<RowDataBo> entityRowBoList, List<DynamicObject> entityDynList, List<Object> pkIdList, IBaseEntityService entityService) {
        EntityBo entityBo = new EntityBo();
        for (RowDataBo rowDataBo : entityRowBoList) {
            Object pkId = rowDataBo.getPkId();
            DynamicObject entityDyn = entityService.generateEmptyDynamicObject();
            entityBo.boToDynamicObject(entityDyn, rowDataBo);
            entityDynList.add(entityDyn);
            pkIdList.add(pkId);
        }
    }

    private void syncCtrData(List<CtrlRelTableBo> confItemCtrlRelTableBoList) {
        if (CollectionUtils.isEmpty(confItemCtrlRelTableBoList)) {
            return;
        }
        StringBuilder saveSqlSb = new StringBuilder();
        DBRoute dbRoute = null;
        PreInsDataScriptBuilder preInsDataScriptBuilder = new PreInsDataScriptBuilder();
        StringBuilder ctrTableKsqlSb = new StringBuilder();
        String entityNumber = null;
        HashMap<String, Map<String, List<Object>>> ctrlTableVsDataIdMap = new HashMap<String, Map<String, List<Object>>>(16);
        for (CtrlRelTableBo ctrlRelTableBo : confItemCtrlRelTableBoList) {
            String tableKsql;
            String dbRouteKey = ctrlRelTableBo.getDbRouteKey();
            dbRoute = DBRoute.of((String)dbRouteKey);
            entityNumber = ctrlRelTableBo.getEntityNumber();
            String dataSql = ctrlRelTableBo.getKsql();
            if (HRStringUtils.isEmpty((String)dataSql)) continue;
            saveSqlSb.append(dataSql).append("\r\n");
            String tableName = ctrlRelTableBo.getTableName();
            String filterField = ctrlRelTableBo.getCtrEntityField();
            ArrayList<Object> filterIdValList = new ArrayList<Object>();
            filterIdValList.addAll(this.ctrEntityPkIdSet);
            Map<String, Object> ksql = this.getControlEntityTableKsql(dbRoute, preInsDataScriptBuilder, tableName, filterField, new ArrayList<Object>(this.ctrEntityPkIdSet));
            if (ObjectUtils.isEmpty(ksql) || HRStringUtils.isEmpty((String)(tableKsql = ksql.get("sql").toString()))) continue;
            ctrlTableVsDataIdMap.putIfAbsent(tableName, new HashMap(16));
            ((Map)ctrlTableVsDataIdMap.get(tableName)).put(filterField, filterIdValList);
            String tableAnnotationSql = "-- " + entityNumber + "," + tableName + "\r\n";
            ctrTableKsqlSb.append(tableAnnotationSql).append(tableKsql);
        }
        if (StringUtils.isNotEmpty((String)ctrTableKsqlSb.toString()) && StringUtils.isNotEmpty(entityNumber)) {
            FileUtils.writeStr2File(null, (String)this.getBakDataSqlFileName(entityNumber), (String)ctrTableKsqlSb.toString());
            this.delOldCtrData(dbRoute, ctrlTableVsDataIdMap);
        }
        if (HRStringUtils.isNotEmpty((String)saveSqlSb.toString())) {
            this.executeSql(dbRoute, saveSqlSb);
        }
    }

    public void delOldCtrData(DBRoute dbRoute, Map<String, Map<String, List<Object>>> ctrlTableVsDataIdMap) {
        for (Map.Entry<String, Map<String, List<Object>>> ctrEntry : ctrlTableVsDataIdMap.entrySet()) {
            String tableName = ctrEntry.getKey();
            StringBuilder tableDelSqlSb = new StringBuilder();
            tableDelSqlSb.append("DELETE FROM ").append(tableName.toUpperCase(Locale.ROOT)).append(" WHERE ");
            Map<String, List<Object>> fieldVsIdListMap = ctrEntry.getValue();
            for (Map.Entry<String, List<Object>> fieldVsIdEntry : fieldVsIdListMap.entrySet()) {
                tableDelSqlSb.append(fieldVsIdEntry.getKey()).append(" in (").append(Joiner.on((char)',').join((Iterable)fieldVsIdEntry.getValue())).append(");\r\n");
            }
            this.executeSql(dbRoute, tableDelSqlSb);
        }
    }

    private void executeSql(DBRoute dbRoute, StringBuilder tableDelSqlSb) {
        SqlBuilder sqlBuilder = new SqlBuilder().append(tableDelSqlSb.toString(), new Object[0]);
        DB.execute((DBRoute)dbRoute, (SqlBuilder)sqlBuilder);
    }

    private void syncHisEventData(List<HisEventBo> confItemHisEventBoList, String entityNumber, Set<Long> confItemBoIdSet) {
        if (!MetadataUtils.hisEntity((String)entityNumber) || StringUtils.isBlank((CharSequence)entityNumber) || CollectionUtils.isEmpty(confItemBoIdSet)) {
            return;
        }
        DynamicObject dyEventGroup = HisModelEventDataService.getInstance().getEventGroupDyByEntity(entityNumber);
        if (dyEventGroup != null) {
            DynamicObject dyEvent = dyEventGroup.getDynamicObject("evententity");
            DynamicObject dyBsEvent = dyEventGroup.getDynamicObject("busevententity");
            DynamicObject dyVersionEvent = dyEventGroup.getDynamicObject("hisevententity");
            String eventEntityNumber = dyEvent.getString("number");
            String bussEventEntityNumber = dyBsEvent.getString("number");
            String versionEventEntityNumber = dyVersionEvent.getString("number");
            LOG.info("ConfigItemDomainServiceImpl.handleHisModData,entityNumber={},eventEntityNumber={},bussEventEntityNumber={},versionEventEntityNumber={},entityBoIdSet={}", new Object[]{entityNumber, eventEntityNumber, bussEventEntityNumber, versionEventEntityNumber, SerializationUtils.toJsonString(confItemBoIdSet)});
            CommonServiceImpl eventServiceHelper = new CommonServiceImpl(eventEntityNumber);
            HRBaseServiceHelper bussEventServiceHelper = new HRBaseServiceHelper(bussEventEntityNumber);
            CommonServiceImpl versionEventServiceHelper = new CommonServiceImpl(versionEventEntityNumber);
            List<RowDataBo> allBussEventBoList = null;
            List<RowDataBo> allVersionEventBoList = null;
            List<RowDataBo> allEventBoList = null;
            for (HisEventBo hisEventBo : confItemHisEventBoList) {
                String hisEventEntityNum = hisEventBo.getHisEventEntityNum();
                if (bussEventEntityNumber.equals(hisEventEntityNum)) {
                    allBussEventBoList = hisEventBo.getRowDataBoList();
                    continue;
                }
                if (versionEventEntityNumber.equals(hisEventEntityNum)) {
                    allVersionEventBoList = hisEventBo.getRowDataBoList();
                    continue;
                }
                allEventBoList = hisEventBo.getRowDataBoList();
            }
            if (CollectionUtils.isEmpty(allBussEventBoList)) {
                return;
            }
            ArrayList<DynamicObject> bussEventDynList = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> versionEventDynList = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> eventDynList = new ArrayList<DynamicObject>(10);
            HashSet<Long> bussEventIdSet = new HashSet<Long>(16);
            ArrayList<Long> versionEventIdList = new ArrayList<Long>(10);
            ArrayList<Long> eventIdList = new ArrayList<Long>(10);
            HashSet<Long> eventIdSet = new HashSet<Long>(16);
            this.assemblyBussEventData(confItemBoIdSet, bussEventServiceHelper, allBussEventBoList, bussEventDynList, bussEventIdSet, eventIdSet);
            this.assemblyVerAndEventData(versionEventServiceHelper, allVersionEventBoList, versionEventDynList, bussEventIdSet, versionEventIdList, "busievent");
            this.hisFilterOtherBoEvent(confItemBoIdSet, bussEventServiceHelper, eventIdSet);
            this.assemblyVerAndEventData(eventServiceHelper, allEventBoList, eventDynList, eventIdSet, eventIdList, "id");
            this.writeBakEntityDataIntoFile(bussEventEntityNumber, new ArrayList<Object>(bussEventIdSet));
            this.writeBakEntityDataIntoFile(versionEventEntityNumber, new ArrayList<Object>(versionEventIdList));
            this.writeBakEntityDataIntoFile(eventEntityNumber, new ArrayList<Object>(eventIdList));
            this.delHisModData(entityNumber, new ArrayList<Long>(confItemBoIdSet));
            bussEventServiceHelper.save(bussEventDynList.toArray(new DynamicObject[0]));
            versionEventServiceHelper.save(versionEventDynList.toArray(new DynamicObject[0]));
            if (CollectionUtils.isNotEmpty(eventDynList)) {
                eventServiceHelper.save(eventDynList.toArray(new DynamicObject[0]));
            }
        }
    }

    private void hisFilterOtherBoEvent(Set<Long> entityBoIdSet, HRBaseServiceHelper bussEventServiceHelper, Set<Long> eventIdSet) {
        if (entityBoIdSet != null) {
            DynamicObject[] dyRestEvent = HisEventEntityRepository.queryBussEventByEventIds((HRBaseServiceHelper)bussEventServiceHelper, (Long[])entityBoIdSet.toArray(new Long[0]), (Long[])eventIdSet.toArray(new Long[0]));
            Set restEventId = Arrays.stream(dyRestEvent).map(dy -> dy.getLong("event")).collect(Collectors.toSet());
            eventIdSet.removeAll(restEventId);
        }
    }

    private void assemblyBussEventData(Set<Long> entityBoIdSet, HRBaseServiceHelper bussEventServiceHelper, List<RowDataBo> allBussEventMapList, List<DynamicObject> bussEventDynList, Set<Long> bussEventIdSet, Set<Long> eventIdSet) {
        if (ObjectUtils.isEmpty(allBussEventMapList)) {
            return;
        }
        EntityBo entityBo = new EntityBo();
        for (RowDataBo bussEventRowDataBo : allBussEventMapList) {
            List<FieldBo> fieldBoList = bussEventRowDataBo.getFieldBoList();
            Long bussEventBoId = 0L;
            for (FieldBo fieldBo : fieldBoList) {
                if (!"boid".equals(fieldBo.getFieldName())) continue;
                bussEventBoId = this.idToLong(fieldBo.getFieldValue());
                break;
            }
            if (!entityBoIdSet.contains(bussEventBoId)) continue;
            DynamicObject bussEventDyn = bussEventServiceHelper.generateEmptyDynamicObject();
            entityBo.boToDynamicObject(bussEventDyn, bussEventRowDataBo);
            bussEventDynList.add(bussEventDyn);
            bussEventIdSet.add(bussEventDyn.getLong("id"));
            eventIdSet.add(this.idToLong(bussEventDyn.getLong("event")));
        }
    }

    public void initBeforeHandleConfItemData(Map<String, Object> retMap) {
        this.confItemKeyFieldMap = new HashMap<String, String>(16);
        retMap.put("code", 0);
        retMap.put("msg", "");
        retMap.put("dev_msg", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MainEntityBo getConfItemImportDataByUrl(String exportUrl) {
        MainEntityBo mainEntityBo = null;
        TempFileCacheDownloadable.Content cacheContentFromTempContent = FileUtils.getCacheContentFromTempUrl((String)exportUrl);
        if (null != cacheContentFromTempContent) {
            InputStream inputStream = null;
            try {
                inputStream = cacheContentFromTempContent.getInputStream();
                String dataStr = FileUtils.inputStreamToString((InputStream)inputStream);
                mainEntityBo = (MainEntityBo)JSON.parseObject((String)dataStr, MainEntityBo.class);
            }
            catch (Exception exception) {
                LOG.error(exception.getMessage(), (Throwable)exception);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    LOG.info("inputStream.close is exception,handleConfItemImportData,exportUrl={}", (Object)exportUrl);
                }
            }
        }
        return mainEntityBo;
    }

    private void initConfItemKeyField(String confItemName) {
        CommonServiceImpl confItemService = new CommonServiceImpl("hrcc_configitems");
        DynamicObject confItemDyn = confItemService.queryOne("id, number,keyfields", new QFilter[]{new QFilter("number", "=", (Object)confItemName), ENABLE_FILTER});
        if (confItemDyn == null) {
            return;
        }
        long confItemPkId = confItemDyn.getLong("id");
        this.confItemKeyFieldMap.put(confItemDyn.getString("number"), confItemDyn.getString("keyfields"));
        CommonServiceImpl confItemRelEntityService = new CommonServiceImpl("hrcc_relentityconf");
        List configItemRelEntityDynList = confItemRelEntityService.queryOriginalList("id,relentity.number,keyfields", new QFilter[]{new QFilter("configitem", "=", (Object)confItemPkId)});
        if (!ObjectUtils.isEmpty((Object)configItemRelEntityDynList)) {
            configItemRelEntityDynList.forEach(relDyn -> this.confItemKeyFieldMap.put(relDyn.getString("relentity.number"), relDyn.getString("keyfields")));
        }
        LOG.info("initConfItemKeyField,confItemKeyFieldMap={}", (Object)SerializationUtils.toJsonString(this.confItemKeyFieldMap));
    }

    private void entityDelAndSave(String entityNumber, IBaseEntityService entityService, QFilter delFilter, List<DynamicObject> newDataDynList) {
        LOG.info("ConfigItemDomainServiceImpl.entityDelAndSave,entityNumber={},delFilter={}", (Object)entityNumber, (Object)delFilter);
        long startTime = System.currentTimeMillis();
        if (!ObjectUtils.isEmpty((Object)delFilter)) {
            entityService.deleteByFilter(new QFilter[]{delFilter});
        }
        if (!ObjectUtils.isEmpty(newDataDynList)) {
            this.batchSaveEntityData(entityService, newDataDynList);
        }
        LOG.info("ConfigItemDomainServiceImpl.entityDelAndSave,entityNumber={},newDataDynList.size={},cost={}ms", new Object[]{entityNumber, newDataDynList.size(), System.currentTimeMillis() - startTime});
    }

    private void batchSaveEntityData(IBaseEntityService entityService, List<DynamicObject> newDataDynList) {
        int totalPages = (newDataDynList.size() + 200 - 1) / 200;
        LOG.info("newDataDynList.size={},totalPages={}", (Object)newDataDynList.size(), (Object)totalPages);
        for (int i = 0; i < totalPages; ++i) {
            int fromIndex = i * 200;
            int toIndex = Math.min(fromIndex + 200, newDataDynList.size());
            List<DynamicObject> subList = newDataDynList.subList(fromIndex, toIndex);
            entityService.save(subList.toArray(new DynamicObject[0]));
        }
    }

    public Map<String, Object> getControlEntityTableKsql(DBRoute dbRoute, PreInsDataScriptBuilder preInsDataScriptBuilder, String tableName, String filterField, List<Object> filterIdValList) {
        if (ObjectUtils.isEmpty(filterIdValList)) {
            return new HashMap<String, Object>(16);
        }
        List columnNames = DB.getColumnNames((DBRoute)dbRoute, (String)tableName);
        return preInsDataScriptBuilder.genInsertSQLScript(dbRoute, tableName, String.join((CharSequence)",", columnNames), filterField + " in (" + Joiner.on((char)',').join(filterIdValList) + ") ", null, null);
    }

    private void assemblyVerAndEventData(CommonServiceImpl eventServiceHelper, List<RowDataBo> allEventBoList, List<DynamicObject> eventDynList, Set<Long> bussEventIdSet, List<Long> versionEventIdList, String ventIdField) {
        if (!ObjectUtils.isEmpty(allEventBoList)) {
            for (RowDataBo rowDataBo : allEventBoList) {
                List<FieldBo> fieldBoList = rowDataBo.getFieldBoList();
                FieldBo eventFieldBo = fieldBoList.stream().filter(fieldBo -> ventIdField.equals(fieldBo.getFieldName())).findAny().get();
                Object relF7IdVal = eventFieldBo.getFieldValue();
                if (!bussEventIdSet.contains(this.idToLong(relF7IdVal))) continue;
                EntityBo entityBo = new EntityBo();
                DynamicObject verEventDyn = eventServiceHelper.generateEmptyDynamicObject();
                entityBo.boToDynamicObject(verEventDyn, rowDataBo);
                eventDynList.add(verEventDyn);
                versionEventIdList.add(verEventDyn.getLong("id"));
            }
        }
    }

    private void delHisModData(String entityNumber, List<Long> boIdList) {
        HisBaseBo hisBaseBo = new HisBaseBo();
        hisBaseBo.setEntityNumber(entityNumber);
        hisBaseBo.setBoIdList(boIdList);
        HisDeleteService.getInstance().deleteBoEventData(hisBaseBo);
    }

    private void writeBakEntityDataIntoFile(String entityNumber, List<Object> idList) {
        String bakDataSqlFileName = this.getBakDataSqlFileName(entityNumber);
        boolean isEmptyFile = true;
        if (!CollectionUtils.isEmpty(idList)) {
            int ksqlBatchSize = 100;
            int totalPages = (idList.size() + ksqlBatchSize - 1) / ksqlBatchSize;
            LOG.info("batchSaveEntitySynLogData,newDataDynList.size={},totalPages={}", (Object)idList.size(), (Object)totalPages);
            String entityAnnotationSql = "-- " + entityNumber + "\r\n";
            for (int i = 0; i < totalPages; ++i) {
                int fromIndex = i * ksqlBatchSize;
                int toIndex = Math.min(fromIndex + ksqlBatchSize, idList.size());
                List<Object> subList = idList.subList(fromIndex, toIndex);
                String batchIdStrJoin = Joiner.on((char)',').join(subList);
                String ksql = this.metaDatePresetDataDomainService.getPresetDataString(entityNumber, Q_FILTER_STRING + batchIdStrJoin + ')');
                if (StringUtils.isEmpty((String)ksql)) continue;
                isEmptyFile = false;
                if (i == 0) {
                    ksql = entityAnnotationSql + ksql;
                }
                ksql = ksql + "\r\n";
                FileUtils.writeStr2File(null, (String)bakDataSqlFileName, (String)ksql);
            }
        }
        if (!isEmptyFile) {
            this.handleBakDataFile(this.synConfItemEntityNum, entityNumber, bakDataSqlFileName);
        }
    }

    private String getBakDataSqlFileName(String entityNumber) {
        String dataFormat = DateTimeUtils.format((Date)this.nowDate, (String)"yyyyMMddHHmmSSS");
        return entityNumber + "_" + dataFormat + ".sql";
    }

    private Long idToLong(Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).longValue();
        }
        if (obj instanceof String) {
            return Long.parseLong(obj.toString());
        }
        return (Long)obj;
    }

    @Override
    public DynamicObjectCollection getChildrenDynamicObject(Object[] ids, BasedataEntityType entityType) {
        ORM orm = ORM.create();
        String number = entityType.getNumberProperty();
        if (entityType.getProperty("longnumber") == null) {
            return null;
        }
        String entityName = entityType.getName();
        String selectFields = "id,longnumber,parent.longnumber," + number + ",enable";
        String orderBy = "longnumber desc";
        int dbType = entityType.getPrimaryKey().getDbType();
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = DbTypeConverter.safeConvert((int)dbType, (Object)ids[i]);
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)ids)};
        DynamicObjectCollection collection = orm.query(entityName, selectFields, filters, orderBy);
        ArrayList<String> list = new ArrayList<String>(10);
        for (DynamicObject dynamicObject : collection) {
            if (dynamicObject.getString("longnumber") == null || "".equals(dynamicObject.getString("longnumber").trim())) continue;
            list.add(dynamicObject.getString("longnumber"));
        }
        selectFields = "id,longnumber,parent.longnumber," + number + ",enable";
        ParentBasedataProp parentProp = null;
        DataEntityPropertyCollection props = entityType.getProperties();
        for (IDataEntityProperty prop : props) {
            if (!(prop.getParent() instanceof MainEntityType) || !(prop instanceof ParentBasedataProp)) continue;
            parentProp = (ParentBasedataProp)prop;
            break;
        }
        String longNumberDLM = ".";
        if (parentProp != null) {
            longNumberDLM = parentProp.getLongNumberDLM();
        }
        QFilter baseQfilter = new QFilter("id", "in", (Object)ids);
        if (ids.length > 1000) {
            return collection;
        }
        for (int i = 0; i < list.size(); ++i) {
            baseQfilter.or(new QFilter("longnumber", "like", (Object)((String)list.get(i) + longNumberDLM + "%")));
        }
        return list.isEmpty() ? collection : orm.query(entityName, selectFields, new QFilter[]{baseQfilter}, orderBy);
    }

    @Override
    public JSONObject delSysConfigTrees(List<Long> idList) {
        JSONObject result = new JSONObject();
        try {
            LOG.info("delSysConfigTrees,idList={}", idList);
            result = (JSONObject)HRMServiceHelper.invokeBizService((String)"imsc", (String)"ricc", (String)"configItemService", (String)"delConfigTrees", (Object[])new Object[]{idList});
            LOG.info("delSysConfigTrees,result={}", (Object)SerializationUtils.toJsonString((Object)result));
            if (!HRStringUtils.equals((String)result.getString("success"), (String)"true")) {
                return result;
            }
        }
        catch (Exception e) {
            LOG.error("delSysConfigTrees error:", (Throwable)e);
            result.put("msg", (Object)e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FormShowParameter getDelConfGroupFormShowParameter(Map<Long, Object> delDataMap, OperationResult curOperationResult, String operateName, Map<Long, Object> syncDelSysGroupFailMap) {
        void var10_17;
        List successPkIds = curOperationResult.getSuccessPkIds();
        int totalBillCount = curOperationResult.getBillCount();
        HashMap<Long, OperateErrorInfo> curResultFailMap = new HashMap<Long, OperateErrorInfo>(16);
        if (curOperationResult.getValidateResult() != null && curOperationResult.getValidateResult().getValidateErrors() != null) {
            for (ValidateResult res : curOperationResult.getValidateResult().getValidateErrors()) {
                List list = res.getAllErrorInfo();
                if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                for (OperateErrorInfo info : list) {
                    curResultFailMap.put(Long.parseLong(info.getPkValue().toString()), info);
                }
            }
        }
        for (Map.Entry<Long, Object> sysGroupFailEntry : syncDelSysGroupFailMap.entrySet()) {
            Map map = (Map)sysGroupFailEntry.getValue();
            String errorCode = (String)map.get("errorCode");
            if ("notExistRecords".equals(errorCode)) continue;
            ++totalBillCount;
        }
        StringBuilder failMsgSb = new StringBuilder();
        for (Map.Entry entry : delDataMap.entrySet()) {
            Long pkId = (Long)entry.getKey();
            Object sysDelSysGroupObj = syncDelSysGroupFailMap.get(pkId);
            OperateErrorInfo curOperateErrorInfo = (OperateErrorInfo)curResultFailMap.get(pkId);
            if (sysDelSysGroupObj != null && curOperateErrorInfo == null) {
                Map sysSyncFailMsgMap = (Map)sysDelSysGroupObj;
                String errorCode = (String)sysSyncFailMsgMap.get("errorCode");
                if ("notExistRecords".equals(errorCode)) continue;
                String sysSyncErrorMsg = (String)sysSyncFailMsgMap.get("errorMsg");
                failMsgSb.append(sysSyncErrorMsg).append("\r\n");
                continue;
            }
            if (curOperateErrorInfo == null) continue;
            String curOpErrMsg = curOperateErrorInfo.getMessage();
            failMsgSb.append(curOpErrMsg).append("\r\n");
        }
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("operateName", (Object)operateName);
        parameters.setCustomParam("errorMsg", (Object)failMsgSb);
        int successCount = successPkIds.size();
        int validError = totalBillCount - successCount;
        if (validError > 0) {
            String string = String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u5206\u7ec4\uff0c%2$s\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761", (String)"ConfigItemDomainServiceImpl_4", (String)"hdtc-hrcc-business", (Object[])new Object[0]), totalBillCount, StringUtils.isBlank((CharSequence)operateName) ? "" : operateName, successCount, validError);
        } else {
            String string = String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u5206\u7ec4\uff0c%2$s\u6210\u529f%3$s\u6761", (String)"ConfigItemDomainServiceImpl_5", (String)"hdtc-hrcc-business", (Object[])new Object[0]), totalBillCount, StringUtils.isBlank((CharSequence)operateName) ? "" : operateName, successCount);
        }
        parameters.setCustomParam("title", (Object)var10_17);
        return parameters;
    }

    @Override
    public int queryExtendConfigNumber() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter groupEnableFilter = new QFilter("group.enable", "=", (Object)"1");
        QFilter sysPresetsFilter = new QFilter("issyspreset", "=", (Object)Character.valueOf('0'));
        DynamicObject[] configItemDynArr = this.configItemEntityService.query("id,number", new QFilter[]{enableFilter, sysPresetsFilter, groupEnableFilter});
        return configItemDynArr.length;
    }

    @Override
    public int queryPresetConfigNumber() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter groupEnableFilter = new QFilter("group.enable", "=", (Object)"1");
        QFilter sysPresetsFilter = new QFilter("issyspreset", "=", (Object)Character.valueOf('1'));
        DynamicObject[] configItemDynArr = this.configItemEntityService.query("id,number", new QFilter[]{enableFilter, sysPresetsFilter, groupEnableFilter});
        return configItemDynArr.length;
    }

    @Override
    public JSONObject presetRiccConfItemPackScheme(List<PackSchemePresetParamBo> packSchemePresetParamBoList) {
        JSONObject result = new JSONObject();
        if (CollectionUtils.isEmpty(packSchemePresetParamBoList)) {
            return result;
        }
        ArrayList presetMapList = new ArrayList(10);
        for (PackSchemePresetParamBo packSchemePresetParamBo : packSchemePresetParamBoList) {
            HashMap<String, Object> schemeMap = new HashMap<String, Object>(16);
            schemeMap.put("id", packSchemePresetParamBo.getSchemeId());
            schemeMap.put("name", packSchemePresetParamBo.getSchemeName());
            schemeMap.put("number", packSchemePresetParamBo.getSchemeNumber());
            schemeMap.put("enable", "1");
            schemeMap.put(ISPRESET, true);
            schemeMap.put("remarks", packSchemePresetParamBo.getRemarks());
            ArrayList entryList = new ArrayList(10);
            List<PackSchemeEntryParamBo> schemeEntryParamBoList = packSchemePresetParamBo.getSchemeEntryParamBoList();
            for (PackSchemeEntryParamBo packSchemeEntryParamBo : schemeEntryParamBoList) {
                HashMap<String, Object> entryMap = new HashMap<String, Object>(16);
                entryMap.put("entryid", packSchemeEntryParamBo.getSchemeEntryId());
                entryMap.put("parententryid", 0L);
                entryMap.put("itemid", packSchemeEntryParamBo.getSchemeItemId());
                entryMap.put("dataselection", "A");
                FilterCondition filterCondition = new FilterCondition();
                filterCondition.setForList(false);
                ArrayList<FilterValue> value = new ArrayList<FilterValue>(10);
                FilterValue sysPreValue = new FilterValue();
                sysPreValue.setValue((Object)"0");
                value.add(sysPreValue);
                SimpleFilterRow simpleFilterRow = new SimpleFilterRow("(", packSchemeEntryParamBo.getCompareType(), packSchemeEntryParamBo.getFieldName(), ")", LogicOperate.AND.name(), value);
                filterCondition.addFilterRow(simpleFilterRow);
                CRCondition crCondition = new CRCondition();
                String entityNumber = packSchemeEntryParamBo.getItemNumber();
                DataEntityPropertyCollection properties = MetadataUtils.getMainEntityType((String)entityNumber).getProperties();
                IDataEntityProperty isSysPresetProType = (IDataEntityProperty)properties.get((Object)"issyspreset");
                if (Objects.nonNull(isSysPresetProType) && HRStringUtils.isNotEmpty((String)isSysPresetProType.getAlias())) {
                    crCondition.setFilterCondition(filterCondition);
                    crCondition.setExprTran(packSchemeEntryParamBo.getExprTran());
                    entryMap.put("exportfilters", SerializationUtils.toJsonString((Object)crCondition));
                }
                entryList.add(entryMap);
            }
            schemeMap.put("packschemeentry", entryList);
            presetMapList.add(schemeMap);
        }
        try {
            result = (JSONObject)HRMServiceHelper.invokeBizService((String)"imsc", (String)"ricc", (String)"packSchemeService", (String)"savePackScheme", (Object[])new Object[]{presetMapList});
        }
        catch (Exception exception) {
            LOG.error("sync ricc error(getPackSchemePresetMap):", (Throwable)exception);
            if (exception instanceof NullPointerException) {
                result.put("msg", (Object)BizModeMsgEnum.UNKNOWN_ERROR.get());
            } else {
                result.put("msg", (Object)exception.getMessage());
            }
            result.put("success", (Object)"false");
        }
        return result;
    }

    public Set<String> getEntityBlackList() {
        if (this.entityBlackList == null) {
            this.entityBlackList = this.ihrccBaseConfigEntityService.getRelBaseEntityBlackList();
        }
        return this.entityBlackList;
    }

    @Override
    @Deprecated
    public Map<String, List<Object>> getKeyFieldFilterValueMap(List<RowDataBo> entityRowBoList, Set<String> keyFieldSet) {
        return new EntityBo().getKeyFieldFilterValueMap(entityRowBoList, keyFieldSet);
    }
}

