/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.task;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.serviceImpl.ScheduleManagerImpl;
import kd.hdtc.hrcc.business.common.ServiceFactory;
import kd.hdtc.hrcc.business.common.model.confitem.params.PackSchemeEntryParamBo;
import kd.hdtc.hrcc.business.common.model.confitem.params.PackSchemePresetParamBo;
import kd.hdtc.hrcc.business.common.model.confitem.params.PresetConfItemParamBo;
import kd.hdtc.hrcc.business.common.model.confitem.params.PresetConfTreeParamBo;
import kd.hdtc.hrcc.business.domain.common.entity.impl.CommonServiceImpl;
import kd.hdtc.hrcc.business.domain.transfer.configitem.IConfigItemDomainService;
import kd.hdtc.hrcc.business.domain.transfer.configitem.impl.ConfigItemDomainServiceImpl;
import kd.hdtc.hrcc.business.domain.transfer.entity.IConfigGroupEntityService;
import kd.hdtc.hrcc.business.domain.transfer.entity.IConfigItemEntityService;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class ConfItemPresetDataSyncTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(ConfigItemDomainServiceImpl.class);
    private IConfigItemDomainService configItemDomainService = ServiceFactory.createInstance(IConfigItemDomainService.class);
    private IConfigItemEntityService configItemEntityService = ServiceFactory.getService(IConfigItemEntityService.class);
    private IConfigGroupEntityService configGroupEntityService = ServiceFactory.getService(IConfigGroupEntityService.class);
    private static final String SUCCESS = "success";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOG.info("ConfItemPresetDataSyncTask start,map={},getLang={}", map, (Object)requestContext.getLang());
        LOG.info("ConfItemPresetDataSyncTask,curUserId={},userName={}", (Object)requestContext.getCurrUserId(), (Object)requestContext.getUserName());
        Object isRepeatExecutionObj = map.get("isRepeatExecution");
        boolean isRepeatExecution = Boolean.parseBoolean(isRepeatExecutionObj == null ? "true" : (isRepeatExecutionObj.toString().equals("false") || isRepeatExecutionObj.toString().equals("true") ? isRepeatExecutionObj.toString() : "true"));
        this.offTheSysConfTree();
        this.offTheSysConfItem();
        this.presetTreeAndConfItemData();
        JSONObject configTreeResult = this.configItemDomainService.syncConfigTree(null, true);
        JSONObject configItemResult = this.configItemDomainService.syncConfigItem(null, true);
        this.handleResult(configTreeResult, configItemResult, "ConfItemPresetDataSyncTask end,configTreeResult={},configItemResult={}");
        JSONObject presetRiccConfItemResult = this.configItemDomainService.presetRiccConfItemPackScheme(this.getPackSchemePresetParamBoList());
        if (presetRiccConfItemResult.size() > 0 && !HRStringUtils.equals((String)presetRiccConfItemResult.getString(SUCCESS), (String)"true")) {
            String treeMsg = presetRiccConfItemResult.getString("msg");
            String confItemResultMsg = presetRiccConfItemResult.getString("msg");
            throw new KDBizException(new ErrorCode("presetRiccConfItemPackScheme", treeMsg + "\r\n" + confItemResultMsg + ""), new Object[0]);
        }
        this.handleResult(configTreeResult, configItemResult, "ConfItemPresetDataSyncTask end,configTreeResult={},configItemResult={}");
        this.disableTask(isRepeatExecution);
    }

    private void offTheSysConfTree() {
        CommonServiceImpl commonService = new CommonServiceImpl("ricc_configtree");
        ImmutableList delSysTreeIdList = ImmutableList.of((Object)1830015531491702784L, (Object)1830015532439615488L, (Object)1830015532565443584L, (Object)1830015533387527168L);
        commonService.delete(delSysTreeIdList.toArray(new Long[0]));
    }

    private void offTheSysConfItem() {
        CommonServiceImpl commonService = new CommonServiceImpl("ricc_configitems");
        ImmutableSet delSysConfItemIdSet = ImmutableSet.of((Object)1830499931887113222L, (Object)1909373946516604928L, (Object)1909374936993105920L, (Object)1909375847517786112L, (Object)1909376368207071232L, (Object)1909377161333182464L, (Object[])new Long[]{1909376826854213632L, 1830499931887113224L, 1834274254129110016L, 1830499931887115269L, 1830499931895501824L, 1830499931895503886L, 1830499931895503887L, 1830499931895503872L, 1961673128144808965L, 1961673129688312837L, 1966684414742233088L});
        commonService.delete(delSysConfItemIdSet.toArray(new Long[0]));
    }

    private void disableTask(boolean isRepeatExecution) {
        if (!isRepeatExecution) {
            ScheduleManagerImpl scheduleManager = new ScheduleManagerImpl();
            scheduleManager.disableSchedule("3V2XOO4D5QB9");
        }
    }

    public List<PackSchemePresetParamBo> getPackSchemePresetParamBoList() {
        ArrayList<PackSchemePresetParamBo> packSchemePresetParamBoList = new ArrayList<PackSchemePresetParamBo>(10);
        QFilter filter = new QFilter("group.level", ">=", (Object)2);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        List sysPreConfItemDynList = this.configItemEntityService.queryOriginalList("group.id,group.longnumber,group.level,group.name,group.number,group.parent,confignumber,id,number", new QFilter[]{new QFilter("issyspreset", "=", (Object)"1"), filter}, "group.longnumber");
        if (CollectionUtils.isEmpty((Collection)sysPreConfItemDynList)) {
            return packSchemePresetParamBoList;
        }
        LinkedHashMap confItemDynGroupMap = new LinkedHashMap(16);
        Map<String, String> groupInfoMap = this.getConfigGroupInfo();
        for (DynamicObject dyn : sysPreConfItemDynList) {
            String groupLongNumber = dyn.getString("group.longnumber");
            String[] longNumberArr = groupLongNumber.split("\\.");
            String cloud = longNumberArr[0];
            confItemDynGroupMap.putIfAbsent(cloud, new ArrayList(10));
            ((List)confItemDynGroupMap.get(cloud)).add(dyn);
            String groupKey = longNumberArr[0] + "_" + longNumberArr[1];
            confItemDynGroupMap.putIfAbsent(groupKey, new ArrayList(10));
            ((List)confItemDynGroupMap.get(groupKey)).add(dyn);
        }
        long[] entryIdArr = DB.genLongIds((String)"hrcc_configitems", (int)(sysPreConfItemDynList.size() * 2));
        long[] pkIdArr = DB.genLongIds((String)"hrcc_configitems", (int)confItemDynGroupMap.size());
        String schemeNameSuffix = ResManager.loadKDString((String)"\u6279\u91cf\u6253\u5305\u65b9\u6848", (String)"ConfItemPresetDataSyncTask_0", (String)"hdtc-hrcc-business", (Object[])new Object[0]);
        String exprTran = ResManager.loadKDString((String)"\u662f\u5426\u7cfb\u7edf\u9884\u7f6e \u7b49\u4e8e \u5426", (String)"ConfItemPresetDataSyncTask_1", (String)"hdtc-hrcc-business", (Object[])new Object[0]);
        int i = 0;
        int j = 0;
        for (Map.Entry confItemEntry : confItemDynGroupMap.entrySet()) {
            List confItemDynList = (List)confItemEntry.getValue();
            String cloudAndApp = (String)confItemEntry.getKey();
            PackSchemePresetParamBo packSchemePresetParamBo = new PackSchemePresetParamBo();
            packSchemePresetParamBo.setSchemeId(pkIdArr[i++]);
            packSchemePresetParamBo.setSchemeNumber(cloudAndApp);
            packSchemePresetParamBo.setSchemeName(groupInfoMap.get(cloudAndApp) + schemeNameSuffix);
            List<PackSchemeEntryParamBo> schemeEntryParamBoList = packSchemePresetParamBo.getSchemeEntryParamBoList();
            for (DynamicObject confItemDyn : confItemDynList) {
                PackSchemeEntryParamBo packSchemeEntryParamBo = new PackSchemeEntryParamBo();
                packSchemeEntryParamBo.setSchemeEntryId(entryIdArr[j++]);
                packSchemeEntryParamBo.setSchemeItemId(confItemDyn.getLong("id"));
                packSchemeEntryParamBo.setItemNumber(confItemDyn.getString("number"));
                packSchemeEntryParamBo.setExprTran(exprTran);
                packSchemeEntryParamBo.setCompareType("105");
                packSchemeEntryParamBo.setFieldName("issyspreset");
                schemeEntryParamBoList.add(packSchemeEntryParamBo);
            }
            packSchemePresetParamBoList.add(packSchemePresetParamBo);
        }
        return packSchemePresetParamBoList;
    }

    private Map<String, String> getConfigGroupInfo() {
        DynamicObject[] groups = this.configGroupEntityService.query("number,name,parent", new QFilter[]{QFilterConstants.Q_ENABLE, QFilterConstants.Q_PRESET});
        HashMap<String, String> groupInfoMap = new HashMap<String, String>(16);
        for (DynamicObject group : groups) {
            DynamicObject parent = group.getDynamicObject("parent");
            String groupKey = group.getString("number");
            if (parent != null) {
                groupKey = parent.getString("number") + "_" + groupKey;
            }
            groupInfoMap.put(groupKey, group.getString("name"));
        }
        return groupInfoMap;
    }

    public void presetTreeAndConfItemData() {
        ArrayList<PresetConfTreeParamBo> presetConfTreeParamBoList = new ArrayList<PresetConfTreeParamBo>(10);
        presetConfTreeParamBoList.add(new PresetConfTreeParamBo(1830015537464390656L, ResManager.loadKDString((String)"HR\u4ea4\u4ed8\u5de5\u5177\u4e91", (String)"ConfItemPresetDataSyncTask_2", (String)"hdtc-hrcc-business", (Object[])new Object[0]), "HDTC", "99", 0L));
        presetConfTreeParamBoList.add(new PresetConfTreeParamBo(1866074162905400320L, ResManager.loadKDString((String)"HR\u914d\u7f6e\u4e2d\u5fc3", (String)"ConfItemPresetDataSyncTask_3", (String)"hdtc-hrcc-business", (Object[])new Object[0]), "hrcc", "99.01", 1830015537464390656L));
        ArrayList<PresetConfItemParamBo> presetConfItemParamBoList = new ArrayList<PresetConfItemParamBo>(10);
        presetConfItemParamBoList.add(new PresetConfItemParamBo(1863124934734127104L, ResManager.loadKDString((String)"\u57fa\u7840\u914d\u7f6e\u9879\u5de6\u6811", (String)"ConfItemPresetDataSyncTask_4", (String)"hdtc-hrcc-business", (Object[])new Object[0]), "hrcc_configtree", "99.01.001", "number", 1866074162905400320L, "hrcc"));
        presetConfItemParamBoList.add(new PresetConfItemParamBo(1863126238726475776L, ResManager.loadKDString((String)"\u57fa\u7840\u914d\u7f6e\u9879", (String)"ConfItemPresetDataSyncTask_5", (String)"hdtc-hrcc-business", (Object[])new Object[0]), "hrcc_configitems", "99.01.002", "confignumber", 1866074162905400320L, "hrcc"));
        presetConfItemParamBoList.add(new PresetConfItemParamBo(1863125442597232640L, ResManager.loadKDString((String)"\u5173\u8054\u5b9e\u4f53\u914d\u7f6e", (String)"ConfItemPresetDataSyncTask_6", (String)"hdtc-hrcc-business", (Object[])new Object[0]), "hrcc_relentityconf", "99.01.003", "id", 1866074162905400320L, "hrcc"));
        JSONObject syncPresetConfigTreeResult = this.configItemDomainService.syncPresetConfigTree(presetConfTreeParamBoList);
        JSONObject syncPresetConfigItemResult = this.configItemDomainService.syncPresetConfigItem(presetConfItemParamBoList);
        this.handleResult(syncPresetConfigTreeResult, syncPresetConfigItemResult, "syncPresetConfigTreeResult={},syncPresetConfigItemResult={}");
    }

    private void handleResult(JSONObject syncPresetConfigTreeResult, JSONObject syncPresetConfigItemResult, String logInfo) {
        if (syncPresetConfigTreeResult.size() == 0 || syncPresetConfigItemResult.size() == 0) {
            LOG.info("ConfItemPresetDataSyncTask.handleResult,all data sync finish!");
            return;
        }
        LOG.info(logInfo, (Object)syncPresetConfigTreeResult.toJSONString(), (Object)syncPresetConfigItemResult.toJSONString());
        if (!HRStringUtils.equals((String)syncPresetConfigTreeResult.getString(SUCCESS), (String)"true") || !HRStringUtils.equals((String)syncPresetConfigItemResult.getString(SUCCESS), (String)"true")) {
            String treeMsg = syncPresetConfigTreeResult.getString("msg");
            String confItemResultMsg = syncPresetConfigItemResult.getString("msg");
            throw new KDBizException(new ErrorCode("ConfItemPresetDataSyncTaskSyncFail", treeMsg + "\r\n" + confItemResultMsg + ""), new Object[0]);
        }
    }
}

