/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.task.execute;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hdtc.hrcc.business.common.ServiceFactory;
import kd.hdtc.hrcc.business.domain.fileimport.IFileImportTaskDomainService;
import kd.hdtc.hrcc.business.domain.fileimport.entity.IFileImportSubTaskEntityService;
import kd.hdtc.hrcc.business.domain.fileimport.entity.IFileImportTaskEntityService;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportConfigBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportSubTaskResultBean;
import kd.hdtc.hrcc.common.enums.FileImportSubTaskDealStatusEnum;
import kd.hdtc.hrcc.common.enums.FileImportTaskDealStatusEnum;
import kd.hdtc.hrdbs.common.exception.HDTCBizException;
import kd.hdtc.hrdbs.common.factory.ExecutorFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.DateTimeUtils;
import kd.hdtc.hrdbs.common.util.HDTCArrayUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public abstract class FileImportTaskAbstractTask
extends AbstractTask {
    private static Log LOG = LogFactory.getLog(FileImportTaskAbstractTask.class);
    protected static final String D_LOCK_PREFIX = "FileImportTaskExecuteServiceImpl_DLOCK";
    protected IFileImportTaskDomainService fileImportTaskDomainService = ServiceFactory.getService(IFileImportTaskDomainService.class);
    protected IFileImportSubTaskEntityService fileImportSubTaskEntityService = ServiceFactory.getService(IFileImportSubTaskEntityService.class);
    protected IFileImportTaskEntityService fileImportTaskEntityService = ServiceFactory.getService(IFileImportTaskEntityService.class);

    protected Future<List<FileImportSubTaskResultBean>> executeTask(List<DynamicObject> subTaskDynList, FileImportConfigBo fileImportConfigBo) {
        if (CollectionUtils.isEmpty(subTaskDynList)) {
            return null;
        }
        Queue<DynamicObject> taskQueue = this.toBlockQueueFromList(subTaskDynList);
        ExecutorService executorService = ExecutorFactory.getCommonExecutor();
        return executorService.submit(new FileImportSubTask(taskQueue, fileImportConfigBo));
    }

    private void setSubTaskResult(DynamicObject taskDyn, boolean success, String msg, FileImportSubTaskResultBean fileImportSubTaskResultBean) {
        taskDyn.set("dealstatus", (Object)(success ? FileImportSubTaskDealStatusEnum.SUCCESS.getStatus() : FileImportTaskDealStatusEnum.FAIL.getStatus()));
        if (StringUtils.isNotEmpty((String)msg)) {
            fileImportSubTaskResultBean.fail(msg);
            taskDyn.set("msg", (Object)msg);
        }
    }

    abstract FileImportSubTaskResultBean executeBizSubTask(DynamicObject var1, FileImportConfigBo var2);

    protected void afterHandleTask(Long taskId, Future<List<FileImportSubTaskResultBean>> future) throws Exception {
        if (future == null) {
            return;
        }
        List<FileImportSubTaskResultBean> resultBeanList = future.get();
        boolean temResult = true;
        StringBuilder failSb = new StringBuilder();
        for (FileImportSubTaskResultBean fileImportSubTaskResultBean : resultBeanList) {
            if (temResult) {
                temResult = fileImportSubTaskResultBean.getSuccess();
            }
            if (!StringUtils.isNotEmpty((String)fileImportSubTaskResultBean.getMsg())) continue;
            failSb.append(fileImportSubTaskResultBean.getMsg()).append("\r\n");
        }
        DynamicObject[] taskDynArr = this.fileImportTaskEntityService.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "=", (Object)taskId)});
        if (taskDynArr == null) {
            return;
        }
        taskDynArr[0].set("taskstatus", (Object)(temResult ? FileImportTaskDealStatusEnum.COMPLETE.getStatus() : FileImportTaskDealStatusEnum.FAIL.getStatus()));
        this.fileImportTaskEntityService.save(taskDynArr);
        if (StringUtils.isNotEmpty((String)failSb.toString())) {
            throw new HDTCBizException(failSb.toString());
        }
    }

    public List<DynamicObject> getCanExecute(DynamicObject[] subTaskDynArr, String dealStatus) {
        if (HDTCArrayUtils.isEmpty((Object[])subTaskDynArr)) {
            return new ArrayList<DynamicObject>();
        }
        return Arrays.stream(subTaskDynArr).filter(subDyn -> StringUtils.equals((String)subDyn.getString("dealstatus"), (String)dealStatus)).collect(Collectors.toList());
    }

    private Queue<DynamicObject> toBlockQueueFromList(List<DynamicObject> subTaskDynList) {
        LinkedBlockingDeque<DynamicObject> dataQueue = new LinkedBlockingDeque<DynamicObject>();
        subTaskDynList.forEach(dataQueue::offer);
        return dataQueue;
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }

    public class FileImportSubTask
    implements Callable<List<FileImportSubTaskResultBean>> {
        private final Queue<DynamicObject> taskQueue;
        private final FileImportConfigBo fileImportConfigBo;

        public FileImportSubTask(Queue<DynamicObject> taskQueue, FileImportConfigBo fileImportConfigBo) {
            this.taskQueue = taskQueue;
            this.fileImportConfigBo = fileImportConfigBo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<FileImportSubTaskResultBean> call() {
            ArrayList resultBeanList = Lists.newArrayListWithExpectedSize((int)this.taskQueue.size());
            while (!this.taskQueue.isEmpty()) {
                DynamicObject taskDyn = this.taskQueue.poll();
                FileImportSubTaskResultBean fileImportSubTaskResultBean = null;
                try (DLock dLock = null;){
                    long taskId = taskDyn.getLong("id");
                    dLock = DLock.createReentrant((String)(FileImportTaskAbstractTask.D_LOCK_PREFIX + taskId));
                    fileImportSubTaskResultBean = FileImportTaskAbstractTask.this.executeBizSubTask(taskDyn, this.fileImportConfigBo);
                    FileImportTaskAbstractTask.this.setSubTaskResult(taskDyn, fileImportSubTaskResultBean.getSuccess(), fileImportSubTaskResultBean.getMsg(), fileImportSubTaskResultBean);
                    taskDyn.set("executetime", (Object)DateTimeUtils.getNowDateTime());
                }
                FileImportTaskAbstractTask.this.fileImportSubTaskEntityService.save(taskDyn);
                resultBeanList.add(fileImportSubTaskResultBean);
            }
            return resultBeanList;
        }
    }
}

