/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.task.execute;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrcc.business.common.ServiceFactory;
import kd.hdtc.hrcc.business.domain.fileimport.IFileImportConfigDomainService;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportConfigBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportSubTaskResultBean;
import kd.hdtc.hrcc.business.domain.fileimport.service.IFileImportExecuteSubTaskEndSingleService;
import kd.hdtc.hrcc.business.domain.fileimport.utils.FileImportUtils;
import kd.hdtc.hrcc.business.task.execute.FileImportTaskAbstractTask;
import kd.hdtc.hrcc.common.MsgEnum.FileImportMsgEnum;
import kd.hdtc.hrcc.common.enums.FileImportTaskDealStatusEnum;
import kd.hdtc.hrdbs.common.exception.HDTCBizException;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.ThrowableUtils;

public class FileImportTaskExecuteServiceImpl
extends FileImportTaskAbstractTask {
    private static Log LOG = LogFactory.getLog(FileImportTaskExecuteServiceImpl.class);
    private final IFileImportConfigDomainService fileImportConfigDomainService = ServiceFactory.getService(IFileImportConfigDomainService.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long startTime = System.currentTimeMillis();
        Long taskId = ConvertUtils.toLong((Object)map.get("biz_task_id"));
        LOG.info("FileImportTaskExecuteServiceImpl execute start taskId:{}", (Object)taskId);
        DynamicObject[] subTaskArr = this.fileImportTaskDomainService.getSubTasksByTaskId(taskId);
        try {
            List<DynamicObject> canExecuteDynList = this.getCanExecute(subTaskArr, FileImportTaskDealStatusEnum.UN_EXECUTE.getStatus());
            Long confId = canExecuteDynList.stream().map(dyn -> dyn.getLong("scene.config.id")).findFirst().get();
            Future<List<FileImportSubTaskResultBean>> future = this.executeTask(canExecuteDynList, this.fileImportConfigDomainService.getConfigBoById(confId));
            this.afterHandleTask(taskId, future);
        }
        catch (Exception exception) {
            LOG.error("executeTask is exception.", (Throwable)exception);
            throw new HDTCBizException(ThrowableUtils.toString((Throwable)exception));
        }
        finally {
            this.deleteAllFileBySubTask(subTaskArr);
        }
        LOG.info("FileImportTaskExecuteServiceImpl end ,cost={}ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private void deleteAllFileBySubTask(DynamicObject[] subTaskArr) {
        if (subTaskArr == null) {
            return;
        }
        try {
            for (DynamicObject subTaskDyn : subTaskArr) {
                FileImportUtils.deleteLocalDirFile(subTaskDyn.getString("scene.config.number"), subTaskDyn.getString("zipname"));
            }
        }
        catch (Exception exception) {
            LOG.error("FileImportTaskExecuteServiceImpl.deleteAllFileBySubTask is exception." + exception);
        }
    }

    @Override
    public FileImportSubTaskResultBean executeBizSubTask(DynamicObject bizTaskDyn, FileImportConfigBo fileImportConfigBo) {
        FileImportSubTaskResultBean fileImportSubTaskResultBean = this.fileImportTaskDomainService.executeSubTask(bizTaskDyn, fileImportConfigBo);
        this.executeEndService(bizTaskDyn, fileImportSubTaskResultBean);
        return fileImportSubTaskResultBean;
    }

    private void executeEndService(DynamicObject bizTaskDyn, FileImportSubTaskResultBean fileImportSubTaskResultBean) {
        String singlePlugin = bizTaskDyn.getString("singleplugin");
        if (StringUtils.isEmpty((String)singlePlugin)) {
            return;
        }
        this.executeServicePlugin(singlePlugin, bizTaskDyn, fileImportSubTaskResultBean);
    }

    private void executeServicePlugin(String plugin, DynamicObject bizTaskDyn, FileImportSubTaskResultBean fileImportSubTaskResultBean) {
        if (StringUtils.isEmpty((String)plugin)) {
            return;
        }
        Class<?> pluginClass = this.getClassByFullPath(plugin);
        Class<IFileImportExecuteSubTaskEndSingleService> serviceInterface = IFileImportExecuteSubTaskEndSingleService.class;
        if (pluginClass == null || !serviceInterface.isAssignableFrom(pluginClass)) {
            return;
        }
        try {
            Object instance = pluginClass.newInstance();
            pluginClass.getMethod("executeEndTask", DynamicObject.class, FileImportSubTaskResultBean.class).invoke(instance, bizTaskDyn, fileImportSubTaskResultBean);
        }
        catch (Exception e) {
            LOG.error("executeServicePlugin error plugin:{}", (Object)plugin);
            LOG.error("executeServicePlugin error", (Throwable)e);
            fileImportSubTaskResultBean.fail(FileImportMsgEnum.NO_SUCH_METHOD_EXCEPTION.get());
            throw new HDTCBizException(ThrowableUtils.toString((Throwable)e));
        }
    }

    private Class<?> getClassByFullPath(String plugin) {
        try {
            return TypesContainer.getOrRegister((String)plugin);
        }
        catch (Exception e) {
            LOG.error("getClassByFullPath error,plugin:{}", (Object)plugin);
            LOG.error("getClassByFullPath error,", (Throwable)e);
            return null;
        }
    }
}

