/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.exception.HDTCBizException;
import kd.hdtc.hrdbs.common.util.BosHttpClientUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class BosApiUtil {
    private static final Log logger = LogFactory.getLog(BosApiUtil.class);
    private static final String APP_ID = "appId";
    private static final String APP_TOKEN = "app_token";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String TOKEN_DATA_KEY = "data";
    private static final String APP_SECURE_KEY = "appsecuret";
    private static final String ACCOUNT_ID = "accountId";
    private static final String TARGET_DATA_CENTER_USER = "targetdatacenteruser";
    private static final String ENV_URL = "evnurl";

    public static String doLoginByMobilePhone(Map<String, Object> loginParam) {
        String phoneNumber = (String)loginParam.get(TARGET_DATA_CENTER_USER);
        String number = (String)loginParam.get(ACCOUNT_ID);
        String evnUrl = (String)loginParam.get(ENV_URL);
        String appSecure = (String)loginParam.get(APP_SECURE_KEY);
        String appId = (String)loginParam.get(APP_ID);
        Map<String, Object> mapAppToken = BosApiUtil.getAppToken(appId, number, evnUrl, appSecure);
        String appToken = (String)((Map)mapAppToken.get(TOKEN_DATA_KEY)).get(APP_TOKEN);
        Map<String, Object> mapUserToken = BosApiUtil.getAccessToken(phoneNumber, number, evnUrl, appToken);
        return (String)((Map)mapUserToken.get(TOKEN_DATA_KEY)).get(ACCESS_TOKEN);
    }

    public static Map<String, Object> getAppToken(String appId, String accountId, String evnUrl, String appSecure) {
        String url = evnUrl + "/api/getAppToken.do";
        HashMap<String, String> param = new HashMap<String, String>(5);
        param.put(APP_ID, appId);
        param.put("appSecuret", appSecure);
        param.put(ACCOUNT_ID, accountId);
        param.put("language", "zh_CN");
        String data = JSON.toJSONString(param);
        String response = BosHttpClientUtils.doPostByHttpClient(url, data);
        Map mapAppToken = (Map)JSON.parseObject((String)response, Map.class);
        if (!StringUtils.equals((String)((String)mapAppToken.get("state")), (String)"success")) {
            logger.info("\u83b7\u53d6app_token\u5931\u8d25\uff01{},{}", (Object)url, (Object)data);
            throw new HDTCBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u83b7\u53d6appToken\u5931\u8d25\uff1a%s\u3002", (String)"ApiUtil_0", (String)"hdtc-hrdbs-common", (Object[])new Object[0]), mapAppToken.get("errorMsg")));
        }
        return mapAppToken;
    }

    public static Map<String, Object> getAccessToken(String phoneNumber, String number, String evnUrl, String appToken) {
        String url = evnUrl + "/api/login.do";
        HashMap<String, String> param = new HashMap<String, String>(5);
        param.put("user", phoneNumber);
        param.put("apptoken", appToken);
        param.put(ACCOUNT_ID, number);
        param.put("usertype", "Mobile");
        String data = JSON.toJSONString(param);
        String response = BosHttpClientUtils.doPostByHttpClient(url, data);
        Map mapUserToken = (Map)JSON.parseObject((String)response, Map.class);
        if (!StringUtils.equals((String)((String)mapUserToken.get("state")), (String)"success")) {
            logger.info("get access_token error url:{} ,data:{} ", (Object)url, (Object)data);
            throw new HDTCBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u83b7\u53d6accessToken\u5931\u8d25\uff1a%s\u3002", (String)"ApiUtil_1", (String)"hdtc-hrdbs-common", (Object[])new Object[0]), mapUserToken.get("errorMsg")));
        }
        return mapUserToken;
    }

    public static List<JSONObject> getDestDataCenterList(String evnUrl) {
        List retList = null;
        String url = evnUrl + "/auth/getAllDatacenters.do";
        String response = BosHttpClientUtils.doGetByHttpClient(url);
        try {
            retList = (List)JSON.parseObject((String)response, List.class);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u8d26\u5957\u5931\u8d25,\u8bf7\u68c0\u67e5\u5f55\u5165\u7684\u73af\u5883\u5730\u5740\u662f\u5426\u6b63\u786e\u6216\u73af\u5883{}\u662f\u5426\u670d\u52a1\u5f02\u5e38{}\u3002", (Object)url, (Object)e);
            throw new HDTCBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u83b7\u53d6\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u8d26\u5957\u5931\u8d25\u3002\u8bf7\u68c0\u67e5\u5f55\u5165\u7684\u73af\u5883\u5730\u5740\u662f\u5426\u6b63\u786e\uff0c\u6216\u73af\u5883\u662f\u5426\u670d\u52a1\u5f02\u5e38\u3002%s", (String)"ApiUtil_4", (String)"hdtc-hrdbs-common", (Object[])new Object[0]), BosHttpClientUtils.getEvnUrlMessage()));
        }
        for (JSONObject ret : retList) {
            String accountId = ret.getString(ACCOUNT_ID);
            if (!StringUtils.isBlank((CharSequence)accountId)) continue;
            logger.error("\u672a\u68c0\u6d4b\u5230\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5f55\u5165\u7684\u73af\u5883\u5730\u5740\u662f\u5426\u6b63\u786e\u6216\u73af\u5883{}\u662f\u5426\u670d\u52a1\u5f02\u5e38\u3002", (Object)url);
            throw new HDTCBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u672a\u68c0\u6d4b\u5230\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5f55\u5165\u7684\u73af\u5883\u5730\u5740\u662f\u5426\u6b63\u786e\u6216\u73af\u5883\u662f\u5426\u670d\u52a1\u5f02\u5e38\u3002%s", (String)"ApiUtil_5", (String)"hdtc-hrdbs-common", (Object[])new Object[0]), BosHttpClientUtils.getEvnUrlMessage()));
        }
        return retList;
    }
}

