/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;

public final class ConvertUtils {
    private static final String[] FALSE_ARR = new String[]{"false", "0", "no", "off", "n", "f", "undefined", "disable"};
    private static final String[] TRUE_ARR = new String[]{"true", "1", "yes", "on", "y", "t", "ok", "success", "enable"};

    public static <T> T convert(Object obj) {
        return (T)obj;
    }

    public static long toLong(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        return ConvertUtils.toLong(value.toString().trim());
    }

    private static long toLong(String str) {
        if (str.length() == 0) {
            return 0L;
        }
        return Long.parseLong(str);
    }

    public static int toInt(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        return ConvertUtils.toInt(value.toString().trim());
    }

    private static int toInt(String str) {
        if (str.length() == 0) {
            return 0;
        }
        return Integer.parseInt(str);
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).toPlainString();
        }
        String str = obj.toString();
        if (str == null) {
            return null;
        }
        return (str = str.trim()).length() == 0 ? null : str;
    }

    public static boolean toBoolean(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue() != 0;
        }
        String str = obj.toString().trim();
        if (str.length() == 0) {
            return false;
        }
        if (ConvertUtils.checkStrExistIgnoreCase(FALSE_ARR, str)) {
            return false;
        }
        if (ConvertUtils.checkStrExistIgnoreCase(TRUE_ARR, str)) {
            return true;
        }
        throw new KDBizException("invalid boolean string '" + str + "'.");
    }

    private static boolean checkStrExistIgnoreCase(String[] checkArr, String tar) {
        return Stream.of(checkArr).filter(it -> it.equalsIgnoreCase(tar)).findAny().isPresent();
    }

    public static Map<String, Object> toMap(DynamicObject dy) {
        return dy.getDataEntityType().getProperties().stream().map(prop -> prop.getName()).filter(key -> Objects.nonNull(dy.get(key))).collect(Collectors.toMap(key -> key, key -> dy.get(key)));
    }

    public static <E> List<E> toList(E[] array) {
        ArrayList transferList = new ArrayList();
        Arrays.stream(array).forEach(arr -> transferList.add(arr));
        return transferList;
    }

    public static <E> E[] toArray(List<E> list) {
        return list.stream().toArray();
    }
}

