/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.common.util;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public final class DateTimeUtils
extends HRDateTimeUtils {
    private static final Log LOG = LogFactory.getLog(DateTimeUtils.class);
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String MIN_DATE_TIME_STR = "1970-01-01";
    public static final String MAX_DATE_TIME_STR = "2199-12-31";
    public static Date MIN_DATE_TIME;
    public static Date MAX_DATE_TIME;

    public static Date parseDateByTimeStamp(Long timeStamp, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeStamp);
        if (timeZone != null) {
            calendar.setTimeZone(timeZone);
        } else {
            calendar.setTimeZone(KDDateUtils.getSysTimeZone());
        }
        return calendar.getTime();
    }

    static {
        try {
            MIN_DATE_TIME = DateTimeUtils.parseDate((String)MIN_DATE_TIME_STR, (String)YYYY_MM_DD);
            MAX_DATE_TIME = DateTimeUtils.parseDate((String)MAX_DATE_TIME_STR, (String)YYYY_MM_DD);
        }
        catch (ParseException e) {
            LOG.error("data time parse error", (Throwable)e);
        }
    }
}

