/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.LargeTextField;
import kd.bos.metadata.entity.commonfield.MulComboField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.RadioGroupField;
import kd.bos.metadata.entity.commonfield.TextAreaField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.entity.commonfield.TimeField;
import kd.hdtc.hrdbs.common.util.DateTimeUtils;
import kd.hdtc.hrdbs.common.util.ObjectUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.business.log.EntityModifyInfo;
import kd.hr.hbp.business.log.FieldModifyInfo;

public class DynamicObjectCompareUtils {
    public static EntityModifyInfo getEntityModifyInfo(DynamicObject newBizObj, DynamicObject oldBizObj, List<String> fieldNumberList) {
        List<EntityItem<?>> allEntityItems = MetadataUtils.getAllEntityItems(newBizObj.getDataEntityType().getName());
        EntityModifyInfo entityModifyInfo = new EntityModifyInfo();
        allEntityItems.forEach(entityItem -> {
            FieldModifyInfo fieldModifyInfo = null;
            String fieldName = entityItem.getKey();
            if (fieldNumberList.contains(entityItem.getKey())) {
                fieldModifyInfo = DynamicObjectCompareUtils.fieldCompare(entityItem, oldBizObj, newBizObj);
            }
            if (fieldModifyInfo != null) {
                entityModifyInfo.addField(fieldName, fieldModifyInfo);
            }
        });
        return entityModifyInfo;
    }

    public static FieldModifyInfo fieldCompare(EntityItem entityItem, DynamicObject oldBizObj, DynamicObject newBizObj) {
        FieldModifyInfo fieldModifyInfo = null;
        if (entityItem instanceof BigIntField) {
            fieldModifyInfo = DynamicObjectCompareUtils.simpleDataCompare(newBizObj, oldBizObj, entityItem);
        } else if (entityItem instanceof IntegerField) {
            fieldModifyInfo = DynamicObjectCompareUtils.simpleDataCompare(newBizObj, oldBizObj, entityItem);
        } else if (entityItem instanceof DecimalField) {
            fieldModifyInfo = DynamicObjectCompareUtils.simpleDataCompare(newBizObj, oldBizObj, entityItem);
        } else if (entityItem instanceof LargeTextField) {
            fieldModifyInfo = DynamicObjectCompareUtils.bigTextDataCompare(newBizObj, oldBizObj, entityItem);
        } else if (entityItem instanceof DateField) {
            fieldModifyInfo = DynamicObjectCompareUtils.dateDataCompare(newBizObj, oldBizObj, entityItem);
        } else if (entityItem instanceof MuliLangTextField) {
            fieldModifyInfo = DynamicObjectCompareUtils.mulLanguageDataCompare(newBizObj, oldBizObj, entityItem);
        } else if (entityItem instanceof TimeField) {
            fieldModifyInfo = DynamicObjectCompareUtils.dateDataCompare(newBizObj, oldBizObj, entityItem);
        } else if (entityItem instanceof CheckBoxField) {
            fieldModifyInfo = DynamicObjectCompareUtils.simpleDataCompare(newBizObj, oldBizObj, entityItem);
        } else if (entityItem instanceof RadioGroupField) {
            fieldModifyInfo = DynamicObjectCompareUtils.simpleDataCompare(newBizObj, oldBizObj, entityItem);
        } else if (entityItem instanceof MulComboField) {
            fieldModifyInfo = DynamicObjectCompareUtils.simpleDataCompare(newBizObj, oldBizObj, entityItem);
        } else if (entityItem instanceof ComboField) {
            fieldModifyInfo = DynamicObjectCompareUtils.comboFieldCompare(newBizObj, oldBizObj, entityItem);
        } else if (entityItem instanceof TextAreaField) {
            fieldModifyInfo = DynamicObjectCompareUtils.simpleDataCompare(newBizObj, oldBizObj, entityItem);
        } else if (entityItem instanceof TextField) {
            fieldModifyInfo = DynamicObjectCompareUtils.simpleDataCompare(newBizObj, oldBizObj, entityItem);
        } else if (entityItem instanceof DateTimeField) {
            fieldModifyInfo = DynamicObjectCompareUtils.dateDataCompare(newBizObj, oldBizObj, entityItem);
        } else if (entityItem instanceof RadioField) {
            fieldModifyInfo = DynamicObjectCompareUtils.simpleDataCompare(newBizObj, oldBizObj, entityItem);
        } else if (entityItem instanceof BasedataField) {
            fieldModifyInfo = DynamicObjectCompareUtils.baseDataCompare(newBizObj, oldBizObj, entityItem);
        } else if (entityItem instanceof MulBasedataField) {
            fieldModifyInfo = DynamicObjectCompareUtils.mulBaseDataCompare(newBizObj, oldBizObj, entityItem);
        }
        return fieldModifyInfo;
    }

    private static FieldModifyInfo comboFieldCompare(DynamicObject newBizObj, DynamicObject oldBizObj, EntityItem<?> entityItem) {
        Object oldValue = oldBizObj.get(entityItem.getKey());
        Object newValue = newBizObj.get(entityItem.getKey());
        FieldModifyInfo fieldModifyInfo = null;
        String caption = entityItem.getName().getLocaleValue();
        String fieldName = entityItem.getKey();
        if (ObjectUtils.isEmpty(oldValue) && ObjectUtils.isEmpty(newValue)) {
            return null;
        }
        if (ObjectUtils.isEmpty(oldValue) || ObjectUtils.isEmpty(newValue)) {
            fieldModifyInfo = new FieldModifyInfo(oldValue, newValue, caption);
            fieldModifyInfo.setFieldName(fieldName);
            return fieldModifyInfo;
        }
        if (!oldValue.equals(newValue)) {
            fieldModifyInfo = new FieldModifyInfo(oldValue, newValue, caption);
            fieldModifyInfo.setFieldName(fieldName);
            return fieldModifyInfo;
        }
        return fieldModifyInfo;
    }

    private static FieldModifyInfo simpleDataCompare(DynamicObject newBizObj, DynamicObject oldBizObj, EntityItem<?> entityItem) {
        Object oldValue = oldBizObj.get(entityItem.getKey());
        Object newValue = newBizObj.get(entityItem.getKey());
        FieldModifyInfo fieldModifyInfo = null;
        String caption = entityItem.getName().getLocaleValue();
        String fieldName = entityItem.getKey();
        if (oldValue == null && newValue == null) {
            return null;
        }
        if (oldValue == null || newValue == null) {
            fieldModifyInfo = new FieldModifyInfo(oldValue, newValue, caption);
            fieldModifyInfo.setFieldName(fieldName);
            return fieldModifyInfo;
        }
        if (!oldValue.equals(newValue)) {
            fieldModifyInfo = new FieldModifyInfo(oldValue, newValue, caption);
            fieldModifyInfo.setFieldName(fieldName);
            return fieldModifyInfo;
        }
        return fieldModifyInfo;
    }

    private static FieldModifyInfo bigTextDataCompare(DynamicObject newBizObj, DynamicObject oldBizObj, EntityItem<?> entityItem) {
        String oldValue = DynamicObjectUtils.getBigText(oldBizObj, entityItem.getKey());
        String newValue = DynamicObjectUtils.getBigText(newBizObj, entityItem.getKey());
        FieldModifyInfo fieldModifyInfo = null;
        String caption = entityItem.getName().getLocaleValue();
        String fieldName = entityItem.getKey();
        if (oldValue == null && newValue == null) {
            return null;
        }
        if (oldValue == null || newValue == null) {
            fieldModifyInfo = new FieldModifyInfo((Object)oldValue, (Object)newValue, caption);
            fieldModifyInfo.setFieldName(fieldName);
            return fieldModifyInfo;
        }
        if (!oldValue.equals(newValue)) {
            fieldModifyInfo = new FieldModifyInfo((Object)oldValue, (Object)newValue, caption);
            fieldModifyInfo.setFieldName(fieldName);
            return fieldModifyInfo;
        }
        return fieldModifyInfo;
    }

    private static FieldModifyInfo dateDataCompare(DynamicObject newBizObj, DynamicObject oldBizObj, EntityItem<?> entityItem) {
        String newValueStr;
        Date oldValue = oldBizObj.getDate(entityItem.getKey());
        Date newValue = newBizObj.getDate(entityItem.getKey());
        FieldModifyInfo fieldModifyInfo = null;
        String caption = entityItem.getName().getLocaleValue();
        String fieldName = entityItem.getKey();
        if (oldValue == null && newValue == null) {
            return null;
        }
        if (oldValue == null || newValue == null) {
            fieldModifyInfo = new FieldModifyInfo((Object)oldValue, (Object)newValue, caption);
            fieldModifyInfo.setFieldName(fieldName);
            return fieldModifyInfo;
        }
        String oldValueStr = DateTimeUtils.format((Date)oldValue, (String)"yyyy-MM-dd HH:mm:ss");
        if (!oldValueStr.equals(newValueStr = DateTimeUtils.format((Date)newValue, (String)"yyyy-MM-dd HH:mm:ss"))) {
            fieldModifyInfo = new FieldModifyInfo((Object)oldValue, (Object)newValue, caption);
            fieldModifyInfo.setFieldName(fieldName);
            return fieldModifyInfo;
        }
        return fieldModifyInfo;
    }

    private static FieldModifyInfo mulBaseDataCompare(DynamicObject newBizObj, DynamicObject oldBizObj, EntityItem<?> entityItem) {
        DynamicObjectCollection oldValue = oldBizObj.getDynamicObjectCollection(entityItem.getKey());
        DynamicObjectCollection newValue = newBizObj.getDynamicObjectCollection(entityItem.getKey());
        FieldModifyInfo fieldModifyInfo = null;
        String caption = entityItem.getName().getLocaleValue();
        String fieldName = entityItem.getKey();
        if (oldValue == null && newValue == null) {
            return null;
        }
        if (oldValue == null || newValue == null) {
            fieldModifyInfo = new FieldModifyInfo((Object)oldValue, (Object)newValue, caption);
            fieldModifyInfo.setFieldName(fieldName);
            return fieldModifyInfo;
        }
        ArrayList oldBaseDataIdList = Lists.newArrayListWithCapacity((int)oldValue.size());
        ArrayList newBaseDataIdList = Lists.newArrayListWithCapacity((int)newValue.size());
        oldValue.forEach(item -> oldBaseDataIdList.add(item.get("fbasedataid_id").toString()));
        newValue.forEach(item -> newBaseDataIdList.add(item.get("fbasedataid_id").toString()));
        if (oldBaseDataIdList.size() != newBaseDataIdList.size() || !oldBaseDataIdList.containsAll(newBaseDataIdList)) {
            fieldModifyInfo = new FieldModifyInfo((Object)oldValue, (Object)newValue, caption);
            fieldModifyInfo.setFieldName(fieldName);
            return fieldModifyInfo;
        }
        return fieldModifyInfo;
    }

    private static FieldModifyInfo baseDataCompare(DynamicObject newBizObj, DynamicObject oldBizObj, EntityItem<?> entityItem) {
        DynamicObject oldValue = oldBizObj.getDynamicObject(entityItem.getKey());
        DynamicObject newValue = newBizObj.getDynamicObject(entityItem.getKey());
        FieldModifyInfo fieldModifyInfo = null;
        String caption = entityItem.getName().getLocaleValue();
        String fieldName = entityItem.getKey();
        if (oldValue == null && newValue == null) {
            return null;
        }
        if (oldValue == null || newValue == null) {
            fieldModifyInfo = new FieldModifyInfo((Object)oldValue, (Object)newValue, caption);
            fieldModifyInfo.setFieldName(fieldName);
            return fieldModifyInfo;
        }
        if (!oldValue.get("id").equals(newValue.get("id"))) {
            fieldModifyInfo = new FieldModifyInfo((Object)oldValue, (Object)newValue, caption);
            fieldModifyInfo.setFieldName(fieldName);
            return fieldModifyInfo;
        }
        return fieldModifyInfo;
    }

    private static FieldModifyInfo mulLanguageDataCompare(DynamicObject newBizObj, DynamicObject oldBizObj, EntityItem<?> entityItem) {
        LocaleString newValue;
        String oldLocaleStringValue = oldBizObj.getLocaleString(entityItem.getKey()).getLocaleValue();
        String newLocaleStringValue = newBizObj.getLocaleString(entityItem.getKey()).getLocaleValue();
        FieldModifyInfo fieldModifyInfo = null;
        String caption = entityItem.getName().getLocaleValue();
        String fieldName = entityItem.getKey();
        if (oldLocaleStringValue == null && newLocaleStringValue == null) {
            return null;
        }
        if (oldLocaleStringValue == null || newLocaleStringValue == null) {
            fieldModifyInfo = new FieldModifyInfo((Object)oldLocaleStringValue, (Object)newLocaleStringValue, caption);
            fieldModifyInfo.setFieldName(fieldName);
            return fieldModifyInfo;
        }
        LocaleString oldValue = LocaleString.fromMap((Map)oldBizObj.getLocaleString(entityItem.getKey()));
        if (!oldValue.equals((Object)(newValue = LocaleString.fromMap((Map)newBizObj.getLocaleString(entityItem.getKey()))))) {
            fieldModifyInfo = new FieldModifyInfo((Object)oldValue, (Object)newValue, caption);
            fieldModifyInfo.setFieldName(fieldName);
            return fieldModifyInfo;
        }
        return fieldModifyInfo;
    }
}

