/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.common.util;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.zip.ZipFile;
import kd.bos.zip.model.ZipParameters;
import kd.hdtc.hrdbs.common.exception.HDTCBizException;
import kd.hdtc.hrdbs.common.util.StringUtils;
import org.apache.commons.io.FilenameUtils;

public final class FileUtils {
    private static final Log LOG = LogFactory.getLog(FileUtils.class);
    private static final int BUFFER_SIZE = 2048;
    private static String[] illegalChars = new String[]{"../", "..\\", "<", ">", "\""};
    private static final String ENTITY_NUMBER = "entityNum";
    private static final String ZIP_FILE_SUFFIX = ".zip";

    public static File createFile(String path, String childName) {
        File dirFile = FileUtils.checkAndCreateDir(path);
        File file = new File(dirFile.getPath(), childName);
        try {
            if (!file.exists() && !file.createNewFile()) {
                throw new HDTCBizException("FileUtils.createFile is error");
            }
        }
        catch (IOException ioException) {
            LOG.error("FileUtils.createFile is error", (Throwable)ioException);
            throw new HDTCBizException("FileUtils.createFile is error");
        }
        return file;
    }

    public static void toZip(String srcPath, String zipOutFilePath) {
        try {
            String localPath = FileUtils.generateLocalPath();
            File sourceFile = FileUtils.createFile(localPath, srcPath);
            File zipOutFile = FileUtils.createFile(localPath, zipOutFilePath);
            FileUtils.compress(sourceFile, zipOutFile);
        }
        catch (Exception exception) {
            LOG.error("toZip error.srcDir=" + srcPath, (Throwable)exception);
            throw new HDTCBizException("zip error from CommonUtil");
        }
    }

    public static void compress(File sourceFile, File zipOutFile) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(zipOutFile);
             ZipOutputStream zipOut = new ZipOutputStream((OutputStream)fos, Charset.forName("GBK"));
             FileInputStream fis = new FileInputStream(sourceFile);){
            int length;
            ZipEntry zipEntry = new ZipEntry(sourceFile.getName());
            zipOut.putNextEntry(zipEntry);
            byte[] bytes = new byte[2048];
            while ((length = fis.read(bytes)) >= 0) {
                zipOut.write(bytes, 0, length);
            }
        }
    }

    public static void deleteLocalFile(File fileTemp) {
        if (fileTemp == null) {
            return;
        }
        try {
            if (fileTemp.isDirectory()) {
                org.apache.commons.io.FileUtils.deleteDirectory((File)fileTemp);
            } else {
                org.apache.commons.io.FileUtils.delete((File)fileTemp);
            }
        }
        catch (IOException var3) {
            String msgTpl = ResManager.loadKDString((String)"\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25: ", (String)"FileUtils_0", (String)"hdtc-hrdbs-common", (Object[])new Object[0]);
            throw new KDBizException((Throwable)var3, new ErrorCode("", msgTpl), new Object[0]);
        }
    }

    public static String generateLocalPath() {
        String userHome = System.getProperty("user.home");
        String tempPath = "hrdbs";
        String localPath = userHome + File.separator + "KINGDEEDOWNLOAD" + File.separator + tempPath;
        return FileUtils.checkFilePath(localPath);
    }

    public static String checkFilePath(String path) {
        return path.replace("../", "#");
    }

    public static String getUploadPrefixPath() {
        String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMM"));
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        return String.format("/%s/%s/%s", tenantId, accountId, date);
    }

    public static void addFileToZipFile(File sourceFile, ZipFile zipFile, String name, boolean keepDirStructure, ZipParameters zipParameters) throws Exception {
        if (sourceFile.isFile()) {
            zipFile.addFile(sourceFile, zipParameters);
        } else {
            File[] listFiles;
            if (keepDirStructure && !sourceFile.getName().equals(name)) {
                zipFile.addFolder(sourceFile, zipParameters);
            }
            if ((listFiles = sourceFile.listFiles()) == null || listFiles.length == 0) {
                return;
            }
            for (File file : listFiles) {
                FileUtils.addFileToZipFile(file, zipFile, name + File.separator + file.getName(), keepDirStructure, zipParameters);
            }
        }
    }

    public static File checkAndCreateDir(String path) {
        String delPath = FileUtils.generateLocalPath();
        if (StringUtils.isNotEmpty((String)path) && !path.contains(delPath)) {
            path = delPath + File.separator + path;
        } else if (StringUtils.isEmpty((String)path)) {
            path = delPath;
        }
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static File checkAndCreateDir(String path, String childName) {
        File file = FileUtils.createFile(path, childName);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static void writeMap2File(String fullFilePath, String fileName, Map<String, Object> objectMap) {
        String jsonStr = JSON.toJSONString(objectMap);
        FileUtils.writeStr2File(fullFilePath, fileName, jsonStr);
    }

    public static File writeStr2File(String fullFilePath, String fileName, String str) {
        File jsonFile = FileUtils.createFile(fullFilePath, fileName);
        try (FileOutputStream fos = new FileOutputStream(jsonFile.getAbsolutePath(), true);){
            fos.write(str.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception exception) {
            String msgTpl = ResManager.loadKDString((String)"\u6587\u4ef6\u5199\u5165\u5931\u8d25\u3002", (String)"FileUtils_1", (String)"hdtc-hrdbs-common", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("", msgTpl), new Object[]{exception});
        }
        return jsonFile;
    }

    public static void inputStreamToOutputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int index;
        byte[] bytes = new byte[4096];
        while ((index = inputStream.read(bytes)) != -1) {
            outputStream.write(bytes, 0, index);
        }
    }

    public static TempFileCacheDownloadable.Content getCacheContentFromTempUrl(String tempUrl) {
        String[] queryParams;
        if (StringUtils.isEmpty((String)tempUrl)) {
            String msgTpl = ResManager.loadKDString((String)"\u4e34\u65f6\u6587\u4ef6URL\u4e3a\u7a7a\u3002", (String)"FileUtils_2", (String)"hdtc-hrdbs-common", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("", msgTpl), new Object[0]);
        }
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        try {
            String queryUrl = new URL(tempUrl).getQuery();
            if (!tempUrl.contains("&") && !tempUrl.contains("tempfile-")) {
                LOG.info("getCacheContentFromTempUrl tempUrl is not temp url,tempUrl={}", (Object)tempUrl);
                return null;
            }
            queryParams = queryUrl.split("&");
        }
        catch (MalformedURLException e) {
            String msgTpl = ResManager.loadKDString((String)"\u4e34\u65f6\u6587\u4ef6URL\u89e3\u6790\u5931\u8d25\u3002%s\u3002", (String)"FileUtils_3", (String)"hdtc-hrdbs-common", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("", msgTpl), new Object[]{e});
        }
        HashMap downloadFileParams = Maps.newHashMapWithExpectedSize((int)queryParams.length);
        for (String queryParam : queryParams) {
            String[] paraArr = queryParam.split("=");
            downloadFileParams.put(paraArr[0], paraArr[1]);
        }
        return downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
    }

    public static String inputStreamToString(InputStream inputStream) {
        String resultStr = "";
        try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            resultStr = result.toString("UTF-8");
        }
        catch (IOException e) {
            String msgTpl = ResManager.loadKDString((String)"inputStream\u8f6c\u5b57\u7b26\u4e32\u5f02\u5e38\uff1a", (String)"FileUtils_4", (String)"hdtc-hrdbs-common", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("", msgTpl), new Object[]{e});
        }
        return resultStr;
    }

    public static byte[] inputStreamToByte(InputStream is) {
        byte[] resBytes;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] bytes = new byte[1024];
            int flag = -1;
            while ((flag = is.read(bytes)) != -1) {
                bos.write(bytes, 0, flag);
            }
            resBytes = bos.toByteArray();
        }
        catch (Exception e) {
            String msgTpl = ResManager.loadKDString((String)"inputStream\u8f6cbyte\u6570\u7ec4\u5f02\u5e38", (String)"FileUtils_5", (String)"hdtc-hrdbs-common", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("", msgTpl), new Object[]{e});
        }
        return resBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeContentAndGetUrl(String packageName, String fileName, String content) {
        String filePath = FileUtils.generateLocalPath();
        String jsonFilePath = filePath + File.separator + fileName;
        File file = FileUtils.writeStr2File(filePath, fileName, content);
        String tempFileUrl = "";
        if (file == null) {
            return tempFileUrl;
        }
        InputStream input = null;
        try {
            input = Files.newInputStream(Paths.get(FilenameUtils.getFullPath((String)jsonFilePath) + FilenameUtils.getName((String)jsonFilePath), new String[0]), new OpenOption[0]);
            tempFileUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, input, 28800);
            if (tempFileUrl.startsWith("tempfile") && !tempFileUrl.contains("http")) {
                tempFileUrl = UrlService.getDomainContextUrl() + "/" + tempFileUrl;
            }
        }
        catch (IOException e) {
            LOG.error("FileUtils.writeContentAndGetUrl is exception.", (Throwable)e);
        }
        finally {
            FileUtils.deleteLocalFile(file);
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    LOG.error("FileUtils.writeContentAndGetUrl input close is exception.", (Throwable)e);
                }
            }
        }
        return tempFileUrl;
    }

    /*
     * Exception decompiling
     */
    public static Map<String, String> uploadFile(String fileName, String localPath) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String dealPathParam(String path) {
        if (FileUtils.containsIllegalChar(path).booleanValue()) {
            throw new KDException(new ErrorCode("ILLEGAL_PATH", "PATH_CONTAINS_ILLEGAL_CHAR"), new Object[0]);
        }
        if (path.contains("&kdedcba=")) {
            path = path.substring(0, path.lastIndexOf("&kdedcba="));
        }
        if (path.contains("?v=1")) {
            path = path.replace("?v=1.0", "");
            path = path.replace("?v=1", "");
        }
        if (path.contains("?v=0.5")) {
            path = path.replace("?v=0.5", "");
        }
        return path;
    }

    public static String dealPath(String path, String source) {
        path = FileUtils.dealPathParam(path);
        path = "image".equals(source) ? FileServiceExtFactory.getImageFileServiceExt().getRealPath(path) : FileServiceExtFactory.getAttachFileServiceExt().getRealPath(path);
        LOG.info("kd.hdtc.hrdbs.common.util.FileUtils.dealPath={}", (Object)path);
        if (FileUtils.containsIllegalChar(path).booleanValue()) {
            throw new HDTCBizException(new ErrorCode("ILLEGAL_PATH", "PATH_CONTAINS_ILLEGAL_CHAR"), new Object[0]);
        }
        return path;
    }

    private static String getNewFilePath(String oldPath, String fileName) {
        String selfPath = oldPath;
        boolean isEncrptyPath = Boolean.parseBoolean(String.valueOf(DispatchServiceHelper.invokeBOSService((String)IAttachmentService.class.getSimpleName(), (String)"isEncrptyPath", (Object[])new Object[0])));
        if (oldPath == null || !oldPath.contains("/")) {
            selfPath = FileUtils.generateAttPath(fileName);
        }
        return !isEncrptyPath ? selfPath : FileUtils.generateAttPath(fileName);
    }

    private static String generateAttPath(String fileName) {
        String rootPath = System.getProperty("attachment.rootpath", "/");
        if (!rootPath.startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        if (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        String uuid = UUID.randomUUID().toString().replace("-", "");
        RequestContext rc = RequestContext.get();
        return rootPath + FileNameUtils.getAttachmentFileName((String)rc.getTenantCode(), (String)rc.getAccountId(), (Object)uuid, (String)fileName);
    }

    private static Boolean containsIllegalChar(String path) {
        if (path == null) {
            return Boolean.FALSE;
        }
        for (String illegalChar : illegalChars) {
            if (!path.contains(illegalChar)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String getFileSuffix(String fileName) {
        if (StringUtils.isEmpty((String)fileName)) {
            return "";
        }
        int lastIndex = fileName.lastIndexOf(46);
        if (lastIndex <= 0) {
            return "";
        }
        return fileName.substring(lastIndex + 1);
    }

    public static void unzip(String zipFilePath, String destDirectoryPath) {
        if (!zipFilePath.endsWith(ZIP_FILE_SUFFIX)) {
            throw new HDTCBizException("The file to be extracted must be zip.");
        }
        FileInputStream fis = null;
        ZipInputStream zis = null;
        try {
            fis = new FileInputStream(zipFilePath);
            zis = new ZipInputStream((InputStream)fis, Charset.forName("GBK"));
            ZipEntry zipEntry = zis.getNextEntry();
            File destDir = new File(destDirectoryPath);
            FileUtils.checkAndCreateDir(destDirectoryPath);
            while (zipEntry != null) {
                String filePath = destDir.getPath() + File.separator + zipEntry.getName();
                File destFile = new File(filePath);
                if (!zipEntry.isDirectory()) {
                    destFile.getParentFile().mkdirs();
                    FileUtils.extractFile(zis, filePath);
                } else {
                    destFile.mkdirs();
                }
                zipEntry = zis.getNextEntry();
                zis.closeEntry();
            }
        }
        catch (Exception e) {
            try {
                LOG.error("unzip IOException, zipFilePath={}, destDirectoryPath={}, error={}", new Object[]{zipFilePath, destDirectoryPath, e.getMessage(), e});
                throw new HDTCBizException("unzip is IOException");
            }
            catch (Throwable throwable) {
                FileUtils.closeStreamZis(zis);
                FileUtils.closeStreamFis(fis);
                throw throwable;
            }
        }
        FileUtils.closeStreamZis(zis);
        FileUtils.closeStreamFis(fis);
    }

    private static void closeStreamFis(FileInputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (IOException ioException) {
            LOG.error("closeStreamFis is exception ", (Throwable)ioException);
        }
    }

    private static void closeStreamZis(ZipInputStream zis) {
        try {
            if (zis != null) {
                zis.closeEntry();
                zis.close();
            }
        }
        catch (IOException ioException) {
            LOG.error("closeStreamZis is exception ", (Throwable)ioException);
        }
    }

    private static void extractFile(ZipInputStream zis, String filePath) {
        BufferedOutputStream bos = null;
        try {
            int read;
            bos = new BufferedOutputStream(new FileOutputStream(filePath));
            byte[] bytesIn = new byte[4096];
            while ((read = zis.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
        catch (IOException ioException) {
            try {
                LOG.error((Throwable)ioException);
                throw new HDTCBizException("extractFile is exception");
            }
            catch (Throwable throwable) {
                FileUtils.safeClose(bos);
                throw throwable;
            }
        }
        FileUtils.safeClose(bos);
    }

    public static void safeClose(BufferedOutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                throw new HDTCBizException("safeClose is ioexception.");
            }
        }
    }

    public static String downloadFile(String servePath, String suffix) {
        File tempFile;
        try {
            FileService service = FileServiceFactory.getAttachmentFileService();
            tempFile = File.createTempFile(UUID.randomUUID().toString(), suffix);
            try (InputStream in = service.getInputStream(servePath);){
                org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)in, (File)tempFile);
            }
        }
        catch (IOException ioException) {
            throw new HDTCBizException("downloadFile " + servePath + " is exception.");
        }
        return tempFile.getPath();
    }

    public static void addDownloadPermission(String formId, String urls, String appId) {
        String tempFileId = UrlUtil.getParam((String)urls, (String)"id");
        HashMap refEntityMap = Maps.newHashMapWithExpectedSize((int)3);
        refEntityMap.put(ENTITY_NUMBER, formId);
        refEntityMap.put("appid", appId);
        refEntityMap.put("permissionItemId", "47150e89000000ac");
        DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(formId);
        redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString((Object)refEntityMap), 600);
    }

    public static String downloadTempFile(String tempUrl) {
        File tempFile;
        TempFileCacheDownloadable.Content cacheContentFromTempUrl = FileUtils.getCacheContentFromTempUrl(tempUrl);
        if (cacheContentFromTempUrl == null) {
            throw new HDTCBizException("cacheContentFromTempUrl is empty.");
        }
        String filename = cacheContentFromTempUrl.getFilename();
        String suffix = filename.substring(filename.lastIndexOf("."));
        try {
            tempFile = File.createTempFile(UUID.randomUUID().toString(), suffix);
            try (InputStream in = cacheContentFromTempUrl.getInputStream();){
                org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)in, (File)tempFile);
            }
        }
        catch (IOException ioException) {
            LOG.error("downloadTempFile is exception.", (Throwable)ioException);
            throw new HDTCBizException(ioException.getMessage());
        }
        return tempFile.getPath();
    }
}

