/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.common.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.hdtc.hrdbs.common.pojo.NodeParam;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.EntryParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class MetadataGenParamUtils {
    private static final Map<String, Object> NORMAL_RULE = ImmutableMap.builder().put((Object)"MustInput", (Object)Boolean.FALSE).put((Object)"Hidden", (Object)Boolean.FALSE).put((Object)"EmptyText", (Object)"").put((Object)"LockedEmptyTip", (Object)"").put((Object)"Suffix", (Object)"").put((Object)"Importable", (Object)Boolean.TRUE).put((Object)"Features", (Object)Maps.newHashMap()).build();

    public static MetadataGenParam getDefaultParam() {
        MetadataGenParam metadataGenParam = new MetadataGenParam();
        metadataGenParam.setBaseParam(MetadataGenParamUtils.buildDefault());
        return metadataGenParam;
    }

    public static void handleBaseDataPropParam(MetadataGenParam metadataGenParam) {
        List<EntryParam> entryParamList;
        if (metadataGenParam == null) {
            return;
        }
        List<FieldParam> fieldParamList = metadataGenParam.getFieldParamList();
        if (CollectionUtils.isNotEmpty(fieldParamList)) {
            Map<String, FieldParam> fieldParamMap = fieldParamList.stream().collect(Collectors.toMap(NodeParam::getNumber, fieldParam -> fieldParam, (v1, v2) -> v2));
            for (FieldParam fieldParam2 : metadataGenParam.getFieldParamList()) {
                if (!"BasedataPropField".equals(fieldParam2.getType())) continue;
                String baseDataNumber = (String)fieldParam2.getFieldRuleMap().get("baseDataNumber");
                if (HRStringUtils.isNotEmpty((String)baseDataNumber) && fieldParamMap.get(baseDataNumber) == null) {
                    FieldParam templateBaseDataFieldParam = new FieldParam();
                    templateBaseDataFieldParam.setNumber(baseDataNumber);
                    fieldParam2.setBaseDataFieldParam(templateBaseDataFieldParam);
                    continue;
                }
                fieldParam2.setBaseDataFieldParam(fieldParamMap.get(baseDataNumber));
            }
        }
        if (CollectionUtils.isNotEmpty(entryParamList = metadataGenParam.getEntryParamList())) {
            for (EntryParam entryParam : entryParamList) {
                MetadataGenParamUtils.handleBaseDataPropEntry(entryParam.getFieldParamList());
            }
        }
    }

    private static void handleBaseDataPropEntry(List<FieldParam> fieldParamList) {
        if (CollectionUtils.isEmpty(fieldParamList)) {
            return;
        }
        Map<String, FieldParam> fieldParamMap = fieldParamList.stream().collect(Collectors.toMap(NodeParam::getNumber, fieldParam -> fieldParam, (v1, v2) -> v2));
        for (FieldParam fieldParam2 : fieldParamList) {
            if (!fieldParam2.getType().startsWith("BasedataPropField")) continue;
            String baseDataNumber = (String)fieldParam2.getFieldRuleMap().get("baseDataNumber");
            fieldParam2.setBaseDataFieldParam(fieldParamMap.get(baseDataNumber));
        }
    }

    private static BaseParam buildDefault() {
        BaseParam baseParam = new BaseParam();
        baseParam.setNormalFieldRuleMap(NORMAL_RULE);
        return baseParam;
    }
}

