/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.common.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.exception.HDTCBizException;
import kd.hdtc.hrdbs.common.pojo.OperationResultInfo;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class OperationResultUtils {
    private static final Log LOG = LogFactory.getLog(OperationResultUtils.class);

    public static void check(OperationResult rs) {
        if (!rs.isSuccess()) {
            StringBuilder sb = new StringBuilder();
            for (IOperateInfo op : rs.getAllErrorOrValidateInfo()) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(op.getTitle()).append(' ').append(op.getMessage());
            }
            if (sb.length() == 0) {
                throw new HDTCBizException(rs.getMessage());
            }
            throw new HDTCBizException(sb.toString());
        }
    }

    public static OperationResultInfo parseResult(OperationResult operationResult, String operateKey) {
        if (operationResult != null && StringUtils.isNotEmpty((String)operateKey) && operationResult.getValidateResult().getErrorPkIds().size() != 0) {
            int successCount = operationResult.getSuccessPkIds().size();
            int errorCount = operationResult.getValidateResult().getErrorPkIds().size();
            int totalCount = successCount + errorCount;
            String operateName = "";
            switch (operateKey) {
                case "save": {
                    operateName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"OperationResultUtils_1", (String)"hdtc-hrdbs-common", (Object[])new Object[0]);
                    break;
                }
                case "modify": {
                    operateName = ResManager.loadKDString((String)"\u4fee\u6539", (String)"OperationResultUtils_5", (String)"hdtc-hrdbs-common", (Object[])new Object[0]);
                    break;
                }
                case "disable": {
                    operateName = ResManager.loadKDString((String)"\u7981\u7528", (String)"OperationResultUtils_3", (String)"hdtc-hrdbs-common", (Object[])new Object[0]);
                    break;
                }
                case "enable": {
                    operateName = ResManager.loadKDString((String)"\u542f\u7528", (String)"OperationResultUtils_2", (String)"hdtc-hrdbs-common", (Object[])new Object[0]);
                    break;
                }
                case "delete": {
                    operateName = ResManager.loadKDString((String)"\u5220\u9664", (String)"OperationResultUtils_4", (String)"hdtc-hrdbs-common", (Object[])new Object[0]);
                    break;
                }
            }
            String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u5355\u636e\uff0c\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"OperationResultUtils_0", (String)"hdtc-hrdbs-common", (Object[])new Object[0]), totalCount, operateName, successCount, errorCount);
            OperationResultInfo operationResultInfo = new OperationResultInfo();
            operationResultInfo.setTitle(title);
            ArrayList errorMsgList = Lists.newArrayListWithExpectedSize((int)operationResult.getValidateResult().getValidateErrors().size());
            operationResult.getValidateResult().getValidateErrors().forEach(dy -> {
                List allErrorInfoList = dy.getAllErrorInfo();
                if (CollectionUtils.isNotEmpty(allErrorInfoList)) {
                    allErrorInfoList.forEach(info -> errorMsgList.add(info.getMessage()));
                }
            });
            operationResultInfo.setErrorMsgList(errorMsgList);
            return operationResultInfo;
        }
        return null;
    }

    public static String parseResultToString(OperationResult operationResult, String operateKey) {
        OperationResultInfo operationResultInfo = OperationResultUtils.parseResult(operationResult, operateKey);
        if (operationResultInfo == null) {
            return null;
        }
        String operationResultInfoStr = "";
        try {
            operationResultInfoStr = JsonUtils.toString((Object)operationResultInfo);
        }
        catch (IOException e) {
            LOG.error("OperationResultUtils  parseResultToString error{}", (Object)e.getMessage());
        }
        return operationResultInfoStr;
    }

    public static OperationResultInfo getOperationResultInfo(String operationResultInfoStr) {
        if (StringUtils.isEmpty((String)operationResultInfoStr)) {
            return null;
        }
        OperationResultInfo operationResultInfo = null;
        try {
            operationResultInfo = (OperationResultInfo)JsonUtils.cast((String)operationResultInfoStr, OperationResultInfo.class);
        }
        catch (IOException e) {
            LOG.error("OperationResultUtils  getOperationResultInfo error{}", (Object)e.getMessage());
        }
        return operationResultInfo;
    }

    public static FormShowParameter getShowOperationResultPageParameter(String operationResultInfoStr) {
        OperationResultInfo operationResultInfo = OperationResultUtils.getOperationResultInfo(operationResultInfoStr);
        if (operationResultInfo != null) {
            return OperationResultUtils.getShowOperationResultPageParameter(operationResultInfo.getTitle(), operationResultInfo.getErrorMsgList());
        }
        return null;
    }

    public static Map<String, String> paraseOpResult(OperationResult operationResult) {
        HashMap<String, String> opResultMap = new HashMap<String, String>(16);
        ValidateResultCollection validateCollection = operationResult.getValidateResult();
        String message = operationResult.getMessage();
        if (StringUtils.isNotEmpty((String)message) && (validateCollection == null || validateCollection.errorSize() == 0)) {
            opResultMap.put("allFailed", message);
            return opResultMap;
        }
        Map billNosMap = operationResult.getBillNos();
        OperationResultUtils.paraseErrorInfo(opResultMap, operationResult.getAllErrorInfo(), billNosMap);
        if (validateCollection != null) {
            List validateErrorList = validateCollection.getValidateErrors();
            validateErrorList.forEach(validateResult -> OperationResultUtils.paraseErrorInfo(opResultMap, validateResult.getAllErrorInfo(), billNosMap));
        }
        return opResultMap;
    }

    private static void paraseErrorInfo(Map<String, String> opResultMap, List<OperateErrorInfo> allErrorInfoList, Map<Object, String> billNosMap) {
        if (CollectionUtils.isEmpty(allErrorInfoList)) {
            return;
        }
        allErrorInfoList.forEach(operateErrorInfo -> {
            String pkValue = OperationResultUtils.getPkValue(operateErrorInfo, billNosMap);
            String errorInfo = opResultMap.get(pkValue) == null ? "" : (String)opResultMap.get(pkValue);
            opResultMap.put(pkValue, errorInfo + operateErrorInfo.getMessage());
        });
    }

    private static String getPkValue(OperateErrorInfo operateErrorInfo, Map<Object, String> billNosMap) {
        String pkValue = operateErrorInfo.getPkValue().toString();
        String billPkValue = billNosMap.get(pkValue);
        if (StringUtils.isNotEmpty((String)billPkValue)) {
            return billPkValue;
        }
        if (!"0".equals(pkValue)) {
            return pkValue;
        }
        return operateErrorInfo.getMessage().split("\uff1a")[0];
    }

    public static FormShowParameter getShowOperationResultPageParameter(String title, List<String> errorMessageList) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("title", (Object)title);
        parameters.setCustomParam("errorMsg", errorMessageList);
        parameters.setHasRight(true);
        return parameters;
    }
}

