/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.common.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.interceptor.ExceptionInterceptor;
import kd.hr.hbp.common.util.HRStringUtils;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;

public final class ServiceFactoryUtils {
    private static final Log LOG = LogFactory.getLog(ServiceFactoryUtils.class);
    private static final String CLASS_SUFFIX = ".class";
    private static final boolean USE_PROXY = true;

    public static Map<String, String> getServiceInfo(Map<String, String> packageMap) {
        LinkedHashMap serviceMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        packageMap.entrySet().stream().forEach(entry -> serviceMap.putAll(ServiceFactoryUtils.getServiceInfo((String)entry.getKey(), ServiceFactoryUtils.getImplPackage(entry))));
        return serviceMap;
    }

    public static Map<String, String> getServiceInfo(String interfacePackageName, String implPackageName) {
        HashMap<String, String> serviceMap = new HashMap<String, String>(16);
        try {
            Map<String, Class> interfaceMap = ServiceFactoryUtils.findPackageContainsClassNameList(interfacePackageName);
            Map<String, Class> classMap = ServiceFactoryUtils.findPackageContainsClassNameList(implPackageName);
            LOG.info("find {} interface and {} impl in package summary {}", new Object[]{interfaceMap.size(), classMap.size(), ServiceFactoryUtils.getPackageSummary(interfacePackageName)});
            for (Map.Entry<String, Class> entry : classMap.entrySet()) {
                for (Class<?> interfaceClass : entry.getValue().getInterfaces()) {
                    if (!interfaceMap.containsKey(interfaceClass.getName())) continue;
                    serviceMap.put(interfaceClass.getSimpleName(), entry.getValue().getName());
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
        }
        return serviceMap;
    }

    private static String getImplPackage(Map.Entry<String, String> entry) {
        String interfacePackage = entry.getKey();
        String implPackage = entry.getValue();
        if (HRStringUtils.isNotEmpty((String)implPackage)) {
            return implPackage;
        }
        return String.format(Locale.ROOT, "%s.impl", interfacePackage);
    }

    private static String getPackageSummary(String interfacePackageName) {
        List summaryList = Splitter.on((String)".").splitToList((CharSequence)interfacePackageName).stream().filter(HRStringUtils::isNotEmpty).map(it -> it.substring(0, 1)).collect(Collectors.toList());
        return Joiner.on((String)".").join(summaryList);
    }

    private static Map<String, Class> findPackageContainsClassNameList(String interfacePackageName) throws IOException, ClassNotFoundException {
        String packagePath = interfacePackageName.replace('.', '/');
        Enumeration<URL> ensureUrls = Class.forName(ServiceFactoryUtils.class.getName()).getClassLoader().getResources(packagePath);
        ArrayList classList = Lists.newArrayList();
        while (ensureUrls.hasMoreElements()) {
            URL url = ensureUrls.nextElement();
            if (url == null) continue;
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                classList.addAll(ServiceFactoryUtils.scanDir(URLDecoder.decode(url.getPath(), "UTF-8")));
                continue;
            }
            if ("jar".equals(protocol)) {
                classList.addAll(ServiceFactoryUtils.scanJar(url, packagePath));
                continue;
            }
            LOG.warn("the protocol {} is not support", (Object)protocol);
        }
        return classList.stream().collect(Collectors.toMap(className -> interfacePackageName + "." + className, className -> {
            try {
                return Class.forName(interfacePackageName + "." + className);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }, (o1, o2) -> o1 == null ? o2 : o1));
    }

    private static List<String> scanJar(URL url, String basePackage) throws IOException {
        ArrayList classNameList = Lists.newArrayList();
        URLConnection urlConn = url.openConnection();
        if (urlConn instanceof JarURLConnection) {
            JarURLConnection jarUrlConn = (JarURLConnection)urlConn;
            classNameList.addAll(ServiceFactoryUtils.parseFileInJar(basePackage, jarUrlConn));
        }
        return classNameList;
    }

    private static List<String> parseFileInJar(String basePackage, JarURLConnection jarUrlConn) throws IOException {
        ArrayList simpleClassNameList = Lists.newArrayListWithCapacity((int)10);
        try (JarFile jarFile = jarUrlConn.getJarFile();){
            jarFile.stream().forEach(jarEntry -> {
                String className = jarEntry.getName();
                String judgeSimpleClassName = ServiceFactoryUtils.judgeClassName(className, basePackage);
                if (HRStringUtils.isNotEmpty((String)judgeSimpleClassName)) {
                    simpleClassNameList.add(judgeSimpleClassName);
                }
            });
        }
        return simpleClassNameList;
    }

    private static String judgeClassName(String className, String basePackage) {
        if (className.endsWith(CLASS_SUFFIX) && className.startsWith(basePackage)) {
            String simpleClassName = ServiceFactoryUtils.getSimpleClassName(className);
            if (className.equals(basePackage + "/" + simpleClassName + CLASS_SUFFIX)) {
                return simpleClassName;
            }
        }
        return null;
    }

    private static String getSimpleClassName(String className) {
        String simpleClassName = className.substring(0, className.length() - 6).replace('/', '.');
        if (simpleClassName.contains(".")) {
            simpleClassName = simpleClassName.substring(simpleClassName.lastIndexOf(".") + 1);
        }
        return simpleClassName;
    }

    private static List<String> scanDir(String dirPath) {
        ArrayList classNames = Lists.newArrayList();
        File dir = new File(dirPath);
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                String fileName = file.getName();
                if (fileName.lastIndexOf(CLASS_SUFFIX) <= -1) continue;
                fileName = fileName.substring(0, fileName.lastIndexOf("."));
                classNames.add(fileName);
            }
        }
        return classNames;
    }

    public static <T> T createProxyService(Object obj, Class<T> clazz) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setCallback((Callback)new ExceptionInterceptor(obj));
        return (T)enhancer.create();
    }
}

