/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashSet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ThrowableUtils {
    private static final Log LOG = LogFactory.getLog(ThrowableUtils.class);

    public static String toString(Throwable event) {
        try {
            return ThrowableUtils.getAllMsg(event);
        }
        catch (IOException ioException) {
            LOG.error("parse exception", (Throwable)ioException);
            return event.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getAllMsg(Throwable event) throws IOException {
        if (event == null) {
            return null;
        }
        ByteArrayOutputStream baos = null;
        PrintStream ps = null;
        try {
            baos = new ByteArrayOutputStream();
            ps = new PrintStream((OutputStream)baos, true, "UTF-8");
            event.printStackTrace(ps);
            ps.flush();
            String code = baos.toString("utf-8");
            String msg = ThrowableUtils.getCascadeMessage(event) + "\r\n\r\n" + Thread.currentThread().getName() + "\r\n" + code.replace(ThrowableUtils.getMessage(event), "");
            String string = ThrowableUtils.replaceZeroChar(msg);
            return string;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
    }

    private static String getCascadeMessage(Throwable err) {
        StringBuilder builder = new StringBuilder();
        HashSet<Throwable> visited = new HashSet<Throwable>();
        for (Throwable e = err; e != null && visited.add(e); e = e.getCause()) {
            String message;
            boolean flag;
            boolean bl = flag = e.getMessage() != null || !(e instanceof UndeclaredThrowableException) && !(e instanceof InvocationTargetException);
            if (!flag || builder.indexOf(message = ThrowableUtils.getMessage(e)) >= 0) continue;
            builder.append(message);
        }
        String msg = builder.toString();
        return ThrowableUtils.replaceZeroChar(msg);
    }

    private static String getMessage(Throwable event) {
        String message = event.getMessage();
        if (message == null) {
            message = event.getClass().getName();
        }
        return ThrowableUtils.replaceZeroChar(message);
    }

    private static String replaceZeroChar(String str) {
        if (str == null) {
            return str;
        }
        return str.indexOf(0) < 0 ? str : str.replace('\u0000', ' ');
    }
}

