/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.common.util.network;

import java.net.InetAddress;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.network.CheckBean;
import kd.hdtc.hrdbs.common.util.network.CheckNetWorkUtil;
import kd.hdtc.hrdbs.common.util.network.CheckNetwork;
import kd.hdtc.hrdbs.common.util.network.CheckResult;

public class SimplePing
implements CheckNetwork {
    protected static final SimplePing INSTANCE = new SimplePing();
    private static final int MAX_NUM = 5;
    private final String IP_ERROR = ResManager.loadKDString((String)"\u8bf7\u586b\u5199IP\u6216\u57df\u540d\u3002", (String)"SimplePing_0", (String)"hdtc-hrdbs-common", (Object[])new Object[0]);
    private final String PINT_INFO = ResManager.loadKDString((String)"%s \u7684 Ping \u7edf\u8ba1\u4fe1\u606f:", (String)"SimplePing_1", (String)"hdtc-hrdbs-common", (Object[])new Object[0]);
    private final String PINT_DETAIL_INFO = ResManager.loadKDString((String)"\u7b2c%1$s\u6b21\u6210\u529fPING%2$s\uff0c\u8017\u65f6\uff1a%3$sms\u3002", (String)"SimplePing_2", (String)"hdtc-hrdbs-common", (Object[])new Object[0]);

    private SimplePing() {
    }

    @Override
    public CheckResult check(CheckBean checkBean) {
        if (StringUtils.isEmpty((String)checkBean.getIpOrHostName())) {
            throw new HRDBSBizException(this.IP_ERROR);
        }
        long start = System.currentTimeMillis();
        return this.executeSimple(checkBean, start);
    }

    private CheckResult executeSimple(CheckBean checkBean, long start) {
        try {
            long eachStart = System.currentTimeMillis();
            InetAddress.getByName(checkBean.getIpOrHostName());
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(Locale.ROOT, this.PINT_INFO, checkBean.getIpOrHostName())).append("\r\n");
            for (int i = 1; i <= 5; ++i) {
                long span = System.currentTimeMillis() - eachStart;
                sb.append(String.format(Locale.ROOT, this.PINT_DETAIL_INFO, i, checkBean.getIpOrHostName(), span));
                sb.append("\r\n");
            }
            return new CheckResult(true, sb.toString(), start);
        }
        catch (Exception e) {
            return new CheckResult(false, CheckNetWorkUtil.toString(e), start, e);
        }
    }
}

