/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.common.util.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.network.CheckBean;
import kd.hdtc.hrdbs.common.util.network.CheckNetWorkUtil;
import kd.hdtc.hrdbs.common.util.network.CheckNetwork;
import kd.hdtc.hrdbs.common.util.network.CheckResult;

public class SimpleTelnet
implements CheckNetwork {
    private final Log logger = LogFactory.getLog(SimpleTelnet.class);
    protected static final SimpleTelnet INSTANCE = new SimpleTelnet();
    private final String IP_ERROR = ResManager.loadKDString((String)"\u8bf7\u586b\u5199IP\u6216\u57df\u540d\u3002", (String)"SimpleTelnet_0", (String)"hdtc-hrdbs-common", (Object[])new Object[0]);
    private final String PORT_ERROR = ResManager.loadKDString((String)"\u7f51\u7edc\u7aef\u53e3\u4e0d\u5408\u6cd5", (String)"SimpleTelnet_1", (String)"hdtc-hrdbs-common", (Object[])new Object[0]);

    private SimpleTelnet() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckResult check(CheckBean checkBean) {
        if (StringUtils.isEmpty((String)checkBean.getIpOrHostName())) {
            throw new HRDBSBizException(this.IP_ERROR);
        }
        if (checkBean.getPort() <= 0) {
            throw new HRDBSBizException(this.PORT_ERROR);
        }
        long start = System.currentTimeMillis();
        Socket socket = null;
        try {
            socket = new Socket();
            InetSocketAddress address = new InetSocketAddress(checkBean.getIpOrHostName(), checkBean.getPort());
            socket.connect(address, checkBean.getTimeout());
            CheckResult checkResult = new CheckResult(true, start);
            return checkResult;
        }
        catch (Exception e) {
            CheckResult checkResult = new CheckResult(false, CheckNetWorkUtil.toString(e), start, e);
            return checkResult;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException exception) {
                    this.logger.error("SimpleTelnet.check(CheckBean)", (Throwable)exception);
                }
            }
        }
    }
}

