/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.common.util.platform;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataInfoParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.DateTimeUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public final class DynamicObjectUtils
extends HRDynamicObjectUtils {
    private static final Log LOG = LogFactory.getLog(DynamicObjectUtils.class);

    public static String getFieldByPage(String page) {
        return DynamicObjectUtils.getFieldByPage(page, true);
    }

    public static String getCurrentPageField(String page) {
        List<EntityItem<?>> newItemList = MetadataUtils.getAllEntityItems(page);
        if (CollectionUtils.isEmpty(newItemList)) {
            return "";
        }
        ArrayList fieldList = Lists.newArrayListWithExpectedSize((int)newItemList.size());
        newItemList.forEach(dy -> {
            if (!dy.isInherit()) {
                fieldList.add(dy.getKey());
            }
        });
        return String.join((CharSequence)",", fieldList);
    }

    public static String getFieldByPage(String page, boolean containsTag) {
        Map<String, IDataEntityProperty> fieldMap = DynamicObjectUtils.getFieldMap(page);
        if (containsTag) {
            HashMap fieldMapTemp = new HashMap(16);
            fieldMap.entrySet().forEach(entry -> {
                if (entry.getValue() instanceof LargeTextProp) {
                    fieldMapTemp.put((String)entry.getKey() + "_tag", new TextProp());
                }
            });
            fieldMap.putAll(fieldMapTemp);
        }
        StringBuilder builder = new StringBuilder();
        if (fieldMap.isEmpty()) {
            return "";
        }
        for (String key : fieldMap.keySet()) {
            builder.append(key).append(',');
        }
        return builder.substring(0, builder.length() - 1);
    }

    private static Map<String, IDataEntityProperty> getFieldMap(String page) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)page.trim());
        return entityType.getAllFields().entrySet().stream().filter(entry -> HRStringUtils.isNotEmpty((String)((IDataEntityProperty)entry.getValue()).getAlias())).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (IDataEntityProperty)entry.getValue(), (o1, o2) -> o1));
    }

    public static void setBigText(DynamicObject dyn, String field, String txt) {
        if (HRStringUtils.isNotEmpty((String)txt) && txt.length() > 255) {
            dyn.set(field, (Object)txt.substring(0, 255));
            dyn.set(field + "_tag", (Object)txt);
        } else {
            dyn.set(field, (Object)txt);
            dyn.set(field + "_tag", null);
        }
    }

    public static void clearBigText(DynamicObject dyn, String field) {
        DynamicObjectUtils.setBigText(dyn, field, "");
    }

    public static void addAuditInfo(DynamicObject dyn) {
        dyn.set("creator_id", (Object)RequestContext.get().getCurrUserId());
        dyn.set("modifier_id", (Object)RequestContext.get().getCurrUserId());
        Date nowDate = new Date();
        dyn.set("createtime", (Object)nowDate);
        dyn.set("modifytime", (Object)nowDate);
    }

    public static void addModifyAuditInfo(DynamicObject dyn) {
        dyn.set("modifier_id", (Object)RequestContext.get().getCurrUserId());
        dyn.set("modifytime", (Object)new Date());
    }

    public static String getBigText(DynamicObject dyn, String field) {
        String tagTxt = dyn.getString(field + "_tag");
        return StringUtils.isEmpty((String)tagTxt) || tagTxt.length() <= 255 ? dyn.getString(field) : tagTxt;
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj) {
        if (fromObj != null && toObj != null) {
            HRDynamicObjectUtils.copy((DynamicObject)fromObj, (DynamicObject)toObj);
            toObj.set("id", fromObj.get("id"));
            String number = fromObj.getDataEntityType().getName();
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
            mainType.getProperties().forEach(property -> {
                if (property instanceof EntryProp) {
                    DynamicObjectCollection dynamicObjectCollection = fromObj.getDynamicObjectCollection(property.getName());
                    DynamicObjectCollection dynamicObjectCollectionFromDb = toObj.getDynamicObjectCollection(property.getName());
                    if (!CollectionUtils.isEmpty(dynamicObjectCollection) && !CollectionUtils.isEmpty(dynamicObjectCollectionFromDb)) {
                        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                            ((DynamicObject)dynamicObjectCollectionFromDb.get(i)).set("id", ((DynamicObject)dynamicObjectCollection.get(i)).get("id"));
                        }
                    }
                }
            });
        }
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, boolean isCopyPkId) {
        if (fromObj != null && toObj != null) {
            HRDynamicObjectUtils.copy((DynamicObject)fromObj, (DynamicObject)toObj);
            if (isCopyPkId) {
                DynamicObjectUtils.copy(fromObj, toObj);
            }
        }
    }

    public static Map<String, Object> convertDynamicObjectToSimpleValueMap(DynamicObject dy, String uniqueFieldKey) {
        if (dy != null) {
            MetadataInfoParam metadataInfoParam = MetadataUtils.parseMetadataInfo(uniqueFieldKey, dy.getDataEntityType().getName());
            Map<String, IDataEntityProperty> fieldNameAndTypeMap = metadataInfoParam.getFieldNameAndTypeMap();
            HashMap externalApiMap = Maps.newHashMapWithExpectedSize((int)fieldNameAndTypeMap.size());
            fieldNameAndTypeMap.forEach((fieldName, type) -> {
                if (type instanceof MulBasedataProp) {
                    List<String> valueList = DynamicObjectUtils.handleMulBaseData(dy, fieldName, uniqueFieldKey);
                    externalApiMap.put(fieldName, valueList);
                } else if (type instanceof BasedataProp) {
                    String queryFieldName = metadataInfoParam.getBaseDataFieldNameAndRealFieldNameMap().getOrDefault(fieldName, (String)fieldName);
                    externalApiMap.put(fieldName, dy.get(queryFieldName));
                } else if (type instanceof DateTimeProp) {
                    Date dateTimeValue = dy.getDate(fieldName);
                    if (dateTimeValue != null) {
                        externalApiMap.put(fieldName, DateTimeUtils.format((Date)dateTimeValue, (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                } else if (type instanceof EntryProp) {
                    Map<String, IDataEntityProperty> entryFieldNameAndTypeMap = metadataInfoParam.getBillEntryFieldMap().get(type.getName());
                    DynamicObjectCollection dynamicObjectCollection = dy.getDynamicObjectCollection(type.getName());
                    ArrayList entryList = Lists.newArrayListWithExpectedSize((int)dynamicObjectCollection.size());
                    dynamicObjectCollection.forEach(entry -> {
                        HashMap entryValueMap = Maps.newHashMapWithExpectedSize((int)entryFieldNameAndTypeMap.size());
                        entryFieldNameAndTypeMap.forEach((entryFieldName, entryType) -> {
                            if (entryType instanceof MulBasedataProp) {
                                List<String> valueList = DynamicObjectUtils.handleMulBaseData(entry, entryFieldName, uniqueFieldKey);
                                entryValueMap.put(entryFieldName, valueList);
                            } else if (entryType instanceof BasedataProp) {
                                entryValueMap.put(entryFieldName, entry.get(entryFieldName + "." + uniqueFieldKey));
                            } else if (entryType instanceof DateTimeProp) {
                                Date dateTimeValue = entry.getDate(entryFieldName);
                                if (dateTimeValue != null) {
                                    entryValueMap.put(entryFieldName, DateTimeUtils.format((Date)dateTimeValue, (String)"yyyy-MM-dd HH:mm:ss"));
                                }
                            } else {
                                entryValueMap.put(entryFieldName, entry.get(entryFieldName));
                            }
                        });
                        entryList.add(entryValueMap);
                    });
                    externalApiMap.put(fieldName, entryList);
                } else {
                    externalApiMap.put(fieldName, dy.get(fieldName));
                }
            });
            externalApiMap.put("id", dy.get("id"));
            return externalApiMap;
        }
        return new HashMap<String, Object>();
    }

    private static List<String> handleMulBaseData(DynamicObject dy, String fieldName, String uniqueFieldKey) {
        DynamicObjectCollection dynamicObjectCollection = dy.getDynamicObjectCollection(fieldName);
        ArrayList valueList = Lists.newArrayListWithCapacity((int)dynamicObjectCollection.size());
        dynamicObjectCollection.forEach(dd -> valueList.add(dd.getString("fbasedataid." + uniqueFieldKey)));
        return valueList;
    }

    public static void setMulBasedataValue(DynamicObject dy, String fieldName, Object ... ids) {
        DynamicObjectUtils.setMulBasedataValue(dy, fieldName, (DynamicObjectType type) -> BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)type));
    }

    public static void setMulBasedataValueByNumber(DynamicObject dy, String fieldName, Object ... numbers) {
        DynamicObjectUtils.setMulBasedataValue(dy, fieldName, (DynamicObjectType type) -> BusinessDataServiceHelper.load((String)type.getName(), (String)"id,number,name,pkid", (QFilter[])new QFilter("number", "in", (Object)numbers).toArray()));
    }

    private static void setMulBasedataValue(DynamicObject dy, String fieldName, Function<DynamicObjectType, DynamicObject[]> function) {
        DynamicProperty dynamicProperty = Optional.ofNullable(dy.getDynamicObjectType()).map(it -> it.getProperty(fieldName)).orElseThrow(() -> new HRDBSBizException("field " + fieldName + " is not exists"));
        if (!(dynamicProperty instanceof MulBasedataProp)) {
            throw new HRDBSBizException("field " + fieldName + " is not MulBasedataProp");
        }
        MulBasedataProp mulBasedataProp = (MulBasedataProp)dynamicProperty;
        String baseEntityId = mulBasedataProp.getBaseEntityId();
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)baseEntityId);
        dynamicObjectCollection.addAll((Collection)Lists.newArrayList((Object[])function.apply((DynamicObjectType)type)));
        dy.set(fieldName, (Object)dynamicObjectCollection);
    }
}

