/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.common.util.platform;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BaseEntity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataInfoParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.util.HRDBUtil;

public final class MetadataUtils {
    private static final Log LOG = LogFactory.getLog(MetadataUtils.class);

    public static FormMetadata getFormMetadataByNumber(String number) {
        return (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
    }

    public static Set<String> getDataEntityOperate(String entityNumber) {
        List<Map<String, Object>> dataEntityOperateList = MetadataUtils.getDataEntityOperateInfo(entityNumber);
        HashSet opSet = Sets.newHashSetWithExpectedSize((int)dataEntityOperateList.size());
        dataEntityOperateList.forEach(opMap -> opSet.add((String)opMap.get("key")));
        return opSet;
    }

    public static List<Map<String, Object>> getDataEntityOperateInfo(String entityNumber) {
        return EntityMetadataCache.getDataEntityOperate((String)entityNumber);
    }

    public static List<EntityItem<?>> getAllEntityItems(String number) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        return entityMetadata.getItems();
    }

    public static List<String> getFieldNumberList(String number) {
        List<EntityItem<?>> allEntityItems = MetadataUtils.getAllEntityItems(number);
        return allEntityItems.stream().map(dy -> dy.getKey()).collect(Collectors.toList());
    }

    public static boolean isExist(String number) {
        String id = MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Entity);
        return StringUtils.isNotEmpty((String)id);
    }

    public static List<MainEntityType> getMainEntityTypes(String entityNumber) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (mainType == null) {
            return new ArrayList<MainEntityType>(0);
        }
        ArrayList<MainEntityType> entityTypeList = new ArrayList<MainEntityType>();
        if (mainType instanceof QueryEntityType) {
            QueryEntityType queryType = (QueryEntityType)mainType;
            entityTypeList.add(queryType.getMainEntityType());
            entityTypeList.addAll(queryType.getAllJoinEntityType());
        } else {
            entityTypeList.add(mainType);
        }
        return entityTypeList;
    }

    public static MainEntityType getMainEntityType(String entityNumber) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (mainType instanceof QueryEntityType) {
            QueryEntityType queryType = (QueryEntityType)mainType;
            return queryType;
        }
        return mainType;
    }

    public static Map<EntityMetadata, List<EntityItem<?>>> getMultiEntityFieldItems(String entityNumber) {
        List<MainEntityType> entityTypeList = MetadataUtils.getMainEntityTypes(entityNumber);
        if (CollectionUtils.isNotEmpty(entityTypeList)) {
            HashMap entityItemsMap = new HashMap(entityTypeList.size());
            for (MainEntityType mainEntityType : entityTypeList) {
                EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
                List fieldItems = entityMetadata.getItems().stream().filter(item -> item instanceof Field).collect(Collectors.toList());
                entityItemsMap.put(entityMetadata, fieldItems);
            }
            return entityItemsMap;
        }
        return null;
    }

    public static List<EntityItem<?>> getEntityFieldItems(String entityNumber) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        if (entityMetadata == null) {
            return null;
        }
        List entityItems = entityMetadata.getItems();
        return entityItems.stream().filter(item -> item instanceof Field).collect(Collectors.toList());
    }

    public static String getEntityNumberFieldName(String entityNumber) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        if (entityMetadata == null) {
            return null;
        }
        return entityMetadata.getItemById(((BaseEntity)entityMetadata.getRootEntity()).getNumberFieldId()).getKey();
    }

    public static String getEntityNameFieldName(String entityNumber) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        if (entityMetadata == null) {
            return null;
        }
        return entityMetadata.getItemById(((BaseEntity)entityMetadata.getRootEntity()).getNameFieldId()).getKey();
    }

    public static List<ControlAp<?>> getFormMetadata(String formId) {
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        if (formMetadata == null) {
            return null;
        }
        List apList = formMetadata.getItems();
        Collections.sort(apList, new Comparator<ControlAp<?>>(){

            @Override
            public int compare(ControlAp<?> o1, ControlAp<?> o2) {
                int compareValue = o1.getParentId() == null && o2.getParentId() == null ? 0 : (o1.getParentId() == null && o2.getParentId() != null ? -1 : (o1.getParentId() != null && o2.getParentId() == null ? 1 : o1.getParentId().compareTo(o2.getParentId())));
                if (compareValue != 0) {
                    return compareValue;
                }
                return Integer.compare(o1.getIndex(), o2.getIndex());
            }
        });
        return apList;
    }

    public static Long getMetaVersion(String number, MetaCategory metaCategory) {
        String id = MetadataDao.getIdByNumber((String)number, (MetaCategory)metaCategory);
        String sql = "select fversion from T_META_FORMDESIGN where FID = ?";
        Object[] params = new Object[]{id};
        Long version = 0L;
        try (DataSet rs = HRDBUtil.queryDataSet((String)"getMetaVersion", (DBRoute)new DBRoute("sys.meta"), (String)sql, (Object[])params);){
            while (rs.hasNext()) {
                Row data = rs.next();
                version = data.getLong("fversion");
            }
        }
        return version;
    }

    public static List<EntityItem<?>> getRangeFieldItems(String entityNumber) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        if (entityMetadata == null) {
            return null;
        }
        List entityItemList = entityMetadata.getItems();
        ArrayList rangeFieldItemList = new ArrayList(entityItemList.size());
        for (EntityItem item : entityItemList) {
            if (!(item instanceof DateRangeField) && !(item instanceof TimeRangeField)) continue;
            rangeFieldItemList.add(item);
        }
        return rangeFieldItemList;
    }

    public static String getMetaTableName(String number) {
        String sql = "select ftablename from t_meta_entityinfo where FID = ?";
        Object[] params = new Object[]{number};
        String tableName = "";
        try (DataSet rs = HRDBUtil.queryDataSet((String)"getMetaTableName", (DBRoute)new DBRoute("sys.meta"), (String)sql, (Object[])params);){
            while (rs.hasNext()) {
                Row data = rs.next();
                tableName = data.getString("ftablename");
            }
        }
        return tableName;
    }

    public static List<String> getEntityNumberListByTableName(String tableName) {
        String sql = "select FID from t_meta_entityinfo where ftablename = ?";
        Object[] params = new Object[]{tableName};
        ArrayList<String> entityNumberList = new ArrayList<String>();
        try (DataSet rs = HRDBUtil.queryDataSet((String)"getMetaTableName", (DBRoute)new DBRoute("sys.meta"), (String)sql, (Object[])params);){
            while (rs.hasNext()) {
                Row data = rs.next();
                String entityNumber = data.getString("FID");
                entityNumberList.add(entityNumber);
            }
        }
        return entityNumberList;
    }

    public static Set<String> getEntityNumberBySameTableName(String entityNumber) {
        String sql = "select b.fid,b.ftablename from t_meta_entityinfo a\nleft join t_meta_entityinfo b on a.ftablename = b.ftablename\nwhere a.fid=?";
        Object[] params = new Object[]{entityNumber};
        HashSet<String> entityNumberList = new HashSet<String>(16);
        try (DataSet rs = HRDBUtil.queryDataSet((String)"getMetaTableName", (DBRoute)new DBRoute("sys.meta"), (String)sql, (Object[])params);){
            while (rs.hasNext()) {
                Row data = rs.next();
                String dbEntityNumber = data.getString("FID");
                entityNumberList.add(dbEntityNumber);
            }
        }
        return entityNumberList;
    }

    public static IDataEntityProperty getItemFromProps(IDataEntityType sourceDataEntityType, String sourceFieldNumber) {
        DataEntityPropertyCollection props = sourceDataEntityType.getProperties();
        for (IDataEntityProperty prop : props) {
            IDataEntityProperty iDataEntityProperty;
            if (sourceFieldNumber.equalsIgnoreCase(prop.getName())) {
                return prop;
            }
            if (!(prop instanceof EntryProp) || (iDataEntityProperty = MetadataUtils.getEntryOrSubProperty(sourceFieldNumber, (EntryProp)prop)) == null) continue;
            return iDataEntityProperty;
        }
        return null;
    }

    private static IDataEntityProperty getEntryOrSubProperty(String sourceFieldNumber, EntryProp prop) {
        DataEntityPropertyCollection entryItemTypeCol = prop.getItemType().getProperties();
        for (IDataEntityProperty iDataEntityProperty : entryItemTypeCol) {
            if (iDataEntityProperty instanceof BasedataProp && sourceFieldNumber.equals(iDataEntityProperty.getName())) {
                return iDataEntityProperty;
            }
            if (iDataEntityProperty instanceof MulBasedataProp && sourceFieldNumber.equals(iDataEntityProperty.getName())) {
                return iDataEntityProperty;
            }
            if (!(iDataEntityProperty instanceof SubEntryProp)) continue;
            DataEntityPropertyCollection subProCol = ((SubEntryProp)iDataEntityProperty).getItemType().getProperties();
            for (IDataEntityProperty subPro : subProCol) {
                if (!(subPro instanceof BasedataProp) || !sourceFieldNumber.equals(subPro.getName())) continue;
                return subPro;
            }
        }
        return null;
    }

    public static IDataEntityProperty getFieldEntityPropertyByFieldNum(MainEntityType mainEntityType, String fieldNumber) {
        Map allFieldPropertyMap = mainEntityType.getAllFields();
        return (IDataEntityProperty)allFieldPropertyMap.get(fieldNumber);
    }

    public static String getItemClassTypeProName(MainEntityType mainEntityType, String fieldNumber) {
        IDataEntityProperty property = MetadataUtils.getFieldEntityPropertyByFieldNum(mainEntityType, fieldNumber);
        if (property instanceof ItemClassProp) {
            ItemClassProp itemClassProp = (ItemClassProp)property;
            return itemClassProp.getTypePropName();
        }
        return "";
    }

    public static boolean checkBaseDataCtrl(String entityNumber) {
        return BaseDataServiceHelper.checkBaseDataCtrl((String)entityNumber);
    }

    public static boolean hisEntity(String entityNumber) {
        String entityTpl = HisModelController.getInstance().entityInhRelation(entityNumber);
        return !EnumEntityTpl.COMMON_TPL.getNumber().equals(entityTpl);
    }

    public static MetadataInfoParam parseMetadataInfo(String uniqueFieldKey, String entityNumber) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType(entityNumber);
        ArrayList queryFileNameList = Lists.newArrayListWithExpectedSize((int)mainEntityType.getProperties().size());
        HashMap fieldNameAndTypeMap = Maps.newHashMapWithExpectedSize((int)mainEntityType.getProperties().size());
        HashMap baseDataFieldNameAndRealFieldNameMap = Maps.newHashMapWithExpectedSize((int)mainEntityType.getProperties().size());
        HashMap<String, Map<String, IDataEntityProperty>> billEntryFieldMap = new HashMap<String, Map<String, IDataEntityProperty>>(16);
        mainEntityType.getProperties().forEach(property -> {
            if (property instanceof BasedataProp) {
                String queryFieldName = property.getName() + "." + uniqueFieldKey;
                queryFileNameList.add(queryFieldName);
                baseDataFieldNameAndRealFieldNameMap.put(property.getName(), queryFieldName);
            } else if (property instanceof EntryProp) {
                HashMap entryPropFieldMap = new HashMap(16);
                ArrayList baseFieldIdNumberList = new ArrayList();
                ((EntryProp)property).getDynamicCollectionItemPropertyType().getProperties().forEach(pro -> {
                    entryPropFieldMap.put(pro.getName(), pro);
                    if (pro instanceof BasedataProp) {
                        baseFieldIdNumberList.add(pro.getName() + "_id");
                    }
                });
                baseFieldIdNumberList.forEach(entryPropFieldMap::remove);
                entryPropFieldMap.remove("multilanguagetext");
                billEntryFieldMap.put(property.getName(), entryPropFieldMap);
            } else {
                queryFileNameList.add(property.getName());
            }
            fieldNameAndTypeMap.put(property.getName(), property);
        });
        if (CollectionUtils.isNotEmpty(billEntryFieldMap)) {
            billEntryFieldMap.forEach((entryKey, entryFieldMap) -> entryFieldMap.forEach((entryFieldName, entryFieldType) -> queryFileNameList.add(entryKey + "." + entryFieldName)));
        }
        baseDataFieldNameAndRealFieldNameMap.forEach((fieldName, queryFieldName) -> {
            String targetFieldName = fieldName + "_id";
            fieldNameAndTypeMap.remove(targetFieldName);
            queryFileNameList.remove(targetFieldName);
        });
        fieldNameAndTypeMap.remove("multilanguagetext");
        queryFileNameList.remove("multilanguagetext");
        MetadataInfoParam metadataInfoParam = new MetadataInfoParam();
        metadataInfoParam.setEntityNumber(entityNumber);
        metadataInfoParam.setBaseDataFieldNameAndRealFieldNameMap(baseDataFieldNameAndRealFieldNameMap);
        metadataInfoParam.setBillEntryFieldMap(billEntryFieldMap);
        metadataInfoParam.setFieldNameAndTypeMap(fieldNameAndTypeMap);
        metadataInfoParam.setQueryFileNameList(queryFileNameList);
        metadataInfoParam.setMainEntityType(mainEntityType);
        metadataInfoParam.setUniqueFieldKey(uniqueFieldKey);
        return metadataInfoParam;
    }

    public static List<Object> getPrimaryKeys(List<String> businessKeys, String entityNumber) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType(entityNumber);
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)businessKeys.size());
        if (mainEntityType.getPrimaryKey() instanceof LongProp) {
            for (String businessKey : businessKeys) {
                idList.add(Long.parseLong(businessKey));
            }
        } else {
            idList.addAll(businessKeys);
        }
        return idList;
    }

    public static Map<String, IDataEntityProperty> getAllRefF7EntityProperty(String entityNumber) {
        if (StringUtils.isEmpty((String)entityNumber)) {
            return new HashMap<String, IDataEntityProperty>(0);
        }
        Map allFieldPropertyMap = MetadataUtils.getMainEntityType(entityNumber).getAllFields();
        HashMap<String, IDataEntityProperty> allRefF7EntityTypeMap = new HashMap<String, IDataEntityProperty>(16);
        for (Map.Entry propertyEntry : allFieldPropertyMap.entrySet()) {
            String proName = (String)propertyEntry.getKey();
            IDataEntityProperty proDataEntityProperty = (IDataEntityProperty)propertyEntry.getValue();
            if (!StringUtils.isNotEmpty((String)proDataEntityProperty.getAlias()) || !(proDataEntityProperty instanceof IBasedataField)) continue;
            allRefF7EntityTypeMap.put(proName, proDataEntityProperty);
        }
        return allRefF7EntityTypeMap;
    }

    public static Map<String, String> getEntityRefF7ProMap(String entityNumber) {
        if (StringUtils.isEmpty((String)entityNumber)) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> allF7EntityProMap = new HashMap<String, String>(16);
        Map<String, IDataEntityProperty> allRefF7EntityProperty = MetadataUtils.getAllRefF7EntityProperty(entityNumber);
        for (Map.Entry<String, IDataEntityProperty> propertyEntry : allRefF7EntityProperty.entrySet()) {
            String baseEntityId = ((IBasedataField)propertyEntry.getValue()).getBaseEntityId();
            allF7EntityProMap.put(propertyEntry.getKey(), baseEntityId);
        }
        return allF7EntityProMap;
    }

    public static boolean isF7ItemClass(String entityNumber, String proName) {
        String itemClassTypeProName = MetadataUtils.getItemClassTypeProName(MetadataUtils.getMainEntityType(entityNumber), proName);
        return StringUtils.isNotEmpty((String)itemClassTypeProName);
    }
}

