/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.application.external.entity.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.business.application.external.entity.IBizAppEntityService;
import kd.hdtc.hrdbs.business.application.external.model.BizAppEntry;
import kd.hdtc.hrdbs.business.entity.AbstractBaseEntityService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.SqlUtils;
import kd.hr.hbp.common.util.HRDBUtil;

public class BizAppEntityServiceImpl
extends AbstractBaseEntityService
implements IBizAppEntityService {
    public BizAppEntityServiceImpl() {
        super("bos_devportal_bizapp");
    }

    @Override
    public Map<String, List<BizAppEntry>> queryBizAppIdByBizCloudList(Collection<String> cloudIdList) {
        BizAppEntry bizAppEntry;
        if (CollectionUtils.isEmpty(cloudIdList)) {
            return new HashMap<String, List<BizAppEntry>>(16);
        }
        String sql = "select fid,fnumber,fbizcloudid from t_meta_bizapp where fbizcloudid in ( " + String.join((CharSequence)",", SqlUtils.getQuestionList((int)cloudIdList.size())) + ")";
        HashMap cloudIdAndAppInfoListMap = Maps.newHashMapWithExpectedSize((int)cloudIdList.size());
        HashMap appIdAndBizAppEntryMap = Maps.newHashMapWithExpectedSize((int)cloudIdList.size());
        try (DataSet ds = HRDBUtil.queryDataSet((String)"queryBizAppIdByBizCloudList", (DBRoute)new DBRoute("sys.meta"), (String)sql, (Object[])cloudIdList.toArray(new String[0]));){
            while (ds.hasNext()) {
                Row row = ds.next();
                String bizCloudId = row.getString("fbizcloudid");
                List bizAppList = cloudIdAndAppInfoListMap.getOrDefault(bizCloudId, Lists.newArrayListWithExpectedSize((int)0));
                bizAppEntry = this.getBizAppEntry(row, bizCloudId);
                bizAppList.add(bizAppEntry);
                cloudIdAndAppInfoListMap.put(bizCloudId, bizAppList);
                appIdAndBizAppEntryMap.put(bizAppEntry.getBizAppId(), bizAppEntry);
            }
        }
        if (CollectionUtils.isNotEmpty((Map)appIdAndBizAppEntryMap)) {
            String querySql = "select fid,fname from t_meta_bizapp_l where flocaleid='zh_CN'AND fid in ( " + String.join((CharSequence)",", SqlUtils.getQuestionList((int)appIdAndBizAppEntryMap.size())) + ")";
            try (DataSet ds = HRDBUtil.queryDataSet((String)"queryBizAppIdByBizCloudList", (DBRoute)new DBRoute("sys.meta"), (String)querySql, (Object[])appIdAndBizAppEntryMap.keySet().toArray(new String[0]));){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    String bizAppId = row.getString("fid");
                    bizAppEntry = (BizAppEntry)appIdAndBizAppEntryMap.get(bizAppId);
                    bizAppEntry.setBizAppName(row.getString("fname"));
                }
            }
        }
        return cloudIdAndAppInfoListMap;
    }

    @Override
    public Map<String, String> queryBizAppIdByBizAppNumberList(Collection<String> bizAppNumberList) {
        if (CollectionUtils.isEmpty(bizAppNumberList)) {
            return new HashMap<String, String>(16);
        }
        String sql = "select fid,fnumber,fbizcloudid from t_meta_bizapp where fnumber in (" + String.join((CharSequence)",", SqlUtils.getQuestionList((int)bizAppNumberList.size())) + ")";
        HashMap appNumberAndAppIdMap = Maps.newHashMapWithExpectedSize((int)bizAppNumberList.size());
        try (DataSet ds = HRDBUtil.queryDataSet((String)"queryBizAppIdByBizAppNumberList", (DBRoute)new DBRoute("sys.meta"), (String)sql, (Object[])bizAppNumberList.toArray(new String[0]));){
            while (ds.hasNext()) {
                Row row = ds.next();
                appNumberAndAppIdMap.put(row.getString("fnumber"), row.getString("fid"));
            }
        }
        return appNumberAndAppIdMap;
    }

    @Override
    public Map<String, DynamicObject> queryBizAppByBizAppNumberList(Collection<String> bizAppNumberList) {
        if (CollectionUtils.isEmpty(bizAppNumberList)) {
            return new HashMap<String, DynamicObject>(16);
        }
        QFilter numberFilter = new QFilter("number", "in", bizAppNumberList);
        Object[] dynamicObjects = this.query("id,name,number,bizcloud", new QFilter[]{numberFilter});
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        return Stream.of(dynamicObjects).collect(Collectors.toMap(dy -> dy.getString("number"), Function.identity()));
    }

    private BizAppEntry getBizAppEntry(Row row, String bizCloudId) {
        BizAppEntry bizAppEntry = new BizAppEntry();
        bizAppEntry.setBizCloudId(bizCloudId);
        bizAppEntry.setBizAppId(row.getString("fid"));
        bizAppEntry.setBizAppNumber(row.getString("fnumber"));
        return bizAppEntry;
    }
}

