/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.application.external.entity.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.hdtc.hrdbs.business.application.external.entity.IFormDesignEntityService;
import kd.hdtc.hrdbs.business.application.external.model.FormEntry;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.SqlUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.hbp.common.util.HRDBUtil;

public class FormDesignEntityServiceImpl
implements IFormDesignEntityService {
    @Override
    public List<FormEntry> queryEntityNumberByBizAppId(String bizAppId) {
        ArrayList formEntryList = Lists.newArrayListWithExpectedSize((int)10);
        if (StringUtils.isEmpty((String)bizAppId)) {
            return formEntryList;
        }
        HashMap formIdAndFormEntryMap = Maps.newHashMapWithExpectedSize((int)16);
        String sql = "select fid,fnumber,fmodeltype from t_meta_formdesign where fmodeltype in ('BillFormModel','BaseFormModel') and fbizappid = ?";
        try (DataSet ds = HRDBUtil.queryDataSet((String)"queryEntityNumberByBizAppId", (DBRoute)new DBRoute("sys.meta"), (String)sql, (Object[])new String[]{bizAppId});){
            while (ds.hasNext()) {
                Row row = ds.next();
                FormEntry formEntry = new FormEntry();
                formEntry.setBizAppId(bizAppId);
                formEntry.setEntityNumber(row.getString("fnumber"));
                formEntry.setModelType(row.getString("fmodeltype"));
                formEntryList.add(formEntry);
                formIdAndFormEntryMap.put(row.getString("fid"), formEntry);
            }
        }
        if (CollectionUtils.isNotEmpty((Map)formIdAndFormEntryMap)) {
            String querySql = "select fid,fname from t_meta_formdesign_l where flocaleid='zh_CN' AND fid in ( " + String.join((CharSequence)",", SqlUtils.getQuestionList((int)formIdAndFormEntryMap.size())) + ")";
            try (DataSet ds = HRDBUtil.queryDataSet((String)"queryEntityNumberByBizAppId", (DBRoute)new DBRoute("sys.meta"), (String)querySql, (Object[])formIdAndFormEntryMap.keySet().toArray(new String[0]));){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    String formId = row.getString("fid");
                    FormEntry formEntry = (FormEntry)formIdAndFormEntryMap.get(formId);
                    formEntry.setEntityName(row.getString("fname"));
                }
            }
        }
        return formEntryList;
    }
}

