/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.application.external.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.application.external.IBizAppDomainService;
import kd.hdtc.hrdbs.business.application.external.entity.IBizAppEntityService;
import kd.hdtc.hrdbs.business.application.external.entity.IBizCloudEntityService;
import kd.hdtc.hrdbs.business.application.external.entity.IFormDesignEntityService;
import kd.hdtc.hrdbs.business.application.external.model.BizAppEntry;
import kd.hdtc.hrdbs.business.application.external.model.FormEntry;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.common.util.CollectionUtils;

public class BizAppDomainServiceImpl
implements IBizAppDomainService {
    private static final Log LOG = LogFactory.getLog(BizAppDomainServiceImpl.class);
    private final IBizCloudEntityService bizCloudEntityService = ServiceFactory.getService(IBizCloudEntityService.class);
    private final IBizAppEntityService bizAppEntityService = ServiceFactory.getService(IBizAppEntityService.class);
    private final IFormDesignEntityService formDesignEntityService = ServiceFactory.getService(IFormDesignEntityService.class);

    @Override
    public Map<String, List<BizAppEntry>> queryBizAppByBizCloudList(Collection<String> allHrCloudNumberList) {
        if (CollectionUtils.isEmpty(allHrCloudNumberList)) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        Map<String, String> cloudNumberAndCloudIdMap = this.bizCloudEntityService.queryCloudIdByCloudNumberList(allHrCloudNumberList);
        Map<String, List<BizAppEntry>> cloudIdAndAppInfoListMap = this.bizAppEntityService.queryBizAppIdByBizCloudList(cloudNumberAndCloudIdMap.values());
        cloudNumberAndCloudIdMap.forEach((cloudNumber, cloudId) -> {
            List bizAppEntryList = cloudIdAndAppInfoListMap.getOrDefault(cloudId, Lists.newArrayListWithExpectedSize((int)10));
            bizAppEntryList.forEach(bizAppEntry -> bizAppEntry.setBizCloudNumber((String)cloudNumber));
            cloudIdAndAppInfoListMap.put((String)cloudNumber, bizAppEntryList);
        });
        return cloudIdAndAppInfoListMap;
    }

    @Override
    public Map<String, List<FormEntry>> queryFormInfoByAppNumberList(Collection<String> appNumberList) {
        if (CollectionUtils.isEmpty(appNumberList)) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        HashMap appNumberAndFormEntryList = Maps.newHashMapWithExpectedSize((int)appNumberList.size());
        Map<String, String> appNumberAndAppIdMap = this.bizAppEntityService.queryBizAppIdByBizAppNumberList(appNumberList);
        appNumberAndAppIdMap.forEach((appNumber, appId) -> {
            List<FormEntry> formEntryList = this.formDesignEntityService.queryEntityNumberByBizAppId((String)appId);
            if (CollectionUtils.isNotEmpty(formEntryList)) {
                formEntryList.forEach(formEntry -> formEntry.setBizAppNumber((String)appNumber));
                appNumberAndFormEntryList.put(appNumber, formEntryList);
            }
        });
        return appNumberAndFormEntryList;
    }

    @Override
    public Map<String, DynamicObject> queryBizAppByBizAppNumberList(Collection<String> bizAppNumberList) {
        return this.bizAppEntityService.queryBizAppByBizAppNumberList(bizAppNumberList);
    }
}

