/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.application.service.metadata.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.designer.query.QueryDynSourcePlugIn;
import kd.bos.designer.query.QueryMetadataHelper;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.IDynamicMetadataDomainService;
import kd.hdtc.hrdbs.business.domain.metadata.IMetadataLogDomainService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.DesignMetadataParser;
import kd.hdtc.hrdbs.business.domain.metadata.impl.util.MetadataUtils;
import kd.hdtc.hrdbs.business.domain.metadata.impl.validator.ParamValidator;
import kd.hdtc.hrdbs.common.constants.CtsQueryDynSourceConstants;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.enums.MetadataOperateStatusEnum;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.pojo.metadata.QueryMetadataGenParam;
import kd.hdtc.hrdbs.common.util.MetadataGenParamUtils;

public class DynamicMetadataApplicationServiceImpl
implements IDynamicMetadataApplicationService {
    private static final Log LOG = LogFactory.getLog(DynamicMetadataApplicationServiceImpl.class);
    private static final String REFUSE_KD_GENERATE_METADATA = "refuse_kd_generate_metadata";
    private final IDynamicMetadataDomainService dynamicMetadataDomainService = ServiceFactory.getService(IDynamicMetadataDomainService.class);
    private final IMetadataLogDomainService metadataLogDomainService = ServiceFactory.getService(IMetadataLogDomainService.class);

    @Override
    public MetadataGenResult generate(MetadataGenParam metadataGenParam) {
        MetadataGenResult metadataGenResult = MetadataGenResult.success();
        String refuseKdGenerateMetadata = System.getProperty(REFUSE_KD_GENERATE_METADATA);
        if (Boolean.TRUE.toString().equals(refuseKdGenerateMetadata) && "kingdee".equals(ISVService.getISVInfo().getId())) {
            throw new HRDBSBizException("can not generate metadata use current isv, isv = kingdee");
        }
        MetadataGenParamUtils.handleBaseDataPropParam((MetadataGenParam)metadataGenParam);
        new ParamValidator(metadataGenParam, metadataGenResult).validate();
        if (!metadataGenResult.isSuccess()) {
            String msg = "param validate error :" + String.join((CharSequence)",", metadataGenResult.getMsgList());
            LOG.warn(msg);
            return metadataGenResult;
        }
        Long metadataCreateLogId = this.metadataLogDomainService.recordLog(metadataGenParam.getBaseParam().getMetadataNumber(), metadataGenParam.getMetadataOperateTypeEnum(), MetadataOperateStatusEnum.PROCESSING);
        if (MetadataGenTypeEnum.NORMAL_METADATA == metadataGenParam.getBaseParam().getType()) {
            this.dynamicMetadataDomainService.generateNormalMetadata(metadataGenParam, metadataGenResult);
        } else if (MetadataGenTypeEnum.EXTEND_METADATA == metadataGenParam.getBaseParam().getType()) {
            this.dynamicMetadataDomainService.generateExtendMetadata(metadataGenParam, metadataGenResult);
        } else if (MetadataGenTypeEnum.EXTEND_ENTRY_METADATA == metadataGenParam.getBaseParam().getType()) {
            this.dynamicMetadataDomainService.generateExtendEntryMetadata(metadataGenParam, metadataGenResult);
        } else {
            this.dynamicMetadataDomainService.generateMiddleTable(metadataGenParam, metadataGenResult);
        }
        this.updateLog(metadataGenResult, metadataCreateLogId);
        return metadataGenResult;
    }

    private void updateLog(MetadataGenResult metadataGenResult, Long metadataCreateLogId) {
        if (metadataGenResult.isSuccess()) {
            this.metadataLogDomainService.success(metadataCreateLogId);
        } else {
            this.metadataLogDomainService.fail(metadataCreateLogId, String.join((CharSequence)";", metadataGenResult.getMsgList()));
        }
    }

    @Override
    public void deleteMetadata(String number, boolean dropTable) {
        this.dynamicMetadataDomainService.deleteMetadata(number, dropTable);
    }

    @Override
    public String getOrCreateExtIsvAppId(String appNumber) {
        return this.dynamicMetadataDomainService.getOrCreateExtIsvAppId(appNumber);
    }

    @Override
    public void generateQuery(QueryMetadataGenParam queryMetadataGenParam, DynamicObject ctsQueryDynSource) {
        FormShowParameter parameter = this.buildCtsQueryDynFormShowParameter(queryMetadataGenParam);
        IFormView view = parameter.createView();
        view.addService(IPageCache.class, (Object)new PageCache(""));
        parameter.setFormConfig(FormMetadataCache.getFormConfig((String)parameter.getFormId()));
        view.initialize(parameter);
        IDataModel dataModel = view.getModel();
        dataModel.createNewData((Object)ctsQueryDynSource);
        QueryMetadataHelper queryMetadataHelper = new QueryMetadataHelper();
        QueryDynSourcePlugIn plugin = new QueryDynSourcePlugIn();
        plugin.setView(view);
        Map<String, List<Map<String, Object>>> relationConditionCache = this.buildQueryRelationConditionCache(ctsQueryDynSource);
        view.getPageCache().put("QueryDynSourcePlugInCache", SerializationUtils.toJsonString(relationConditionCache));
        Map<String, Object> fromMetaDataMap = MetadataUtils.getDesignerMetadata(ctsQueryDynSource.getString("mainentityalias"));
        Map<String, Object> ops = this.buildOps(fromMetaDataMap);
        view.getPageCache().put("operations_control_val", SerializationUtils.toJsonString((Object)ops.get("operations_control_val")));
        view.getPageCache().put("permission_control_val", null);
        view.getPageCache().put("PermissionControl", SerializationUtils.toJsonString(this.getQueryControlPermCache()));
        view.getPageCache().put("PermissionDimension", SerializationUtils.toJsonString(this.getQueryPermissionPermCache()));
        dataModel.setValue("group", (Object)queryMetadataGenParam.getCurrentUnitId());
        queryMetadataHelper.saveQueryMetadata(plugin, dataModel);
    }

    private Map<String, Object> getQueryControlPermCache() {
        HashMap<String, Object> permissionControl = new HashMap<String, Object>();
        permissionControl.put("_Type_", "PermissionControl");
        permissionControl.put("Id", Uuid8.generateShortUuid());
        permissionControl.put("Key", "PermissionControl");
        permissionControl.put("Name", ResManager.loadKDString((String)"\u63a7\u5236\u529f\u80fd\u6743\u9650", (String)"DynamicMetadataApplicationServiceImpl_0", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
        permissionControl.put("ControlFunction", false);
        permissionControl.put("ForbidDataPerm", false);
        permissionControl.put("AnonymousUserControl", false);
        HashMap<String, Object> oppara = new HashMap<String, Object>();
        oppara.put("value", permissionControl);
        return oppara;
    }

    private Map<String, Object> getQueryPermissionPermCache() {
        HashMap<String, String> permissionDIM = new HashMap<String, String>();
        permissionDIM.put("_Type_", "PermissionDimension");
        permissionDIM.put("DataDimension", "");
        permissionDIM.put("DataDimensionField", "");
        permissionDIM.put("DataAssistDimension", "");
        permissionDIM.put("DimensionControl", "DIM_NULL");
        permissionDIM.put("DataAssistDimensionField", "");
        permissionDIM.put("Key", "PermissionDimension");
        permissionDIM.put("Name", ResManager.loadKDString((String)"\u7ef4\u5ea6\u63a7\u5236", (String)"DynamicMetadataApplicationServiceImpl_1", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
        permissionDIM.put("PublishApps", "[]");
        HashMap<String, Object> permissionDIMPara = new HashMap<String, Object>();
        permissionDIMPara.put("value", permissionDIM);
        return permissionDIMPara;
    }

    private Map<String, List<Map<String, Object>>> buildQueryRelationConditionCache(DynamicObject ctsQueryDynSource) {
        HashMap queryDataMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObjectCollection queryRelationCollection = ctsQueryDynSource.getDynamicObjectCollection("queryrelationenrtry");
        DynamicObjectCollection conditionCollection = ctsQueryDynSource.getDynamicObjectCollection("queryrelaconditionentry");
        for (int i = 0; i < queryRelationCollection.size(); ++i) {
            DynamicObject queryRelation = (DynamicObject)queryRelationCollection.get(i);
            DynamicObject condition = (DynamicObject)conditionCollection.get(i);
            ArrayList cons = Lists.newArrayListWithExpectedSize((int)1);
            String parentNumber = queryRelation.getString("parententityalias");
            HashMap<String, Object> conditionMap = new HashMap<String, Object>(16);
            conditionMap.put("parentField", condition.get("relaparententityprop"));
            conditionMap.put("conditionField", condition.get("relaconditiontype"));
            conditionMap.put("childField", condition.get("relachildentityprop"));
            cons.add(conditionMap);
            String childEntityNumber = queryRelation.getString("childentitynumber");
            queryDataMap.put(parentNumber + ":" + childEntityNumber, cons);
        }
        return queryDataMap;
    }

    private Map<String, Object> buildOps(Map<String, Object> sourceMetaData) {
        DesignMetadataParser sourceDesignMetadataParser = new DesignMetadataParser(sourceMetaData);
        List<Map<String, Object>> editParamList = sourceDesignMetadataParser.getEntityMetadata();
        ArrayList<Map> operationListMap = new ArrayList<Map>();
        ArrayList<Map> curPermList = new ArrayList<Map>();
        List entityOperationList = (List)editParamList.get(0).get("Operations");
        List permissionItemsList = (List)editParamList.get(0).get("PermissionItems");
        if (entityOperationList != null) {
            List<String> innerOperationKeysList = Arrays.asList(CtsQueryDynSourceConstants.INNER_OPERATION_KEYS);
            ArrayList<String> innerPermissionKeysList = new ArrayList<String>();
            for (Map permMap : entityOperationList) {
                if (!innerOperationKeysList.contains(permMap.get("OperationType"))) continue;
                operationListMap.add(permMap);
                innerPermissionKeysList.add((String)permMap.get("PermissionItemId"));
            }
            if (permissionItemsList != null) {
                for (Map permMap : permissionItemsList) {
                    if (!innerPermissionKeysList.contains(permMap.get("ItemId"))) continue;
                    curPermList.add(permMap);
                }
            }
        }
        return ImmutableMap.builder().put((Object)"operations_control_val", operationListMap).put((Object)"permission_control_val", curPermList).build();
    }

    private FormShowParameter buildCtsQueryDynFormShowParameter(QueryMetadataGenParam queryMetadataGenParam) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cts_querydynsource");
        parameter.setAppId("cts");
        parameter.setCustomParam("currentBizAppId", (Object)BizAppServiceHelp.getAppIdByAppNumber((String)queryMetadataGenParam.getCurrentBizAppNumber()));
        parameter.setCustomParam("currentUnitId", (Object)queryMetadataGenParam.getCurrentUnitId());
        return parameter;
    }
}

