/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.entity.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IMetadataEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.bo.MetadataBo;
import kd.hdtc.hrdbs.business.domain.metadata.impl.util.MetadataUtils;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.QFilterBuilder;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class MetadataEntityServiceImpl
implements IMetadataEntityService {
    private static final Log LOG = LogFactory.getLog(MetadataEntityServiceImpl.class);
    private static final String DEFAULT_UNIT_NUMBER = "_default";
    private final String DEFAULT_UNIT_NAME = ResManager.loadKDString((String)"\u9ed8\u8ba4\u5206\u7ec4", (String)"MetadataEntityServiceImpl_0", (String)"hdtc-hrdbs-business", (Object[])new Object[0]);

    @Override
    public void saveAppUnit(String formId, String bizUnitId, String bizAppId) {
        LOG.info("save biz unit start, formId = {}, bizUnitId = {}, bizAppId = {}", new Object[]{formId, bizAppId, bizAppId});
        this.deleteBizUnit(formId);
        this.saveBizUnit(formId, bizUnitId, bizAppId);
        this.saveAppMeta(bizUnitId, bizAppId);
    }

    private void saveBizUnit(String formId, String bizUnitId, String bizAppId) {
        DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
        dObject.set("bizapp", (Object)bizAppId);
        dObject.set("bizunit", (Object)bizUnitId);
        dObject.set("form", (Object)formId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
    }

    private void saveAppMeta(String bizUnitId, String bizAppId) {
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)bizAppId);
        List appFunctionPackets = appMetadata.getAppFunctionPackets();
        for (AppFunctionPacketElement appFunctionPacket : appFunctionPackets) {
            if (!kd.hdtc.hrdbs.common.util.StringUtils.equals((String)bizUnitId, (String)appFunctionPacket.getId())) continue;
            return;
        }
        AppFunctionPacketElement appFunctionPacketElement = this.createAppFunctionPacketElement(bizUnitId, this.getMaxUnitSeq(appFunctionPackets));
        appFunctionPackets.add(appFunctionPacketElement);
        AppMetaServiceHelper.save((AppMetadata)appMetadata);
    }

    private AppFunctionPacketElement createAppFunctionPacketElement(String bizUnitId, short seq) {
        AppFunctionPacketElement appFunctionPacketElement = AppMetaServiceHelper.CreateBlankAppFunctionPacketElement();
        appFunctionPacketElement.setId(bizUnitId);
        appFunctionPacketElement.setName(new LocaleString(this.DEFAULT_UNIT_NAME));
        appFunctionPacketElement.setNumber(ISVServiceHelper.getISVInfo().getId() + DEFAULT_UNIT_NUMBER);
        appFunctionPacketElement.setSeq(seq);
        appFunctionPacketElement.setLeaf("false");
        appFunctionPacketElement.setParentName("");
        appFunctionPacketElement.setDescription(new LocaleString(""));
        return appFunctionPacketElement;
    }

    private short getMaxUnitSeq(List<AppFunctionPacketElement> appFunctionPackets) {
        if (CollectionUtils.isEmpty(appFunctionPackets)) {
            return 1;
        }
        appFunctionPackets.sort((value1, value2) -> value2.getSeq() - value1.getSeq());
        return (short)(appFunctionPackets.get(0).getSeq() + 1);
    }

    private void deleteBizUnit(String formId) {
        QFilter formIdQFilter = new QFilter("form", "=", (Object)formId);
        QFilter[] filters = new QFilter[]{formIdQFilter};
        DeleteServiceHelper.delete((String)"bos_devportal_unitrelform", (QFilter[])filters);
    }

    @Override
    public Map<String, Object> save(Map<String, Object> metadataMap) {
        return MetadataUtils.save(metadataMap);
    }

    @Override
    public String getExtMetaObject(String entityNumber) {
        return MetadataUtils.getExtMetaNumber(entityNumber);
    }

    @Override
    public Map<String, Object> getDesignMetadata(String entityNumber) {
        return MetadataUtils.getDesignerMetadata(entityNumber);
    }

    @Override
    public Map<String, Object> createDesignMetadata(Map<String, Object> param) {
        return MetadataUtils.createBlankModel(param);
    }

    @Override
    public AppInfo getAppInfoByEntityNumber(String number) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)number);
        return EntityMetadataCache.getAppInfo((String)dataEntityType.getAppId());
    }

    @Override
    public AppInfo getAppInfoByEntityId(String id) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityTypeById((String)id);
        return EntityMetadataCache.getAppInfo((String)dataEntityType.getAppId());
    }

    @Override
    public List<MainEntityType> getEntityTypeList(String number) {
        return MetadataUtils.getEntityTypeList(number);
    }

    @Override
    public AbstractMetadata loadMeta(String entityNumber) {
        return null;
    }

    @Override
    public Map<String, Date> getMetadataLatestModifyTime(Set<String> entityNumberSet) {
        return null;
    }

    @Override
    public Map<String, MetadataBo> getMetadataBoMap(Set<String> entityNumberSet) {
        return null;
    }

    @Override
    public boolean deleteMetadata(String formId, String bizAppId, String bizUnitId) {
        return false;
    }

    @Override
    public boolean isExists(String entityNumber) {
        return MetadataUtils.checkNumber(entityNumber);
    }

    @Override
    public boolean isNotExists(String entityNumber) {
        return false;
    }

    @Override
    public String getRefBasedataNumber(String entityNumber, String propNumber) {
        List<MainEntityType> entityTypeList = this.getEntityTypeList(entityNumber);
        String entityId = null;
        for (MainEntityType entityType : entityTypeList) {
            DynamicProperty property;
            if (!HRStringUtils.equals((String)entityType.getName(), (String)entityNumber) || (property = this.findProperty(propNumber, entityType)) == null) continue;
            if (property instanceof BasedataProp) {
                entityId = ((BasedataProp)property).getBaseEntityId();
                break;
            }
            if (!(property instanceof MulBasedataProp)) continue;
            entityId = ((MulBasedataProp)property).getBaseEntityId();
            break;
        }
        if (kd.hdtc.hrdbs.common.util.StringUtils.isNotEmpty(entityId)) {
            return MetadataUtils.getMainEntityType(entityId).getName();
        }
        return null;
    }

    @Override
    public AppInfo getIsvExtAppInfo(String sourceAppNumber) {
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)sourceAppNumber);
        if (!ISVServiceHelper.isKingdeeISV()) {
            Map isvDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"number,inheritpath", (QFilter[])this.buildIsvQFilter(appId));
            if (CollectionUtils.isNotEmpty((Map)isvDynamicObjectMap)) {
                String number = isvDynamicObjectMap.entrySet().stream().map(it -> (DynamicObject)it.getValue()).sorted(Comparator.comparing(it -> it.getString("inheritpath"))).findFirst().map(it -> it.getString("number")).orElse("");
                appId = BizAppServiceHelp.getAppIdByAppNumber((String)number);
            } else {
                return null;
            }
        }
        return EntityMetadataCache.getAppInfo((String)appId);
    }

    @Override
    public List<String> getIsvExtAppNumberList(String sourceAppNumber) {
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)sourceAppNumber);
        if (!ISVServiceHelper.isKingdeeISV()) {
            Map isvDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"number,inheritpath", (QFilter[])this.buildIsvQFilter(appId));
            if (CollectionUtils.isNotEmpty((Map)isvDynamicObjectMap)) {
                return isvDynamicObjectMap.entrySet().stream().map(it -> (DynamicObject)it.getValue()).sorted(Comparator.comparing(it -> it.getString("inheritpath"))).map(it -> it.getString("number")).collect(Collectors.toList());
            }
            return Lists.newArrayListWithExpectedSize((int)10);
        }
        return Lists.newArrayList((Object[])new String[]{sourceAppNumber});
    }

    private QFilter[] buildIsvQFilter(String appId) {
        return new QFilterBuilder().append(new QFilter("inheritpath", "like", (Object)(appId + "%"))).append(new QFilter("isv", "=", (Object)ISVServiceHelper.getISVInfo().getId())).build();
    }

    @Override
    public DynamicObject getNewExtAppMeta(String sourceAppNumber) {
        return this.getNewExtAppObj(sourceAppNumber, "_ext");
    }

    @Override
    public DynamicObject getHRExtAppMeta(String sourceAppNumber) {
        return this.getNewExtAppObj(sourceAppNumber, "_exthr");
    }

    private DynamicObject getNewExtAppObj(String sourceAppNumber, String extAppTag) {
        AppInfo sourceAppInfo = EntityMetadataCache.getAppInfo((String)sourceAppNumber);
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)sourceAppInfo.getId(), (String)"bos_devportal_bizapp");
        DynamicObject extAppObj = new HRBaseServiceHelper("bos_devportal_bizapp").generateEmptyDynamicObject();
        if (obj != null) {
            DynamicObject cloudIndustry;
            DataEntityPropertyCollection props = obj.getDataEntityType().getProperties();
            for (IDataEntityProperty prop : props) {
                String propName = prop.getName();
                if ("isv".equals(propName) || "id".equals(propName) || prop instanceof DynamicLocaleProperty) continue;
                if (prop instanceof MuliLangTextProp) {
                    OrmLocaleValue localValue = (OrmLocaleValue)prop.getValue((Object)obj);
                    String val = localValue.getLocaleValue();
                    extAppObj.set(propName, (Object)val);
                    continue;
                }
                Object val = prop.getValue((Object)obj);
                extAppObj.set(propName, val);
            }
            String parentInheritPath = obj.getString("inheritpath");
            String inheritPath = "";
            if (kd.hdtc.hrdbs.common.util.StringUtils.isNotBlank((CharSequence[])new CharSequence[]{parentInheritPath})) {
                if (parentInheritPath.startsWith(",")) {
                    parentInheritPath = parentInheritPath.substring(1);
                }
                inheritPath = parentInheritPath + "," + sourceAppInfo.getId();
            } else {
                inheritPath = sourceAppInfo.getId();
            }
            extAppObj.set("inheritpath", (Object)inheritPath);
            String number = AppReader.getAppNumberById((String)sourceAppInfo.getId());
            number = MetadataEntityServiceImpl.autoExtendedNumber(number, extAppTag);
            number = AppUtils.autoAppNumber((String)sourceAppInfo.getCloudId(), (String)number, (String)extAppTag);
            extAppObj.set("number", (Object)number.toLowerCase());
            extAppObj.set("type", (Object)"2");
            extAppObj.set("parentid", (Object)sourceAppInfo.getId());
            String masterId = sourceAppInfo.getId();
            if (obj != null && kd.hdtc.hrdbs.common.util.StringUtils.isNotBlank((CharSequence[])new CharSequence[]{obj.getString("masterid")})) {
                masterId = obj.getString("masterid");
            }
            extAppObj.set("masterid", (Object)masterId);
            if (kd.hdtc.hrdbs.common.util.StringUtils.isNotBlank((CharSequence[])new CharSequence[]{sourceAppInfo.getCloudId()}) && (cloudIndustry = BusinessDataServiceHelper.loadSingleFromCache((Object)sourceAppInfo.getCloudId(), (String)"bos_devportal_bizcloud", (String)"industry")) != null) {
                String cloudIndustryId = cloudIndustry.get("industry_id").toString();
                extAppObj.set("industry_id", (Object)cloudIndustryId);
            }
        }
        return extAppObj;
    }

    private static String autoExtendedNumber(String number, String tag) {
        String isv = ISVService.getISVInfo().getId();
        number = number.toLowerCase(Locale.ENGLISH);
        if (!"kingdee".equalsIgnoreCase(isv) && StringUtils.isNotBlank((CharSequence)isv) && !number.startsWith(isv.toLowerCase() + "_")) {
            number = isv.toLowerCase() + "_" + number;
        }
        return number + tag;
    }

    @Override
    public Map<String, Object> saveExtAppMeta(DynamicObject extMetadata) {
        Map resultMap = AppMetaServiceHelper.save((DynamicObject)extMetadata);
        return resultMap;
    }

    private DynamicProperty findProperty(String propNumber, MainEntityType entityType) {
        for (Map.Entry subEntityTypeEntry : entityType.getAllEntities().entrySet()) {
            DynamicProperty property = ((EntityType)subEntityTypeEntry.getValue()).getProperty(propNumber);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    @Override
    public Optional<MetadataBo> getIsvMetadataBo(String number) {
        return MetadataUtils.getIsvExtMetadata(Sets.newHashSet((Object[])new String[]{number})).stream().findAny();
    }

    @Override
    public List<MetadataBo> getIsvMetadataBoList(String number) {
        return MetadataUtils.getIsvExtMetadata(Sets.newHashSet((Object[])new String[]{number}));
    }

    @Override
    public String createExtMetadata(String number, String extNumber) {
        String genExtNumber = extNumber;
        return genExtNumber;
    }
}

