/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.AppInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.IDynamicMetadataDomainService;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IMetadataEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.MetaNodeConstants;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataContext;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataSingleNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.IsvInfoHandle;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.load.BaseTemplateMetadataNodeLoader;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.load.CurrentMetadataNodeLoader;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.load.ExtendMetadataNodeLoader;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.load.OriginMetadataNodeLoader;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.load.RefMetadataNodeLoader;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.AppCreateOn;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.ExtMetadataAddOn;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.ListNameAddOn;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.MetadataAddOn;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.MetadataAfterConvertAddOn;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.MetadataNodeClear;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.MetadataNodeHider;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.MetadataNodeModifier;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.RootNodeModifier;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.convert.MidTableGenerateConverter;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.convert.NodeFileNameRepeatConverter;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.convert.NormalGenerateConverter;
import kd.hdtc.hrdbs.business.domain.metadata.impl.util.MetadataUtils;
import kd.hdtc.hrdbs.business.domain.metadata.impl.util.TableUtils;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class DynamicMetadataDomainServiceImpl
implements IDynamicMetadataDomainService {
    private static final Log LOG = LogFactory.getLog(DynamicMetadataDomainServiceImpl.class);
    private static final IMetadataEntityService metadataEntityService = ServiceFactory.getService(IMetadataEntityService.class);
    private static final String SKIP_METADATA_SAVE = "skipMetadataSave";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateMiddleTable(MetadataGenParam metadataGenParam, MetadataGenResult metadataGenResult) {
        try {
            MetadataContext metadataContext = MetadataContext.create(metadataGenParam, metadataGenResult);
            new IsvInfoHandle().handle();
            new OriginMetadataNodeLoader().handle();
            new RefMetadataNodeLoader().handle();
            new MetadataNodeClear().handle();
            new MetadataAddOn().handle();
            new MidTableGenerateConverter().handle();
            new NodeFileNameRepeatConverter().handle();
            new MetadataAfterConvertAddOn().handle();
            new ListNameAddOn().handle();
            if (!this.saveMetadata(metadataContext)) {
                LOG.warn("save metadata error");
                return;
            }
            String parentId = metadataContext.getMetadataGenParam().getBaseParam().getParentId();
            metadataEntityService.saveAppUnit((String)metadataContext.getOriginMetadataNodeMap().get("id"), metadataContext.getMetadataGenParam().getBaseParam().getBizUnitId(), metadataEntityService.getAppInfoByEntityId(parentId).getId());
            this.addVersion(metadataGenResult, metadataContext);
        }
        catch (Exception ex) {
            LOG.error("generate metadata error\u3002 ", (Throwable)ex);
            metadataGenResult.getMsgList().add(ex.getMessage());
            metadataGenResult.setErrorCode(1020);
            metadataGenResult.setSuccess(Boolean.FALSE.booleanValue());
            metadataGenResult.putThrowable((Throwable)ex);
        }
        finally {
            MetadataContext.remove();
        }
    }

    private void addVersion(MetadataGenResult metadataGenResult, MetadataContext metadataContext) {
        String version = Optional.ofNullable(MetadataServiceHelper.getDataEntityType((String)metadataContext.getMetadataGenParam().getBaseParam().getMetadataNumber())).map(MainEntityType::getVersion).orElse(null);
        metadataGenResult.setVersionNumber(version);
    }

    @Override
    public String getOrCreateExtIsvAppId(String appNumber) {
        AppInfo extAppInfo = metadataEntityService.getIsvExtAppInfo(appNumber);
        if (Objects.nonNull(extAppInfo)) {
            return extAppInfo.getAppId();
        }
        DynamicObject newExtAppMeta = metadataEntityService.getNewExtAppMeta(appNumber);
        Map<String, Object> resultMap = metadataEntityService.saveExtAppMeta(newExtAppMeta);
        if (resultMap.size() > 0 && !Boolean.parseBoolean(resultMap.get("success").toString())) {
            throw new HRDBSBizException(resultMap.get("message").toString());
        }
        return newExtAppMeta.getString("number");
    }

    @Override
    public String getOrCreateHRExtIsvAppId(String appNumber) {
        List<String> extAppNumberList = metadataEntityService.getIsvExtAppNumberList(appNumber);
        String existHrAppNumber = extAppNumberList.stream().filter(number -> MetaNodeConstants.HR_APP_SUFFIX_PATTERN.matcher((CharSequence)number).find()).findFirst().orElse("");
        if (StringUtils.isNotBlank((CharSequence[])new CharSequence[]{existHrAppNumber})) {
            return existHrAppNumber;
        }
        String sourceAppId = Optional.ofNullable(extAppNumberList).filter(list -> ObjectUtils.isNotEmpty((Object)list)).filter(list -> list.size() > 0).map(list -> (String)list.get(list.size() - 1)).orElse(appNumber);
        DynamicObject newExtAppMeta = metadataEntityService.getHRExtAppMeta(sourceAppId);
        Map<String, Object> resultMap = metadataEntityService.saveExtAppMeta(newExtAppMeta);
        if (resultMap.size() > 0 && !Boolean.parseBoolean(resultMap.get("success").toString())) {
            throw new HRDBSBizException(resultMap.get("message").toString());
        }
        return newExtAppMeta.getString("number");
    }

    private boolean saveMetadata(MetadataContext metadataContext) {
        Boolean skip;
        Boolean bl = skip = metadataContext.getMetadataGenParam().getOtherInfo(SKIP_METADATA_SAVE) == null ? Boolean.FALSE : (Boolean)metadataContext.getMetadataGenParam().getOtherInfo(SKIP_METADATA_SAVE);
        if (skip.booleanValue()) {
            LOG.info("unit test in");
            return false;
        }
        MetadataGenResult metadataGenResult = metadataContext.getMetadataGenResult();
        Map<String, Object> result = metadataEntityService.save(metadataContext.getOriginMetadataNodeMap());
        boolean success = (Boolean)result.getOrDefault("success", Boolean.FALSE);
        if (!success) {
            metadataGenResult.setSuccess(success);
            metadataGenResult.setErrorCode(1010);
            List errorList = (List)result.get("errors");
            try {
                if (CollectionUtils.isNotEmpty((Collection)errorList)) {
                    metadataGenResult.getMsgList().add(JsonUtils.toString((Object)errorList));
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                metadataGenResult.getMsgList().add(errorList.toString());
            }
            return false;
        }
        MetadataSingleNode rootNode = metadataContext.getRootNode();
        metadataGenResult.setEntityId(rootNode.getId());
        metadataGenResult.setEntityNumber(rootNode.getNumber());
        EntityMetadataCache.removeDataEntityTypeLocalCache((String)metadataContext.getMetadataGenParam().getBaseParam().getMetadataNumber());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateNormalMetadata(MetadataGenParam metadataGenParam, MetadataGenResult metadataGenResult) {
        try {
            MetadataContext metadataContext = MetadataContext.create(metadataGenParam, metadataGenResult);
            new IsvInfoHandle().handle();
            new OriginMetadataNodeLoader().load();
            new BaseTemplateMetadataNodeLoader().load();
            new CurrentMetadataNodeLoader().load();
            new AppCreateOn().handle();
            new RootNodeModifier().handle();
            new MetadataNodeHider().handle();
            new MetadataNodeModifier().handle();
            new MetadataAddOn().handle();
            new NormalGenerateConverter().handle();
            new ListNameAddOn().handle();
            if (!this.saveMetadata(metadataContext)) {
                LOG.warn("save metadata error");
                return;
            }
            BaseParam baseParam = metadataContext.getMetadataGenParam().getBaseParam();
            metadataEntityService.saveAppUnit((String)metadataContext.getOriginMetadataNodeMap().get("id"), baseParam.getBizUnitId(), BizAppServiceHelp.getAppIdByAppNumber((String)baseParam.getAppId()));
            this.addVersion(metadataGenResult, metadataContext);
        }
        catch (Exception ex) {
            LOG.error("generate metadata error\u3002 ", (Throwable)ex);
            metadataGenResult.getMsgList().add(ex.getMessage());
            metadataGenResult.setErrorCode(1020);
            metadataGenResult.setSuccess(Boolean.FALSE.booleanValue());
            metadataGenResult.putThrowable((Throwable)ex);
        }
        finally {
            MetadataContext.remove();
        }
    }

    @Override
    public void deleteMetadata(String number, boolean dropTable) {
        String id = MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isNotEmpty((String)id)) {
            try {
                List<MainEntityType> entityTypeList = null;
                if (dropTable) {
                    entityTypeList = MetadataUtils.getEntityTypeList(number);
                }
                DevportalUtil.deletePage((String)id, null, (Boolean)false, null, (String)"0", (String)"PAGE_TYPE", (String)"bos_formmeta");
                if (CollectionUtils.isNotEmpty(entityTypeList)) {
                    for (MainEntityType mainEntityType : entityTypeList) {
                        TableUtils.dropTable(mainEntityType.getDBRouteKey(), mainEntityType.getAlias());
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("deleteMetadata error\u3002 ", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateExtendMetadata(MetadataGenParam metadataGenParam, MetadataGenResult metadataGenResult) {
        try {
            MetadataContext metadataContext = MetadataContext.create(metadataGenParam, metadataGenResult);
            new IsvInfoHandle().handle();
            new ExtendMetadataNodeLoader().handle();
            new BaseTemplateMetadataNodeLoader().load();
            new CurrentMetadataNodeLoader().load();
            new AppCreateOn().handle();
            new RootNodeModifier().handle();
            new MetadataNodeHider().handle();
            new MetadataNodeModifier().handle();
            new ExtMetadataAddOn().handle();
            new NormalGenerateConverter().handle();
            new ListNameAddOn().handle();
            if (!this.saveMetadata(metadataContext)) {
                LOG.warn("save metadata error");
                return;
            }
            BaseParam baseParam = metadataContext.getMetadataGenParam().getBaseParam();
            metadataEntityService.saveAppUnit((String)metadataContext.getOriginMetadataNodeMap().get("id"), baseParam.getBizUnitId(), BizAppServiceHelp.getAppIdByAppNumber((String)baseParam.getAppId()));
        }
        catch (Exception ex) {
            LOG.error("generate metadata error\u3002 ", (Throwable)ex);
            metadataGenResult.getMsgList().add(ex.getMessage());
            metadataGenResult.setErrorCode(1020);
            metadataGenResult.setSuccess(Boolean.FALSE.booleanValue());
            metadataGenResult.putThrowable((Throwable)ex);
        }
        finally {
            MetadataContext.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateExtendEntryMetadata(MetadataGenParam metadataGenParam, MetadataGenResult metadataGenResult) {
        try {
            MetadataContext metadataContext = MetadataContext.create(metadataGenParam, metadataGenResult);
            new IsvInfoHandle().handle();
            new ExtendMetadataNodeLoader().handle();
            new BaseTemplateMetadataNodeLoader().load();
            new CurrentMetadataNodeLoader().load();
            new AppCreateOn().handle();
            new MetadataNodeHider().handle();
            new MetadataNodeModifier().handle();
            new MetadataAddOn().handle();
            new NormalGenerateConverter().handle();
            new ListNameAddOn().handle();
            if (!this.saveMetadata(metadataContext)) {
                LOG.warn("save metadata error");
                return;
            }
            BaseParam baseParam = metadataContext.getMetadataGenParam().getBaseParam();
            metadataEntityService.saveAppUnit((String)metadataContext.getOriginMetadataNodeMap().get("id"), baseParam.getBizUnitId(), BizAppServiceHelp.getAppIdByAppNumber((String)baseParam.getAppId()));
        }
        catch (Exception ex) {
            LOG.error("generate metadata error\u3002 ", (Throwable)ex);
            metadataGenResult.getMsgList().add(ex.getMessage());
            metadataGenResult.setErrorCode(1020);
            metadataGenResult.setSuccess(Boolean.FALSE.booleanValue());
            metadataGenResult.putThrowable((Throwable)ex);
        }
        finally {
            MetadataContext.remove();
        }
    }
}

