/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.domain.metadata.IDynamicQueryDomainService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.QueryConfigGenerator;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.QueryContext;
import kd.hdtc.hrdbs.business.domain.metadata.impl.query.list.QueryListGenerator;
import kd.hdtc.hrdbs.common.hibernate.utils.ValidationUtils;
import kd.hdtc.hrdbs.common.pojo.metadata.ParamValidateResult;
import kd.hdtc.hrdbs.common.pojo.query.QueryEntity;
import kd.hdtc.hrdbs.common.pojo.query.QueryField;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenParam;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenResult;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.LogUtils;

public class DynamicQueryDomainService
implements IDynamicQueryDomainService {
    private static final Log LOG = LogFactory.getLog(DynamicQueryDomainService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryGenResult generatePlatformQuery(QueryGenParam queryGenParam) {
        LOG.info("generate query start, param = {}", (Object)queryGenParam);
        QueryGenResult queryGenResult = QueryGenResult.success();
        QueryContext.create(queryGenParam, queryGenResult);
        try {
            DynamicQueryDomainService.validateQueryGenParam(queryGenParam);
            if (!queryGenResult.isSuccess()) {
                String msg = "param validate error :" + String.join((CharSequence)",", queryGenResult.getMsgList());
                LOG.warn(msg);
                QueryGenResult queryGenResult2 = queryGenResult;
                return queryGenResult2;
            }
            LogUtils.printTimeCostLog((String)ResManager.loadKDString((String)"\u67e5\u8be2\u914d\u7f6e\u751f\u6210", (String)"DynamicQueryDomainService_0", (String)"hdtc-hrdbs-business", (Object[])new Object[0]), () -> new QueryConfigGenerator().generate());
            if (queryGenResult.isSuccess()) {
                LogUtils.printTimeCostLog((String)ResManager.loadKDString((String)"\u67e5\u8be2\u5217\u8868\u751f\u6210", (String)"DynamicQueryDomainService_1", (String)"hdtc-hrdbs-business", (Object[])new Object[0]), () -> new QueryListGenerator().generate());
            }
        }
        finally {
            QueryContext.remove();
        }
        return queryGenResult;
    }

    private static void validateQueryGenParam(QueryGenParam queryGenParam) {
        DynamicQueryDomainService.validate(queryGenParam);
        DynamicQueryDomainService.validate(queryGenParam.getQueryList());
        for (QueryEntity queryEntity : queryGenParam.getSubQueryEntityList()) {
            DynamicQueryDomainService.validate(queryEntity);
        }
        for (QueryField queryField : queryGenParam.getQueryFieldList()) {
            DynamicQueryDomainService.validate(queryField);
        }
        Optional.ofNullable(queryGenParam.getQueryList()).map(it -> it.getQueryFieldList()).ifPresent(fieldList -> DynamicQueryDomainService.validate(fieldList));
    }

    private static void validate(Object obj) {
        if (obj == null) {
            return;
        }
        QueryGenResult queryGenResult = QueryContext.get().getQueryGenResult();
        List validateList = ValidationUtils.validate((Object)obj, null);
        if (CollectionUtils.isNotEmpty((Collection)validateList)) {
            queryGenResult.setSuccess(Boolean.FALSE.booleanValue());
            queryGenResult.setErrorCode(1000);
            List msgList = queryGenResult.getMsgList();
            for (ParamValidateResult result : validateList) {
                msgList.add(result.getMsg());
            }
        }
    }
}

