/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl;

import com.google.common.base.Joiner;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hdtc.hrdbs.business.domain.metadata.IMetaDataPresetDataDomainService;
import kd.hdtc.hrdbs.business.model.MetaDataConfigBo;
import kd.hdtc.hrdbs.business.model.MultiEntryDecodeBo;
import kd.hdtc.hrdbs.business.model.MultiTableDecodeBo;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class MetaDatePresetDataDomainServiceImpl
implements IMetaDataPresetDataDomainService {
    private final Map<String, List<Object>> pkDataMap = new HashMap<String, List<Object>>();
    private static final String KEY_EMPTY = "";
    private static final String WHERE_STRING = " where ";

    @Override
    public String getPresetDataString(String entityNumber, String qFilter) {
        List<MetaDataConfigBo> metaList = this.buildMetaConfigBoList(entityNumber, qFilter);
        if (CollectionUtils.isEmpty(metaList)) {
            return KEY_EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (MetaDataConfigBo dataConfig : metaList) {
            Map<String, List<IDataEntityProperty>> extTableProMap = dataConfig.getPropList().stream().filter(pro -> StringUtils.isNotEmpty((String)pro.getTableGroup())).collect(Collectors.groupingBy(IDataEntityProperty::getTableGroup));
            this.appendSql(dataConfig, stringBuilder);
            if (!CollectionUtils.isNotEmpty(extTableProMap)) continue;
            this.handleExtTable(stringBuilder, dataConfig, extTableProMap);
        }
        return stringBuilder.toString();
    }

    private void handleExtTable(StringBuilder stringBuilder, MetaDataConfigBo dataConfig, Map<String, List<IDataEntityProperty>> extTableProMap) {
        List extMainPkProList = dataConfig.getPkList().stream().filter(pro -> !"pid".equals(pro.getName())).collect(Collectors.toList());
        for (Map.Entry<String, List<IDataEntityProperty>> extTableProEntry : extTableProMap.entrySet()) {
            String extTableSuffix = extTableProEntry.getKey();
            List<IDataEntityProperty> proList = extTableProEntry.getValue();
            proList.addAll(extMainPkProList);
            MetaDataConfigBo extMetaDataConfigBo = new MetaDataConfigBo(dataConfig.getName(), dataConfig.getAlias() + "_" + extTableSuffix.toUpperCase(Locale.ROOT), dataConfig.getAppId(), dataConfig.getDisplayName(), dataConfig.getDbRouteKey());
            extMetaDataConfigBo.setPropList(proList);
            extMetaDataConfigBo.getPkList().addAll(extMainPkProList);
            extMetaDataConfigBo.setWhere(this.getWhere(dataConfig));
            extMetaDataConfigBo.setTableGroup(extTableSuffix);
            this.appendSql(extMetaDataConfigBo, stringBuilder);
        }
    }

    private List<MetaDataConfigBo> buildMetaConfigBoList(String entityNumber, String qFilter) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        if (null == entityType) {
            return null;
        }
        ArrayList<MetaDataConfigBo> metaList = new ArrayList<MetaDataConfigBo>(16);
        MetaDataConfigBo metaDataConfigBo = new MetaDataConfigBo(entityType, null);
        metaDataConfigBo.setWhere(qFilter);
        MultiTableDecodeBo.addMetaDataConfig(metaDataConfigBo, metaList, null);
        MultiTableDecodeBo multiTableDecodeBo = new MultiTableDecodeBo(metaList);
        multiTableDecodeBo.parseMainMetaData(metaDataConfigBo);
        if (multiTableDecodeBo.isContainMulTab(metaDataConfigBo, new EntryProp(), false)) {
            new MultiEntryDecodeBo(metaList).addMetaData(metaDataConfigBo);
        }
        return metaList;
    }

    private void appendSql(MetaDataConfigBo metaDataConfigBo, StringBuilder stringBuilder) {
        String where = this.getWhere(metaDataConfigBo);
        String alias = metaDataConfigBo.getAlias();
        if (alias == null || alias.length() == 0 || KEY_EMPTY.equals(where)) {
            return;
        }
        String sql = "select " + this.getFieldKey(metaDataConfigBo) + " from " + alias + " " + where;
        DB.query((DBRoute)DBRoute.of((String)metaDataConfigBo.getDbRouteKey()), (String)sql, resultSet -> {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                this.appendDeleteSQL(stringBuilder, resultSetMetaData, metaDataConfigBo, resultSet);
                this.appendInsertSql(resultSet, resultSetMetaData, stringBuilder, metaDataConfigBo);
            }
            return KEY_EMPTY;
        });
    }

    private String getWhere(MetaDataConfigBo metaDataConfigBo) {
        String where = metaDataConfigBo.getWhere();
        if (StringUtils.isNotEmpty((String)where)) {
            if (where.contains(WHERE_STRING)) {
                return where;
            }
            return WHERE_STRING + where;
        }
        if (StringUtils.isEmpty((String)metaDataConfigBo.getTableGroup())) {
            return this.getRefWhere(metaDataConfigBo);
        }
        return this.getExtendTableWhere(metaDataConfigBo);
    }

    private String getRefWhere(MetaDataConfigBo metaDataConfigBo) {
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, String> refMap = metaDataConfigBo.getReferenceMap();
        boolean isAppendFlag = false;
        for (Map.Entry<String, String> entry : refMap.entrySet()) {
            List<Object> list;
            String value = entry.getValue().toUpperCase(Locale.ROOT);
            String key = entry.getKey();
            if (StringUtils.isEmpty((String)value) || !key.contains(".") || CollectionUtils.isEmpty(list = this.pkDataMap.get(value))) continue;
            String field = key.substring(key.lastIndexOf(46) + 1);
            if (stringBuilder.length() == 0) {
                stringBuilder.append(WHERE_STRING);
            } else {
                stringBuilder.append(" and ");
            }
            String str = Joiner.on((String)",").join(list);
            stringBuilder.append(field).append(" in(").append(str).append(") ");
            isAppendFlag = true;
        }
        if (!isAppendFlag) {
            return KEY_EMPTY;
        }
        return stringBuilder.toString();
    }

    private String getExtendTableWhere(MetaDataConfigBo metaDataConfigBo) {
        String tableGroup = "_" + metaDataConfigBo.getTableGroup();
        String tableName = metaDataConfigBo.getAlias();
        if (StringUtils.isNotEmpty((String)tableName) && tableName.contains(tableGroup)) {
            tableName = tableName.substring(0, tableName.indexOf(tableGroup));
        }
        if (CollectionUtils.isEmpty(metaDataConfigBo.getPkList())) {
            return KEY_EMPTY;
        }
        String filed = metaDataConfigBo.getPkList().get(0).getAlias();
        String key = (metaDataConfigBo.getAppId() + "." + tableName + "." + metaDataConfigBo.getPkList().get(0).getAlias()).toUpperCase(Locale.ROOT);
        List<Object> list = this.pkDataMap.get(key);
        if (CollectionUtils.isEmpty(list)) {
            return KEY_EMPTY;
        }
        return WHERE_STRING + filed + " in(" + Joiner.on((String)",").join(list) + ")";
    }

    private String getFieldKey(MetaDataConfigBo metaDataConfigBo) {
        List filedNameList = metaDataConfigBo.getPropList().stream().filter(Objects::nonNull).filter(arg -> !this.isIgnoreField(metaDataConfigBo, (IDataEntityProperty)arg, metaDataConfigBo.getTableGroup())).map(arg -> arg.getAlias().toLowerCase(Locale.ROOT)).distinct().collect(Collectors.toList());
        String tableGroup = metaDataConfigBo.getTableGroup();
        if (StringUtils.isNotEmpty((String)tableGroup)) {
            filedNameList.addAll(metaDataConfigBo.getPkList().stream().filter(Objects::nonNull).filter(arg -> !"pid".equals(arg.getName())).map(arg -> arg.getAlias().toLowerCase(Locale.ROOT)).distinct().collect(Collectors.toList()));
        }
        return String.join((CharSequence)",", filedNameList);
    }

    private boolean isIgnoreField(MetaDataConfigBo config, IDataEntityProperty property, String tableGroup) {
        boolean mulCondition;
        if (property == null || StringUtils.isEmpty((String)property.getAlias())) {
            return true;
        }
        boolean bl = mulCondition = property.isDbIgnore() && property instanceof MuliLangTextProp && !config.getAlias().endsWith("_L");
        if (mulCondition) {
            return true;
        }
        if (property instanceof MulBasedataProp) {
            return true;
        }
        List list = config.getPropList().stream().filter(arg -> arg instanceof DynamicComplexProperty).map(arg -> (DynamicComplexProperty)arg).collect(Collectors.toList());
        if (list.stream().anyMatch(arg -> property.getName().equalsIgnoreCase(arg.getRefIdPropName()))) {
            return true;
        }
        return !this.isStrEquals(tableGroup, property.getTableGroup());
    }

    private boolean isStrEquals(String str, String arg) {
        if (str == null) {
            return arg == null;
        }
        return str.equalsIgnoreCase(arg);
    }

    private void appendDeleteSQL(StringBuilder stringBuilder, ResultSetMetaData resultSetMetaData, MetaDataConfigBo metaDataConfigBo, ResultSet resultSet) throws SQLException {
        List<IDataEntityProperty> list = metaDataConfigBo.getPkList();
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        String pkName = list.get(0).getAlias();
        int count = resultSetMetaData.getColumnCount();
        Object value = null;
        for (int i = 1; i <= count; ++i) {
            if (!pkName.equalsIgnoreCase(resultSetMetaData.getColumnName(i))) continue;
            value = resultSet.getObject(i);
        }
        if (value == null) {
            return;
        }
        stringBuilder.append("DELETE FROM ").append(metaDataConfigBo.getAlias().toUpperCase(Locale.ROOT)).append(" WHERE ");
        stringBuilder.append(pkName.toLowerCase(Locale.ROOT)).append(" =");
        String key = (metaDataConfigBo.getAppId() + "." + metaDataConfigBo.getAlias() + "." + pkName).toUpperCase(Locale.ROOT);
        List<Object> pkValueList = this.pkDataMap.get(key);
        if (CollectionUtils.isEmpty(pkValueList)) {
            pkValueList = new ArrayList<Object>();
        }
        if (list.get(0) instanceof VarcharProp) {
            pkValueList.add("'" + value.toString().trim() + "'");
            stringBuilder.append(" '").append(value).append("';\n");
        } else {
            pkValueList.add(value);
            stringBuilder.append(value).append(";\n");
        }
        this.pkDataMap.put(key, pkValueList);
    }

    private void appendInsertSql(ResultSet resultSet, ResultSetMetaData resultSetMetaData, StringBuilder stringBuilder, MetaDataConfigBo metaDataConfigBo) throws SQLException {
        stringBuilder.append("INSERT INTO ").append(metaDataConfigBo.getAlias()).append('(');
        int size = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= size; ++i) {
            String columnName = resultSetMetaData.getColumnName(i);
            if (i == size) {
                stringBuilder.append(columnName).append(')');
                continue;
            }
            stringBuilder.append(columnName).append(',');
        }
        stringBuilder.append(" VALUES(");
        this.getInsertSqlByResultMetaData(resultSet, resultSetMetaData, stringBuilder);
    }

    private void getInsertSqlByResultMetaData(ResultSet rs, ResultSetMetaData rsmd, StringBuilder insertSql) throws SQLException {
        int size = rsmd.getColumnCount();
        block6: for (int i = 1; i <= size; ++i) {
            int columnType = rsmd.getColumnType(i);
            String columnName = rsmd.getColumnName(i);
            switch (columnType) {
                case -5: 
                case 2: 
                case 4: 
                case 5: {
                    long columnValue = rs.getLong(i);
                    if (i == size) {
                        insertSql.append(columnValue).append(");\n");
                        continue block6;
                    }
                    insertSql.append(columnValue).append(',');
                    continue block6;
                }
                case 3: {
                    double columnValue = rs.getDouble(i);
                    if (i == size) {
                        insertSql.append(columnValue).append(");\n");
                        continue block6;
                    }
                    insertSql.append(columnValue).append(',');
                    continue block6;
                }
                case -9: 
                case 1: 
                case 12: {
                    this.initString(rs, insertSql, i, size, columnName);
                    continue block6;
                }
                case 91: 
                case 93: {
                    String tmpVal;
                    if (i == size) {
                        Timestamp timeVal = rs.getTimestamp(i);
                        if (timeVal != null) {
                            tmpVal = ((Object)timeVal).toString();
                            tmpVal = tmpVal.substring(0, tmpVal.lastIndexOf(46));
                            insertSql.append("{ts'").append(tmpVal).append("'});\n");
                            continue block6;
                        }
                        insertSql.append(timeVal).append(");\n ");
                        continue block6;
                    }
                    Timestamp timeVal = rs.getTimestamp(i);
                    if (timeVal != null) {
                        tmpVal = ((Object)timeVal).toString();
                        tmpVal = tmpVal.substring(0, tmpVal.lastIndexOf(46));
                        insertSql.append("{ts'").append(tmpVal).append("'},");
                        continue block6;
                    }
                    insertSql.append(timeVal).append(',');
                    continue block6;
                }
                default: {
                    this.initString(rs, insertSql, i, size, columnName);
                }
            }
        }
    }

    private void initString(ResultSet rs, StringBuilder insertSql, int i, int size, String columnName) throws SQLException {
        if (i == size) {
            if (rs.getString(i) == null) {
                insertSql.append("null").append(");\n ");
            } else {
                String columnValue = rs.getString(i);
                if (columnValue != null && columnValue.contains("'")) {
                    columnValue = columnValue.replace("'", "' '");
                } else if (StringUtils.isBlank((CharSequence)columnValue)) {
                    columnValue = " ";
                }
                insertSql.append(" '").append(columnValue).append("');\n");
            }
        } else if (rs.getString(i) == null) {
            insertSql.append("null,");
        } else {
            String columnValue = rs.getString(i);
            if (columnValue != null && columnValue.contains("'")) {
                columnValue = columnValue.replace("'", "' '");
            } else if (StringUtils.isBlank((CharSequence)columnValue)) {
                columnValue = " ";
            }
            insertSql.append(" '").append(columnValue).append("',");
        }
    }
}

