/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.IMetadataLogDomainService;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IMetadataCreateLogEntityService;
import kd.hdtc.hrdbs.common.enums.MetadataOperateStatusEnum;
import kd.hdtc.hrdbs.common.enums.MetadataOperateTypeEnum;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;

public class MetadataLogDomainServiceImpl
implements IMetadataLogDomainService {
    private static final Log LOG = LogFactory.getLog(MetadataLogDomainServiceImpl.class);
    private static final String SELECT_PROPERTIES = "id,objnumber,operatetype,operatestatus,errormsg,errormsg_tag,starttime,endtime";
    private final IMetadataCreateLogEntityService metadataCreateLogEntityService = ServiceFactory.getService(IMetadataCreateLogEntityService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long recordLog(String metadataNumber, MetadataOperateTypeEnum metadataOperateTypeEnum, MetadataOperateStatusEnum metadataOperateStatusEnum) {
        DynamicObject metadataCreateLog = this.metadataCreateLogEntityService.generateEmptyDynamicObject();
        long metadataCreateLogId = ID.genLongId();
        metadataCreateLog.set("id", (Object)metadataCreateLogId);
        metadataCreateLog.set("objnumber", (Object)metadataNumber);
        metadataCreateLog.set("starttime", (Object)new Date());
        if (metadataOperateTypeEnum == null) {
            metadataCreateLog.set("operatetype", (Object)MetadataOperateTypeEnum.PAGE_SAVE.getType());
        } else {
            metadataCreateLog.set("operatetype", (Object)metadataOperateTypeEnum.getType());
        }
        if (metadataOperateStatusEnum == null) {
            metadataCreateLog.set("operatestatus", (Object)MetadataOperateStatusEnum.PROCESSING.getType());
        } else {
            metadataCreateLog.set("operatestatus", (Object)metadataOperateStatusEnum.getType());
        }
        try (TXHandle txHandle = TX.requiresNew();){
            this.metadataCreateLogEntityService.save(metadataCreateLog);
        }
        return metadataCreateLogId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void success(Long id) {
        DynamicObject metadataCreateLog = this.metadataCreateLogEntityService.queryOne(SELECT_PROPERTIES, id);
        if (metadataCreateLog != null) {
            metadataCreateLog.set("operatestatus", (Object)MetadataOperateStatusEnum.SUCCESS.getType());
            metadataCreateLog.set("endtime", (Object)new Date());
            try (TXHandle txHandle = TX.requiresNew();){
                this.metadataCreateLogEntityService.save(metadataCreateLog);
            }
        } else {
            LOG.error("id:{} MetadataLogDomainServiceImpl.success metadataCreateLog should not be null", (Object)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fail(Long id, String errorInfo) {
        DynamicObject metadataCreateLog = this.metadataCreateLogEntityService.queryOne(SELECT_PROPERTIES, id);
        if (metadataCreateLog != null) {
            metadataCreateLog.set("operatestatus", (Object)MetadataOperateStatusEnum.FAIL.getType());
            metadataCreateLog.set("endtime", (Object)new Date());
            DynamicObjectUtils.setBigText((DynamicObject)metadataCreateLog, (String)"errormsg", (String)errorInfo);
            try (TXHandle txHandle = TX.requiresNew();){
                this.metadataCreateLogEntityService.save(metadataCreateLog);
            }
        } else {
            LOG.error("id:{} MetadataLogDomainServiceImpl.fail metadataCreateLog should not be null", (Object)id);
        }
    }
}

