/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.context;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataSingleNode;
import kd.hdtc.hrdbs.common.util.CollectionUtils;

public class DesignMetadataParser {
    private static final Log LOG = LogFactory.getLog(DesignMetadataParser.class);
    private Map<String, Object> designerMetadataMap;
    private Map<String, Map<String, Object>> formMetadataMap;
    private Map<String, Map<String, Object>> entityMetadataMap;
    private Map<String, Map<String, Object>> entityTreeMetadataMap;
    private Map<String, String> keyIdMap;
    private String entityNumber;
    private boolean inited;

    public DesignMetadataParser(Map<String, Object> designerMetadataMap) {
        this.designerMetadataMap = designerMetadataMap;
    }

    public DesignMetadataParser(Map<String, Object> designerMetadataMap, String entityNumber) {
        this.designerMetadataMap = designerMetadataMap;
        this.entityNumber = entityNumber;
    }

    private List<Map<String, Object>> getNodeInfo(Map<String, Object> designerMetadataMap, String nodeKey) {
        return Optional.ofNullable(designerMetadataMap).map(it -> (Map)it.get(nodeKey)).map(it -> (List)it.get("Items")).orElseGet(() -> new ArrayList());
    }

    public void addFormMetadata(List<Map<String, Object>> formMetadataList) {
        Map metadataMap = (Map)this.designerMetadataMap.get("formmeta");
        List metadataItemList = (List)metadataMap.get("Items");
        if (CollectionUtils.isEmpty((Collection)metadataItemList)) {
            metadataMap.put("Items", formMetadataList);
        } else {
            metadataItemList.addAll(formMetadataList);
        }
    }

    public void addEntityMeta(List<Map<String, Object>> entityMetaList) {
        Map metadataMap = (Map)this.designerMetadataMap.get("entitymeta");
        List metadataItemList = (List)metadataMap.get("Items");
        if (CollectionUtils.isEmpty((Collection)metadataItemList)) {
            return;
        }
        List metadataOperationList = (List)((Map)metadataItemList.get(0)).get("Operations");
        metadataOperationList.addAll(entityMetaList);
    }

    public List<Map<String, Object>> getFormMetadata() {
        return this.getNodeInfo(this.designerMetadataMap, "formmeta");
    }

    public List<Map<String, Object>> getEntityTreeMetadata() {
        return this.getNodeInfo(this.designerMetadataMap, "entitytree");
    }

    public List<Map<String, Object>> getEntityMetadata() {
        return this.getNodeInfo(this.designerMetadataMap, "entitymeta");
    }

    public List<Map<String, Object>> getListMetadata() {
        return Optional.ofNullable(this.getListRootNode()).map(it -> (List)it.get("Items")).orElseGet(() -> Lists.newArrayList());
    }

    public Map<String, Object> getListRootNode() {
        return Optional.ofNullable(this.designerMetadataMap).map(it -> (Map)it.get("formmeta")).map(it -> (List)it.get("Items")).filter(Objects::nonNull).filter(it -> !it.isEmpty()).map(it -> (Map)it.get(0)).map(it -> (Map)it.get("ListMeta")).orElseGet(() -> Maps.newHashMap());
    }

    public List<Map<String, Object>> getUiMetadata() {
        return this.getNodeInfo(this.designerMetadataMap, "ui");
    }

    public MetadataSingleNode getSingleNode(String propNumber) {
        this.initNodeMap();
        MetadataSingleNode metadataSingleNode = new MetadataSingleNode();
        metadataSingleNode.setNumber(propNumber);
        metadataSingleNode.setId(this.keyIdMap.get(propNumber));
        metadataSingleNode.setFormMetadataMap(this.formMetadataMap.get(metadataSingleNode.getId()));
        metadataSingleNode.setEntryFormMetadataMap(this.formMetadataMap.get(metadataSingleNode.getId()));
        metadataSingleNode.setEntityMetadataMap(this.entityMetadataMap.get(metadataSingleNode.getId()));
        metadataSingleNode.setEntityTreeMetadataMap(this.entityTreeMetadataMap.get(metadataSingleNode.getId()));
        return metadataSingleNode;
    }

    private void initNodeMap() {
        if (!this.inited) {
            this.keyIdMap = this.getFormMetadata().stream().collect(Collectors.toMap(it -> (String)it.get("Key"), it -> (String)it.get("Id"), (it1, it2) -> it1));
            this.formMetadataMap = this.getFormMetadata().stream().collect(Collectors.toMap(it -> (String)it.get("Id"), it -> it, (it1, it2) -> it1));
            this.entityMetadataMap = this.getEntityMetadata().stream().collect(Collectors.toMap(it -> (String)it.get("Id"), it -> it, (it1, it2) -> it1));
            this.entityTreeMetadataMap = Maps.newHashMapWithExpectedSize((int)this.getEntityTreeMetadata().size());
            this.buildEntityTreeMetadataMap(this.getEntityTreeMetadata());
            this.inited = true;
        }
    }

    private void buildEntityTreeMetadataMap(List<Map<String, Object>> entityTreeMap) {
        entityTreeMap.forEach(entityTreeMetadata -> {
            this.entityTreeMetadataMap.put((String)entityTreeMetadata.get("Id"), (Map<String, Object>)entityTreeMetadata);
            if ("EntryEntity".equals(entityTreeMetadata.get("Type")) || "SubEntryEntity".equals(entityTreeMetadata.get("Type"))) {
                List entryItemList = (List)entityTreeMetadata.get("Items");
                this.buildEntityTreeMetadataMap(entryItemList);
            }
        });
    }

    public void setInited(boolean inited) {
        this.inited = inited;
    }

    public void initKeyIdMap() {
        this.keyIdMap = this.getFormMetadata().stream().collect(Collectors.toMap(it -> (String)it.get("Key"), it -> (String)it.get("Id"), (it1, it2) -> it1));
    }

    public String getIdByNumber(String number) {
        return this.keyIdMap.get(number);
    }

    public boolean containsNode(String nodeKey) {
        return this.keyIdMap.containsKey(nodeKey);
    }
}

