/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.context;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.AppMetadataCache;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataContext;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class ExtendMetadata {
    private static final Log LOG = LogFactory.getLog(ExtendMetadata.class);
    private String metadataNumber;
    private String metadataId;
    private String extendMetadataNumber;
    private String extAppId;
    private String bizUnitId;
    private ILocaleString name;
    private String isv = ISVService.getISVInfo().getId();

    ExtendMetadata(String metadataNumber) {
        this.metadataNumber = metadataNumber;
    }

    public void bind(String extendMetadataNumber) {
        LOG.info("bind metadata success, metadata number = {}, extend metadata number, isv = {}", new Object[]{this.metadataNumber, extendMetadataNumber, this.isv});
        if (StringUtils.isNotEmpty((String)this.extendMetadataNumber)) {
            throw new HRDBSBizException("Extend Metadata Number Exist");
        }
        this.extendMetadataNumber = extendMetadataNumber;
        MetadataContext.get().getMetadataGenParam().getBaseParam().setMetadataNumber(extendMetadataNumber);
    }

    public String getMetadataNumber() {
        return this.metadataNumber;
    }

    public String getExtendMetadataNumber() {
        return this.extendMetadataNumber;
    }

    public String toString() {
        return "ExtendMetadata{metadataNumber='" + this.metadataNumber + '\'' + ", extendMetadataNumber='" + this.extendMetadataNumber + '\'' + '}';
    }

    public Map<String, Object> createExtGenMap(String extNumber) {
        HashMap genMap = Maps.newHashMap();
        BaseParam baseParam = MetadataContext.get().getMetadataGenParam().getBaseParam();
        genMap.put("devType", "2");
        String appId = AppMetadataCache.getAppInfo((String)baseParam.getAppId()).getId();
        genMap.put("bizappid", appId);
        genMap.put("name", baseParam.getMetadataName());
        genMap.put("modelType", baseParam.getModelType());
        genMap.put("bizunitid", baseParam.getBizUnitId());
        genMap.put("parentId", baseParam.getParentId());
        genMap.put("id", extNumber);
        return genMap;
    }
}

