/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.context;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.id.ID;
import kd.bos.list.SeqColumnType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataSingleNode;
import kd.hdtc.hrdbs.common.util.CollectionUtils;

public class ListMetadataNode
extends MetadataNode {
    private static final Log LOG = LogFactory.getLog(ListMetadataNode.class);
    private Integer nodeIndex = 20;
    private Map<String, Object> listRootNodeMap;
    private Map<String, Map<String, Object>> keyNodeMap;

    public ListMetadataNode(Map<String, Object> listRootNodeMap, List<Map<String, Object>> nodeList) {
        super(nodeList);
        this.listRootNodeMap = listRootNodeMap;
        this.keyNodeMap = nodeList.stream().collect(Collectors.toMap(it -> (String)it.get("Key"), Function.identity(), (oldValue, newValue) -> oldValue));
    }

    @Override
    public void add(MetadataSingleNode singleNode) {
        this.nodeList.add(this.generateListNode(singleNode));
    }

    @Override
    protected String getNodeKey() {
        return "ListFieldId";
    }

    private Map<String, Object> generateListNode(MetadataSingleNode singleNode) {
        LinkedHashMap listNodeMap = Maps.newLinkedHashMap();
        listNodeMap.put("ParentId", "gridview");
        listNodeMap.put("_Type_", "ListColumnAp");
        listNodeMap.put("Name", this.getNodeName(singleNode));
        listNodeMap.put("Order", "NotOrder");
        listNodeMap.put("SeqColumnType", SeqColumnType.NotSeq.name());
        this.nodeIndex = this.nodeIndex + 1;
        listNodeMap.put("Index", this.nodeIndex);
        listNodeMap.put("ListFieldId", singleNode.getNumber());
        listNodeMap.put("ColumnOrderAndFilter", Boolean.TRUE);
        listNodeMap.put("Id", ID.genStringId());
        listNodeMap.put("Key", "listcolumnap" + this.nodeIndex);
        return listNodeMap;
    }

    public void modifyName(String nodeNameKey, String newNodeName) {
        Map<String, Object> nodePropMap = this.keyNodeMap.get(nodeNameKey);
        if (CollectionUtils.isEmpty(nodePropMap)) {
            LOG.warn("not find node info, please check. nodeName = {}", (Object)nodeNameKey);
            return;
        }
        nodePropMap.put("Name", newNodeName);
    }

    public void modifyRootName(String rootName) {
        this.listRootNodeMap.put("Name", rootName);
    }

    private String getNodeName(MetadataSingleNode singleNode) {
        return (String)singleNode.getFormMetadataMap().get("Name");
    }
}

