/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.context;

import java.util.Map;
import java.util.Optional;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.DesignMetadataParser;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.EntityMetadataNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.EntityTreeMetadataNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.ExtendMetadata;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.FormMetadataNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.ListMetadataNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataSingleNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.RefMetadataNode;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.pojo.metadata.EntryParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;

public class MetadataContext {
    private static final ThreadLocal<MetadataContext> THREAD_LOCAL = new ThreadLocal();
    public Map<FieldParam, RefMetadataNode> entityObjNodeMap;
    public Map<FieldParam, RefMetadataNode> entryEntityObjNodeMap;
    public Map<EntryParam, RefMetadataNode> entryObjNodeMap;
    public Map<FieldParam, RefMetadataNode> currentNodeMap;
    public Map<EntryParam, RefMetadataNode> currentEntryNodeMap;
    public Map<FieldParam, RefMetadataNode> currentEntryEntityNodeMap;
    public Map<String, String> keyTableNameMap;
    private ExtendMetadata extendMetadata;
    private DesignMetadataParser designMetadataParser;
    private MetadataGenParam metadataGenParam;
    private MetadataGenResult metadataGenResult;
    private Map<String, Object> originMetadataNodeMap;
    private MetadataSingleNode rootNode;
    private EntityMetadataNode entityMetadataNode;
    private EntityTreeMetadataNode entityTreeMetadataNode;
    private FormMetadataNode formMetadataNode;
    private ListMetadataNode listMetadataNode;
    private String isvId;

    public static MetadataContext create(MetadataGenParam metadataGenParam, MetadataGenResult metadataGenResult) {
        MetadataContext metadataContext = new MetadataContext(metadataGenParam, metadataGenResult);
        THREAD_LOCAL.set(metadataContext);
        return metadataContext;
    }

    public static MetadataContext get() {
        return THREAD_LOCAL.get();
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }

    private MetadataContext(MetadataGenParam metadataGenParam, MetadataGenResult metadataGenResult) {
        this.metadataGenParam = metadataGenParam;
        this.metadataGenResult = metadataGenResult;
    }

    public String getIsvId() {
        return this.isvId;
    }

    public void setIsvId(String isvId) {
        this.isvId = isvId;
    }

    public MetadataGenParam getMetadataGenParam() {
        return this.metadataGenParam;
    }

    public MetadataGenResult getMetadataGenResult() {
        return this.metadataGenResult;
    }

    public Map<String, Object> getOriginMetadataNodeMap() {
        return this.originMetadataNodeMap;
    }

    public void setOriginMetadataNodeMap(Map<String, Object> originMetadataNodeMap) {
        this.originMetadataNodeMap = originMetadataNodeMap;
        this.initMetadataNode();
    }

    public EntityMetadataNode getEntityMetadataNode() {
        return this.entityMetadataNode;
    }

    public EntityTreeMetadataNode getEntityTreeMetadataNode() {
        return this.entityTreeMetadataNode;
    }

    public ListMetadataNode getListMetadataNode() {
        return this.listMetadataNode;
    }

    public FormMetadataNode getFormMetadataNode() {
        return this.formMetadataNode;
    }

    public ExtendMetadata initExtendMetadata(String number) {
        this.extendMetadata = new ExtendMetadata(number);
        return this.extendMetadata;
    }

    public void initMetadataNode() {
        this.designMetadataParser = new DesignMetadataParser(this.originMetadataNodeMap);
        this.entityMetadataNode = new EntityMetadataNode(this.designMetadataParser.getEntityMetadata());
        this.keyTableNameMap = this.entityMetadataNode.getKeyTableNameMap();
        this.entityTreeMetadataNode = new EntityTreeMetadataNode(this.designMetadataParser.getEntityTreeMetadata());
        this.formMetadataNode = new FormMetadataNode(this.designMetadataParser.getFormMetadata());
        this.rootNode = this.designMetadataParser.getSingleNode(this.metadataGenParam.getBaseParam().getMetadataNumber());
        this.listMetadataNode = new ListMetadataNode(this.designMetadataParser.getListRootNode(), this.designMetadataParser.getListMetadata());
    }

    public Map<FieldParam, RefMetadataNode> getEntityObjNodeMap() {
        return this.entityObjNodeMap;
    }

    public void setEntityObjNodeMap(Map<FieldParam, RefMetadataNode> entityObjNodeMap) {
        this.entityObjNodeMap = entityObjNodeMap;
    }

    public DesignMetadataParser getDesignMetadataParser() {
        return this.designMetadataParser;
    }

    public void remove(String node) {
        this.formMetadataNode.remove(node);
        this.entityMetadataNode.remove(node);
        this.entityTreeMetadataNode.remove(node);
        this.listMetadataNode.remove(node);
    }

    public Map<FieldParam, RefMetadataNode> getCurrentNodeMap() {
        return this.currentNodeMap;
    }

    public void setCurrentNodeMap(Map<FieldParam, RefMetadataNode> currentNodeMap) {
        this.currentNodeMap = currentNodeMap;
    }

    public String getParentId(String number) {
        return this.designMetadataParser.getIdByNumber(number);
    }

    public MetadataSingleNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(MetadataSingleNode rootNode) {
        this.rootNode = rootNode;
    }

    public Map<EntryParam, RefMetadataNode> getEntryObjNodeMap() {
        return this.entryObjNodeMap;
    }

    public void setEntryObjNodeMap(Map<EntryParam, RefMetadataNode> entryObjNodeMap) {
        this.entryObjNodeMap = entryObjNodeMap;
    }

    public Map<EntryParam, RefMetadataNode> getCurrentEntryNodeMap() {
        return this.currentEntryNodeMap;
    }

    public void setCurrentEntryNodeMap(Map<EntryParam, RefMetadataNode> currentEntryNodeMap) {
        this.currentEntryNodeMap = currentEntryNodeMap;
    }

    public Map<FieldParam, RefMetadataNode> getEntryEntityObjNodeMap() {
        return this.entryEntityObjNodeMap;
    }

    public void setEntryEntityObjNodeMap(Map<FieldParam, RefMetadataNode> entryEntityObjNodeMap) {
        this.entryEntityObjNodeMap = entryEntityObjNodeMap;
    }

    public Map<FieldParam, RefMetadataNode> getCurrentEntryEntityNodeMap() {
        return this.currentEntryEntityNodeMap;
    }

    public void setCurrentEntryEntityNodeMap(Map<FieldParam, RefMetadataNode> currentEntryEntityNodeMap) {
        this.currentEntryEntityNodeMap = currentEntryEntityNodeMap;
    }

    public Map<String, String> getKeyTableNameMap() {
        return this.keyTableNameMap;
    }

    public RefMetadataNode getCurrentRefMetadataNode(FieldParam fieldParam) {
        if (fieldParam.getEntryParam() != null) {
            return MetadataContext.get().getCurrentEntryEntityNodeMap().get(fieldParam);
        }
        return MetadataContext.get().getCurrentNodeMap().get(fieldParam);
    }

    public MetadataSingleNode getMetadataSingleNode(FieldParam fieldParam) {
        return Optional.ofNullable(MetadataContext.get()).map(it -> it.getCurrentRefMetadataNode(fieldParam)).map(RefMetadataNode::getMetadataSingleNode).orElseThrow(() -> new HRDBSBizException("can not match metadata node, fieldParam = " + fieldParam));
    }
}

