/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.context;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataSingleNode;

public abstract class MetadataNode {
    private static final Log LOG = LogFactory.getLog(MetadataNode.class);
    protected final List<Map<String, Object>> nodeList;
    protected Map<String, Map<String, Object>> nodeMap;

    public MetadataNode(List<Map<String, Object>> nodeList) {
        this.nodeList = nodeList;
        this.nodeMap = nodeList.stream().collect(Collectors.toMap(it -> (String)it.get(this.getNodeKey()), Function.identity(), (oldValue, newValue) -> oldValue));
    }

    protected String getNodeKey() {
        return "Key";
    }

    public boolean remove(String node) {
        Map<String, Object> objectMap = this.nodeMap.get(node);
        if (Objects.isNull(objectMap)) {
            return false;
        }
        return this.nodeList.remove(objectMap);
    }

    public Map<String, Object> getNode(String nodeKey) {
        return this.nodeMap.get(nodeKey);
    }

    public abstract void add(MetadataSingleNode var1);

    public boolean contains(String nodeKey) {
        return this.nodeMap.containsKey(nodeKey);
    }
}

