/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.context;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.domain.metadata.impl.MetaNodeConstants;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataContext;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.RefMetadataNode;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FormPluginParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class MetadataSingleNode
implements Cloneable {
    private static final String FEATURES = "Features";
    private static final Log LOG = LogFactory.getLog(MetadataSingleNode.class);
    private String id;
    private String number;
    private String parentNumber;
    private RefMetadataNode refMetadataNode;
    private Map<String, Object> entityMetadataMap;
    private Map<String, Object> entityTreeMetadataMap;
    private Map<String, Object> formMetadataMap;
    private Map<String, Object> entryFormMetadataMap;
    public boolean entry;
    private Map<String, String> keyTableNameMap = MetadataContext.get().getKeyTableNameMap();

    public void setParentNumber(String parentNumber) {
        this.parentNumber = parentNumber;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Map<String, Object> getEntityMetadataMap() {
        return this.entityMetadataMap;
    }

    void setEntityMetadataMap(Map<String, Object> entityMetadataMap) {
        this.entityMetadataMap = entityMetadataMap;
    }

    public Map<String, Object> getEntityTreeMetadataMap() {
        return this.entityTreeMetadataMap;
    }

    void setEntityTreeMetadataMap(Map<String, Object> entityTreeMetadataMap) {
        this.entityTreeMetadataMap = entityTreeMetadataMap;
    }

    void setRefMetadataNode(RefMetadataNode refMetadataNode) {
        this.refMetadataNode = refMetadataNode;
    }

    public Map<String, Object> getFormMetadataMap() {
        return this.formMetadataMap;
    }

    void setFormMetadataMap(Map<String, Object> formMetadataMap) {
        this.formMetadataMap = formMetadataMap;
    }

    public boolean isEntry() {
        return this.entry;
    }

    public void setEntry(boolean entry) {
        this.entry = entry;
    }

    public Map<String, Object> getEntryFormMetadataMap() {
        return this.entryFormMetadataMap;
    }

    public void setEntryFormMetadataMap(Map<String, Object> entryFormMetadataMap) {
        this.entryFormMetadataMap = entryFormMetadataMap;
    }

    public boolean isMatch() {
        return this.getFormMetadataMap() != null;
    }

    public void modifyBaseInfo() {
        this.getFormMetadataMap().put("Key", this.number);
        this.getFormMetadataMap().put("Id", this.id);
        this.getFormMetadataMap().put("FieldId", this.id);
        this.getFormMetadataMap().put("ParentId", MetadataContext.get().getParentId(this.parentNumber));
        this.getFormMetadataMap().put("Inherit", Boolean.FALSE);
        FieldParam fieldParam = Optional.ofNullable(this.refMetadataNode).map(RefMetadataNode::getFieldParam).orElse(null);
        if (fieldParam != null) {
            this.getFormMetadataMap().put("Index", fieldParam.getIndex());
        }
        this.getEntityMetadataMap().put("Key", this.number);
        this.getEntityMetadataMap().put("Id", this.id);
        this.getEntityTreeMetadataMap().put("Key", this.number);
        this.getEntityTreeMetadataMap().put("Id", this.id);
        this.modifyEntity();
    }

    public void modifyEntity() {
        if (this.refMetadataNode.getFieldParam() != null && this.refMetadataNode.getFieldParam().getEntryParam() != null) {
            this.getEntityMetadataMap().put("ParentId", MetadataContext.get().getParentId(this.refMetadataNode.getFieldParam().getEntryParam().getEntryKey()));
            this.getEntityTreeMetadataMap().put("ParentId", MetadataContext.get().getParentId(this.refMetadataNode.getFieldParam().getEntryParam().getEntryKey()));
        }
    }

    public MetadataSingleNode clone() {
        MetadataSingleNode clone = new MetadataSingleNode();
        clone.setId(this.id);
        clone.setNumber(this.number);
        if (CollectionUtils.isNotEmpty(this.formMetadataMap)) {
            clone.setFormMetadataMap(new LinkedHashMap<String, Object>(this.formMetadataMap));
        }
        if (CollectionUtils.isNotEmpty(this.entryFormMetadataMap)) {
            clone.setEntryFormMetadataMap(new LinkedHashMap<String, Object>(this.entryFormMetadataMap));
        }
        if (CollectionUtils.isNotEmpty(this.entityMetadataMap)) {
            clone.setEntityMetadataMap(new LinkedHashMap<String, Object>(this.entityMetadataMap));
        }
        if (CollectionUtils.isNotEmpty(this.entityTreeMetadataMap)) {
            clone.setEntityTreeMetadataMap(new LinkedHashMap<String, Object>(this.entityTreeMetadataMap));
        }
        return clone;
    }

    public void modifyMuliLang(Boolean gl) {
        if (MetaNodeConstants.MULI_LANG_TEXT_FIELD.equals(this.getEntityMetadataMap().get("_Type_"))) {
            this.getEntityMetadataMap().put("GL", gl);
        }
    }

    public void modifyBaseDataProp(String id) {
        if (MetaNodeConstants.BASE_DATA_PROP_FIELD.equals(this.getEntityMetadataMap().get("_Type_"))) {
            this.getEntityMetadataMap().put("RefBaseFieldId", id);
        }
    }

    public void modifyEntryField() {
        if ("EntryFieldAp".equals(this.getFormMetadataMap().get("_Type_"))) {
            this.getFormMetadataMap().put("_Type_", "FieldAp");
        }
    }

    public void modifyFieldRule(Map<String, Object> fieldRuleMap) {
        for (Map.Entry<String, Object> ruleEntry : fieldRuleMap.entrySet()) {
            String ruleKey = ruleEntry.getKey();
            Object ruleValue = ruleEntry.getValue();
            this.getFormMetadataMap().put(ruleKey, ruleValue);
            if (this.getEntityTreeMetadataMap() != null) {
                this.getEntityTreeMetadataMap().put(ruleKey, ruleValue);
            }
            if (this.getEntityMetadataMap() == null) continue;
            this.getEntityMetadataMap().put(ruleKey, ruleValue);
        }
    }

    public void addTable(String tableName) {
        this.getEntityMetadataMap().put("TableName", tableName);
    }

    public void modifyFieldName(String fieldName) {
        if (this.refMetadataNode.getFieldParam().isAutoGenFieldName()) {
            this.getEntityMetadataMap().put("FieldName", fieldName);
        }
    }

    public void addFormPlugin(List<FormPluginParam> pluginParamList) {
        Map<String, Object> formMetadataMap = this.getFormMetadataMap();
        List pluginList = Optional.ofNullable((List)formMetadataMap.get("Plugins")).orElseGet(() -> new ArrayList(pluginParamList.size()));
        Set containPlugins = pluginList.stream().map(plugin -> String.valueOf(plugin.get("ClassName"))).collect(Collectors.toSet());
        pluginParamList.forEach(formPluginParam -> {
            if (CollectionUtils.isEmpty((Collection)containPlugins) || !containPlugins.contains(formPluginParam.getClassName())) {
                ImmutableMap plugin = ImmutableMap.builder().put((Object)"FPK", (Object)"").put((Object)"_Type_", (Object)"Plugin").put((Object)"Description", (Object)formPluginParam.getDescription()).put((Object)"ClassName", (Object)formPluginParam.getClassName()).put((Object)"Enabled", (Object)formPluginParam.getEnable()).put((Object)"BizAppId", (Object)"").build();
                pluginList.add(plugin);
            }
        });
        formMetadataMap.put("Plugins", pluginList);
    }

    public String getFieldName() {
        return (String)this.getEntityMetadataMap().get("FieldName");
    }

    public void modifyName(String name) {
        if (this.getFormMetadataMap() != null) {
            this.getFormMetadataMap().put("Name", name);
        }
        if (this.getEntityMetadataMap() != null) {
            this.getEntityMetadataMap().put("Name", name);
        }
        if (this.getEntityTreeMetadataMap() != null) {
            this.getEntityTreeMetadataMap().put("Name", name);
        }
    }

    public void modifyRootName(String name) {
        Map formMetaMap = (Map)MetadataContext.get().getOriginMetadataNodeMap().get("formmeta");
        Map entityMetaMap = (Map)MetadataContext.get().getOriginMetadataNodeMap().get("entitymeta");
        formMetaMap.put("Name", name);
        entityMetaMap.put("Name", name);
        this.modifyName(name);
    }

    public void addMulBaseDataTableName() {
        FieldParam fieldParam = this.refMetadataNode.getFieldParam();
        String tableName = this.keyTableNameMap.get(fieldParam.getNumber());
        if (StringUtils.isEmpty((String)tableName)) {
            tableName = this.getMulTableName();
        }
        this.getEntityMetadataMap().put("TableName", tableName);
        this.keyTableNameMap.put(fieldParam.getNumber(), tableName);
    }

    private String getMulTableName() {
        String mainTableName = Optional.ofNullable(MetadataContext.get().getRootNode()).map(it -> it.getEntityMetadataMap()).map(it -> (String)it.get("TableName")).orElse("");
        if (StringUtils.isEmpty((String)mainTableName)) {
            return "";
        }
        String mulBaseDataTableName = this.refMetadataNode.getFieldParam().getTableField();
        if (StringUtils.isNotEmpty((String)mulBaseDataTableName)) {
            return mulBaseDataTableName;
        }
        String mainTableNamePrefix = this.getMainTablePrefix(mainTableName);
        return this.getMulTableName(mainTableNamePrefix);
    }

    private String getMulTableName(String mainTableNamePrefix) {
        String regex = mainTableNamePrefix + "_m(\\d{1,2})";
        Pattern pattern = Pattern.compile(regex);
        int maxIndex = 0;
        for (Map.Entry<String, String> mapEntry : this.keyTableNameMap.entrySet()) {
            String indexStr;
            int index;
            String tableName = mapEntry.getValue();
            Matcher matcher = pattern.matcher(tableName);
            if (!matcher.matches() || (index = Integer.parseInt(indexStr = matcher.group(1))) <= maxIndex) continue;
            maxIndex = index;
        }
        return mainTableNamePrefix + "_m" + (maxIndex + 1);
    }

    private String getMainTablePrefix(String mainTableName) {
        if (mainTableName.length() <= 21) {
            return mainTableName;
        }
        return mainTableName.substring(0, 21);
    }

    public void modifyFieldType(String type) {
        this.getEntityMetadataMap().put("_Type_", type);
        this.getEntityTreeMetadataMap().put("Type", type);
    }

    private <T> T getFormNodeValue(String nodeKey) {
        return (T)this.getFormMetadataMap().get(nodeKey);
    }

    private <T> T getEntityNodeValue(String nodeKey) {
        return (T)this.getEntityMetadataMap().get(nodeKey);
    }

    public void modifyFieldType(String originType, String newType) {
        if (StringUtils.equals((String)((String)this.getEntityNodeValue("_Type_")), (String)originType)) {
            this.modifyFieldType(newType);
        }
    }

    public String toString() {
        return "MetadataSingleNode{id='" + this.id + '\'' + ", number='" + this.number + '\'' + ", parentNumber='" + this.parentNumber + '\'' + '}';
    }

    public void modifyFeaturesRule(Map<String, Object> featureRuleMap) {
        if (CollectionUtils.isEmpty(featureRuleMap)) {
            return;
        }
        Map<String, Object> entityMetadataMap = this.getEntityMetadataMap();
        Map featuresMap = (Map)entityMetadataMap.computeIfAbsent(FEATURES, var -> {
            HashMap newFeaturesMap = Maps.newHashMapWithExpectedSize((int)16);
            newFeaturesMap.put("_Type_", FEATURES);
            return newFeaturesMap;
        });
        featuresMap.putAll(featureRuleMap);
    }

    public void appendSplitTable(String suffix) {
        Map<String, Object> entityMetadataMap = this.getEntityMetadataMap();
        List splitTableList = (List)entityMetadataMap.computeIfAbsent("SplitTables", split -> Lists.newArrayListWithCapacity((int)10));
        for (Map splitTableMap : splitTableList) {
            String existSuffix = (String)splitTableMap.computeIfAbsent("Suffix", split -> "");
            if (!suffix.equals(existSuffix)) continue;
            return;
        }
        splitTableList.add(this.getSplitTableMap(suffix));
    }

    private Map<String, Object> getSplitTableMap(String suffix) {
        LinkedHashMap splitTableMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        splitTableMap.put("_Type_", "SplitTable");
        splitTableMap.put("Suffix", suffix);
        splitTableMap.put("Description", "split table " + suffix);
        splitTableMap.put("Id", ID.genStringId());
        return splitTableMap;
    }

    public void modifySuffix(String suffix) {
        Optional.ofNullable(this.getEntityMetadataMap()).ifPresent(entityMetadataMap -> {
            ImmutableMap suffixRuleMap = ImmutableMap.of((Object)"Suffix", (Object)suffix);
            this.modifyFieldRule((Map<String, Object>)suffixRuleMap);
        });
    }
}

