/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.handle.load;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IMetadataEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.DesignMetadataParser;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataContext;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.RefMetadataNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.MetadataHandle;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.load.RefMetadataNodeLoader;
import kd.hdtc.hrdbs.common.pojo.metadata.EntryParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hr.hbp.common.util.HRStringUtils;

public class BaseTemplateMetadataNodeLoader
extends MetadataHandle {
    private static final Log LOG = LogFactory.getLog(RefMetadataNodeLoader.class);
    private IMetadataEntityService metadataEntityService = ServiceFactory.getService(IMetadataEntityService.class);
    private List<FieldParam> fieldParamList;
    private List<EntryParam> entryParamList;
    private Map<FieldParam, RefMetadataNode> fieldNodeMap;
    private Map<FieldParam, RefMetadataNode> entryFieldNodeMap;
    private Map<EntryParam, RefMetadataNode> entryNodeMap;
    private Set<String> numberSet;
    private static final String BASE_TEMPLATE_NUMBER = "hrdbs_metabasetpl";
    private Map<String, Map<String, Object>> entityDesignMetadataMap;

    public BaseTemplateMetadataNodeLoader() {
        RefMetadataNode refMetadataNode;
        MetadataContext metadataContext = MetadataContext.get();
        MetadataGenParam metadataGenParam = this.getMetadataContext().getMetadataGenParam();
        this.fieldParamList = metadataContext.getMetadataGenParam().getFieldParamList();
        this.entryParamList = metadataContext.getMetadataGenParam().getEntryParamList();
        this.fieldParamList.forEach(it -> it.addBasedataNumber(metadataGenParam.getBaseParam().getRefEntityNumber()));
        this.fieldNodeMap = Maps.newHashMapWithExpectedSize((int)this.fieldParamList.size());
        this.entryFieldNodeMap = new HashMap<FieldParam, RefMetadataNode>(16);
        this.entryNodeMap = Maps.newHashMapWithExpectedSize((int)this.entryParamList.size());
        metadataContext.setEntityObjNodeMap(this.fieldNodeMap);
        metadataContext.setEntryObjNodeMap(this.entryNodeMap);
        metadataContext.setEntryEntityObjNodeMap(this.entryFieldNodeMap);
        this.numberSet = Sets.newHashSetWithExpectedSize((int)this.fieldParamList.size());
        for (FieldParam fieldParam : this.fieldParamList) {
            refMetadataNode = new RefMetadataNode();
            refMetadataNode.setFieldParam(fieldParam);
            this.fieldNodeMap.put(fieldParam, refMetadataNode);
        }
        for (EntryParam entryParam : this.entryParamList) {
            refMetadataNode = new RefMetadataNode();
            refMetadataNode.setEntryParam(entryParam);
            this.entryNodeMap.put(entryParam, refMetadataNode);
        }
        for (EntryParam entryParam : this.entryParamList) {
            for (FieldParam fieldParam : entryParam.getFieldParamList()) {
                RefMetadataNode refMetadataNode2 = new RefMetadataNode();
                refMetadataNode2.setFieldParam(fieldParam);
                this.entryFieldNodeMap.put(fieldParam, refMetadataNode2);
            }
        }
    }

    public void load() {
        this.numberSet.add(BASE_TEMPLATE_NUMBER);
        this.loadDesignMetadata();
        this.fillCollectNode();
    }

    @Override
    protected void fillCollectNode() {
        Map<String, Object> designMetadataMap;
        RefMetadataNode node;
        for (Map.Entry<FieldParam, RefMetadataNode> entry : this.fieldNodeMap.entrySet()) {
            node = entry.getValue();
            designMetadataMap = this.getDesignMedataMap();
            node.setMetadataSingleNode(new DesignMetadataParser(designMetadataMap).getSingleNode(node.getFieldParam().getType().toLowerCase(Locale.ROOT)));
        }
        for (Map.Entry<FieldParam, RefMetadataNode> entry : this.entryNodeMap.entrySet()) {
            node = entry.getValue();
            designMetadataMap = this.getDesignMedataMap();
            node.setMetadataSingleNode(new DesignMetadataParser(designMetadataMap).getSingleNode(node.getEntryParam().getType().toLowerCase(Locale.ROOT)));
        }
        for (Map.Entry<FieldParam, RefMetadataNode> entry : this.entryFieldNodeMap.entrySet()) {
            node = entry.getValue();
            designMetadataMap = this.getDesignMedataMap();
            node.setMetadataSingleNode(new DesignMetadataParser(designMetadataMap).getSingleNode(node.getFieldParam().getType().toLowerCase(Locale.ROOT)));
        }
    }

    private Map<String, Object> getDesignMedataMap() {
        return this.entityDesignMetadataMap.get(BASE_TEMPLATE_NUMBER);
    }

    private void loadDesignMetadata() {
        this.entityDesignMetadataMap = Maps.newHashMapWithExpectedSize((int)this.numberSet.size());
        for (String number : this.numberSet) {
            String extMetadataNumber = this.metadataEntityService.getExtMetaObject(number);
            Map<String, Object> designMetadata = this.metadataEntityService.getDesignMetadata(extMetadataNumber);
            this.entityDesignMetadataMap.put(number, designMetadata);
        }
    }

    private void addNeedLoadNumberSet() {
        this.fieldParamList.stream().map(FieldParam::getBasedataNumber).forEach(it -> this.numberSet.add((String)it));
        this.fieldParamList.stream().map(it -> this.fieldNodeMap.get(it)).map(RefMetadataNode::getRefBasedataNumber).filter(HRStringUtils::isNotEmpty).forEach(it -> this.numberSet.add((String)it));
    }

    private void findRefMetadata() {
        for (FieldParam fieldParam : this.fieldParamList) {
            if (!fieldParam.isBasedata()) continue;
            this.fieldNodeMap.get(fieldParam).setRefBasedataNumber(BASE_TEMPLATE_NUMBER);
        }
    }

    @Override
    public void handle() {
        this.load();
    }
}

