/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.handle.load;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.DesignMetadataParser;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataContext;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.RefMetadataNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.MetadataHandle;
import kd.hdtc.hrdbs.common.enums.NodeHandleTypeEnum;
import kd.hdtc.hrdbs.common.pojo.NodeParam;
import kd.hdtc.hrdbs.common.pojo.metadata.EntryParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;

public class CurrentMetadataNodeLoader
extends MetadataHandle {
    private List<FieldParam> fieldParamList;
    private List<EntryParam> entryParamList;
    private Map<FieldParam, RefMetadataNode> fieldNodeMap;
    private Map<FieldParam, RefMetadataNode> entryFieldNodeMap;
    private Map<EntryParam, RefMetadataNode> entryNodeMap;
    private MetadataGenParam metadataGenParam = this.getMetadataContext().getMetadataGenParam();
    private Map<String, Map<String, Object>> entityDesignMetadataMap;

    public CurrentMetadataNodeLoader() {
        RefMetadataNode refMetadataNode;
        MetadataContext metadataContext = MetadataContext.get();
        MetadataGenParam metadataGenParam = this.getMetadataContext().getMetadataGenParam();
        this.fieldParamList = metadataContext.getMetadataGenParam().getFieldParamList();
        this.entryParamList = metadataContext.getMetadataGenParam().getEntryParamList();
        this.fieldParamList.forEach(it -> it.addBasedataNumber(metadataGenParam.getBaseParam().getRefEntityNumber()));
        this.fieldNodeMap = Maps.newHashMapWithExpectedSize((int)this.fieldParamList.size());
        this.entryFieldNodeMap = new HashMap<FieldParam, RefMetadataNode>(16);
        this.entryNodeMap = Maps.newHashMapWithExpectedSize((int)this.entryParamList.size());
        for (FieldParam fieldParam : this.fieldParamList) {
            refMetadataNode = new RefMetadataNode();
            refMetadataNode.setFieldParam(fieldParam);
            this.fieldNodeMap.put(fieldParam, refMetadataNode);
        }
        for (EntryParam entryParam : this.entryParamList) {
            refMetadataNode = new RefMetadataNode();
            refMetadataNode.setEntryParam(entryParam);
            this.entryNodeMap.put(entryParam, refMetadataNode);
        }
        for (EntryParam entryParam : this.entryParamList) {
            for (FieldParam fieldParam : entryParam.getFieldParamList()) {
                RefMetadataNode refMetadataNode2 = new RefMetadataNode();
                refMetadataNode2.setFieldParam(fieldParam);
                this.entryFieldNodeMap.put(fieldParam, refMetadataNode2);
            }
        }
    }

    public void load() {
        this.initFieldType();
        this.addDesignMetadata();
        this.fillCollectNode();
    }

    private void initFieldType() {
        this.changeFieldType(this.fieldParamList);
        for (EntryParam entryParam : this.entryParamList) {
            this.changeFieldType(entryParam.getFieldParamList());
        }
        this.changeFieldType(MetadataContext.get().getMetadataGenParam().getContainerParamList());
    }

    private <T extends NodeParam> void changeFieldType(List<T> nodeParamList) {
        if (nodeParamList == null) {
            return;
        }
        List addFieldParamList = nodeParamList.stream().filter(node -> !node.isDelete()).collect(Collectors.toList());
        for (NodeParam nodeParam2 : addFieldParamList) {
            if (!this.getMetadataContext().getDesignMetadataParser().containsNode(nodeParam2.getNumber())) continue;
            nodeParam2.setNodeHandleTypeEnum(NodeHandleTypeEnum.UPDATE);
        }
        nodeParamList.stream().filter(NodeParam::isDelete).forEach(nodeParam -> {
            if (!this.getMetadataContext().getDesignMetadataParser().containsNode(nodeParam.getNumber())) {
                nodeParam.setIgnore(true);
            }
        });
    }

    @Override
    protected void fillCollectNode() {
        Map<String, Object> designMetadataMap;
        RefMetadataNode node;
        for (Map.Entry<FieldParam, RefMetadataNode> entry : this.fieldNodeMap.entrySet()) {
            if (entry.getKey().isAdd()) continue;
            node = entry.getValue();
            designMetadataMap = this.getDesignMedataMap();
            node.setMetadataSingleNode(new DesignMetadataParser(designMetadataMap).getSingleNode(node.getFieldParam().getType().toLowerCase(Locale.ROOT)));
            MetadataContext.get().getEntityObjNodeMap().put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<FieldParam, RefMetadataNode> entry : this.entryNodeMap.entrySet()) {
            node = entry.getValue();
            designMetadataMap = this.getDesignMedataMap();
            node.setMetadataSingleNode(new DesignMetadataParser(designMetadataMap).getSingleNode(node.getEntryParam().getType().toLowerCase(Locale.ROOT)));
        }
        for (Map.Entry<FieldParam, RefMetadataNode> entry : this.entryFieldNodeMap.entrySet()) {
            node = entry.getValue();
            designMetadataMap = this.getDesignMedataMap();
            node.setMetadataSingleNode(new DesignMetadataParser(designMetadataMap).getSingleNode(node.getFieldParam().getType().toLowerCase(Locale.ROOT)));
            MetadataContext.get().getEntityObjNodeMap().put(entry.getKey(), entry.getValue());
        }
    }

    private Map<String, Object> getDesignMedataMap() {
        return MetadataContext.get().getOriginMetadataNodeMap();
    }

    private void addDesignMetadata() {
        this.entityDesignMetadataMap = Maps.newHashMapWithExpectedSize((int)16);
        this.entityDesignMetadataMap.put(this.metadataGenParam.getBaseParam().getMetadataNumber(), this.getDesignMedataMap());
    }

    private Map<String, Map<String, Object>> getEntityDesignMetadataMap() {
        return this.entityDesignMetadataMap;
    }

    @Override
    public void handle() {
        this.load();
    }
}

