/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.handle.load;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IMetadataEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.DesignMetadataParser;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataContext;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataSingleNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.RefMetadataNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.MetadataHandle;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hr.hbp.common.util.HRStringUtils;

public class RefMetadataNodeLoader
extends MetadataHandle {
    private IMetadataEntityService metadataEntityService = ServiceFactory.getService(IMetadataEntityService.class);
    private static final Log LOG = LogFactory.getLog(RefMetadataNodeLoader.class);
    private List<FieldParam> fieldParamList;
    private Map<FieldParam, RefMetadataNode> fieldNodeMap;
    private Set<String> numberSet;
    private Map<String, Map<String, Object>> entityDesignMetadataMap;

    public RefMetadataNodeLoader() {
        MetadataContext metadataContext = MetadataContext.get();
        MetadataGenParam metadataGenParam = this.getMetadataContext().getMetadataGenParam();
        this.fieldParamList = metadataContext.getMetadataGenParam().getFieldParamList();
        this.fieldParamList.forEach(it -> it.addBasedataNumber(metadataGenParam.getBaseParam().getRefEntityNumber()));
        this.fieldNodeMap = Maps.newHashMapWithExpectedSize((int)this.fieldParamList.size());
        metadataContext.setEntityObjNodeMap(this.fieldNodeMap);
        this.numberSet = Sets.newHashSetWithExpectedSize((int)this.fieldParamList.size());
        for (FieldParam fieldParam : this.fieldParamList) {
            RefMetadataNode refMetadataNode = new RefMetadataNode();
            refMetadataNode.setFieldParam(fieldParam);
            this.fieldNodeMap.put(fieldParam, refMetadataNode);
        }
    }

    public void load() {
        this.findRefMetadata();
        this.addNeedLoadNumberSet();
        this.loadDesignMetadata();
        this.fillCollectNode();
    }

    @Override
    protected void fillCollectNode() {
        for (Map.Entry<FieldParam, RefMetadataNode> entry : this.fieldNodeMap.entrySet()) {
            RefMetadataNode node = entry.getValue();
            Map<String, Object> designMetadataMap = this.getDesignMedataMap(node);
            if (node.getFieldParam().isBasedata()) {
                node.setMetadataSingleNode(this.getBasedataSingleNode(node, designMetadataMap));
            } else {
                node.setMetadataSingleNode(new DesignMetadataParser(designMetadataMap).getSingleNode(node.getFieldParam().getOldNumber()));
            }
            if (node.getMetadataSingleNode().isMatch()) continue;
            LOG.warn("single node can not match, ref node = {}", (Object)node);
        }
    }

    private MetadataSingleNode getBasedataSingleNode(RefMetadataNode node, Map<String, Object> designMetadataMap) {
        MainEntityType dataEntityType;
        String basedataPropNumber = node.getFieldParam().getBasedataPropNumber();
        String refBasedataNumber = node.getRefBasedataNumber();
        DesignMetadataParser designMetadataParser = new DesignMetadataParser(designMetadataMap);
        MetadataSingleNode singleNode = designMetadataParser.getSingleNode(basedataPropNumber);
        if (!singleNode.isMatch() && (dataEntityType = EntityMetadataCache.getDataEntityType((String)refBasedataNumber)) instanceof BasedataEntityType) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)dataEntityType;
            basedataPropNumber = "number".equals(basedataPropNumber) ? basedataEntityType.getNumberProperty() : basedataEntityType.getNameProperty();
            singleNode = designMetadataParser.getSingleNode(basedataPropNumber);
        }
        node.getFieldParam().setMatchedBasedataPropNumber(basedataPropNumber);
        return singleNode;
    }

    private Map<String, Object> getDesignMedataMap(RefMetadataNode node) {
        if (node.getFieldParam().isBasedata()) {
            return this.entityDesignMetadataMap.get(node.getRefBasedataNumber());
        }
        return this.entityDesignMetadataMap.get(node.getFieldParam().getBasedataNumber());
    }

    private void loadDesignMetadata() {
        this.entityDesignMetadataMap = Maps.newHashMapWithExpectedSize((int)this.numberSet.size());
        for (String number : this.numberSet) {
            String extMetadataNumber = this.metadataEntityService.getExtMetaObject(number);
            Map<String, Object> designMetadata = this.metadataEntityService.getDesignMetadata(extMetadataNumber);
            this.entityDesignMetadataMap.put(number, designMetadata);
        }
    }

    private void addNeedLoadNumberSet() {
        this.fieldParamList.stream().map(FieldParam::getBasedataNumber).forEach(it -> this.numberSet.add((String)it));
        this.fieldParamList.stream().map(it -> this.fieldNodeMap.get(it)).map(RefMetadataNode::getRefBasedataNumber).filter(HRStringUtils::isNotEmpty).forEach(it -> this.numberSet.add((String)it));
    }

    private void findRefMetadata() {
        for (FieldParam fieldParam : this.fieldParamList) {
            if (!fieldParam.isBasedata()) continue;
            this.fieldNodeMap.get(fieldParam).setRefBasedataNumber(this.getRefBasedataNumber(fieldParam));
        }
    }

    private String getRefBasedataNumber(FieldParam fieldParam) {
        return this.metadataEntityService.getRefBasedataNumber(fieldParam.getBasedataNumber(), fieldParam.getOldNumber());
    }

    @Override
    public void handle() {
        this.load();
    }
}

