/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.DesignMetadataParser;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.EntityMetadataNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.EntityTreeMetadataNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.FormMetadataNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataContext;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataSingleNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.RefMetadataNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.MetadataHandle;
import kd.hdtc.hrdbs.common.enums.EntityModelTypeEum;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.ButtonParam;
import kd.hdtc.hrdbs.common.pojo.metadata.ContainerParam;
import kd.hdtc.hrdbs.common.pojo.metadata.EntryParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FormPluginParam;
import kd.hdtc.hrdbs.common.pojo.metadata.OperationParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.PredicateContainer;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class MetadataAddOn
extends MetadataHandle {
    private static final Log LOG = LogFactory.getLog(MetadataAddOn.class);
    private final FormMetadataNode formMetadataNode;
    private final EntityMetadataNode entityMetadataNode;
    private final EntityTreeMetadataNode entityTreeMetadataNode;
    final List<FieldParam> fieldParamList;
    final List<EntryParam> entryParamList;
    private final List<ContainerParam> containerParamList;
    private final List<ButtonParam> buttonParamList = new ArrayList<ButtonParam>();
    private final List<OperationParam> operationParamList = new ArrayList<OperationParam>();
    private final List<FormPluginParam> formPluginParamList;
    private final DesignMetadataParser designMetadataParser;
    private static PredicateContainer<BaseParam> tableNoGenPredicateContainer = PredicateContainer.getInstance();
    private Map<String, String> keyTableNameMap = MetadataContext.get().getKeyTableNameMap();

    public MetadataAddOn() {
        this.formMetadataNode = this.getMetadataContext().getFormMetadataNode();
        this.entityMetadataNode = this.getMetadataContext().getEntityMetadataNode();
        this.entityTreeMetadataNode = this.getMetadataContext().getEntityTreeMetadataNode();
        this.fieldParamList = this.getMetadataContext().getMetadataGenParam().getFieldParamList();
        this.entryParamList = this.getMetadataContext().getMetadataGenParam().getEntryParamList();
        this.containerParamList = this.getMetadataContext().getMetadataGenParam().getContainerParamList();
        this.initButtonParamList(this.buttonParamList);
        this.initOperationParamList(this.operationParamList);
        this.formPluginParamList = this.getMetadataContext().getMetadataGenParam().getFormPluginParamList();
        this.designMetadataParser = this.getMetadataContext().getDesignMetadataParser();
    }

    private void initButtonParamList(List<ButtonParam> buttonParamList) {
        this.containerParamList.forEach(container -> {
            if ("AdvConToolbarAp".equals(container.getType())) {
                ButtonParam buttonParam = new ButtonParam();
                buttonParam.setNumber(this.getButtonNumber((ContainerParam)container, "newentry"));
                buttonParam.setParentNumber(container.getNumber());
                buttonParam.setName(ResManager.loadKDString((String)"\u589e\u884c", (String)"MetadataAddOn_2", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
                buttonParam.setOperationKey(this.getButtonNumber((ContainerParam)container, "newentry"));
                buttonParam.setType("AdvConBarItemAp");
                buttonParam.setOperationType("newentry");
                ButtonParam buttonParam2 = new ButtonParam();
                buttonParam2.setNumber(this.getButtonNumber((ContainerParam)container, "delentry"));
                buttonParam2.setParentNumber(container.getNumber());
                buttonParam2.setName(ResManager.loadKDString((String)"\u5220\u884c", (String)"MetadataAddOn_3", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
                buttonParam2.setOperationKey(this.getButtonNumber((ContainerParam)container, "delentry"));
                buttonParam2.setType("AdvConBarItemAp");
                buttonParam2.setOperationType("deleteentry");
                buttonParamList.addAll((Collection<ButtonParam>)ImmutableList.of((Object)buttonParam, (Object)buttonParam2));
            }
        });
    }

    private String getButtonNumber(ContainerParam containerParam, String buttonKey) {
        return containerParam.getLocation() + "_" + containerParam.getSuffix() + "_" + buttonKey;
    }

    private void initOperationParamList(List<OperationParam> operationParamList) {
        this.buttonParamList.forEach(button -> {
            OperationParam operationParam = new OperationParam();
            operationParam.setName(button.getName());
            operationParam.setKey(button.getNumber());
            operationParam.setType("Operation");
            operationParam.setOperationType(button.getOperationType());
            operationParamList.add(operationParam);
        });
    }

    @Override
    public void handle() {
        this.handleContainer();
        this.handleField();
        this.handleEntry();
        this.handleOperation();
        this.handleButton();
        this.handleFormPlugin();
        this.handleTableName();
    }

    private void handleTableName() {
        if (tableNoGenPredicateContainer.anyMatch((Object)this.getMetadataContext().getMetadataGenParam().getBaseParam())) {
            return;
        }
        String tableName = this.getMetadataContext().getMetadataGenParam().getBaseParam().getTableName();
        String metadataNumber = this.getMetadataContext().getMetadataGenParam().getBaseParam().getMetadataNumber();
        if (StringUtils.isEmpty((String)tableName)) {
            tableName = "kingdee".equalsIgnoreCase(this.getMetadataContext().getIsvId()) ? "t_" + metadataNumber : "tk_" + metadataNumber;
            tableName = tableName.length() > 25 ? tableName.substring(0, 25) : tableName;
        }
        this.getMetadataContext().getRootNode().addTable(tableName);
    }

    private void handleContainer() {
        this.containerParamList.forEach(containerParam -> {
            if (this.formMetadataNode.contains(containerParam.getNumber())) {
                return;
            }
            ArrayList<Map<String, Object>> formMetadataList = new ArrayList<Map<String, Object>>(this.containerParamList.size());
            HashMap containerMap = Maps.newHashMapWithExpectedSize((int)7);
            containerMap.put("_Type_", containerParam.getType());
            containerMap.put("Id", ID.genStringId());
            containerMap.put("Index", containerParam.getIndex());
            containerMap.put("Name", containerParam.getName());
            containerMap.put("Key", containerParam.getNumber());
            containerMap.put("Collapsible", containerParam.isCollapsible());
            containerMap.put("BackColor", "#ffffff");
            if ("AdvConAp".equals(containerParam.getType())) {
                HashMap<String, Object> containerRuleMap = new HashMap<String, Object>();
                containerRuleMap.put("_Type_", "Style");
                HashMap<String, String> margin = new HashMap<String, String>();
                margin.put("_Type_", "Margin");
                margin.put("Top", "10px");
                containerRuleMap.put("Margin", margin);
                containerMap.put("Style", containerRuleMap);
                containerMap.put("Grow", 0);
                containerMap.put("Shrink", 0);
                containerMap.put("Width", "100%");
            }
            if (CollectionUtils.isNotEmpty((Map)containerParam.getContainerRuleMap())) {
                containerMap.putAll(containerParam.getContainerRuleMap());
            }
            String parentId = this.designMetadataParser.getIdByNumber(containerParam.getParentNumber());
            containerMap.put("ParentId", parentId);
            formMetadataList.add(containerMap);
            this.designMetadataParser.addFormMetadata(formMetadataList);
            this.designMetadataParser.initKeyIdMap();
        });
    }

    private void handleOperation() {
        this.operationParamList.forEach(operationParam -> {
            ArrayList<Map<String, Object>> entityMetadataList = new ArrayList<Map<String, Object>>(this.operationParamList.size());
            HashMap operationMap = Maps.newHashMapWithExpectedSize((int)7);
            operationMap.put("_Type_", operationParam.getType());
            operationMap.put("Id", ID.genStringId());
            operationMap.put("Name", operationParam.getName());
            operationMap.put("OperationType", operationParam.getOperationType());
            operationMap.put("Inherit", Boolean.TRUE);
            HashMap<String, String> parameter = new HashMap<String, String>();
            if ("donothing".equals(operationParam.getOperationType())) {
                ArrayList pluginList = new ArrayList();
                HashMap<String, Object> pluginMap = new HashMap<String, Object>();
                pluginMap.put("_Type_", "Plugin");
                pluginMap.put("Inherit", Boolean.TRUE);
                pluginMap.put("ClassName", "");
                pluginMap.put("Description", "");
                pluginMap.put("Enabled", Boolean.FALSE);
                pluginList.add(pluginMap);
                operationMap.put("Plugins", pluginList);
            } else {
                parameter.put("_Type_", "EntryOpParameter");
                String parentId = this.designMetadataParser.getIdByNumber(this.entryParamList.get(0).getEntryKey());
                parameter.put("EntryId", parentId);
                operationMap.put("Parameter", parameter);
            }
            operationMap.put("Key", operationParam.getKey());
            entityMetadataList.add(operationMap);
            this.designMetadataParser.addEntityMeta(entityMetadataList);
            this.designMetadataParser.initKeyIdMap();
        });
    }

    private void handleButton() {
        this.buttonParamList.forEach(buttonParam -> {
            if (this.formMetadataNode.contains(buttonParam.getNumber())) {
                return;
            }
            ArrayList<Map<String, Object>> formMetadataList = new ArrayList<Map<String, Object>>(this.buttonParamList.size());
            HashMap buttonMap = Maps.newHashMapWithExpectedSize((int)7);
            buttonMap.put("_Type_", buttonParam.getType());
            buttonMap.put("Id", ID.genStringId());
            buttonMap.put("Index", buttonParam.getIndex());
            buttonMap.put("Name", buttonParam.getName());
            buttonMap.put("Visible", "init,new,edit");
            buttonMap.put("Key", buttonParam.getNumber());
            String parentId = this.designMetadataParser.getIdByNumber(buttonParam.getParentNumber());
            buttonMap.put("ParentId", parentId);
            buttonMap.put("OperationKey", buttonParam.getOperationKey());
            formMetadataList.add(buttonMap);
            this.designMetadataParser.addFormMetadata(formMetadataList);
            this.designMetadataParser.initKeyIdMap();
        });
    }

    private void handleField() {
        this.handleFieldSeq();
        this.fieldParamList.stream().filter(it -> it.isAdd()).forEach(fieldParam -> {
            MetadataSingleNode singleNode = this.findEntityObjSingleNode((FieldParam)fieldParam);
            RefMetadataNode currentNode = this.getMetadataContext().getCurrentNodeMap().get(fieldParam);
            MetadataSingleNode newNode = singleNode.clone();
            newNode.setId(currentNode.getNewId());
            newNode.setNumber(currentNode.getFieldParam().getNumber());
            newNode.setParentNumber(fieldParam.getContainerNumber());
            currentNode.setMetadataSingleNode(newNode);
            if (newNode.isMatch()) {
                newNode.modifyBaseInfo();
                this.formMetadataNode.add(newNode);
                this.entityMetadataNode.add(newNode);
                this.entityTreeMetadataNode.add(newNode);
                this.modifyFieldOther(newNode, (FieldParam)fieldParam);
            } else {
                fieldParam.setIgnore(true);
            }
        });
    }

    protected void modifyFieldOther(MetadataSingleNode newNode, FieldParam fieldParam) {
    }

    private void handleFieldSeq() {
        int seq = 1001;
        for (FieldParam fieldParam : this.fieldParamList) {
            if (fieldParam.getIndex() != 0) continue;
            fieldParam.setIndex(seq++);
        }
    }

    private void handleEntry() {
        this.entryParamList.forEach(entryParam -> {
            MetadataSingleNode singleNode = this.findEntryObjSingleNode((EntryParam)entryParam);
            RefMetadataNode currentNode = this.getMetadataContext().getCurrentEntryNodeMap().get(entryParam);
            MetadataSingleNode newNode = singleNode.clone();
            newNode.setNumber(entryParam.getEntryKey());
            newNode.setEntry(true);
            newNode.setId(currentNode.getNewId());
            newNode.setParentNumber(entryParam.getContainerNumber());
            newNode.getEntryFormMetadataMap().put("ParentId", this.designMetadataParser.getIdByNumber(entryParam.getContainerNumber()));
            newNode.getEntityMetadataMap().put("TableName", entryParam.getTableName());
            newNode.getEntityMetadataMap().put("Name", entryParam.getEntryName());
            newNode.getEntryFormMetadataMap().put("Name", entryParam.getEntryName());
            newNode.getEntityTreeMetadataMap().put("Name", entryParam.getEntryName());
            newNode.getEntryFormMetadataMap().putAll(entryParam.getFieldRuleMap());
            currentNode.setMetadataSingleNode(newNode);
            if (newNode.isMatch()) {
                newNode.modifyBaseInfo();
                this.formMetadataNode.add(newNode);
                this.entityMetadataNode.add(newNode);
                this.entityTreeMetadataNode.add(newNode);
                this.designMetadataParser.initKeyIdMap();
            } else {
                entryParam.setIgnore(true);
            }
            this.handleEntryField((EntryParam)entryParam);
        });
    }

    private void handleEntryField(EntryParam entryParam) {
        entryParam.getFieldParamList().stream().filter(it -> it.isAdd()).forEach(fieldParam -> {
            MetadataSingleNode singleNode = this.findEntryEntityObjSingleNode((FieldParam)fieldParam);
            RefMetadataNode currentNode = this.getMetadataContext().getCurrentEntryEntityNodeMap().get(fieldParam);
            MetadataSingleNode newNode = singleNode.clone();
            newNode.setNumber(fieldParam.getNumber());
            newNode.setId(currentNode.getNewId());
            newNode.setParentNumber(fieldParam.getContainerNumber());
            currentNode.setMetadataSingleNode(newNode);
            newNode.getFormMetadataMap().put("Invisible", fieldParam.isInvisible());
            if (fieldParam.getType().equals("MulBasedataFieldentry")) {
                this.keyTableNameMap.put(fieldParam.getNumber(), this.getMulTableName(entryParam));
            }
            if (newNode.isMatch()) {
                newNode.modifyBaseInfo();
                this.formMetadataNode.add(newNode);
                this.entityMetadataNode.add(newNode);
                this.entityTreeMetadataNode.add(newNode);
            } else {
                fieldParam.setIgnore(true);
            }
        });
    }

    private String getMainTablePrefix(String mainTableName) {
        if (mainTableName.length() <= 21) {
            return mainTableName;
        }
        return mainTableName.substring(0, 21);
    }

    private String getMulTableName(EntryParam entryParam) {
        String mainTableName = entryParam.getTableName();
        if (StringUtils.isEmpty((String)mainTableName)) {
            return "";
        }
        String mainTableNamePrefix = this.getMainTablePrefix(mainTableName);
        return this.getMulTableName(mainTableNamePrefix);
    }

    private String getMulTableName(String mainTableNamePrefix) {
        String regex = mainTableNamePrefix + "_m(\\d{1,2})";
        Pattern pattern = Pattern.compile(regex);
        int maxIndex = 0;
        for (Map.Entry<String, String> mapEntry : this.keyTableNameMap.entrySet()) {
            String indexStr;
            int index;
            String tableName = mapEntry.getValue();
            Matcher matcher = pattern.matcher(tableName);
            if (!matcher.matches() || (index = Integer.parseInt(indexStr = matcher.group(1))) <= maxIndex) continue;
            maxIndex = index;
        }
        return mainTableNamePrefix + "_m" + (maxIndex + 1);
    }

    private void handleFormPlugin() {
        this.getMetadataContext().getRootNode().addFormPlugin(this.formPluginParamList);
    }

    private MetadataSingleNode findEntityObjSingleNode(FieldParam fieldParam) {
        return this.getMetadataContext().getEntityObjNodeMap().get(fieldParam).getMetadataSingleNode();
    }

    private MetadataSingleNode findEntryObjSingleNode(EntryParam entryParam) {
        return this.getMetadataContext().getEntryObjNodeMap().get(entryParam).getMetadataSingleNode();
    }

    private MetadataSingleNode findEntryEntityObjSingleNode(FieldParam fieldParam) {
        return this.getMetadataContext().getEntryEntityObjNodeMap().get(fieldParam).getMetadataSingleNode();
    }

    static {
        tableNoGenPredicateContainer.append(baseParam -> baseParam.getType() == MetadataGenTypeEnum.EXTEND_METADATA);
        tableNoGenPredicateContainer.append(baseParam -> !EntityModelTypeEum.BaseFormModel.name().equals(baseParam.getModelType()) && !EntityModelTypeEum.BillFormModel.name().equals(baseParam.getModelType()));
        tableNoGenPredicateContainer.append(baseParam -> baseParam.getType() == MetadataGenTypeEnum.EXTEND_ENTRY_METADATA);
        tableNoGenPredicateContainer.append(baseParam -> !baseParam.isAutoGenTableName());
    }
}

