/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.FormMetadataNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataContext;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataSingleNode;
import kd.hdtc.hrdbs.common.pojo.metadata.ContainerParam;
import kd.hdtc.hrdbs.common.pojo.metadata.EntryParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;

public class MetadataNodeHider {
    private FormMetadataNode formMetadataNode = MetadataContext.get().getFormMetadataNode();
    private Map<String, Object> DEFAULT_RULE_MAP = ImmutableMap.of((Object)"MustInput", (Object)false, (Object)"Invisible", (Object)true);
    private Map<String, Object> FEATURE_RULE_MAP = ImmutableMap.of((Object)"Importable", (Object)false, (Object)"Exportable", (Object)false);

    public void handle() {
        List fieldParamList = MetadataContext.get().getMetadataGenParam().getFieldParamList();
        this.remove(fieldParamList);
        List entryParamList = MetadataContext.get().getMetadataGenParam().getEntryParamList();
        for (EntryParam entryParam : entryParamList) {
            this.remove(entryParam.getFieldParamList());
        }
        this.removeContainer(MetadataContext.get().getMetadataGenParam().getContainerParamList());
    }

    private void removeContainer(List<ContainerParam> containerParamList) {
        if (containerParamList == null) {
            return;
        }
        for (ContainerParam containerParam : containerParamList) {
            this.doRemovePreHandle(containerParam);
            this.doRemove(containerParam);
        }
    }

    private void doRemove(ContainerParam containerParam) {
        if (containerParam.isDelete() && !containerParam.isIgnore() && this.formMetadataNode.contains(containerParam.getNumber())) {
            MetadataSingleNode singleNode = MetadataContext.get().getDesignMetadataParser().getSingleNode(containerParam.getNumber());
            this.doRemoveContainer(singleNode);
        }
    }

    private void doRemovePreHandle(ContainerParam containerParam) {
        if (!containerParam.isIgnore() && this.formMetadataNode.contains(containerParam.getNumber())) {
            MetadataSingleNode singleNode = MetadataContext.get().getDesignMetadataParser().getSingleNode(containerParam.getNumber());
            Map containerRuleMap = containerParam.getContainerRuleMap();
            if (CollectionUtils.isNotEmpty((Map)containerRuleMap)) {
                containerRuleMap.put("Name", containerParam.getName());
                singleNode.modifyFieldRule(containerRuleMap);
            }
        }
    }

    private void doRemove(MetadataSingleNode singleNode) {
        singleNode.modifyFieldRule(this.DEFAULT_RULE_MAP);
        singleNode.modifyFeaturesRule(this.FEATURE_RULE_MAP);
    }

    private void doRemoveContainer(MetadataSingleNode singleNode) {
        singleNode.modifyFieldRule(this.DEFAULT_RULE_MAP);
    }

    private void remove(List<FieldParam> fieldParamList) {
        for (FieldParam fieldParam : fieldParamList) {
            if (!fieldParam.isDelete() || fieldParam.isIgnore()) continue;
            this.doRemove(fieldParam);
        }
    }

    private void doRemove(FieldParam fieldParam) {
        MetadataSingleNode singleNode = MetadataContext.get().getMetadataSingleNode(fieldParam);
        this.doRemove(singleNode);
        singleNode.modifyName(fieldParam.getName());
    }
}

