/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.convert;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataContext;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataSingleNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.RefMetadataNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.convert.AbstractFieldConverter;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class BaseDataPropConverter
extends AbstractFieldConverter {
    private static final Log LOG = LogFactory.getLog(BaseDataPropConverter.class);

    @Override
    public void doConvert(FieldParam fieldParam) {
        RefMetadataNode currentNode = this.getRefMetadataNode(fieldParam);
        if (fieldParam.getBaseDataFieldParam() != null) {
            RefMetadataNode refMetadataNode = this.getRefMetadataNode(fieldParam.getBaseDataFieldParam());
            String baseDataPropNumber = (String)fieldParam.getFieldRuleMap().get("RefDisplayProp");
            MetadataSingleNode originRefBaseDataNode = null;
            if (refMetadataNode == null) {
                String nodeId = MetadataContext.get().getDesignMetadataParser().getIdByNumber(fieldParam.getBaseDataFieldParam().getNumber());
                currentNode.getMetadataSingleNode().modifyBaseDataProp(nodeId);
                originRefBaseDataNode = MetadataContext.get().getDesignMetadataParser().getSingleNode(fieldParam.getBaseDataFieldParam().getNumber());
            } else {
                currentNode.getMetadataSingleNode().modifyBaseDataProp(refMetadataNode.getMetadataSingleNode().getId());
                RefMetadataNode refBaseDataMetaDataNode = this.getRefMetadataNode(fieldParam.getBaseDataFieldParam());
                originRefBaseDataNode = refBaseDataMetaDataNode.getMetadataSingleNode();
            }
            this.modifyBaseDataRefProps(originRefBaseDataNode, baseDataPropNumber);
        }
    }

    private void modifyBaseDataRefProps(MetadataSingleNode refBaseDataNode, String baseDataPropNumber) {
        if (refBaseDataNode == null || StringUtils.isEmpty((String)baseDataPropNumber)) {
            return;
        }
        HashMap refPropMap = Maps.newHashMapWithExpectedSize((int)4);
        refPropMap.put("_Type_", "RefProp");
        refPropMap.put("Name", baseDataPropNumber);
        ArrayList<Map<String, String>> refPropList = null;
        Object refProps = refBaseDataNode.getEntityMetadataMap().get("RefProps");
        if (refProps == null) {
            refPropList = new ArrayList<Map<String, String>>(4);
            refPropList.add(refPropMap);
        } else {
            refPropList = (ArrayList<Map<String, String>>)refProps;
            if (!this.isExitRefProp(refPropList, baseDataPropNumber)) {
                refPropList.add(refPropMap);
            }
        }
        if (CollectionUtils.isNotEmpty(refPropList)) {
            refBaseDataNode.getEntityMetadataMap().put("RefProps", refPropList);
        }
    }

    private boolean isExitRefProp(List<Map<String, String>> refPropList, String baseDataPropNumber) {
        if (CollectionUtils.isEmpty(refPropList)) {
            return false;
        }
        for (Map<String, String> refPropMap : refPropList) {
            if (!HRStringUtils.equals((String)baseDataPropNumber, (String)refPropMap.get("Name"))) continue;
            return true;
        }
        return false;
    }
}

