/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.convert;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataContext;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataSingleNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.RefMetadataNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.convert.AbstractFieldConverter;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class BaseDataRefPropConverter
extends AbstractFieldConverter {
    private static final Log LOG = LogFactory.getLog(BaseDataRefPropConverter.class);

    @Override
    protected boolean isNeedConvert(FieldParam fieldParam) {
        return fieldParam.isAdd() || fieldParam.isUpdate();
    }

    @Override
    public void doConvert(FieldParam fieldParam) {
        if ("BasedataField".equals(fieldParam.getType()) && CollectionUtils.isNotEmpty((Collection)fieldParam.getBasedataRefProp())) {
            RefMetadataNode refMetadataNode = this.getRefMetadataNode(fieldParam);
            MetadataSingleNode originRefBaseDataNode = null;
            originRefBaseDataNode = refMetadataNode == null ? MetadataContext.get().getDesignMetadataParser().getSingleNode(fieldParam.getNumber()) : refMetadataNode.getMetadataSingleNode();
            this.modifyBaseDataRefProps(originRefBaseDataNode, fieldParam.getBasedataRefProp());
        }
    }

    private void modifyBaseDataRefProps(MetadataSingleNode refBaseDataNode, List<String> baseDataRefPropList) {
        if (CollectionUtils.isEmpty(baseDataRefPropList)) {
            return;
        }
        ArrayList<Map<String, String>> refPropList = null;
        Object refProps = refBaseDataNode.getEntityMetadataMap().get("RefProps");
        refPropList = refProps == null ? new ArrayList<Map<String, String>>(4) : (ArrayList<Map<String, String>>)refProps;
        for (String baseDataRefPropNumber : baseDataRefPropList) {
            HashMap refPropMap = Maps.newHashMapWithExpectedSize((int)4);
            refPropMap.put("_Type_", "RefProp");
            refPropMap.put("Name", baseDataRefPropNumber);
            if (this.isExitRefProp(refPropList, baseDataRefPropNumber)) continue;
            refPropList.add(refPropMap);
        }
        if (CollectionUtils.isNotEmpty(refPropList)) {
            refBaseDataNode.getEntityMetadataMap().put("RefProps", refPropList);
        }
    }

    private boolean isExitRefProp(List<Map<String, String>> refPropList, String baseDataPropNumber) {
        if (CollectionUtils.isEmpty(refPropList)) {
            return false;
        }
        for (Map<String, String> refPropMap : refPropList) {
            if (!HRStringUtils.equals((String)baseDataPropNumber, (String)refPropMap.get("Name"))) continue;
            return true;
        }
        return false;
    }
}

