/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.convert;

import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.domain.metadata.impl.MetaNodeConstants;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.MetadataContext;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.RefMetadataNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.convert.AbstractFieldConverter;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class BasedataFieldConverter
extends AbstractFieldConverter {
    private static final Log LOG = LogFactory.getLog(BasedataFieldConverter.class);

    private String getName(RefMetadataNode node) {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(node.getFieldParam().getName());
        nameBuilder.append('.');
        nameBuilder.append(this.getPropName(node.getFieldParam()));
        return nameBuilder.toString();
    }

    private String getPropName(FieldParam fieldParam) {
        RefMetadataNode refMetadataNode = MetadataContext.get().getEntityObjNodeMap().get(fieldParam);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)refMetadataNode.getRefBasedataNumber());
        return dataEntityType.getProperty(fieldParam.getMatchedBasedataPropNumber()).getDisplayName().getLocaleValue();
    }

    private String getFieldName(RefMetadataNode node) {
        return "fh" + node.getMetadataSingleNode().getNumber() + (StringUtils.equals((String)node.getFieldParam().getBasedataPropNumber(), (String)"number") ? "u" : "a");
    }

    @Override
    public void doConvert(FieldParam fieldParam) {
        if (fieldParam.isBasedata()) {
            RefMetadataNode node = this.getRefMetadataNode(fieldParam);
            node.getMetadataSingleNode().modifyFieldName(this.getFieldName(node));
            node.getMetadataSingleNode().modifyName(this.getName(node));
            if ("name".equals(node.getFieldParam().getBasedataPropNumber())) {
                node.getMetadataSingleNode().modifyFieldType(StringUtils.isEmpty((String)node.getFieldParam().getType()) ? MetaNodeConstants.TEXT_FIELD : node.getFieldParam().getType());
            }
        }
    }
}

