/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.convert;

import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.business.domain.metadata.impl.MetaNodeConstants;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.RefMetadataNode;
import kd.hdtc.hrdbs.business.domain.metadata.impl.handle.modify.convert.AbstractFieldConverter;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class FieldConverter
extends AbstractFieldConverter {
    private static final Log LOG = LogFactory.getLog(FieldConverter.class);

    @Override
    public void doConvert(FieldParam fieldParam) {
        RefMetadataNode node = this.getRefMetadataNode(fieldParam);
        node.getMetadataSingleNode().modifyName(node.getFieldParam().getName());
        this.fieldTableNameConvert(node);
    }

    private void fieldTableNameConvert(RefMetadataNode node) {
        String fieldType = node.getFieldParam().getType();
        if (MetaNodeConstants.RANGE_TYPE_SET.contains(fieldType)) {
            this.rangeFieldTableNameConvert(node);
        } else {
            this.commFieldTableNameConvert(node);
        }
    }

    private void rangeFieldTableNameConvert(RefMetadataNode node) {
        Map fieldRuleMap = node.getFieldParam().getFieldRuleMap();
        String number = node.getFieldParam().getNumber();
        String startFieldName = (String)fieldRuleMap.get("StartDateFieldName");
        String startFieldKey = (String)fieldRuleMap.get("StartDateFieldKey");
        if (StringUtils.isEmpty((String)startFieldKey)) {
            startFieldKey = number + "_start";
            fieldRuleMap.put("StartDateFieldKey", startFieldKey);
        }
        fieldRuleMap.put("StartDateFieldName", this.getFieldTableName(startFieldName, startFieldKey));
        String endFieldName = (String)fieldRuleMap.get("EndDateFieldName");
        String endFieldKey = (String)fieldRuleMap.get("EndDateFieldKey");
        if (StringUtils.isEmpty((String)endFieldKey)) {
            endFieldKey = number + "_end";
            fieldRuleMap.put("EndDateFieldKey", endFieldKey);
        }
        fieldRuleMap.put("EndDateFieldName", this.getFieldTableName(endFieldName, endFieldKey));
    }

    private void commFieldTableNameConvert(RefMetadataNode node) {
        String fieldName = node.getMetadataSingleNode().getFieldName();
        String fieldNumber = node.getFieldParam().getNumber();
        if (StringUtils.isEmpty((String)fieldName)) {
            fieldName = node.getFieldParam().getTableField();
        }
        fieldName = this.getFieldTableName(fieldName, fieldNumber);
        node.getMetadataSingleNode().modifyFieldName(fieldName);
    }

    protected String getFieldTableName(String fieldName, String fieldNumber) {
        if (StringUtils.isEmpty((String)fieldName)) {
            fieldName = "f" + fieldNumber;
        }
        fieldName = fieldName.length() > 25 ? fieldName.substring(0, 25) : fieldName;
        return fieldName;
    }
}

